/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/*
	Output - calculate the output, based on a popelem
	error - calculate the error, based on popelem, in and out

*/
#include <stdio.h>
#include <math.h>

#include "genetic_.h"

#include "../genetic.lib/support.h"

float output( int noutput, struct popelem *p, float *in )
{
	float nout[H_LAYER],o;
	int i,j;
	for( j=0; j< H_LAYER; j++ )
	{
		float n;
		n = 1.0F*POP_FLOAT(p->blayer[j]);
		for( i=0; i < IN_LAYER; i++ )
		{
			n += in[i]*POP_FLOAT(p->flayer[i][j]);
		}
		nout[j] = s( n );
	}
	o = 1.0F*POP_FLOAT(p->Blayer[noutput]);
	for( i=0; i < H_LAYER; i++ )
		o += nout[i]*POP_FLOAT(p->llayer[i][noutput]);
	return s( o );
}

float error(struct popelem *p, float *in, float *out )
{
	double err,ze;
	int i;
	for( err=0.0F, i=0; i < OUT_LAYER; i++ )
	{
/*		ze=fabs( (double)out[i] - (double)output(i,p,in) );*/
		ze=( (double)out[i] - (double)output(i,p,in) );
		ze*=ze;
		if( use_penalty )
		{
/*			if( ze > 0.5 )*/
/*					ze += 0.5;*/
			PENALTY( ze );
		}
		err += ze;
	}
	return (float)err;
}

extern float ges_error(struct popelem *p, struct target *t )
{
	float ges;
	int i;
	for( ges=0.0F,i=0; i < N_TARGET; i++ )
		ges += error( p, t[i].input, t[i].output );
	return ges;
}

extern void plot_error( struct popelem *p, struct target *t, FILE *out )
{
	int i;
	for( i=0; i < N_TARGET; i++ )
		fprintf( out,"%f\t%f\n", t[i].input[0], output( 0,p,t[i].input) );
}
