/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Genetic operators */
/* Erweiterung auf mehrere Populationen gleichzeitig */

#include "debug.h"

#ifndef __USHORT
#define __USHORT
typedef unsigned short USHORT;
#endif

/* Statusfunktionen */
extern int get_number(void);

extern int get_size(void);

extern struct r_list *get_population( void );

extern void __destroy_population(void);

/* Legt number von popelem's an, mit Groesse sizepop, Zufallszahlen mit  rseed */
extern void init_population(int number,
				                int sizepop, USHORT rseed);

/* Erstellt eine Rangliste der Population */
extern void set_rank(float (*ges_error) (), void *t);

extern double compute_hamming(void);

extern int dimension(void);

/* Makros fuer verschiedene Spezialfaelle */

/* Normaler C1 GA */
extern float genstep_c1(float (*ges_error) (), void *t, float c1_rate, float m_rate);

/* Normaler C2 GA */
extern float genstep_c2(float (*ges_error) (), void *t, float c2_rate, float m_rate);

/* Normaler Cn GA */
extern float genstep_cn(float (*ges_error) (), void *t, float cn_rate, float m_rate);

