/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/*
    Lernen mit variabler Topologie
    in einem zweistufigen Genetischem Algorithmus
*/

#include <stdio.h>
#include <assert.h>

#include <mgenops.h>
#include <rlist.h>
#include <cmdargs.h>
#include <portrnd.h>

#include "vartop.h"
#include "topology.h"

int meta_popsize=10;
int popsize=50;
int meta_gen=200,multi_basis_gen=500,multi_bonus_gen=20;
float pre_of_cross_meta=0.5, pre_of_cross_multi=0.5;
float p_mutate_meta=0.1, p_mutate_multi=0.1,
    node_penalty=0.01,z_penalty=1.0;
#define RANDOM 

FILE *debugfile=stderr;

struct pararray p_array[MAX_PARAMS] = {
{ 'p', P_LOCASEPAR, P_INT, (void *)&popsize },
/* Populationmsgroesse der Multipopulationen */
{ 'P', P_UPCASEPAR, P_INT, (void *)&meta_popsize },
/* Populationmsgroesse der Metapopulatio */
{ 'c', P_LOCASEPAR, P_FLOAT, (void *)&pre_of_cross_multi },
/* Wahrscheinlichkeit fr Crossover in Multi-Pop */
{ 'C', P_UPCASEPAR, P_FLOAT, (void *)&pre_of_cross_meta },
/* Wahrscheinlichkeit fr Crossover in Meta-Pop */
{ 'm', P_LOCASEPAR, P_FLOAT, (void *)&p_mutate_multi },
/* Wahrscheinlichkeit fr Bit-Mutation in Multi-Pop */
{ 'M', P_UPCASEPAR, P_FLOAT, (void *)&p_mutate_meta },
/* Wahrscheinlichkeit fr Bit-Mutation in Meta-Pop */
{ 'G', P_UPCASEPAR, P_INT, (void *)&meta_gen },
/* Anzahl der Generationen der Meta-Population */
{ 'B', P_UPCASEPAR, P_INT, (void *)&multi_basis_gen },
/* Anzahl der Generationen der Multi-Population,Basis-Wert */
{ 'b', P_LOCASEPAR, P_INT, (void *)&multi_bonus_gen },
/* Anzahl der Generationen der Multi-Population,Bonus-Wert */
/* positive Werte bewirken mehr Generationen fr kleinere Netze */
{ 'n', P_LOCASEPAR, P_FLOAT, (void *)&node_penalty },
/* Straffaktor fr die Anzahl der Node-Verbindungen */
{ 'z', P_LOCASEPAR, P_FLOAT, (void *)&z_penalty }
/* Multiplikator fr die nichtlineare Fehlererhhung in pop_error */
};
int def_parameter=sizeof(p_array)/sizeof(struct pararray);

#define PRINTi(var)\
    printf( "#"#var"\t%d\n",var )

#define PRINTf(var)\
    printf( "#"#var"\t%f\n",var )

void dump_params( void )
{
    PRINTi(popsize);
    PRINTi(meta_popsize);
    PRINTf(pre_of_cross_multi);
    PRINTf(pre_of_cross_meta);
    PRINTf(p_mutate_multi);
    PRINTf(p_mutate_meta);
    PRINTi(meta_gen);
    PRINTi(multi_basis_gen);
    PRINTi(multi_bonus_gen);
    PRINTf(node_penalty);
    PRINTf(z_penalty);
}

/* Wir errechnen eine Bewertung fr eine gegebene, bereits bewertete 
Rangliste */

float pop_error( struct r_list *r, int number, struct node_list *n )
{
    /* Zum einen der aktuelle Fehler, zum anderen die Anzahl der
    	Connections */
    int nconn;
    float perr,pzus;
    assert( r!=NULL);
    assert( number>=0 );
    assert( r->is_calculated==ISCALC);
    assert( r->is_free==ISNOTFREE);
    assert( n!=NULL );
/*	DEBUG_call(pop_error);
    debug_ranklist( r,number );*/
    pzus = 0.0F;
    nconn = n->max_num_of_con;
    perr = r->pop_error;
    if( perr > 0.5 )
    	pzus += 0.5;
    if( perr > 1.0 )
    	pzus += 0.5;
    if( perr > 1.5 )
    	pzus += 0.5;
    if( perr > 2.0 )
    	pzus += 0.5;
/*	DEBUG_int(nconn);
    DEBUG_float(perr);*/
    return perr + pzus*z_penalty + ((float)nconn*node_penalty);
}

/*
**  Funktionsname : dump_element
**
**  Beschreibung  : gibt ein Rangliastenelement aus
**  Input         : npop - Welche Pop
**		    nelem - welches Element
**  Output        : nope
*/
void dump_element( int npop, int nelem )
{
    struct node_list *node;
    popelem *gews;
    int con,maxcon;
    node = get_spare(npop);
    gews = (popelem *)((get_rlist_meta()[npop]).r)[nelem].p;
    printf( "#Cns:\t%d\t", maxcon = node->max_num_of_con );
    for( con=0; con<maxcon; con++ )
    {
    	printf( "{(%d,%d)=%f}",node->nodes[con].from,
    	node->nodes[con].to,
    	(float)gews[con]/32768.0F*(float)MAX_SYN_VALUE );
    }
    printf( "\n" );
}

void main(int argc, char **argv )
{
    int i,j,k;
    float der_fehler;
    int maxgens;
    set_target();
    parse_parameter( argc, argv );
    dump_params();
    init_multi( meta_popsize, sizeof( popelem_f ),
#ifdef RANDOM
    		time_seed()	
#else
    		0
#endif
    				 );
    for( i=0; i<meta_popsize; i++ )
    {
        make_multi_population( i, popsize, make_node_list );
    }
    /* Wir haben jetzt die Populationsstruktur aufgebaut */

    /* meta_gen Generationen lang den Ausseren GA itereieren */
    for( k=0; k<meta_gen;k++ )
    {
    /* Eine Schleife ber alle verschiedenen Populationen */
    for( i=0; i<meta_popsize; i++ )
    {
        double f;
        /* Die maximale Anzahl der Generationen berechnen */
        /* Prinzipiell zunaechst 500 Generationen, dann */
        /* fr pro Synapse weniger nochmal 20 */
        /* Generationen drauf */
        maxgens = multi_basis_gen + (NUM_OF_CON-(
    	(struct node_list *)get_spare(i))->max_num_of_con)
    	*multi_bonus_gen;
        /* maxgens + multi_bonus_gen Generationen lang die Sub-Pops
           evaluieren */
        for( j=0; j<maxgens;j++ )
        {
    	f=genstep_cn_multi( i,ges_error,
    	targets, pre_of_cross_multi, p_mutate_multi );
        }
        fprintf( stderr,
    	"Iterated Population %d over %d Generations giving %f with %d synapses\n",
        i,maxgens,f,
        ((struct node_list *)get_spare(i))->max_num_of_con );

    }
    der_fehler = genstep_cn_meta( pop_error, make_node_list,
    destroy_node_list, pre_of_cross_meta, p_mutate_meta );
    printf( "Generation\t%d\tFehler\t%f\tConn\t%d\n",k,der_fehler,
    ((struct node_list *)get_spare(0))->max_num_of_con );
    }
    printf( "#Ergebnis: Fehler %f bei %d Connections\n",
        get_rlist_multi(0)->pop_error,
        ((struct node_list *)get_spare(0))->max_num_of_con );
    dump_element( 0,0 );
}

