#include <klic/gdobject.h>

#define MAX_EXPORT_SIZE 1024
Volatile struct export_table {
  unsigned long index;
  unsigned long nterm;
  q *terms[MAX_EXPORT_SIZE];
} export_table;

struct export_object {
  struct data_object_method_table *method_table;
  struct export_table *ex_table;
};


#define GD_CLASS_NAME() export
#define GD_OBJ_TYPE struct export_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

#include <klic/gd_macro.h>

GDDEF_GUNIFY()
{
  G_STD_DECL;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_GUNIFY_FAIL;
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_UNIFY_FAIL;
  GD_RETURN;
}

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;
  q *newvar;
  struct export_table *extable;
  unsigned long i;
  q res;
 
  GDSET_NEWOBJ_IN_NEWGEN(newself);
  extable = newself->ex_table = GD_SELF->ex_table;
  G_HEAPALLOC_WITH_CHECK(newvar,MAX_EXPORT_SIZE,(q *),g_allocp,res);
  if (res == GD_GCREQUEST) fatal("Not enough space collected");
  for (i=0; i < MAX_EXPORT_SIZE; i++) {
    if (extable->terms[i]) {
        G_COPY_KL1_TERM_TO_NEWGEN(*(extable->terms[i]),newvar[i]);
	extable->terms[i] = &(newvar[i]);
      }
  }
  GD_RETURN_FROM_GC(newself);
}

#define GDUSE_STD_PRINT
#define GDUSE_STD_GENERIC
#define GDUSE_STD_GGENERIC
#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

#include <klic/gd_method_table.h>

GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  GD_OBJ_TYPE *newobj;
  int i;

  G_HEAPALLOC(newobj,G_SIZE_IN_Q(GD_OBJ_TYPE),(GD_OBJ_TYPE *));
  newobj->method_table = &GD_method_table;
  newobj->ex_table = &export_table;
  export_table.nterm = 0;
  export_table.index = 0;
  for (i=0; i<MAX_EXPORT_SIZE; i++) {
    export_table.terms[i] = 0;
  }
  GD_RETURN_FROM_NEW(newobj);
}

q gd_new_export(argc,argv,g_allocp)
     unsigned long argc;
     q argv[];
     q *g_allocp;
{
 return export_g_new(argc,argv,g_allocp);
}

unsigned long gd_export_register(var)
     q *var;
{
  unsigned long i0, i;
  if ((i0 = export_table.index) >= MAX_EXPORT_SIZE) {
    i0 = 0;
  }
  for (i = i0; i < MAX_EXPORT_SIZE; i++) {
    if (!export_table.terms[i]) goto ok;
  }
  for (i = 0; i < i0; i++) {
    if (!export_table.terms[i]) goto ok;
  }
  fatal("export table overflow!");
 ok:
  export_table.terms[i] = var;
  export_table.index    = i+1;
  export_table.nterm++;
  return(i);
}
