/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/alloc.h>
#include <klic/control.h>
#include <klic/susp.h>
#include <klic/generic.h>
#include <klic/gobj2.h>

static Volatile
do_fail(goal, reasonp)
     struct goalrec *goal;
     q *reasonp;
{
#ifdef DEBUGLIB
  trace_failure(goal);
#endif
  fatal("Reduction Failure");
}

#ifdef DEBUGLIB
static Inline q *record_susp(allocp, goal)
     q *allocp;
     struct goalrec *goal;
{
  declare_globals;
  struct suspended_goal_rec *sm;
  heapalloc(sm, sizeof(struct suspended_goal_rec)/sizeof(q),
	    (struct suspended_goal_rec *));
  sm->goal = goal;
  sm->next = suspended_goal_list;
  suspended_goal_list = sm;
  return allocp;
}
#endif

q *suspend_goal(allocp, goal, reason, spontaneous)
     q *allocp;
     struct goalrec *goal;
     q reason;
     int spontaneous;
{
  declare_globals;
  int suspended = 0;

  goal->next = (struct goalrec *)makeint(current_prio);
  if (derefone(reason) == reason) {
    /* no goals suspended yet on this variable */
    struct susprec *susp;
    q newvar;
    allocnewsusp(newvar,susp);
    susp->u.first_hook.u.g = goal;
    derefone(reason) = newvar;
    suspended = 1;
  } else {
    /* some goals already has suspended */
    struct susprec *susp;
    struct hook *newhook;
    susp = suspp(derefone(reason));
    /* generator object ? */
    if (!is_generator_susp(susp->u)) {
      /* then allocate new hook */
      allochook(&susp->u.first_hook,newhook);
      newhook->u.g = goal;
      suspended = 1;
    } else {
      struct generator_susp *gsusp = generator_suspp(susp);
      q ref = gsusp->backpt;
      q tmp = generic_generate(untag_generator_susp(gsusp->u.o), allocp);
      allocp = heapp;
      if (tmp != (q)0) {
	derefone(ref) = tmp;
	{
	  struct goalrec *rsmg = resumed_goals;
	  if(rsmg == 0) {
	    goal->next = goal;
	  } else {
	    goal->next = rsmg->next;
	    rsmg->next = goal;
	  }
	  resumed_goals = rsmg;
	}
      } /* else ... do nothing */	
    }
    newhook->u.g = goal;
  }
  if (suspended) {
#ifdef DEBUGLIB
    allocp = record_susp(allocp, goal);
#endif
    suspensions++;
  }

  return(allocp);
}

q *interrupt_goal(allocp, pred, reasonp)
     q *allocp;
     struct predicate *pred;
     q *reasonp;
{
  declare_globals;
  struct goalrec *goal = (struct goalrec *)allocp;
  allocp += pred->arity + 2;
  goal->pred = pred;

  if (reasonp == 0) {
    /* Interrupt by some external event, such as: */
    /*   - A higher priority goal got ready for execution */
    /*   - Garbage collection required */
    /* In such cases, the interrupted goal is pushed down to the queue. */
    struct goalrec *rsmg = resumed_goals;
    if (rsmg == 0) {
      goal->next = goal;
    } else {
      goal->next = rsmg->next;
      rsmg->next = goal;
    }
    resumed_goals = goal;
    return allocp;
  } else if (reasonp == reasons) {
    do_fail(goal, reasons[0]);
  } else {
    /* goal suspension */
#ifdef DEBUGLIB
    {
      extern int trace_flag;
      struct goalrec *trace_susp();
      if (trace_flag && (reasonp > reasons)) {
	goal = trace_susp(goal, reasonp, 0);
      }
    }
#endif

    goal->next = (struct goalrec *)makeint(current_prio);
    /* Dereference is not needed for the first suspension reason */
    {
      q tmp, tmp1;
      int redo_request = 0;

      tmp = *(--reasonp);
      tmp1 = derefone(tmp);
      while (1) {
	if (tmp == tmp1) {
	  /* no goals suspended yet on this variable */
	  struct susprec *susp;
	  q newvar;
	  makenewsusp(newvar,susp,allocp);
	  susp->u.first_hook.u.g = goal;
	  derefone(tmp) = newvar;
	} else {
	  /* some goals already has suspended */
	  struct susprec *susp = suspp(tmp1);
	  /* generator object ? */
	  if(!is_generator_susp(susp->u)) {
	    if (susp->u.first_hook.next->u.g == goal) {
	      /* If the second hook is for the same goal, do nothing.
		 This includes the case where there's only one hook,
		 because of the loop structure of the hook chain. */
	    } else {
	      struct hook *newhook;
	      addhook(&susp->u.first_hook,newhook,allocp);
	      newhook->u.g = goal;
	    }
	  } else {
	    /* generator object */
	    struct generator_susp *gsusp = generator_suspp(susp);
	    q ref = gsusp->backpt;
	    q tmp = generic_generate(untag_generator_susp(gsusp->u.o), allocp);
	    allocp = heapp; 
	    redo_request = 1;
	    if(tmp != (q)0) {
	      redo_request = 1;
	      derefone(ref) = tmp;
	    } /* else GC request */
	  }
	}
	if (reasonp == reasons) break;
	/* Dereference IS needed for the second reason and on, */
	/* as suspension inserts a new variable cell */
	for (tmp = *(--reasonp), tmp1 = derefone(tmp);
	     derefone(tmp1) != tmp;
	     tmp = tmp1, tmp1 = derefone(tmp))
	  ;
      }
      if (redo_request) {
	if (resumed_goals == 0) {
	  resumed_goals = goal;
	  goal->next = goal;
	} else {
	  goal->next = resumed_goals->next;
	  resumed_goals->next = goal;
	}
	heaplimit = 0;
      } else {
#ifdef DEBUGLIB
	allocp = record_susp(allocp, goal);
#endif
	suspensions++;
      }
    }
    return allocp;
  }
}
