/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define MAIN

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/timing.h>

#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <signal.h>

extern char *runtime_version, *runtime_date;

jmp_buf klic_topmost;
int start_tracing = 0;

void *module_main();

extern Const struct predicate predicate_main_xmain_0;

char *optarg;

int
parse_size(str)
     char *str;
{
  int n;
  char c[2];
  switch (sscanf(str, "%d%1s", &n, c)) {
  case 1: return n;
  case 2:
    if (c[0] == 'k' || c[0] == 'K') {
      return n*0x400;
    } else if (c[0] == 'm' || c[0] == 'M') {
      return n*0x100000;
    } else if (c[0] == 'g' || c[0] == 'G') {
      return n*0x40000000;
    }
  default:
    fprintf(stderr, "Error in option \"%s\"\n", str);
    exit(-1);
  }
}

#define Optarg() \
( argv[optind][charind+1] != 0 ? \
  argv[optind]+charind+1 : \
  (optind++, argv[optind] ))

static void toploop()
{
  declare_globals;
  struct goalrec *qp = current_queue;
  Const struct predicate *toppred = qp->pred;
  module func = toppred->func;
  while (1) {
    func = (module) func(glbl, qp, heapp, toppred);
    qp = current_queue;
    toppred = qp->pred;
  }
}

main(argc, argv)
     int argc;
     char **argv;
{
  declare_globals;
  void initalloc();
  q *initiate_prioq();
  q *reinitiate_prioq();
#ifdef USESIG
  void init_klic_signal_handling();
#endif
#ifdef DEBUGLIB
  extern struct goalrec *trace_goal();
#endif

  program_name = argv[0];
  heapsize = HEAPSIZE;
  maxheapsize = (unsigned long)(-1); /* largest possible */
  maxactiveratio = 0.5;
  incrementsize = INCREMENTSIZE;

  {
    int optind;
    for (optind = 1;
	 optind < argc && argv[optind][0] == '-';
	 optind++) {
      int charind;
      for (charind = 1;
	   argv[optind][charind] != 0;
	   charind++) {
	switch (argv[optind][charind]) {
	case 'a':
	  maxactiveratio = atof(Optarg());
	  if (maxactiveratio <= 0.0 || maxactiveratio > 1.0) {
	    fatalf("Argument (%g) for option -a should be between 0 and 1",
		   maxactiveratio);
	  }
	  goto nextarg;
	case 'h':
	  heapsize = parse_size(Optarg());
	  if (heapsize > maxheapsize) maxheapsize = heapsize;
	  goto nextarg;
	case 'H':
	  maxheapsize = parse_size(Optarg());
	  if (heapsize > maxheapsize) heapsize = maxheapsize;
	  goto nextarg;
	case 'i':
	  incrementsize = parse_size(Optarg()); goto nextarg;
	case 'g':
	  measure_gc = 1; break;
	case 'v':
	  fprintf(stderr, "KLIC runtime version %s (%s)\n",
		  runtime_version, runtime_date);
	  break;
	case 't':
#ifdef DEBUGLIB
	  start_tracing = 1; break;
#else
	  fatal("Tracing is only possible when linked without -n flag");
#endif
	case '-':
	  optind++; break;
	default:
	  fprintf(stderr,
#ifdef DEBUGLIB
		  "Usage: %s [-t] [-h hsize] [-i increment] [-g] [-v]\n",
#else
		  "Usage: %s [-h hsize] [-i increment] [-g] [-v]\n",
#endif
		  argv[0]);
#ifdef DEBUGLIB
	  fprintf(stderr,
		  "\t-t: start execution with tracing\n");
#endif
	  fatalf("%s%s%s%s%s%s",
		 "\t-h <hsize>: set initial size of heap to <hsize>\n",
		 "\t\t-h 32k makes it 32KW and -h 2m means 2MW\n",
		 "\t-i <increment>: set gap between heap top and bottom\n",
		 "\t\t-i 1k sets 1KW of gap\n",
		 "\t-g: set garbage collection measurement on\n",
		 "\t-v: display KLIC runtime version\n");
	}
      }
    nextarg:;
    }
    command_argc = argc-optind;
    command_argv = argv+optind;
  }

  initalloc();

  {
    extern struct goalrec *get_top_priority_queue();
    q *allocp;
    struct goalrec *qp;

    allocp = initiate_prioq(heapp);
    suspensions = 0;
    resumes = 0;
    current_prio = -1;
#ifdef DEBUGLIB
    suspended_goal_list = 0;
#endif
    qp = (struct goalrec *) allocp;
    qp->pred = &predicate_main_xmain_0;
    heapp = allocp + 2;
#ifdef DEBUGLIB
    if (start_tracing) qp = trace_goal(qp, 1);
#endif
    (void) enqueue_goal(0, HIGHESTPRIO-1, qp, glbl);
    current_queue = get_top_priority_queue();
    resumed_goals = 0;

    interrupt_off = -1;
#ifdef USESIG
    init_klic_signal_handling();
#endif

    if (setjmp(klic_topmost) == 0) toploop();
  }
  return 0;
}

void *topsucceed(glbl, qp, allocp, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     q *allocp;
     Const struct predicate *toppred;
{
  extern q *klic_interrupt();
  extern Const struct predicate topsucceed_pred;
  if (suspensions == resumes) {
    longjmp(klic_topmost, 1);
  }

#ifdef USESIG
  /* perpetual suspension suspected, but let's wait a while for interrupts */

  /* enqueue topsucceed goal again */
  allocp[0] = (q)qp;
  allocp[1] = (q)&topsucceed_pred;
  qp = (struct goalrec *)allocp;

  /* Let's not hastily check perpetual suspension */
#ifdef USEUSLEEP
  usleep(1000);
#else
  (void) sleep(1);
#endif

  /* run GC */
  allocp = klic_interrupt(real_heaplimit, qp);
  qp = current_queue;

  if (qp->pred == &topsucceed_pred) {
    /* no interrupt after topsucceed was called */
    struct sigaction oldact, newact;
    newact.sa_handler = NULL;
    sigfillset(&newact.sa_mask);
    newact.sa_flags = 0;
    sigaction(0, &newact, &oldact);
    if (interrupt_off) pause();
    sigaction(0, &oldact, NULL);
  }
  /* check resumpsions */
  heapp = klic_interrupt(allocp, qp);
  return (void *) current_queue->pred->func;
#else
  fatalf("%d perpetually suspending goals found",
	 suspensions-resumes);
#endif
}
