/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

extern void *malloc_check();

#define BUFSIZE 1024

char *get_program_file_name()
{
  declare_globals;
  char *path;
  char buf[BUFSIZE];
  if (strchr(program_name, '/') != NULL) {
    return program_name;
  }
  path=getenv("PATH");
  while (*path != 0) {
    int k;
    for (k=0; *path != ':' && *path != '\0'; path++, k++) {
      buf[k] = *path;
    }
    buf[k] = '/';
    (void)strcpy(&buf[k+1], program_name);
    if (access(buf, X_OK) == 0) {
      char *result = (char *)malloc_check(strlen(buf)+1);
      (void)strcpy(result, buf);
      return result;
    }
    if (*path == ':') path++;
  }
  fatalf("Can't find executable program file %s", program_name);
}
