/* Compiled by KLIC compiler version 1.410 (Sun Jun 19 12:03:50 JST 1994) */
#include <klic/klichdr.h>
#include "atom.h"
#include "funct.h"

#include <string.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#include <sys/times.h>
#include <klic/gobj.h>
#include <klic/g_pointer.h>

#ifdef USESIG
#include <signal.h>
#endif

#ifdef ASYNCIO
#include <fcntl.h>
#include <stropts.h>
#endif

extern char *malloc_check();
extern struct data_object_method_table pointer_g_data_method_table;
q *register_streamed_signal();

extern char *generic_string_body();
extern char *convert_klic_string_to_c_string();
extern q convert_c_string_to_klic_string();
extern q convert_binary_c_string_to_klic_string();

#define KLIC2C convert_klic_string_to_c_string
#define C2KLIC convert_c_string_to_klic_string
#define BC2KLIC convert_binary_c_string_to_klic_string

extern q gd_new_pointer();
#define FilePointer(x) \
  ((FILE*)((struct pointer_object *)(data_objectp(x)))->pointer)

#define MakeFilePointer(klicvar,file) \
{ \
  klicvar = gd_new_pointer((q)file, allocp); \
  allocp = heapp; \
}

#define Fopen(P,F,L,M) \
{ \
  char *path = KLIC2C(P); \
  FILE *file = fopen(path, M); \
  free(path); \
  if (file==NULL) goto L; \
  MakeFilePointer(F, file); \
}

#define Fdopen(Fd,F,L,M) \
{ \
  FILE *file = fdopen(Fd, M); \
  if (file==NULL) goto L; \
  MakeFilePointer(F, file); \
}

static char buffer[4096];

#ifdef USEBCOPY
#define BCOPY(from,to,len)	bcopy(from,to,len)
#else
#define BCOPY(from,to,len)	memcpy(to,from,len)
#endif

struct iobuf {
  char *ptr, *lim, *buf;
  int fd;
  int bufsize;
};

static struct iobuf *make_iobuf(fd, size, isout)
     int fd, size, isout;
{
  struct iobuf *iob = (struct iobuf *)malloc_check(sizeof(struct iobuf));
  iob->fd = fd;
  iob->bufsize = size;
  iob->buf = malloc_check(iob->bufsize);
  iob->ptr = iob->buf;
  if (isout) {
    iob->lim = iob->buf+size;
  } else {
    iob->lim = iob->buf;
  }
  return iob;
}

#define MakeInBuf(klicvar, fd, size) \
{ \
  klicvar = gd_new_pointer((q)make_iobuf(fd,size,0), allocp); \
  allocp = heapp; \
}

#define MakeOutBuf(klicvar, fd, size) \
{ \
  klicvar = gd_new_pointer((q)make_iobuf(fd,size,1), allocp); \
  allocp = heapp; \
}

#define IOBuf(x) \
  ((struct iobuf*)((struct pointer_object *)(data_objectp(x)))->pointer)

static int fill_buf(iob)
     struct iobuf *iob;
{
  while (1) {
    int result = read(iob->fd, iob->buf, iob->bufsize);
    if (result < 0) {
      switch (errno) {
      case EINTR: continue;
#ifdef ASYNCIO
      case EAGAIN:
#ifdef EWOULDBLOCK
#if EWOULDBLOCK != EAGAIN
      case EWOULDBLOCK:
#endif
#endif
	return -1;
#endif
      default:
	fatalp("read", "Error in asynchronous input");
      }
    } else if (result == 0) {
      return 0;			/* end of file */
    } else {
      iob->lim = iob->buf+result;
      iob->ptr = iob->buf;
      return 1;
    }
  }
}

static int write_buf(iob)
     struct iobuf *iob;
{
  while (1) {
    int result = write(iob->fd, iob->buf, (iob->ptr - iob->buf));
    if (result < 0) {
      switch (errno) {
      case EINTR: continue;
#ifdef ASYNCIO
      case EAGAIN:
#ifdef EWOULDBLOCK
#if EWOULDBLOCK != EAGAIN
      case EWOULDBLOCK:
#endif
#endif
	return -1;
#endif
      default:
	fatalp("write", "Error in asynchronous input");
      }
    } else {
      iob->lim = iob->buf + iob->bufsize;
      iob->ptr = iob->buf;
      return 1;
    }
  }
}

static void setasync(sock, msg)
     int sock;
     char *msg;
{
#ifdef ASYNCIO
  if (fcntl(sock, F_SETOWN, getpid()) < -1) {
    fatalp("fcntl", "Setting error for %s", msg);
  }
#ifdef FASYNC
  if (fcntl(sock, F_SETFL, FASYNC|O_NONBLOCK) < -1) {
    fatalp("fcntl", "Setting error for %s", msg);
  }
#else
  if (fcntl(sock, F_SETFL, O_NONBLOCK) < -1) {
    fatalp("fcntl", "Setting error for %s", msg);
  }
  if (ioctl(sock, I_SETSIG, S_INPUT|S_OUTPUT) != 0) {
    fatalp("ioctl", "Setting error for %s", msg);
  }
#endif
#endif
}


module module_unix();
Const struct predicate predicate_unix_xexit_1 =
   { module_unix, 0, 1 };
Const struct predicate predicate_unix_xunix_1 =
   { module_unix, 1, 1 };
Const struct predicate predicate_unix_xcont_3 =
   { module_unix, 2, 3 };
Const struct predicate predicate_unix_xstdin_1 =
   { module_unix, 3, 1 };
Const struct predicate predicate_unix_xstdout_1 =
   { module_unix, 4, 1 };
Const struct predicate predicate_unix_xstderr_1 =
   { module_unix, 5, 1 };
Const struct predicate predicate_unix_xread__open_2 =
   { module_unix, 6, 2 };
Const struct predicate predicate_unix_xwrite__open_2 =
   { module_unix, 7, 2 };
Const struct predicate predicate_unix_xappend__open_2 =
   { module_unix, 8, 2 };
Const struct predicate predicate_unix_xupdate__open_2 =
   { module_unix, 9, 2 };
Const struct predicate predicate_unix_xsignal__stream_2 =
   { module_unix, 10, 2 };
Const struct predicate predicate_unix_xsignal__stream_3 =
   { module_unix, 11, 3 };
Const struct predicate predicate_unix_xnet__convert_3 =
   { module_unix, 12, 3 };
Const struct predicate predicate_unix_xconnect_2 =
   { module_unix, 13, 2 };
Const struct predicate predicate_unix_xconnect_4 =
   { module_unix, 14, 4 };
Const struct predicate predicate_unix_xconnect__sub_4 =
   { module_unix, 15, 4 };
Const struct predicate predicate_unix_xbind_2 =
   { module_unix, 16, 2 };
Const struct predicate predicate_unix_xbind_4 =
   { module_unix, 17, 4 };
Const struct predicate predicate_unix_xbound__sock_4 =
   { module_unix, 18, 4 };
Const struct predicate predicate_unix_xpipe_1 =
   { module_unix, 19, 1 };
Const struct predicate predicate_unix_xin_2 =
   { module_unix, 20, 2 };
Const struct predicate predicate_unix_xout_2 =
   { module_unix, 21, 2 };
Const struct predicate predicate_unix_xupdate_2 =
   { module_unix, 22, 2 };
Const struct predicate predicate_unix_xclosed_1 =
   { module_unix, 23, 1 };
Const struct predicate predicate_unix_xgetc_3 =
   { module_unix, 24, 3 };
Const struct predicate predicate_unix_xungetc_3 =
   { module_unix, 25, 3 };
Const struct predicate predicate_unix_xfread_4 =
   { module_unix, 26, 4 };
Const struct predicate predicate_unix_xputc_3 =
   { module_unix, 27, 3 };
Const struct predicate predicate_unix_xfwrite_4 =
   { module_unix, 28, 4 };
Const struct predicate predicate_unix_xfeof_3 =
   { module_unix, 29, 3 };
Const struct predicate predicate_unix_xfseek_5 =
   { module_unix, 30, 5 };
Const struct predicate predicate_unix_xftell_3 =
   { module_unix, 31, 3 };
Const struct predicate predicate_unix_xfflush_3 =
   { module_unix, 32, 3 };
Const struct predicate predicate_unix_xfclose_2 =
   { module_unix, 33, 2 };
Const struct predicate predicate_unix_xasync__io_4 =
   { module_unix, 34, 4 };
Const struct predicate predicate_unix_xsystem_2 =
   { module_unix, 35, 2 };
Const struct predicate predicate_unix_xcd_2 =
   { module_unix, 36, 2 };
Const struct predicate predicate_unix_xunlink_2 =
   { module_unix, 37, 2 };
Const struct predicate predicate_unix_xmktemp_2 =
   { module_unix, 38, 2 };
Const struct predicate predicate_unix_xaccess_3 =
   { module_unix, 39, 3 };
Const struct predicate predicate_unix_xchmod_3 =
   { module_unix, 40, 3 };
Const struct predicate predicate_unix_xumask_1 =
   { module_unix, 41, 1 };
Const struct predicate predicate_unix_xumask_2 =
   { module_unix, 42, 2 };
Const struct predicate predicate_unix_xgetenv_2 =
   { module_unix, 43, 2 };
Const struct predicate predicate_unix_xputenv_2 =
   { module_unix, 44, 2 };
Const struct predicate predicate_unix_xkill_3 =
   { module_unix, 45, 3 };
Const struct predicate predicate_unix_xfork_1 =
   { module_unix, 46, 1 };
Const struct predicate predicate_unix_xfork__with__pipes_1 =
   { module_unix, 47, 1 };
Const struct predicate predicate_unix_xfork__with__pipes_2F1_240_6 =
   { module_unix, 48, 6 };
Const struct predicate predicate_unix_xargc_1 =
   { module_unix, 49, 1 };
Const struct predicate predicate_unix_xargv_1 =
   { module_unix, 50, 1 };
Const struct predicate predicate_unix_xmake__argv__list_3 =
   { module_unix, 51, 3 };
Const struct predicate predicate_unix_xtimes_4 =
   { module_unix, 52, 4 };
extern q file__io_g_new();

module module_unix(glbl, qp, allocp, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  register q *allocp;
  Const struct predicate *toppred;
{
  Const static q vectconst_body_0[] = {
    makeint(0),
    makeint(0),
    makeint(0),
    makeint(0),
  };
  Const static vector_structure_type vector_const_0 =
      declare_vector_constant(vectconst_body_0,4);
  q a0, a1, a2, a3, a4, a5;

  q *reasonp;
 module_top:
  a0 = qp->args[0];
  switch_on_pred() {
    case_pred(0, exit_1_top);
    case_pred(1, unix_1_top);
    case_pred(2, cont_3_top);
    case_pred(3, stdin_1_top);
    case_pred(4, stdout_1_top);
    case_pred(5, stderr_1_top);
    case_pred(6, read__open_2_top);
    case_pred(7, write__open_2_top);
    case_pred(8, append__open_2_top);
    case_pred(9, update__open_2_top);
    case_pred(10, signal__stream_2_top);
    case_pred(11, signal__stream_3_top);
    case_pred(12, net__convert_3_top);
    case_pred(13, connect_2_top);
    case_pred(14, connect_4_top);
    case_pred(15, connect__sub_4_top);
    case_pred(16, bind_2_top);
    case_pred(17, bind_4_top);
    case_pred(18, bound__sock_4_top);
    case_pred(19, pipe_1_top);
    case_pred(20, in_2_top);
    case_pred(21, out_2_top);
    case_pred(22, update_2_top);
    case_pred(23, closed_1_top);
    case_pred(24, getc_3_top);
    case_pred(25, ungetc_3_top);
    case_pred(26, fread_4_top);
    case_pred(27, putc_3_top);
    case_pred(28, fwrite_4_top);
    case_pred(29, feof_3_top);
    case_pred(30, fseek_5_top);
    case_pred(31, ftell_3_top);
    case_pred(32, fflush_3_top);
    case_pred(33, fclose_2_top);
    case_pred(34, async__io_4_top);
    case_pred(35, system_2_top);
    case_pred(36, cd_2_top);
    case_pred(37, unlink_2_top);
    case_pred(38, mktemp_2_top);
    case_pred(39, access_3_top);
    case_pred(40, chmod_3_top);
    case_pred(41, umask_1_top);
    case_pred(42, umask_2_top);
    case_pred(43, getenv_2_top);
    case_pred(44, putenv_2_top);
    case_pred(45, kill_3_top);
    case_pred(46, fork_1_top);
    case_pred(47, fork__with__pipes_1_top);
    case_pred(48, fork__with__pipes_2F1_240_6_top);
    case_pred(49, argc_1_top);
    case_pred(50, argv_1_top);
    case_pred(51, make__argv__list_3_top);
    last_case_pred(52, times_4_top);
  }

 exit_1_top: {
  qp = qp->next;
 exit_1_clear_reason:
  reasonp = reasons;
 exit_1_0:
 exit_1_1:
  if (!isint(a0)) goto exit_1_4;
  exit(intval(a0));
  proceed();
 exit_1_4:
  if (!isref(a0)) goto exit_1_interrupt;
  deref_and_jump(a0,exit_1_1);
  *reasonp++ =  a0;
  goto exit_1_interrupt;
 exit_1_ext_interrupt:
  reasonp = 0l;
 exit_1_interrupt:
  goto interrupt_1;
 }

 unix_1_top: {
  q x0, x1, x2, x3;
  qp = qp->next;
 unix_1_clear_reason:
  reasonp = reasons;
 unix_1_0:
 unix_1_1:
  switch (ptagof(a0)) {
 case CONS:
  x0 = car_of(a0);
 unix_1_3:
  switch (ptagof(x0)) {
 case FUNCTOR:
  switch (symval(functor_of(x0))) {
 case functor_stdin_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 0);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(stdin_1_0);
  goto stdin_1_ext_interrupt;
 case functor_stdout_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 0);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(stdout_1_0);
  goto stdout_1_ext_interrupt;
 case functor_stderr_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 0);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(stderr_1_0);
  goto stderr_1_ext_interrupt;
 case functor_read__open_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(read__open_2_0);
  goto read__open_2_ext_interrupt;
 case functor_write__open_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(write__open_2_0);
  goto write__open_2_ext_interrupt;
 case functor_append__open_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(append__open_2_0);
  goto append__open_2_ext_interrupt;
 case functor_update__open_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(update__open_2_0);
  goto update__open_2_ext_interrupt;
 case functor_signal__stream_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(signal__stream_2_0);
  goto signal__stream_2_ext_interrupt;
 case functor_connect_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(connect_2_0);
  goto connect_2_ext_interrupt;
 case functor_bind_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(bind_2_0);
  goto bind_2_ext_interrupt;
 case functor_pipe_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 0);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(pipe_1_0);
  goto pipe_1_ext_interrupt;
 case functor_system_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(system_2_0);
  goto system_2_ext_interrupt;
 case functor_cd_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(cd_2_0);
  goto cd_2_ext_interrupt;
 case functor_unlink_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(unlink_2_0);
  goto unlink_2_ext_interrupt;
 case functor_mktemp_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(mktemp_2_0);
  goto mktemp_2_ext_interrupt;
 case functor_access_3:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 2);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = arg(x0, 1);
  a2 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(access_3_0);
  goto access_3_ext_interrupt;
 case functor_chmod_3:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 2);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = arg(x0, 1);
  a2 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(chmod_3_0);
  goto chmod_3_ext_interrupt;
 case functor_umask_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 0);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(umask_1_0);
  goto umask_1_ext_interrupt;
 case functor_umask_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(umask_2_0);
  goto umask_2_ext_interrupt;
 case functor_getenv_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(getenv_2_0);
  goto getenv_2_ext_interrupt;
 case functor_putenv_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 1);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(getenv_2_0);
  goto getenv_2_ext_interrupt;
 case functor_kill_3:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 2);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = arg(x0, 0);
  a1 = arg(x0, 1);
  a2 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(kill_3_0);
  goto kill_3_ext_interrupt;
 case functor_fork_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 0);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(fork_1_0);
  goto fork_1_ext_interrupt;
 case functor_fork__with__pipes_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xcont_3);
  allocp[2] = x1 = makeref(&allocp[2]);
  x2 = arg(x0, 0);
  allocp[3] = x2;
  x3 = cdr_of(a0);
  allocp[4] = x3;
  a0 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 5;
  execute(fork__with__pipes_1_0);
  goto fork__with__pipes_1_ext_interrupt;
 case functor_sync_1:
  x1 = arg(x0, 0);
  unify_value(x1, NILATOM);
  a0 = cdr_of(a0);
  execute(unix_1_0);
  goto unix_1_ext_interrupt;
 default:
  goto unix_1_interrupt;
  };
 case VARREF:
  deref_and_jump(x0,unix_1_3);
  *reasonp++ =  x0;
  goto unix_1_interrupt;
  };
  goto unix_1_interrupt;
 case ATOMIC:
  if (a0 != NILATOM) goto unix_1_interrupt;
  proceed();
 case VARREF:
  deref_and_jump(a0,unix_1_1);
  *reasonp++ =  a0;
  goto unix_1_interrupt;
  };
  goto unix_1_interrupt;
 unix_1_ext_interrupt:
  reasonp = 0l;
 unix_1_interrupt:
  toppred = &predicate_unix_xunix_1;
  goto interrupt_1;
 }

 cont_3_top: {
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 cont_3_clear_reason:
  reasonp = reasons;
 cont_3_0:
 cont_3_1:
  if (isref(a0)) goto cont_3_4;
  gblt_wait(a0,cont_3_interrupt);
  unify_value(a1, a0);
  a0 = a2;
  execute(unix_1_0);
  goto unix_1_ext_interrupt;
 cont_3_4:
  deref_and_jump(a0,cont_3_1);
  *reasonp++ =  a0;
  goto cont_3_interrupt;
 cont_3_ext_interrupt:
  reasonp = 0l;
 cont_3_interrupt:
  goto interrupt_3;
 }

 stdin_1_top: {
  q x0, x1, x2;
  qp = qp->next;
 stdin_1_clear_reason:
  reasonp = reasons;
 stdin_1_0:
  MakeFilePointer(x0, stdin);
  generic_arg[0] = x0;
  generic_arg[1] = makeint(0L);
  new_generic(file__io_g_new, 2, x1, 0);
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x1;
  x2 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a0, x2);
  proceed();
 stdin_1_ext_interrupt:
  reasonp = 0l;
 stdin_1_interrupt:
  toppred = &predicate_unix_xstdin_1;
  goto interrupt_1;
 }

 stdout_1_top: {
  q x0, x1, x2;
  qp = qp->next;
 stdout_1_clear_reason:
  reasonp = reasons;
 stdout_1_0:
  MakeFilePointer(x0, stdout);
  generic_arg[0] = x0;
  generic_arg[1] = makeint(0L);
  new_generic(file__io_g_new, 2, x1, 0);
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x1;
  x2 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a0, x2);
  proceed();
 stdout_1_ext_interrupt:
  reasonp = 0l;
 stdout_1_interrupt:
  toppred = &predicate_unix_xstdout_1;
  goto interrupt_1;
 }

 stderr_1_top: {
  q x0, x1, x2;
  qp = qp->next;
 stderr_1_clear_reason:
  reasonp = reasons;
 stderr_1_0:
  MakeFilePointer(x0, stderr);
  generic_arg[0] = x0;
  generic_arg[1] = makeint(0L);
  new_generic(file__io_g_new, 2, x1, 0);
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x1;
  x2 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a0, x2);
  proceed();
 stderr_1_ext_interrupt:
  reasonp = 0l;
 stderr_1_interrupt:
  toppred = &predicate_unix_xstderr_1;
  goto interrupt_1;
 }

 read__open_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 read__open_2_clear_reason:
  reasonp = reasons;
 read__open_2_0:
 read__open_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 read__open_2_2:
  if (!isgobj(a0)) goto read__open_2_6;
  if (!isclass(a0,byte__string)) goto read__open_2_6;
  Fopen(a0,x0,read__open_2_6,"r");
  generic_arg[0] = x0;
  generic_arg[1] = a0;
  new_generic(file__io_g_new, 2, x1, 0);
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x1;
  x2 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a1, x2);
  proceed();
 case VARREF:
  deref_and_jump(a0,read__open_2_1);
  *reasonp++ =  a0;
  goto read__open_2_6;
  };
  goto read__open_2_6;
 read__open_2_6:
  otherwise(read__open_2_interrupt);
  unify_value(a1, makesym(atom_abnormal));
  proceed();
 read__open_2_ext_interrupt:
  reasonp = 0l;
 read__open_2_interrupt:
  toppred = &predicate_unix_xread__open_2;
  goto interrupt_2;
 }

 write__open_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 write__open_2_clear_reason:
  reasonp = reasons;
 write__open_2_0:
 write__open_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 write__open_2_2:
  if (!isgobj(a0)) goto write__open_2_6;
  if (!isclass(a0,byte__string)) goto write__open_2_6;
  Fopen(a0,x0,write__open_2_6,"w");
  generic_arg[0] = x0;
  generic_arg[1] = a0;
  new_generic(file__io_g_new, 2, x1, 0);
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x1;
  x2 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a1, x2);
  proceed();
 case VARREF:
  deref_and_jump(a0,write__open_2_1);
  *reasonp++ =  a0;
  goto write__open_2_6;
  };
  goto write__open_2_6;
 write__open_2_6:
  otherwise(write__open_2_interrupt);
  unify_value(a1, makesym(atom_abnormal));
  proceed();
 write__open_2_ext_interrupt:
  reasonp = 0l;
 write__open_2_interrupt:
  toppred = &predicate_unix_xwrite__open_2;
  goto interrupt_2;
 }

 append__open_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 append__open_2_clear_reason:
  reasonp = reasons;
 append__open_2_0:
 append__open_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 append__open_2_2:
  if (!isgobj(a0)) goto append__open_2_6;
  if (!isclass(a0,byte__string)) goto append__open_2_6;
  Fopen(a0,x0,append__open_2_6,"a");
  generic_arg[0] = x0;
  generic_arg[1] = a0;
  new_generic(file__io_g_new, 2, x1, 0);
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x1;
  x2 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a1, x2);
  proceed();
 case VARREF:
  deref_and_jump(a0,append__open_2_1);
  *reasonp++ =  a0;
  goto append__open_2_6;
  };
  goto append__open_2_6;
 append__open_2_6:
  otherwise(append__open_2_interrupt);
  unify_value(a1, makesym(atom_abnormal));
  proceed();
 append__open_2_ext_interrupt:
  reasonp = 0l;
 append__open_2_interrupt:
  toppred = &predicate_unix_xappend__open_2;
  goto interrupt_2;
 }

 update__open_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 update__open_2_clear_reason:
  reasonp = reasons;
 update__open_2_0:
 update__open_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 update__open_2_2:
  if (!isgobj(a0)) goto update__open_2_6;
  if (!isclass(a0,byte__string)) goto update__open_2_6;
  Fopen(a0,x0,update__open_2_6,"r+");
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x2 = makeref(&allocp[1]);
  x1 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a1, x1);
  a0 = x2;
  a1 = x0;
  execute(update_2_clear_reason);
  goto update_2_ext_interrupt;
 case VARREF:
  deref_and_jump(a0,update__open_2_1);
  *reasonp++ =  a0;
  goto update__open_2_6;
  };
  goto update__open_2_6;
 update__open_2_6:
  otherwise(update__open_2_interrupt);
  unify_value(a1, makesym(atom_abnormal));
  proceed();
 update__open_2_ext_interrupt:
  reasonp = 0l;
 update__open_2_interrupt:
  toppred = &predicate_unix_xupdate__open_2;
  goto interrupt_2;
 }

 signal__stream_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 signal__stream_2_clear_reason:
  reasonp = reasons;
 signal__stream_2_0:
  allocp[0] = x0 = makeref(&allocp[0]);
  a2 = x0;
  allocp += 1;
  execute(signal__stream_3_0);
  goto signal__stream_3_ext_interrupt;
 signal__stream_2_ext_interrupt:
  reasonp = 0l;
 signal__stream_2_interrupt:
  toppred = &predicate_unix_xsignal__stream_2;
  goto interrupt_2;
 }

 signal__stream_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 signal__stream_3_clear_reason:
  reasonp = reasons;
 signal__stream_3_0:
 signal__stream_3_1:
  if (!isint(a0)) goto signal__stream_3_4;
  
{
  allocp = register_streamed_signal(allocp, intval(a0), a2);
}
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = a2;
  x0 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a1, x0);
  proceed();
 signal__stream_3_4:
  if (!isref(a0)) goto signal__stream_3_interrupt;
  deref_and_jump(a0,signal__stream_3_1);
  *reasonp++ =  a0;
  goto signal__stream_3_interrupt;
 signal__stream_3_ext_interrupt:
  reasonp = 0l;
 signal__stream_3_interrupt:
  toppred = &predicate_unix_xsignal__stream_3;
  goto interrupt_3;
 }

 net__convert_3_top: {
  q x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 net__convert_3_clear_reason:
  reasonp = reasons;
 net__convert_3_0:
 net__convert_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
  switch (symval(functor_of(a0))) {
 case functor_unix_1:
  x0 = arg(a0, 0);
 net__convert_3_4:
  switch (ptagof(x0)) {
 case FUNCTOR:
 net__convert_3_5:
  if (!isgobj(x0)) goto net__convert_3_interrupt;
  if (!isclass(x0,byte__string)) goto net__convert_3_interrupt;
  
{
  int family = PF_UNIX;
  struct sockaddr *addr;
  char *path = KLIC2C(x0);

  addr =
    (struct sockaddr *)malloc_check(sizeof(struct sockaddr)+strlen(path));
  addr->sa_family = family;
  strcpy(addr->sa_data, path);
  free(path);
  x1 = makeint(family);
  x2 = gd_new_pointer((q)addr, allocp);
  allocp = heapp;
}
  unify_value(a1, x1);
  unify_value(a2, x2);
  proceed();
 case VARREF:
  deref_and_jump(x0,net__convert_3_4);
  *reasonp++ =  x0;
  goto net__convert_3_interrupt;
  };
  goto net__convert_3_interrupt;
 case functor_inet_2:
  x0 = arg(a0, 0);
 net__convert_3_10:
  switch (ptagof(x0)) {
 case FUNCTOR:
 net__convert_3_11:
  if (!isgobj(x0)) goto net__convert_3_interrupt;
  if (!isclass(x0,byte__string)) goto net__convert_3_18;
  x1 = arg(a0, 1);
 net__convert_3_14:
  if (!isint(x1)) goto net__convert_3_17;
  
{
  int family = PF_INET;
  struct sockaddr_in *addr;
  char *host = KLIC2C(x0);
  struct hostent *ent = gethostbyname(host);

  if (ent == NULL) { fatalf("Unknown host %s", host); };
  free(host);
  addr = (struct sockaddr_in *)malloc_check(sizeof(struct sockaddr_in));
  addr->sin_family = family;
  BCOPY((char*)*ent->h_addr_list, (char*)&addr->sin_addr,
	sizeof(struct in_addr));
/*
  The following is not used as some systems don't understand it.

  addr->sin_addr.S_un.S_addr = *(int*)*ent->h_addr_list;
*/
  addr->sin_port = htons(intval(x1));
  x2 = makeint(family);
  x3 = gd_new_pointer((q)addr, allocp);
  allocp = heapp;
}
  unify_value(a1, x2);
  unify_value(a2, x3);
  proceed();
 net__convert_3_17:
  if (!isref(x1)) goto net__convert_3_interrupt;
  deref_and_jump(x1,net__convert_3_14);
  *reasonp++ =  x1;
  goto net__convert_3_interrupt;
 net__convert_3_18:
  if (!isclass(x0,vector)) goto net__convert_3_interrupt;
  gblt_size_of_vector(x0,x4,net__convert_3_interrupt);
 net__convert_3_21:
  if (x4 != makeint(4L)) goto net__convert_3_interrupt;
  gblt_element_of_vector(x0,makeint(0L),x5,net__convert_3_interrupt);
  gblt_element_of_vector(x0,makeint(1L),x6,net__convert_3_interrupt);
  gblt_element_of_vector(x0,makeint(2L),x7,net__convert_3_interrupt);
  gblt_element_of_vector(x0,makeint(3L),x8,net__convert_3_interrupt);
 net__convert_3_27:
  if (!isint(x5)) goto net__convert_3_42;
 net__convert_3_29:
  if (!isint(x6)) goto net__convert_3_41;
 net__convert_3_31:
  if (!isint(x7)) goto net__convert_3_40;
 net__convert_3_33:
  if (!isint(x8)) goto net__convert_3_39;
  x9 = arg(a0, 1);
 net__convert_3_35:
  if (!isint(x9)) goto net__convert_3_38;
  
{
  int family = PF_INET;
  struct sockaddr_in *addr;
  int b1, b2, b3, b4;
  unsigned long laddr;
  char buf[100];

  addr = (struct sockaddr_in *)malloc_check(sizeof(struct sockaddr_in));
  addr->sin_family = family;
  b1 = intval(x5); b2 = intval(x6); b3 = intval(x7); b4 = intval(x8);
  (void)sprintf(buf, "%d.%d.%d.%d", b1, b2, b3, b4);
  laddr = inet_addr(buf);
  if (laddr == -1) goto net__convert_3_interrupt;
  BCOPY((char*)&laddr, (char*)&addr->sin_addr, sizeof(struct in_addr));
/*
  The following is not used as some systems don't understand it.

  addr->sin_addr.S_un.S_un_b.s_b1 = intval(x5);
  addr->sin_addr.S_un.S_un_b.s_b2 = intval(x6);
  addr->sin_addr.S_un.S_un_b.s_b3 = intval(x7);
  addr->sin_addr.S_un.S_un_b.s_b4 = intval(x8);
*/
  addr->sin_port = htons(intval(x9));
  x10 = makeint(family);
  x11 = gd_new_pointer((q)addr, allocp);
  allocp = heapp;
}
  unify_value(a1, x10);
  unify_value(a2, x11);
  proceed();
 net__convert_3_38:
  if (!isref(x9)) goto net__convert_3_interrupt;
  deref_and_jump(x9,net__convert_3_35);
  *reasonp++ =  x9;
  goto net__convert_3_interrupt;
 net__convert_3_39:
  if (!isref(x8)) goto net__convert_3_interrupt;
  deref_and_jump(x8,net__convert_3_33);
  *reasonp++ =  x8;
  goto net__convert_3_interrupt;
 net__convert_3_40:
  if (!isref(x7)) goto net__convert_3_interrupt;
  deref_and_jump(x7,net__convert_3_31);
  *reasonp++ =  x7;
  goto net__convert_3_interrupt;
 net__convert_3_41:
  if (!isref(x6)) goto net__convert_3_interrupt;
  deref_and_jump(x6,net__convert_3_29);
  *reasonp++ =  x6;
  goto net__convert_3_interrupt;
 net__convert_3_42:
  if (!isref(x5)) goto net__convert_3_interrupt;
  deref_and_jump(x5,net__convert_3_27);
  *reasonp++ =  x5;
  goto net__convert_3_interrupt;
 case VARREF:
  deref_and_jump(x0,net__convert_3_10);
  *reasonp++ =  x0;
  goto net__convert_3_interrupt;
  };
  goto net__convert_3_interrupt;
 default:
  goto net__convert_3_interrupt;
  };
 case VARREF:
  deref_and_jump(a0,net__convert_3_1);
  *reasonp++ =  a0;
  goto net__convert_3_interrupt;
  };
  goto net__convert_3_interrupt;
 net__convert_3_ext_interrupt:
  reasonp = 0l;
 net__convert_3_interrupt:
  toppred = &predicate_unix_xnet__convert_3;
  goto interrupt_3;
 }

 connect_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 connect_2_clear_reason:
  reasonp = reasons;
 connect_2_0:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xconnect_4);
  allocp[2] = x0 = makeref(&allocp[2]);
  allocp[3] = x1 = makeref(&allocp[3]);
  allocp[4] = x2 = makeref(&allocp[4]);
  allocp[5] = a1;
  a1 = x0;
  a2 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 6;
  execute(net__convert_3_0);
  goto net__convert_3_ext_interrupt;
 connect_2_ext_interrupt:
  reasonp = 0l;
 connect_2_interrupt:
  toppred = &predicate_unix_xconnect_2;
  goto interrupt_2;
 }

 connect_4_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 connect_4_clear_reason:
  reasonp = reasons;
 connect_4_0:
 connect_4_1:
  if (!isint(a0)) goto connect_4_4;
  
{
  int family = intval(a0);
  int sock = socket(family, SOCK_STREAM, 0);

  if (sock < 0) { fatalp("socket", "Socket creation error"); }
  init_asynchronous_io();
  setasync(sock, "connection");
  register_asynchronous_io_stream(sock, a2);
  x0 = makeint(sock);
}
  a0 = x0;
  execute(connect__sub_4_clear_reason);
  goto connect__sub_4_ext_interrupt;
 connect_4_4:
  if (!isref(a0)) goto connect_4_interrupt;
  deref_and_jump(a0,connect_4_1);
  *reasonp++ =  a0;
  goto connect_4_interrupt;
 connect_4_ext_interrupt:
  reasonp = 0l;
 connect_4_interrupt:
  toppred = &predicate_unix_xconnect_4;
  goto interrupt_4;
 }

 connect__sub_4_top: {
  q x0, x1, x2, x3;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 connect__sub_4_clear_reason:
  reasonp = reasons;
 connect__sub_4_0:
 connect__sub_4_1:
  if (!isint(a0)) goto connect__sub_4_8;
 connect__sub_4_3:
  switch (ptagof(a1)) {
 case FUNCTOR:
 connect__sub_4_4:
  if (!isgobj(a1)) goto connect__sub_4_9;
  if (!isclass(a1,pointer)) goto connect__sub_4_9;
  
{
  int sock = intval(a0);
  struct sockaddr *addr =
    (struct sockaddr*)((struct pointer_object *)(data_objectp(a1)))->pointer;
  struct iobuf *inb, *outb;

  if (connect(sock, addr, sizeof(struct sockaddr)) < 0) {
#ifdef ASYNCIO
    if (errno != EISCONN) {
      if (errno == EINPROGRESS || errno == EALREADY) goto connect__sub_4_9;
#endif
      fatalp("connect", "Socket connection error");
#ifdef ASYNCIO
    }
#endif
  }
  free(addr);
  MakeInBuf(x0, sock, 4096);
  MakeOutBuf(x1, sock, 4096);
}
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x3 = makeref(&allocp[1]);
  x2 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a3, x2);
  a0 = x3;
  a1 = a2;
  a2 = x0;
  a3 = x1;
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a1,connect__sub_4_3);
  *reasonp++ =  a1;
  goto connect__sub_4_9;
  };
  goto connect__sub_4_9;
 connect__sub_4_8:
  if (!isref(a0)) goto connect__sub_4_9;
  deref_and_jump(a0,connect__sub_4_1);
  *reasonp++ =  a0;
  goto connect__sub_4_9;
 connect__sub_4_9:
  alternatively;
 connect__sub_4_11:
  switch (ptagof(a2)) {
 case CONS:
  a2 = cdr_of(a2);
  execute(connect_4_clear_reason);
  goto connect_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a2,connect__sub_4_11);
  *reasonp++ =  a2;
  goto connect__sub_4_interrupt;
  };
  goto connect__sub_4_interrupt;
 connect__sub_4_ext_interrupt:
  reasonp = 0l;
 connect__sub_4_interrupt:
  toppred = &predicate_unix_xconnect__sub_4;
  goto interrupt_4;
 }

 bind_2_top: {
  q x0, x1, x2, x3, x4;
  a1 = qp->args[1];
  qp = qp->next;
 bind_2_clear_reason:
  reasonp = reasons;
 bind_2_0:
 bind_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
  switch (symval(functor_of(a0))) {
 case functor_unix_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xbind_4);
  allocp[2] = x0 = makeref(&allocp[2]);
  allocp[3] = x1 = makeref(&allocp[3]);
  allocp[4] = x2 = makeref(&allocp[4]);
  allocp[5] = a1;
  allocp[6] = makesym(functor_unix_1);
  x4 = arg(a0, 0);
  allocp[7] = x4;
  x3 = makefunctor(&allocp[6]);
  a0 = x3;
  a1 = x0;
  a2 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 8;
  execute(net__convert_3_0);
  goto net__convert_3_ext_interrupt;
 case functor_inet_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xbind_4);
  allocp[2] = x0 = makeref(&allocp[2]);
  allocp[3] = x1 = makeref(&allocp[3]);
  allocp[4] = x2 = makeref(&allocp[4]);
  allocp[5] = a1;
  allocp[6] = makesym(functor_inet_2);
  allocp[7] = makefunctor(&vector_const_0);
  x4 = arg(a0, 0);
  allocp[8] = x4;
  x3 = makefunctor(&allocp[6]);
  a0 = x3;
  a1 = x0;
  a2 = x1;
  qp = (struct goalrec*)&allocp[0];
  allocp += 9;
  execute(net__convert_3_0);
  goto net__convert_3_ext_interrupt;
 default:
  goto bind_2_interrupt;
  };
 case VARREF:
  deref_and_jump(a0,bind_2_1);
  *reasonp++ =  a0;
  goto bind_2_interrupt;
  };
  goto bind_2_interrupt;
 bind_2_ext_interrupt:
  reasonp = 0l;
 bind_2_interrupt:
  toppred = &predicate_unix_xbind_2;
  goto interrupt_2;
 }

 bind_4_top: {
  q x0, x1, x2, x3;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 bind_4_clear_reason:
  reasonp = reasons;
 bind_4_0:
 bind_4_1:
  if (!isint(a0)) goto bind_4_8;
 bind_4_3:
  switch (ptagof(a1)) {
 case FUNCTOR:
 bind_4_4:
  if (!isgobj(a1)) goto bind_4_interrupt;
  if (!isclass(a1,pointer)) goto bind_4_interrupt;
  
{
  int family = intval(a0);
  int reuse = 1;
  struct sockaddr *addr =
    (struct sockaddr*)((struct pointer_object *)(data_objectp(a1)))->pointer;
  int sock = socket(family, SOCK_STREAM, 0);

  if (sock < 0) { fatalp("socket", "Socket creation error"); }
  init_asynchronous_io();

  if (addr->sa_family == PF_INET) {
    if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR,
		   (char *)&reuse, sizeof(reuse))) {
      fatalp("setsockopt", "Socket reuse setting error for binding");
    }
  }
  if (bind(sock, addr, sizeof(struct sockaddr)) < 0) {
    fatalp("bind", "Socket binding error");
  }
  free(addr);
  setasync(sock, "bound socket");
  if (listen(sock, 5) < 0) {
    fatalp("listen", "Socket listen error");
  }
  register_asynchronous_io_stream(sock, a2);
  x0 = makeint(sock);
}
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x2 = makeref(&allocp[1]);
  x1 = makefunctor(&allocp[0]);
  allocp += 2;
  unify_value(a3, x1);
  a0 = x2;
  a1 = x0;
  allocp[0] = x3 = makeref(&allocp[0]);
  a3 = x3;
  allocp += 1;
  execute(bound__sock_4_clear_reason);
  goto bound__sock_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a1,bind_4_3);
  *reasonp++ =  a1;
  goto bind_4_interrupt;
  };
  goto bind_4_interrupt;
 bind_4_8:
  if (!isref(a0)) goto bind_4_interrupt;
  deref_and_jump(a0,bind_4_1);
  *reasonp++ =  a0;
  goto bind_4_interrupt;
 bind_4_ext_interrupt:
  reasonp = 0l;
 bind_4_interrupt:
  goto interrupt_4;
 }

 bound__sock_4_top: {
  q x0, x1, x2, x3, x4, x5, x6, x7;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 bound__sock_4_clear_reason:
  reasonp = reasons;
 bound__sock_4_0:
 bound__sock_4_1:
  switch (ptagof(a0)) {
 case CONS:
  x0 = car_of(a0);
 bound__sock_4_3:
  switch (ptagof(x0)) {
 case FUNCTOR:
  if (functor_of(x0) != makesym(functor_accept_1)) goto bound__sock_4_17;
 bound__sock_4_6:
  if (!isint(a1)) goto bound__sock_4_9;
  
{
  int sock;
  struct sockaddr addr;
  int socklen = sizeof(addr);
#ifdef ASYNCIO
  if (!poll_read_available(intval(a1))) goto bound__sock_4_17;
#endif
  while (1) {
    if ((sock = accept(intval(a1), &addr, &socklen)) > 0) break;
    if (errno != EINTR) {
      fatalp("accept", "Error in accept");
    }
  }
  setasync(sock, "accepted socket");
  register_asynchronous_io_stream(sock,a3);
  MakeInBuf(x1, sock, 4096);
  MakeOutBuf(x2, sock, 4096);
}
  allocp[0] = makesym(functor_normal_1);
  allocp[1] = x4 = makeref(&allocp[1]);
  x3 = makefunctor(&allocp[0]);
  x5 = arg(x0, 0);
  allocp += 2;
  unify_value(x5, x3);
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xbound__sock_4);
  x6 = cdr_of(a0);
  allocp[2] = x6;
  allocp[3] = a1;
  allocp[4] = a2;
  allocp[5] = x7 = makeref(&allocp[5]);
  a0 = x4;
  a1 = a3;
  a2 = x1;
  a3 = x2;
  qp = (struct goalrec*)&allocp[0];
  allocp += 6;
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 bound__sock_4_9:
  if (!isref(a1)) goto bound__sock_4_17;
  deref_and_jump(a1,bound__sock_4_6);
  *reasonp++ =  a1;
  goto bound__sock_4_17;
 case VARREF:
  deref_and_jump(x0,bound__sock_4_3);
  *reasonp++ =  x0;
  goto bound__sock_4_17;
  };
  goto bound__sock_4_17;
 case ATOMIC:
  if (a0 != NILATOM) goto bound__sock_4_17;
 bound__sock_4_13:
  if (!isint(a1)) goto bound__sock_4_16;
  
{
  int fd = intval(a1);
  int namelen = 1000;
  struct sockaddr *name = (struct sockaddr *)malloc_check(namelen);
  getsockname(fd, name, &namelen);
  close_asynchronous_io_stream(fd);
  close(fd);
  if (name->sa_family == PF_UNIX) {
    if (unlink(name->sa_data)) {
      fatalp("unlink", "Error in unlinking socket: %s", name->sa_data);
    }
  }
  free(name);
}
  proceed();
 bound__sock_4_16:
  if (!isref(a1)) goto bound__sock_4_17;
  deref_and_jump(a1,bound__sock_4_13);
  *reasonp++ =  a1;
  goto bound__sock_4_17;
 case VARREF:
  deref_and_jump(a0,bound__sock_4_1);
  *reasonp++ =  a0;
  goto bound__sock_4_17;
  };
  goto bound__sock_4_17;
 bound__sock_4_17:
 bound__sock_4_18:
  switch (ptagof(a2)) {
 case CONS:
  a2 = cdr_of(a2);
  execute(bound__sock_4_clear_reason);
  goto bound__sock_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a2,bound__sock_4_18);
  *reasonp++ =  a2;
  goto bound__sock_4_interrupt;
  };
  goto bound__sock_4_interrupt;
 bound__sock_4_ext_interrupt:
  reasonp = 0l;
 bound__sock_4_interrupt:
  toppred = &predicate_unix_xbound__sock_4;
  goto interrupt_4;
 }

 pipe_1_top: {
  q x0, x1, x2, x3, x4;
  qp = qp->next;
 pipe_1_clear_reason:
  reasonp = reasons;
 pipe_1_0:
  
{
  int fd[2];
  if (pipe(fd)!=0) goto pipe_1_2;
  Fdopen(fd[0],x0,pipe_1_2,"r");
  Fdopen(fd[1],x1,pipe_1_2,"w");
}
  allocp[0] = makesym(functor_normal_2);
  allocp[1] = x3 = makeref(&allocp[1]);
  allocp[2] = x4 = makeref(&allocp[2]);
  x2 = makefunctor(&allocp[0]);
  allocp += 3;
  unify_value(a0, x2);
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  allocp[2] = x4;
  allocp[3] = x1;
  a0 = x3;
  a1 = x0;
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(in_2_clear_reason);
  goto in_2_ext_interrupt;
 pipe_1_2:
  otherwise(pipe_1_interrupt);
  unify_value(a0, makesym(atom_abnormal));
  proceed();
 pipe_1_ext_interrupt:
  reasonp = 0l;
 pipe_1_interrupt:
  toppred = &predicate_unix_xpipe_1;
  goto interrupt_1;
 }

 in_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 in_2_clear_reason:
  reasonp = reasons;
 in_2_0:
 in_2_1:
  switch (ptagof(a0)) {
 case CONS:
  x0 = car_of(a0);
 in_2_3:
  switch (ptagof(x0)) {
 case FUNCTOR:
  switch (symval(functor_of(x0))) {
 case functor_getc_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xin_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(getc_3_0);
  goto getc_3_ext_interrupt;
 case functor_ungetc_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xin_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(ungetc_3_0);
  goto ungetc_3_ext_interrupt;
 case functor_fread_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xin_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  a3 = arg(x0, 1);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fread_4_0);
  goto fread_4_ext_interrupt;
 case functor_feof_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xin_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(feof_3_0);
  goto feof_3_ext_interrupt;
 case functor_fseek_3:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xin_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  a3 = arg(x0, 1);
  a4 = arg(x0, 2);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fseek_5_0);
  goto fseek_5_ext_interrupt;
 case functor_ftell_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xin_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(ftell_3_0);
  goto ftell_3_ext_interrupt;
 case functor_fflush_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xin_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fflush_3_0);
  goto fflush_3_ext_interrupt;
 case functor_fclose_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xclosed_1);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  a0 = a1;
  a1 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 3;
  execute(fclose_2_0);
  goto fclose_2_ext_interrupt;
 case functor_sync_1:
  x1 = arg(x0, 0);
  unify_value(x1, NILATOM);
  a0 = cdr_of(a0);
  execute(in_2_0);
  goto in_2_ext_interrupt;
 default:
  goto in_2_interrupt;
  };
 case VARREF:
  deref_and_jump(x0,in_2_3);
  *reasonp++ =  x0;
  goto in_2_interrupt;
  };
  goto in_2_interrupt;
 case ATOMIC:
  if (a0 != NILATOM) goto in_2_interrupt;
  a0 = a1;
  allocp[0] = x0 = makeref(&allocp[0]);
  a1 = x0;
  allocp += 1;
  execute(fclose_2_0);
  goto fclose_2_ext_interrupt;
 case VARREF:
  deref_and_jump(a0,in_2_1);
  *reasonp++ =  a0;
  goto in_2_interrupt;
  };
  goto in_2_interrupt;
 in_2_ext_interrupt:
  reasonp = 0l;
 in_2_interrupt:
  toppred = &predicate_unix_xin_2;
  goto interrupt_2;
 }

 out_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 out_2_clear_reason:
  reasonp = reasons;
 out_2_0:
 out_2_1:
  switch (ptagof(a0)) {
 case CONS:
  x0 = car_of(a0);
 out_2_3:
  switch (ptagof(x0)) {
 case FUNCTOR:
  switch (symval(functor_of(x0))) {
 case functor_putc_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(putc_3_0);
  goto putc_3_ext_interrupt;
 case functor_fwrite_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  a3 = arg(x0, 1);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fwrite_4_0);
  goto fwrite_4_ext_interrupt;
 case functor_feof_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(feof_3_0);
  goto feof_3_ext_interrupt;
 case functor_fseek_3:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  a3 = arg(x0, 1);
  a4 = arg(x0, 2);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fseek_5_0);
  goto fseek_5_ext_interrupt;
 case functor_ftell_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(ftell_3_0);
  goto ftell_3_ext_interrupt;
 case functor_fflush_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fflush_3_0);
  goto fflush_3_ext_interrupt;
 case functor_fclose_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xclosed_1);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  a0 = a1;
  a1 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 3;
  execute(fclose_2_0);
  goto fclose_2_ext_interrupt;
 case functor_sync_1:
  x1 = arg(x0, 0);
  unify_value(x1, NILATOM);
  a0 = cdr_of(a0);
  execute(out_2_0);
  goto out_2_ext_interrupt;
 default:
  goto out_2_interrupt;
  };
 case VARREF:
  deref_and_jump(x0,out_2_3);
  *reasonp++ =  x0;
  goto out_2_interrupt;
  };
  goto out_2_interrupt;
 case ATOMIC:
  if (a0 != NILATOM) goto out_2_interrupt;
  a0 = a1;
  allocp[0] = x0 = makeref(&allocp[0]);
  a1 = x0;
  allocp += 1;
  execute(fclose_2_0);
  goto fclose_2_ext_interrupt;
 case VARREF:
  deref_and_jump(a0,out_2_1);
  *reasonp++ =  a0;
  goto out_2_interrupt;
  };
  goto out_2_interrupt;
 out_2_ext_interrupt:
  reasonp = 0l;
 out_2_interrupt:
  goto interrupt_2;
 }

 update_2_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  qp = qp->next;
 update_2_clear_reason:
  reasonp = reasons;
 update_2_0:
 update_2_1:
  switch (ptagof(a0)) {
 case CONS:
  x0 = car_of(a0);
 update_2_3:
  switch (ptagof(x0)) {
 case FUNCTOR:
  switch (symval(functor_of(x0))) {
 case functor_getc_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(getc_3_0);
  goto getc_3_ext_interrupt;
 case functor_ungetc_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(ungetc_3_0);
  goto ungetc_3_ext_interrupt;
 case functor_fread_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  a3 = arg(x0, 1);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fread_4_0);
  goto fread_4_ext_interrupt;
 case functor_putc_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(putc_3_0);
  goto putc_3_ext_interrupt;
 case functor_fwrite_2:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  a3 = arg(x0, 1);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fwrite_4_0);
  goto fwrite_4_ext_interrupt;
 case functor_feof_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(feof_3_0);
  goto feof_3_ext_interrupt;
 case functor_fseek_3:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  a3 = arg(x0, 1);
  a4 = arg(x0, 2);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fseek_5_0);
  goto fseek_5_ext_interrupt;
 case functor_ftell_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(ftell_3_0);
  goto ftell_3_ext_interrupt;
 case functor_fflush_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xupdate_2);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  allocp[3] = x2 = makeref(&allocp[3]);
  a0 = a1;
  a1 = x2;
  a2 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(fflush_3_0);
  goto fflush_3_ext_interrupt;
 case functor_fclose_1:
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xclosed_1);
  x1 = cdr_of(a0);
  allocp[2] = x1;
  a0 = a1;
  a1 = arg(x0, 0);
  qp = (struct goalrec*)&allocp[0];
  allocp += 3;
  execute(fclose_2_0);
  goto fclose_2_ext_interrupt;
 case functor_sync_1:
  x1 = arg(x0, 0);
  unify_value(x1, makeint(0L));
  a0 = cdr_of(a0);
  execute(update_2_0);
  goto update_2_ext_interrupt;
 default:
  goto update_2_interrupt;
  };
 case VARREF:
  deref_and_jump(x0,update_2_3);
  *reasonp++ =  x0;
  goto update_2_interrupt;
  };
  goto update_2_interrupt;
 case ATOMIC:
  if (a0 != NILATOM) goto update_2_interrupt;
  a0 = a1;
  allocp[0] = x0 = makeref(&allocp[0]);
  a1 = x0;
  allocp += 1;
  execute(fclose_2_0);
  goto fclose_2_ext_interrupt;
 case VARREF:
  deref_and_jump(a0,update_2_1);
  *reasonp++ =  a0;
  goto update_2_interrupt;
  };
  goto update_2_interrupt;
 update_2_ext_interrupt:
  reasonp = 0l;
 update_2_interrupt:
  toppred = &predicate_unix_xupdate_2;
  goto interrupt_2;
 }

 closed_1_top: {
  q x0, x1;
  qp = qp->next;
 closed_1_clear_reason:
  reasonp = reasons;
 closed_1_0:
 closed_1_1:
  switch (ptagof(a0)) {
 case CONS:
  x0 = car_of(a0);
 closed_1_3:
  switch (ptagof(x0)) {
 case FUNCTOR:
  if (functor_of(x0) != makesym(functor_sync_1)) goto closed_1_interrupt;
  x1 = arg(x0, 0);
  unify_value(x1, makeint(0L));
  a0 = cdr_of(a0);
  execute(closed_1_0);
  goto closed_1_ext_interrupt;
 case VARREF:
  deref_and_jump(x0,closed_1_3);
  *reasonp++ =  x0;
  goto closed_1_interrupt;
  };
  goto closed_1_interrupt;
 case ATOMIC:
  if (a0 != NILATOM) goto closed_1_interrupt;
  proceed();
 case VARREF:
  deref_and_jump(a0,closed_1_1);
  *reasonp++ =  a0;
  goto closed_1_interrupt;
  };
  goto closed_1_interrupt;
 closed_1_ext_interrupt:
  reasonp = 0l;
 closed_1_interrupt:
  goto interrupt_1;
 }

 getc_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 getc_3_clear_reason:
  reasonp = reasons;
 getc_3_0:
 getc_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 getc_3_2:
  if (!isgobj(a0)) goto getc_3_interrupt;
  if (!isclass(a0,pointer)) goto getc_3_interrupt;
  x0 = makeint(getc(FilePointer(a0)));
  unify_value(a2, x0);
  unify_value(a1, a0);
  proceed();
 case VARREF:
  deref_and_jump(a0,getc_3_1);
  *reasonp++ =  a0;
  goto getc_3_interrupt;
  };
  goto getc_3_interrupt;
 getc_3_ext_interrupt:
  reasonp = 0l;
 getc_3_interrupt:
  toppred = &predicate_unix_xgetc_3;
  goto interrupt_3;
 }

 ungetc_3_top: {
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 ungetc_3_clear_reason:
  reasonp = reasons;
 ungetc_3_0:
 ungetc_3_1:
  if (!isint(a2)) goto ungetc_3_8;
 ungetc_3_3:
  switch (ptagof(a0)) {
 case FUNCTOR:
 ungetc_3_4:
  if (!isgobj(a0)) goto ungetc_3_interrupt;
  if (!isclass(a0,pointer)) goto ungetc_3_interrupt;
  ungetc(intval(a2),FilePointer(a0));
  unify_value(a1, a0);
  proceed();
 case VARREF:
  deref_and_jump(a0,ungetc_3_3);
  *reasonp++ =  a0;
  goto ungetc_3_interrupt;
  };
  goto ungetc_3_interrupt;
 ungetc_3_8:
  if (!isref(a2)) goto ungetc_3_interrupt;
  deref_and_jump(a2,ungetc_3_1);
  *reasonp++ =  a2;
  goto ungetc_3_interrupt;
 ungetc_3_ext_interrupt:
  reasonp = 0l;
 ungetc_3_interrupt:
  toppred = &predicate_unix_xungetc_3;
  goto interrupt_3;
 }

 fread_4_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 fread_4_clear_reason:
  reasonp = reasons;
 fread_4_0:
 fread_4_1:
  if (!isint(a2)) goto fread_4_10;
  gblt_less_or_eq(makeint(0L),a2,fread_4_interrupt);
  gblt_less(a2,makeint(4096L),fread_4_interrupt);
 fread_4_5:
  switch (ptagof(a0)) {
 case FUNCTOR:
 fread_4_6:
  if (!isgobj(a0)) goto fread_4_interrupt;
  if (!isclass(a0,pointer)) goto fread_4_interrupt;
  
{
  long n = intval(a2);
  long bytes_read;
  q str;
  if ((char *)allocp+sizeof(struct byte_string_object)+n+sizeof(long) >=
      (char *)real_heaplimit) {
    allocp = real_heaplimit;
    goto async__io_4_ext_interrupt;
  }
  bytes_read = fread(buffer, 1, n, FilePointer(a0));
  str = BC2KLIC(buffer, bytes_read, allocp);
  if (isref(str)) {
    fatal("internal error: string allocation failure for fread");
  }
  x0 = str;
  allocp = heapp;
}
  unify_value(a3, x0);
  unify_value(a1, a0);
  proceed();
 case VARREF:
  deref_and_jump(a0,fread_4_5);
  *reasonp++ =  a0;
  goto fread_4_interrupt;
  };
  goto fread_4_interrupt;
 fread_4_10:
  if (!isref(a2)) goto fread_4_interrupt;
  deref_and_jump(a2,fread_4_1);
  *reasonp++ =  a2;
  goto fread_4_interrupt;
 fread_4_ext_interrupt:
  reasonp = 0l;
 fread_4_interrupt:
  toppred = &predicate_unix_xfread_4;
  goto interrupt_4;
 }

 putc_3_top: {
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 putc_3_clear_reason:
  reasonp = reasons;
 putc_3_0:
 putc_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 putc_3_2:
  if (!isgobj(a0)) goto putc_3_interrupt;
  if (!isclass(a0,pointer)) goto putc_3_interrupt;
 putc_3_5:
  if (!isint(a2)) goto putc_3_8;
  
{
  FILE *outf = FilePointer(a0);
  (void) putc(intval(a2),outf);
}
  unify_value(a1, a0);
  proceed();
 putc_3_8:
  if (!isref(a2)) goto putc_3_interrupt;
  deref_and_jump(a2,putc_3_5);
  *reasonp++ =  a2;
  goto putc_3_interrupt;
 case VARREF:
  deref_and_jump(a0,putc_3_1);
  *reasonp++ =  a0;
  goto putc_3_interrupt;
  };
  goto putc_3_interrupt;
 putc_3_ext_interrupt:
  reasonp = 0l;
 putc_3_interrupt:
  toppred = &predicate_unix_xputc_3;
  goto interrupt_3;
 }

 fwrite_4_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 fwrite_4_clear_reason:
  reasonp = reasons;
 fwrite_4_0:
 fwrite_4_1:
  switch (ptagof(a2)) {
 case FUNCTOR:
 fwrite_4_2:
  if (!isgobj(a2)) goto fwrite_4_interrupt;
  if (!isclass(a2,byte__string)) goto fwrite_4_interrupt;
 fwrite_4_5:
  switch (ptagof(a0)) {
 case FUNCTOR:
 fwrite_4_6:
  if (!isgobj(a0)) goto fwrite_4_interrupt;
  if (!isclass(a0,pointer)) goto fwrite_4_interrupt;
  
{
  FILE *outf = FilePointer(a0);
  struct byte_string_object *str =
    (struct byte_string_object *)functorp(a2);
  int result = fwrite(generic_string_body(str), 1,
		      generic_string_size(str), outf);
  x0 = makeint(result);
}
  unify_value(a3, x0);
  unify_value(a1, a0);
  proceed();
 case VARREF:
  deref_and_jump(a0,fwrite_4_5);
  *reasonp++ =  a0;
  goto fwrite_4_interrupt;
  };
  goto fwrite_4_interrupt;
 case VARREF:
  deref_and_jump(a2,fwrite_4_1);
  *reasonp++ =  a2;
  goto fwrite_4_interrupt;
  };
  goto fwrite_4_interrupt;
 fwrite_4_ext_interrupt:
  reasonp = 0l;
 fwrite_4_interrupt:
  toppred = &predicate_unix_xfwrite_4;
  goto interrupt_4;
 }

 feof_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 feof_3_clear_reason:
  reasonp = reasons;
 feof_3_0:
 feof_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 feof_3_2:
  if (!isgobj(a0)) goto feof_3_interrupt;
  if (!isclass(a0,pointer)) goto feof_3_interrupt;
  
{
  x0 = makeint((feof(FilePointer(a0)) ? 1 : 0));
}
  unify_value(a2, x0);
  unify_value(a1, a0);
  proceed();
 case VARREF:
  deref_and_jump(a0,feof_3_1);
  *reasonp++ =  a0;
  goto feof_3_interrupt;
  };
  goto feof_3_interrupt;
 feof_3_ext_interrupt:
  reasonp = 0l;
 feof_3_interrupt:
  toppred = &predicate_unix_xfeof_3;
  goto interrupt_3;
 }

 fseek_5_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  a4 = qp->args[4];
  qp = qp->next;
 fseek_5_clear_reason:
  reasonp = reasons;
 fseek_5_0:
 fseek_5_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 fseek_5_2:
  if (!isgobj(a0)) goto fseek_5_interrupt;
  if (!isclass(a0,pointer)) goto fseek_5_interrupt;
 fseek_5_5:
  if (!isint(a2)) goto fseek_5_11;
 fseek_5_7:
  if (!isint(a3)) goto fseek_5_10;
  
{
  x0 = makeint(fseek(FilePointer(a0), intval(a2), intval(a3)));
}
  unify_value(a4, x0);
  unify_value(a1, a0);
  proceed();
 fseek_5_10:
  if (!isref(a3)) goto fseek_5_interrupt;
  deref_and_jump(a3,fseek_5_7);
  *reasonp++ =  a3;
  goto fseek_5_interrupt;
 fseek_5_11:
  if (!isref(a2)) goto fseek_5_interrupt;
  deref_and_jump(a2,fseek_5_5);
  *reasonp++ =  a2;
  goto fseek_5_interrupt;
 case VARREF:
  deref_and_jump(a0,fseek_5_1);
  *reasonp++ =  a0;
  goto fseek_5_interrupt;
  };
  goto fseek_5_interrupt;
 fseek_5_ext_interrupt:
  reasonp = 0l;
 fseek_5_interrupt:
  toppred = &predicate_unix_xfseek_5;
  goto interrupt_5;
 }

 ftell_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 ftell_3_clear_reason:
  reasonp = reasons;
 ftell_3_0:
 ftell_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 ftell_3_2:
  if (!isgobj(a0)) goto ftell_3_interrupt;
  if (!isclass(a0,pointer)) goto ftell_3_interrupt;
  x0 = makeint(ftell(FilePointer(a0)));
  unify_value(a2, x0);
  unify_value(a1, a0);
  proceed();
 case VARREF:
  deref_and_jump(a0,ftell_3_1);
  *reasonp++ =  a0;
  goto ftell_3_interrupt;
  };
  goto ftell_3_interrupt;
 ftell_3_ext_interrupt:
  reasonp = 0l;
 ftell_3_interrupt:
  toppred = &predicate_unix_xftell_3;
  goto interrupt_3;
 }

 fflush_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 fflush_3_clear_reason:
  reasonp = reasons;
 fflush_3_0:
 fflush_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 fflush_3_2:
  if (!isgobj(a0)) goto fflush_3_interrupt;
  if (!isclass(a0,pointer)) goto fflush_3_interrupt;
  x0 = makeint(fflush(FilePointer(a0)));
  unify_value(a2, x0);
  unify_value(a1, a0);
  proceed();
 case VARREF:
  deref_and_jump(a0,fflush_3_1);
  *reasonp++ =  a0;
  goto fflush_3_interrupt;
  };
  goto fflush_3_interrupt;
 fflush_3_ext_interrupt:
  reasonp = 0l;
 fflush_3_interrupt:
  toppred = &predicate_unix_xfflush_3;
  goto interrupt_3;
 }

 fclose_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 fclose_2_clear_reason:
  reasonp = reasons;
 fclose_2_0:
 fclose_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 fclose_2_2:
  if (!isgobj(a0)) goto fclose_2_interrupt;
  if (!isclass(a0,pointer)) goto fclose_2_interrupt;
  
{
  FILE *file = FilePointer(a0);
  if (file!=stdin && file!=stdout && file!=stderr) goto fclose_2_6;
}
  unify_value(a1, makeint(0L));
  proceed();
 fclose_2_6:
  x0 = makeint(fclose(FilePointer(a0)));
  unify_value(a1, x0);
  proceed();
 case VARREF:
  deref_and_jump(a0,fclose_2_1);
  *reasonp++ =  a0;
  goto fclose_2_interrupt;
  };
  goto fclose_2_interrupt;
 fclose_2_ext_interrupt:
  reasonp = 0l;
 fclose_2_interrupt:
  toppred = &predicate_unix_xfclose_2;
  goto interrupt_2;
 }

 async__io_4_top: {
  q x0, x1, x2, x3, x4;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 async__io_4_clear_reason:
  reasonp = reasons;
 async__io_4_0:
 async__io_4_1:
  switch (ptagof(a0)) {
 case CONS:
  x0 = car_of(a0);
 async__io_4_3:
  switch (ptagof(x0)) {
 case FUNCTOR:
  switch (symval(functor_of(x0))) {
 case functor_getc_1:
 async__io_4_6:
  switch (ptagof(a2)) {
 case FUNCTOR:
 async__io_4_7:
  if (!isgobj(a2)) goto async__io_4_70;
  if (!isclass(a2,pointer)) goto async__io_4_70;
  
{
  struct iobuf *iob = IOBuf(a2);
  if (iob->ptr == iob->lim) {
    switch (fill_buf(iob)) {
    case -1:
    case 0: goto async__io_4_70;
    case 1: break;
    }
  }
  x1 = makeint(*iob->ptr++);
}
  x2 = arg(x0, 0);
  unify_value(x2, x1);
  a0 = cdr_of(a0);
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a2,async__io_4_6);
  *reasonp++ =  a2;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case functor_fread_2:
 async__io_4_12:
  switch (ptagof(a2)) {
 case FUNCTOR:
 async__io_4_13:
  if (!isgobj(a2)) goto async__io_4_70;
  if (!isclass(a2,pointer)) goto async__io_4_70;
  x1 = arg(x0, 0);
 async__io_4_16:
  if (!isint(x1)) goto async__io_4_19;
  
{
  struct iobuf *iob = IOBuf(a2);
  int toread = intval(x1);
  int ready_bytes = iob->lim - iob->ptr;
  q str;
  if (ready_bytes==0) {
    switch (fill_buf(iob)) {
    case -1:
    case 0: goto async__io_4_70;
    case 1: break;
    }
  }
  if (toread > iob->lim - iob->ptr) toread = iob->lim - iob->ptr;
  if ((char *)allocp+sizeof(struct byte_string_object)+toread+sizeof(long) >=
      (char *)real_heaplimit) {
    allocp = real_heaplimit;
    goto async__io_4_ext_interrupt;
  }
  str = BC2KLIC(iob->ptr, toread, allocp);
  if (isref(str)) {
    fatal("internal error: string allocation failure for fread");
  }
  x2 = str;
  allocp = heapp;
  iob->ptr += toread;
}
  x3 = arg(x0, 1);
  unify_value(x3, x2);
  a0 = cdr_of(a0);
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 async__io_4_19:
  if (!isref(x1)) goto async__io_4_70;
  deref_and_jump(x1,async__io_4_16);
  *reasonp++ =  x1;
  goto async__io_4_70;
 case VARREF:
  deref_and_jump(a2,async__io_4_12);
  *reasonp++ =  a2;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case functor_feof_1:
 async__io_4_21:
  switch (ptagof(a2)) {
 case FUNCTOR:
 async__io_4_22:
  if (!isgobj(a2)) goto async__io_4_70;
  if (!isclass(a2,pointer)) goto async__io_4_70;
  
{
  struct iobuf *iob = IOBuf(a2);
  if (iob->ptr == iob->lim) {
    switch (fill_buf(iob)) {
    case -1: goto async__io_4_70;
    case 0: x1 = makeint(1); break;
    case 1: x1 = makeint(0); break;
    }
  }
}
  x2 = arg(x0, 0);
  unify_value(x2, x1);
  a0 = cdr_of(a0);
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a2,async__io_4_21);
  *reasonp++ =  a2;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case functor_putc_1:
 async__io_4_27:
  switch (ptagof(a3)) {
 case FUNCTOR:
 async__io_4_28:
  if (!isgobj(a3)) goto async__io_4_70;
  if (!isclass(a3,pointer)) goto async__io_4_70;
  x1 = arg(x0, 0);
 async__io_4_31:
  if (!isint(x1)) goto async__io_4_34;
  
{
  struct iobuf *iob = IOBuf(a3);
  if (iob->ptr == iob->lim) {
    switch (write_buf(iob)) {
    case -1: goto async__io_4_70;
    case 1: break;
    }
  }
  *iob->ptr++ = intval(x1);
}
  a0 = cdr_of(a0);
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 async__io_4_34:
  if (!isref(x1)) goto async__io_4_70;
  deref_and_jump(x1,async__io_4_31);
  *reasonp++ =  x1;
  goto async__io_4_70;
 case VARREF:
  deref_and_jump(a3,async__io_4_27);
  *reasonp++ =  a3;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case functor_fwrite_2:
  x1 = arg(x0, 0);
 async__io_4_36:
  switch (ptagof(x1)) {
 case FUNCTOR:
 async__io_4_37:
  if (!isgobj(x1)) goto async__io_4_70;
 async__io_4_38:
  gblt_is_string(x1,async__io_4_70);
  gblt_size_of_string(x1,x2,async__io_4_70);
  gblt_element_size_of_string(x1,x3,async__io_4_70);
 async__io_4_42:
  if (x3 != makeint(8L)) goto async__io_4_70;
 async__io_4_44:
  switch (ptagof(a3)) {
 case FUNCTOR:
 async__io_4_45:
  if (!isgobj(a3)) goto async__io_4_70;
  if (!isclass(a3,pointer)) goto async__io_4_70;
 async__io_4_47:
  if (!isgobj(x1)) goto async__io_4_70;
  if (!isclass(x1,byte__string)) goto async__io_4_70;
  
{
  struct iobuf *iob = IOBuf(a3);
  char *str = KLIC2C(x1);
  int len =intval(x2);
  int room = iob->lim - iob->ptr;
  if (iob->ptr + len >= iob->lim) {
    BCOPY(str, iob->ptr, room);
    len -= room;
    str += room;
    switch (write_buf(iob)) {
    case -1: goto async__io_4_70;
    case 1: break;
    }
  }
  if (len > iob->bufsize) {
    fatalf("String too long (%d bytes > 4096) for asynchronous fwrite", len);
  }
  BCOPY(str, iob->ptr, len);
  iob->ptr += len;
}
  x4 = arg(x0, 1);
  unify_value(x4, x2);
  a0 = cdr_of(a0);
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a3,async__io_4_44);
  *reasonp++ =  a3;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case VARREF:
  deref_and_jump(x1,async__io_4_36);
  *reasonp++ =  x1;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case functor_fflush_1:
 async__io_4_52:
  switch (ptagof(a3)) {
 case FUNCTOR:
 async__io_4_53:
  if (!isgobj(a3)) goto async__io_4_70;
  if (!isclass(a3,pointer)) goto async__io_4_70;
  
{
  struct iobuf *iob = IOBuf(a3);
  if (iob->ptr != iob->buf) {
    switch (write_buf(iob)) {
    case -1: goto async__io_4_70;
    case 1: break;
    }
  }
}
  a0 = cdr_of(a0);
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a3,async__io_4_52);
  *reasonp++ =  a3;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case functor_sync_1:
  x1 = arg(x0, 0);
  unify_value(x1, makeint(0L));
  a0 = cdr_of(a0);
  execute(async__io_4_0);
  goto async__io_4_ext_interrupt;
 default:
  goto async__io_4_70;
  };
 case VARREF:
  deref_and_jump(x0,async__io_4_3);
  *reasonp++ =  x0;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case ATOMIC:
  if (a0 != NILATOM) goto async__io_4_70;
 async__io_4_61:
  switch (ptagof(a3)) {
 case FUNCTOR:
 async__io_4_62:
  if (!isgobj(a3)) goto async__io_4_70;
  if (!isclass(a3,pointer)) goto async__io_4_70;
 async__io_4_65:
  switch (ptagof(a2)) {
 case FUNCTOR:
 async__io_4_66:
  if (!isgobj(a2)) goto async__io_4_70;
  if (!isclass(a2,pointer)) goto async__io_4_70;
  
{
  struct iobuf *outb = IOBuf(a3);
  struct iobuf *inb = IOBuf(a2);
  if (outb->ptr != outb->buf) {
    switch (write_buf(outb)) {
    case -1: goto async__io_4_70;
    case 1: break;
    }
  }
  if (close(outb->fd) != 0) {
    fatalp("close", "Error in closing asynchronous I/O");
  }
  close_asynchronous_io_stream(outb->fd);
  free(outb->buf);
  free(inb->buf);
}
  proceed();
 case VARREF:
  deref_and_jump(a2,async__io_4_65);
  *reasonp++ =  a2;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case VARREF:
  deref_and_jump(a3,async__io_4_61);
  *reasonp++ =  a3;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 case VARREF:
  deref_and_jump(a0,async__io_4_1);
  *reasonp++ =  a0;
  goto async__io_4_70;
  };
  goto async__io_4_70;
 async__io_4_70:
  alternatively;
 async__io_4_72:
  switch (ptagof(a1)) {
 case CONS:
  a1 = cdr_of(a1);
  execute(async__io_4_clear_reason);
  goto async__io_4_ext_interrupt;
 case VARREF:
  deref_and_jump(a1,async__io_4_72);
  *reasonp++ =  a1;
  goto async__io_4_interrupt;
  };
  goto async__io_4_interrupt;
 async__io_4_ext_interrupt:
  reasonp = 0l;
 async__io_4_interrupt:
  toppred = &predicate_unix_xasync__io_4;
  goto interrupt_4;
 }

 system_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 system_2_clear_reason:
  reasonp = reasons;
 system_2_0:
 system_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 system_2_2:
  if (!isgobj(a0)) goto system_2_interrupt;
  if (!isclass(a0,byte__string)) goto system_2_interrupt;
  
{
  char *buf = KLIC2C(a0);
  x0 = makeint(system(buf));
  free(buf);
}
  unify_value(a1, x0);
  proceed();
 case VARREF:
  deref_and_jump(a0,system_2_1);
  *reasonp++ =  a0;
  goto system_2_interrupt;
  };
  goto system_2_interrupt;
 system_2_ext_interrupt:
  reasonp = 0l;
 system_2_interrupt:
  toppred = &predicate_unix_xsystem_2;
  goto interrupt_2;
 }

 cd_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 cd_2_clear_reason:
  reasonp = reasons;
 cd_2_0:
 cd_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 cd_2_2:
  if (!isgobj(a0)) goto cd_2_interrupt;
  if (!isclass(a0,byte__string)) goto cd_2_interrupt;
  
{
  char *buf = KLIC2C(a0);
  x0 = makeint(chdir(buf));
  free(buf);
}
  unify_value(a1, x0);
  proceed();
 case VARREF:
  deref_and_jump(a0,cd_2_1);
  *reasonp++ =  a0;
  goto cd_2_interrupt;
  };
  goto cd_2_interrupt;
 cd_2_ext_interrupt:
  reasonp = 0l;
 cd_2_interrupt:
  toppred = &predicate_unix_xcd_2;
  goto interrupt_2;
 }

 unlink_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 unlink_2_clear_reason:
  reasonp = reasons;
 unlink_2_0:
 unlink_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 unlink_2_2:
  if (!isgobj(a0)) goto unlink_2_interrupt;
  if (!isclass(a0,byte__string)) goto unlink_2_interrupt;
  
{
  char *path = KLIC2C(a0);
  x0 = makeint(unlink(path));
  free(path);
}
  unify_value(a1, x0);
  proceed();
 case VARREF:
  deref_and_jump(a0,unlink_2_1);
  *reasonp++ =  a0;
  goto unlink_2_interrupt;
  };
  goto unlink_2_interrupt;
 unlink_2_ext_interrupt:
  reasonp = 0l;
 unlink_2_interrupt:
  toppred = &predicate_unix_xunlink_2;
  goto interrupt_2;
 }

 mktemp_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 mktemp_2_clear_reason:
  reasonp = reasons;
 mktemp_2_0:
 mktemp_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 mktemp_2_2:
  if (!isgobj(a0)) goto mktemp_2_interrupt;
  if (!isclass(a0,byte__string)) goto mktemp_2_interrupt;
  
{
  char *template = KLIC2C(a0);
  char *real_template = (char *)malloc_check(strlen(template)+7);
  char *mktemp();
  char *result;
  (void)strcpy(real_template, template);
  (void)strcat(real_template, "XXXXXX");
  result = mktemp(real_template);
  x0 = C2KLIC(result, allocp);
  allocp = heapp;
  free(template);
  free(real_template);
}
  unify_value(a1, x0);
  proceed();
 case VARREF:
  deref_and_jump(a0,mktemp_2_1);
  *reasonp++ =  a0;
  goto mktemp_2_interrupt;
  };
  goto mktemp_2_interrupt;
 mktemp_2_ext_interrupt:
  reasonp = 0l;
 mktemp_2_interrupt:
  toppred = &predicate_unix_xmktemp_2;
  goto interrupt_2;
 }

 access_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 access_3_clear_reason:
  reasonp = reasons;
 access_3_0:
 access_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 access_3_2:
  if (!isgobj(a0)) goto access_3_interrupt;
  if (!isclass(a0,byte__string)) goto access_3_interrupt;
 access_3_5:
  if (!isint(a1)) goto access_3_8;
  
{
  char *path = KLIC2C(a0);
  x0 = makeint(access(path, intval(a1)));
  free(path);
}
  unify_value(a2, x0);
  proceed();
 access_3_8:
  if (!isref(a1)) goto access_3_interrupt;
  deref_and_jump(a1,access_3_5);
  *reasonp++ =  a1;
  goto access_3_interrupt;
 case VARREF:
  deref_and_jump(a0,access_3_1);
  *reasonp++ =  a0;
  goto access_3_interrupt;
  };
  goto access_3_interrupt;
 access_3_ext_interrupt:
  reasonp = 0l;
 access_3_interrupt:
  toppred = &predicate_unix_xaccess_3;
  goto interrupt_3;
 }

 chmod_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 chmod_3_clear_reason:
  reasonp = reasons;
 chmod_3_0:
 chmod_3_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 chmod_3_2:
  if (!isgobj(a0)) goto chmod_3_interrupt;
  if (!isclass(a0,byte__string)) goto chmod_3_interrupt;
 chmod_3_5:
  if (!isint(a1)) goto chmod_3_8;
  
{
  char *path = KLIC2C(a0);
  x0 = makeint(chmod(path, intval(a1)));
  free(path);
}
  unify_value(a2, x0);
  proceed();
 chmod_3_8:
  if (!isref(a1)) goto chmod_3_interrupt;
  deref_and_jump(a1,chmod_3_5);
  *reasonp++ =  a1;
  goto chmod_3_interrupt;
 case VARREF:
  deref_and_jump(a0,chmod_3_1);
  *reasonp++ =  a0;
  goto chmod_3_interrupt;
  };
  goto chmod_3_interrupt;
 chmod_3_ext_interrupt:
  reasonp = 0l;
 chmod_3_interrupt:
  toppred = &predicate_unix_xchmod_3;
  goto interrupt_3;
 }

 umask_1_top: {
  q x0;
  qp = qp->next;
 umask_1_clear_reason:
  reasonp = reasons;
 umask_1_0:
  
{
  x0 = makeint(umask(0));
  (void) umask(intval(x0));
}
  unify_value(a0, x0);
  proceed();
 umask_1_ext_interrupt:
  reasonp = 0l;
 umask_1_interrupt:
  toppred = &predicate_unix_xumask_1;
  goto interrupt_1;
 }

 umask_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 umask_2_clear_reason:
  reasonp = reasons;
 umask_2_0:
 umask_2_1:
  if (!isint(a1)) goto umask_2_4;
  
{
  x0 = makeint(umask(0));
  (void) umask(intval(a1));
}
  unify_value(a0, x0);
  proceed();
 umask_2_4:
  if (!isref(a1)) goto umask_2_interrupt;
  deref_and_jump(a1,umask_2_1);
  *reasonp++ =  a1;
  goto umask_2_interrupt;
 umask_2_ext_interrupt:
  reasonp = 0l;
 umask_2_interrupt:
  toppred = &predicate_unix_xumask_2;
  goto interrupt_2;
 }

 getenv_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 getenv_2_clear_reason:
  reasonp = reasons;
 getenv_2_0:
 getenv_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 getenv_2_2:
  if (!isgobj(a0)) goto getenv_2_interrupt;
  if (!isclass(a0,byte__string)) goto getenv_2_interrupt;
  
{
  extern char *getenv();
  char *str = KLIC2C(a0);
  char *value = getenv(str);
  free(str);
  if (value==0) {
    x0 = makeint(0);
  } else {
    x0 = C2KLIC(value, allocp);
    allocp = heapp;
  }
}
  unify_value(a1, x0);
  proceed();
 case VARREF:
  deref_and_jump(a0,getenv_2_1);
  *reasonp++ =  a0;
  goto getenv_2_interrupt;
  };
  goto getenv_2_interrupt;
 getenv_2_ext_interrupt:
  reasonp = 0l;
 getenv_2_interrupt:
  toppred = &predicate_unix_xgetenv_2;
  goto interrupt_2;
 }

 putenv_2_top: {
  q x0;
  a1 = qp->args[1];
  qp = qp->next;
 putenv_2_clear_reason:
  reasonp = reasons;
 putenv_2_0:
 putenv_2_1:
  switch (ptagof(a0)) {
 case FUNCTOR:
 putenv_2_2:
  if (!isgobj(a0)) goto putenv_2_interrupt;
  if (!isclass(a0,byte__string)) goto putenv_2_interrupt;
  
{
  char *str = KLIC2C(a0);
  x0 = makeint(putenv(str));
}
  unify_value(a1, x0);
  proceed();
 case VARREF:
  deref_and_jump(a0,putenv_2_1);
  *reasonp++ =  a0;
  goto putenv_2_interrupt;
  };
  goto putenv_2_interrupt;
 putenv_2_ext_interrupt:
  reasonp = 0l;
 putenv_2_interrupt:
  goto interrupt_2;
 }

 kill_3_top: {
  q x0;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 kill_3_clear_reason:
  reasonp = reasons;
 kill_3_0:
 kill_3_1:
  if (!isint(a0)) goto kill_3_7;
 kill_3_3:
  if (!isint(a1)) goto kill_3_6;
  
{
  x0 = makeint(kill(intval(a0),intval(a1)));
}
  unify_value(a2, x0);
  proceed();
 kill_3_6:
  if (!isref(a1)) goto kill_3_interrupt;
  deref_and_jump(a1,kill_3_3);
  *reasonp++ =  a1;
  goto kill_3_interrupt;
 kill_3_7:
  if (!isref(a0)) goto kill_3_interrupt;
  deref_and_jump(a0,kill_3_1);
  *reasonp++ =  a0;
  goto kill_3_interrupt;
 kill_3_ext_interrupt:
  reasonp = 0l;
 kill_3_interrupt:
  toppred = &predicate_unix_xkill_3;
  goto interrupt_3;
 }

 fork_1_top: {
  q x0;
  qp = qp->next;
 fork_1_clear_reason:
  reasonp = reasons;
 fork_1_0:
  x0 = makeint(fork());
  unify_value(a0, x0);
  proceed();
 fork_1_ext_interrupt:
  reasonp = 0l;
 fork_1_interrupt:
  toppred = &predicate_unix_xfork_1;
  goto interrupt_1;
 }

 fork__with__pipes_1_top: {
  q x0, x1, x2, x3, x4;
  qp = qp->next;
 fork__with__pipes_1_clear_reason:
  reasonp = reasons;
 fork__with__pipes_1_0:
  
{
  int fd1[2], fd2[2];
  pid_t pid;
  if (pipe(fd1) != 0) goto fork__with__pipes_1_2;
  Fdopen(fd1[0],x1,fork__with__pipes_1_2,"r"); Fdopen(fd1[1],x2,fork__with__pipes_1_2,"w");
  if (pipe(fd2) != 0) goto fork__with__pipes_1_2;
  Fdopen(fd2[0],x3,fork__with__pipes_1_2,"r"); Fdopen(fd2[1],x4,fork__with__pipes_1_2,"w");
  pid = fork();
  if (pid==0) {
    fclose(FilePointer(x2));
    fclose(FilePointer(x3));
  } else {
    fclose(FilePointer(x1));
    fclose(FilePointer(x4));
  }
  x0 = makeint(pid);
}
  a1 = a0;
  a2 = x1;
  a3 = x4;
  a4 = x3;
  a5 = x2;
  a0 = x0;
  execute(fork__with__pipes_2F1_240_6_clear_reason);
  goto fork__with__pipes_2F1_240_6_ext_interrupt;
 fork__with__pipes_1_2:
  otherwise(fork__with__pipes_1_interrupt);
  unify_value(a0, makesym(atom_abnormal));
  proceed();
 fork__with__pipes_1_ext_interrupt:
  reasonp = 0l;
 fork__with__pipes_1_interrupt:
  toppred = &predicate_unix_xfork__with__pipes_1;
  goto interrupt_1;
 }

 fork__with__pipes_2F1_240_6_top: {
  q x0, x1, x2;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  a4 = qp->args[4];
  a5 = qp->args[5];
  qp = qp->next;
 fork__with__pipes_2F1_240_6_clear_reason:
  reasonp = reasons;
 fork__with__pipes_2F1_240_6_0:
 fork__with__pipes_2F1_240_6_1:
  if (!isint(a0)) goto fork__with__pipes_2F1_240_6_6;
  gblt_eq(a0,makeint(0L),fork__with__pipes_2F1_240_6_4);
  allocp[0] = makesym(functor_parent_3);
  allocp[1] = a0;
  allocp[2] = x1 = makeref(&allocp[2]);
  allocp[3] = x2 = makeref(&allocp[3]);
  x0 = makefunctor(&allocp[0]);
  allocp += 4;
  unify_value(a1, x0);
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  allocp[2] = x2;
  allocp[3] = a3;
  a0 = x1;
  a1 = a2;
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(in_2_0);
  goto in_2_ext_interrupt;
 fork__with__pipes_2F1_240_6_4:
  gblt_not_eq(a0,makeint(0L),fork__with__pipes_2F1_240_6_interrupt);
  allocp[0] = makesym(functor_child_2);
  allocp[1] = x1 = makeref(&allocp[1]);
  allocp[2] = x2 = makeref(&allocp[2]);
  x0 = makefunctor(&allocp[0]);
  allocp += 3;
  unify_value(a1, x0);
  allocp[0] = (q)qp;
  allocp[1] = (q)(&predicate_unix_xout_2);
  allocp[2] = x2;
  allocp[3] = a5;
  a0 = x1;
  a1 = a4;
  qp = (struct goalrec*)&allocp[0];
  allocp += 4;
  execute(in_2_0);
  goto in_2_ext_interrupt;
 fork__with__pipes_2F1_240_6_6:
  if (!isref(a0)) goto fork__with__pipes_2F1_240_6_interrupt;
  deref_and_jump(a0,fork__with__pipes_2F1_240_6_1);
  *reasonp++ =  a0;
  goto fork__with__pipes_2F1_240_6_interrupt;
 fork__with__pipes_2F1_240_6_ext_interrupt:
  reasonp = 0l;
 fork__with__pipes_2F1_240_6_interrupt:
  toppred = &predicate_unix_xfork__with__pipes_2F1_240_6;
  goto interrupt_6;
 }

 argc_1_top: {
  q x0;
  qp = qp->next;
 argc_1_clear_reason:
  reasonp = reasons;
 argc_1_0:
  x0 = makeint(command_argc);
  unify_value(a0, x0);
  proceed();
 argc_1_ext_interrupt:
  reasonp = 0l;
 argc_1_interrupt:
  goto interrupt_1;
 }

 argv_1_top: {
  q x0;
  qp = qp->next;
 argv_1_clear_reason:
  reasonp = reasons;
 argv_1_0:
  x0 = makeint(command_argc);
  a1 = x0;
  a2 = a0;
  a0 = makeint(0L);
  execute(make__argv__list_3_clear_reason);
  goto make__argv__list_3_ext_interrupt;
 argv_1_ext_interrupt:
  reasonp = 0l;
 argv_1_interrupt:
  goto interrupt_1;
 }

 make__argv__list_3_top: {
  q x0, x1, x2, x3;
  a1 = qp->args[1];
  a2 = qp->args[2];
  qp = qp->next;
 make__argv__list_3_clear_reason:
  reasonp = reasons;
 make__argv__list_3_0:
 make__argv__list_3_1:
  switch (ptagof(a0)) {
 case ATOMIC:
  if (!isint(a0)) goto make__argv__list_3_9;
 make__argv__list_3_3:
 make__argv__list_3_4:
  if (!isint(a1)) goto make__argv__list_3_8;
  gblt_less(a0,a1,make__argv__list_3_9);
  
{
  x0 = C2KLIC(command_argv[intval(a0)], allocp);
  allocp = heapp;
}
  allocp[0] = x2 = makeref(&allocp[0]);
  allocp[1] = x0;
  x1 = makecons(&allocp[0]);
  allocp += 2;
  unify_value(a2, x1);
  bblt_add_no_check(a0,makeint(1L),x3);
  a0 = x3;
  a2 = x2;
  execute(make__argv__list_3_clear_reason);
  goto make__argv__list_3_ext_interrupt;
 make__argv__list_3_8:
  if (!isref(a1)) goto make__argv__list_3_9;
  deref_and_jump(a1,make__argv__list_3_4);
  *reasonp++ =  a1;
  goto make__argv__list_3_9;
 case VARREF:
  deref_and_jump(a0,make__argv__list_3_1);
  *reasonp++ =  a0;
  goto make__argv__list_3_interrupt;
  };
  goto make__argv__list_3_9;
 make__argv__list_3_9:
 make__argv__list_3_10:
  if (isref(a1)) goto make__argv__list_3_13;
  if_not_equal(a1, a0, make__argv__list_3_interrupt);
  unify_value(a2, NILATOM);
  proceed();
 make__argv__list_3_13:
  deref_and_jump(a1,make__argv__list_3_10);
  *reasonp++ =  a1;
  goto make__argv__list_3_interrupt;
 make__argv__list_3_ext_interrupt:
  reasonp = 0l;
 make__argv__list_3_interrupt:
  toppred = &predicate_unix_xmake__argv__list_3;
  goto interrupt_3;
 }

 times_4_top: {
  q x0, x1, x2, x3;
  a1 = qp->args[1];
  a2 = qp->args[2];
  a3 = qp->args[3];
  qp = qp->next;
 times_4_clear_reason:
  reasonp = reasons;
 times_4_0:
  
{
  /* Let's assume 60Hz clock if HZ is left undefined */
#ifndef HZ
#define HZ 60
#endif
  struct tms buf;
  (void) times(&buf);
  x0 = makeint((int)(buf.tms_utime*1000.0/HZ));
  x1 = makeint((int)(buf.tms_stime*1000.0/HZ));
  x2 = makeint((int)(buf.tms_cutime*1000.0/HZ));
  x3 = makeint((int)(buf.tms_cstime*1000.0/HZ));
}
  unify_value(a0, x0);
  unify_value(a1, x1);
  unify_value(a2, x2);
  unify_value(a3, x3);
  proceed();
 times_4_ext_interrupt:
  reasonp = 0l;
 times_4_interrupt:
  goto interrupt_4;
 }
 interrupt_6:
  allocp[7] = a5;
 interrupt_5:
  allocp[6] = a4;
 interrupt_4:
  allocp[5] = a3;
 interrupt_3:
  allocp[4] = a2;
 interrupt_2:
  allocp[3] = a1;
 interrupt_1:
  allocp[2] = a0;
 interrupt_0:
  allocp = interrupt_goal(allocp, toppred, reasonp);
 proceed_label:
  loop_within_module(module_unix);
}
