/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define MAIN

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/timing.h>
#include <klic/functorstuffs.h>

#include <stdio.h>
#include <setjmp.h>
#include <signal.h>

extern char *runtime_version, *runtime_date;

jmp_buf klic_topmost;
int start_tracing = 0;

module module_main();

extern Const struct predicate predicate_main_xmain_0;

char *optarg;

int
parse_size(str)
     char *str;
{
  int n;
  char c[2];
  switch (sscanf(str, "%d%1s", &n, c)) {
  case 1: return n;
  case 2:
    if (c[0] == 'k' || c[0] == 'K') {
      return n*0x400;
    } else if (c[0] == 'm' || c[0] == 'M') {
      return n*0x100000;
    } else if (c[0] == 'g' || c[0] == 'G') {
      return n*0x40000000;
    }
  default:
    fprintf(stderr, "Error in option \"%s\"\n", str);
    exit(-1);
  }
}

#define PrepOptarg() \
{ \
  if (argv[optind][charind+1] != 0) { \
    charind++; \
  } else { \
    optind++; charind = 0; \
    if (optind >= argc) goto option_error; \
  } \
}

#define Optarg() &argv[optind][charind]

static void toploop()
{
  declare_globals;
  struct goalrec *qp = current_queue;
  Const struct predicate *toppred = qp->pred;
  module func = (module)toppred->func;
  while (1) {
    func = ((module (*)())func)(glbl, qp, heapp, toppred);
    qp = current_queue;
    toppred = qp->pred;
  }
}

main(argc, argv)
     int argc;
     char **argv;
{
  declare_globals;
  void initalloc();
  q *initiate_prioq();
  q *reinitiate_prioq();
#ifdef USESIG
  void init_klic_signal_handling();
#endif
#ifdef DEBUGLIB
  extern struct goalrec *trace_goal();
#endif

  program_name = argv[0];
  heapsize = HEAPSIZE;
  maxheapsize = (unsigned long)(-1); /* largest possible */
  maxactiveratio = 0.5;
  incrementsize = INCREMENTSIZE;

  {
    int optind;
    for (optind = 1;
	 optind < argc && argv[optind][0] == '-';
	 optind++) {
      extern double atof();
      int charind;
      for (charind = 1;
	   argv[optind][charind] != 0;
	   charind++) {
	switch (argv[optind][charind]) {
	case 'a':
	  PrepOptarg();
	  maxactiveratio = atof(Optarg());
	  if (maxactiveratio <= 0.0 || maxactiveratio > 1.0) {
	    fatalf("Argument (%g) for option -a should be between 0 and 1",
		   maxactiveratio);
	  }
	  goto nextarg;
	case 'h':
	  PrepOptarg();
	  heapsize = parse_size(Optarg());
	  if (heapsize > maxheapsize) maxheapsize = heapsize;
	  goto nextarg;
	case 'H':
	  PrepOptarg();
	  maxheapsize = parse_size(Optarg());
	  if (heapsize > maxheapsize) heapsize = maxheapsize;
	  goto nextarg;
	case 'i':
	  PrepOptarg();
	  incrementsize = parse_size(Optarg()); goto nextarg;
	case 'g':
	  measure_gc = 1; break;
	case 'v':
	  fprintf(stderr, "KLIC runtime version %s (%s)\n",
		  runtime_version, runtime_date);
	  break;
	case 't':
#ifdef DEBUGLIB
	  start_tracing = 1; break;
#else
	  fatal("Tracing is only possible when linked without -n flag");
#endif
	case '-':
	  optind++; goto option_end;
	default:
	option_error:
#ifdef DEBUGLIB
	  fprintf(stderr,
		  "Usage: %s [options, ...] [program arguments, ...]\n%s%s%s%s%s%s%s%s%s",
		  argv[0],
		  "\t-t: start execution with tracing\n",
#ifdef COMMENT
		 );		/* for parentheses balancing */
#endif
#else
	  fprintf(stderr,
		  "Usage: %s [options, ...] [program arguments, ...]\n%s%s%s%s%s%s%s%s",
		  argv[0],
#endif
		  "\t-a <ratio>: active cell ratio to triger heap extension\n",
		  "\t  <ratio> should be a floating point number >0 and <1\n",
		  "\t-h <initial heap size>: initial size of heap\n",
		  "\t-H <max heap size>: maximum possible heap size\n",
		  "\t-i <increment>: gap between heap top and bottom\n",
		  "\t  for -h, -H and -i, 32k means 32KW and 2m means 2MW\n",
		  "\t-g: set garbage collection measurement on\n",
		  "\t-v: display KLIC runtime version\n");
	  exit(-1);
	}
      }
    nextarg:;
    }
  option_end:
    command_argc = argc-optind;
    command_argv = argv+optind;
  }

  initalloc();

  {
    extern struct goalrec *get_top_priority_queue();
    q *allocp;
    struct goalrec *qp;

    allocp = initiate_prioq(heapp);
    qp = (struct goalrec *) allocp;
    qp->pred = &predicate_main_xmain_0;
    heapp = allocp + 2;
    while (1) {
#ifdef DEBUGLIB
      suspensions = 0;
      resumes = 0;
      current_prio = -1;
      suspended_goal_list = 0;
      if (start_tracing) {
	qp = trace_goal(qp, 1);
	start_tracing = 0;
      }
#endif
      (void) enqueue_goal(0, HIGHESTPRIO-1, qp, glbl);
      current_queue = get_top_priority_queue();
      resumed_goals = 0;

      interrupt_off = -1;
#ifdef USESIG
      init_klic_signal_handling();
#endif
      postmortem_pred = 0;
      postmortem_args = 0;
      if (setjmp(klic_topmost) == 0) toploop();
      if (postmortem_pred == 0 || postmortem_args == 0) break;
      fprintf(stderr, "Starting postmortem processing...\n");
      allocp = initiate_prioq(heapp+incrementsize/2); /* dirty patch */
      qp = (struct goalrec *) allocp;
      qp->pred = postmortem_pred;
      allocp += 2;
      if (isfunctor(postmortem_args)) {
	int arity = arityof(functor_of(postmortem_args));
	int k;
	for (k=0; k<arity; k++) {
	  *allocp++ = arg(postmortem_args, k);
	}
      }
      heapp = allocp;
    }
  }
  return 0;
}

module topsucceed(glbl, qp, allocp, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     q *allocp;
     Const struct predicate *toppred;
{
  extern q *klic_interrupt();
  extern Const struct predicate topsucceed_pred;
  if (suspensions == resumes) {
    longjmp(klic_topmost, 1);
  }

#ifdef USESIG
  /* perpetual suspension suspected, but let's wait a while for interrupts */

  /* enqueue topsucceed goal again */
  allocp[0] = (q)qp;
  allocp[1] = (q)&topsucceed_pred;
  qp = (struct goalrec *)allocp;

  /* Let's not hastily check perpetual suspension */
#ifdef USEUSLEEP
  usleep(1000);
#else
  (void) sleep(1);
#endif

  /* run GC */
  allocp = klic_interrupt(real_heaplimit, qp);
  qp = current_queue;

  if (qp->pred == &topsucceed_pred) {
    /* no interrupt after topsucceed was called */
    struct sigaction oldact, newact;
    newact.sa_handler = NULL;
    sigfillset(&newact.sa_mask);
    newact.sa_flags = 0;
    sigaction(0, &newact, &oldact);
    if (interrupt_off) pause();
    sigaction(0, &oldact, NULL);
  }
  /* check resumpsions */
  heapp = klic_interrupt(allocp, qp);
  return (module) current_queue->pred->func;
#else
  fatalf("%d perpetually suspending goals found",
	 suspensions-resumes);
#endif
}
