/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>
#include <klic/atomstuffs.h>
#include <stdio.h>
#include <klic/gobj.h>
#include <klic/susp.h>

print_partially(x, depth, length)
     q x;
     unsigned long depth, length;
{
  fprint_partially(stdout, x, depth, length);
}

fprint_partially(stream, x, depth, length)
     FILE *stream;
     q x;
     unsigned long depth, length;
{
  declare_globals;
  int leng = length;
#ifdef DEBUGLIB
  extern int verbose_print;
#endif

  deref_and_switch(x, var, atomic, cons, composite);

 atomic:
  switch (atagof(x)) {
  case INT:
    fprintf(stream, "%ld", intval(x));
    return;
  case SYM:
    if (x == NILATOM) {
      fprintf(stream, "[]");
    } else if (x == PERIODATOM) {
      fprintf(stream, ".");
    } else {
      fprintf(stream, "%s", namestringof(x));
    }
    return;
  }

 var:
  fprintf(stream, "_%X", (q*)x-new_space_top);
#ifdef DEBUGLIB
  if(verbose_print && derefone(x) != x){
    struct hook *second_hook = suspp(derefone(x))->u.first_hook.next;
    struct hook *loophook = second_hook;
    int valid_goal = 0;
      
    do {
      union goal_or_consumer u = loophook->u;
      if (u.l != 0 && !is_consumer_hook(u) && isint(u.g->next)) {
	if (valid_goal) {
	  fprintf(stream, "<");
	  valid_goal = 1;
	}
	verbose_print = 0;
	fprint_goal(stream, u.g, 0);
	verbose_print = 1;
	loophook = loophook->next;
	fprintf(stream, "->");
      }
    } while (loophook != second_hook);
    if (valid_goal) fprintf(stream, ">");
  }
#endif
  return;
  
  cons:
#ifdef GCDEBUG
    fprintf(stream, " %x", x);
#endif
    fprintf(stream, "[");
    if(depth ==0){
      fprintf(stream, "..]");
      return;
    }
    while (1) {
      fprint_partially(stream, car_of(x), depth-1, length);
      x = cdr_of(x);
      deref_and_switch(x, othercdr, atomiccdr, conscdr, othercdr);
  conscdr:
      fprintf(stream, ",");
      if(--leng) continue;
      fprintf(stream, "..");
      goto listtail;
  }
 atomiccdr:
  if (issym(x) && symval(x) == 0) goto listtail;
 othercdr:
  fprintf(stream, "|");
  fprint_partially(stream, x, depth-1, length);
 listtail:
  fprintf(stream, "]");
  return;

 composite:
  {
    int i;
    q f = functor_of(x);
#ifdef GCDEBUG
    fprintf(stream, " %x", x);
#endif
    if (isatomic(f)) {
      fprintf(stream, "%s(",functoratomname(f));
      if(depth == 0) {
	fprintf(stream, "..)");
	return;
      }
      for (i = 0; i < arityof(f)-1; i++) {
	fprint_partially(stream, arg(x,i), depth-1, length);
	fprintf(stream, ",");
	if(i>length){
	  fprintf(stream, "..");
	  goto funct_tail;
	}
      }
      fprint_partially(stream, arg(x,arityof(f)-1), depth-1, length);
    funct_tail:
      fprintf(stream, ")");
    }else if(isref(f)){
      generic_print(((struct data_object *)(functorp(x))),
		    stream, depth, length);
    } else {
      fprintf(stderr, "Invalid functor : %x\n", f);
    }
  }

  return;
}

fprint(stream, x)
     FILE *stream;
     q x;
{
  fprint_partially(stream, x, (unsigned long)-1, (unsigned long)-1);
}
     
print(x)
  q x;
{
  fprint_partially(stdout, x, (unsigned long)-1, (unsigned long)-1);
}

void printl(x)
q x;
{
  print(x);
  putc('\n',stdout);
}

general_print(a, stream, depth, length)
     q *a;
     FILE *stream;
     unsigned long depth, length;
{
  fprint_partially(stream, a, depth, length);
}
