/* ---------------------------------------------------------- 
%   (C)1993, 1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>
#include <klic/gobj.h>

/* 
  General Guard Unification

  return value:
  0 : failed
  1 : succeeded
  other : suspended
*/

#define SUCCEEDED ((q)0)
#define FAILED ((q)1)

q eq_terms_body(x,y)
     q x, y;
{
 loop_entry:
  if (isfunctor(x)) {
  x_functor:
    if (isfunctor(y)) {
      q funcx = functor_of(x);
      q funcy = functor_of(y);
      if (funcx == funcy && isatomic(funcx)) {
	long arity = arityof(funcx);
	long i;
	long size = arity - 1;
	for(i=0; i<size; ++i){
	  q retval;
	  if ((retval = eq_terms_body(arg(x, i), arg(y, i))) != SUCCEEDED) {
	    return retval;
	  }
	}
	x = arg(x, size);
	y = arg(y, size);
	goto loop_entry;
      } else if (isref(funcx) && isref(funcy)) {
	/* both arguments are generic objects */
	return generic_passive_unify(data_objectp(x), data_objectp(y));
      } else {
	return FAILED;
      }
    } else if (isref(y)) {
      deref_and_jump(y, x_functor);
      return y;
    } else {
      return FAILED;
    }
  } else if (iscons(x)) {
  x_cons:
    if (iscons(y)) {
      q retval;
      if ((retval = eq_terms_body(car_of(x), car_of(y))) == SUCCEEDED) {
	x = cdr_of(x);
	y = cdr_of(y);
	goto loop_entry;
      } else {
	return retval;
      }
    } else if (isref(y)) {
      deref_and_jump(y, x_cons);
      return y;
    } else {
      return FAILED;
    }
  } else if (isatomic(x)) {
  x_atomic:
    if (x == y) {
      return SUCCEEDED;
    } else if (isref(y)) {
      deref_and_jump(y, x_atomic);
      return y;
    } else {
      return FAILED;
    }
  } else {
    deref_and_jump(x, loop_entry);
    return x;
  }
}
