/*  $Id: rns.c,v 1.5 1991/10/10 16:43:57 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rns.c,v $
 * Revision 1.5  1991/10/10  16:43:57  richard
 * Switched to UNIX RCS
 *
 * Revision 1.4  91/02/17  14:26:32  ROOT_DOS
 * Added comments
 *
 * Revision 1.3  91/01/30  21:42:55  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.2  90/12/08  03:50:11  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:11:54  ROOT_DOS
 * Initial revision
 *   */



/*  hoofdprogramma van RNS  */


#include "rnsdefs.h"     /*  alleen in RNS.C zonder EXTERN  */
#include "rnsfuncs.h"



#ifdef USEPROTOS
int main(int argc, char *argv[])
#else
int main(argc, argv)
       int argc;
       char *argv[];
#endif
{
int rc = OK;

   rc=init();                   /*  initialiseer variabelen         */

   if (rc==OK)                  /*  als OK, verwerk dan argumenten  */
      rc=process_args(argc, argv);

   if (rc==OK)                  /*  als OK, lees dan invoerbestand  */
      rc=read_input();

   if (rc==OK)                  /*  als OK, controleer dan  */
      rc=check_input();         /*  ingevoerde gegevens     */

   if (rc==OK)                  /*  als OK, open dan grafisch scherm  */
      rc=open_graphics();

   if (rc==OK)                  /*  als OK, doe berekeningen met netwerk  */
      rc=process_net();

   if (rc==OK)                  /*  als OK, doe tests op patronen  */
      rc=run_tests();

   if (rc==OK)                  /*  als OK, laat dan resultaten zien  */
      rc=show_results();

   close_graphics();            /*  sluit grafisch scherm  */

   if (rc==OK)                  /*  schrijf resultaten naar uitvoerbestand  */
      rc=write_output();

   if (rc==OK)
      rc=build_plot();

   clean_up();                  /*  ruim de boel op  */

   if (rc!=OK)                  /*  als niet OK, verwerk dan fout  */
      process_error(rc);

   return(rc);
}
