/*  $Id: rnsalloc.c,v 1.4 1991/10/10 16:44:09 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsalloc.c,v $
 * Revision 1.4  1991/10/10  16:44:09  richard
 * Switched to UNIX RCS
 *
 * Revision 1.3  91/02/26  21:48:32  ROOT_DOS
 * Added comments
 * 
 * Revision 1.2  91/02/17  14:30:15  ROOT_DOS
 * Added comments
 *
 * Revision 1.1  91/02/05  09:17:15  ROOT_DOS
 * Initial revision
 *   */



/*  ANSI-achtige versies van 'realloc()' en 'free()' voor UNIX  */


#include "rnsalloc.h"


#ifdef TURBOC
#include <stdlib.h>
#else
#include <stdlib.h>
#endif



/*  wijzig versies van 'realloc()' en 'free()' voor UNIX  */
/*  Turbo C heeft de beveiligingen reeds ingebouwd        */

#ifdef USEPROTOS
void *REALLOC(void *block, size_t size)
#else
void *REALLOC(block, size)
        void *block;
        size_t size;
#endif
{
#ifdef TURBOC
   return((void *)realloc(block, size));
#else
   if (size==0)          /*  geef NULL terug als gevraagde grootte 0 is  */
      return((void *)NULL);

   if (block==NULL)      /*  doe gewone 'malloc()' als pointer NULL is   */
      return((void *)malloc(size));
   else                  /*  doe anders een echte 'realloc()'            */
      return((void *)realloc(block, size));
#endif
}


#ifdef USEPROTOS
void  FREE(void *block)
#else
void  FREE(block)
         void *block;
#endif
{
#ifdef TURBOC
   free(block);
#else
   if (block!=NULL)      /*  'free()' blok alleen als die niet NULL is   */
      free(block);
#endif
}
