/*  $Id: rnsalloc.h,v 1.5 1991/10/10 16:41:53 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsalloc.h,v $
 * Revision 1.5  1991/10/10  16:41:53  richard
 * Switched to UNIX RCS
 *
 * Revision 1.4  91/05/09  14:34:47  ROOT_DOS
 * Added nested include file protection
 * 
 * Revision 1.3  91/03/24  15:56:54  ROOT_DOS
 * Compiler directive TRADITIONAL renamed to UNIX
 *
 * Revision 1.2  91/02/17  14:30:10  ROOT_DOS
 * Added comments
 *
 * Revision 1.1  91/02/05  09:16:40  ROOT_DOS
 * Initial revision
 *   */



/*  beveiligde versies van 'realloc' en 'free'  */


#ifndef _RNSALLOC_H
#define _RNSALLOC_H


#include "rnsconf.h"


#ifdef TURBOC
#include <stddef.h>      /*  voor size_t  */
#else
#include <stdlib.h>      /*  voor size_t  */
#include <stddef.h>      /*  voor size_t  */
#endif



/*  wijzig versies van 'realloc()' en 'free()' voor UNIX  */
/*  Turbo C heeft de beveiligingen reeds ingebouwd        */

void *REALLOC __((void *block, size_t size));
void  FREE __((void *block));


#endif  /*  _RNSALLOC_H  */

