/*  $Id: rnsargs.c,v 1.11 1991/10/10 16:44:14 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsargs.c,v $
 * Revision 1.11  1991/10/10  16:44:14  richard
 * Switched to UNIX RCS
 *
 * Revision 1.10  91/05/09  14:37:59  ROOT_DOS
 * Minor changes
 *
 * Revision 1.9  91/02/26  21:48:40  ROOT_DOS
 * Added comments
 *
 * Revision 1.8  91/02/17  14:30:42  ROOT_DOS
 * Minor changes
 *
 * Revision 1.7  91/02/07  21:33:34  ROOT_DOS
 * Added quiet mode as default in Sparc version
 *
 * Revision 1.6  91/02/01  23:26:36  ROOT_DOS
 * Removed option -q from non-Turbo C version
 *
 * Revision 1.5  91/01/30  21:43:33  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.4  91/01/28  22:19:12  ROOT_DOS
 * Added code in ANSI C compilation mode
 *
 * Revision 1.3  91/01/27  21:00:22  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.2  90/12/08  03:50:18  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:12:18  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het verwerken van de argumenten op de command-line  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <dir.h>
#include <io.h>
#include <string.h>
#else
#include <string.h>
#include <unistd.h>
#endif



#ifdef USEPROTOS
int process_args(int argc, char *argv[])
#else
int process_args(argc, argv)
       int argc;
       char *argv[];
#endif
{
int rc = OK;

int argnr, j;


   argnr=1;

   while (argnr<argc)           /*  zolang er argumenten zijn  */
   {
      if (*argv[argnr]==SWITCHAR)
      {                         /*  als argument een optie is  */
	     for (j=1; j<strlen(argv[argnr]); j++)
		 {	
#ifdef TURBOC
	        if (toupper(argv[argnr][j]) == 'B')
	           batch=TRUE;                    /*  /B  :  batch  */
	        else
	         if (toupper(argv[argnr][j]) == 'Q')
	            quiet=batch=TRUE;             /*  /Q  :  batch & quiet  */
	         else
	          if (toupper(argv[argnr][j]) == 'V')
	             verbose=quiet=batch=TRUE;    /*  /V  :  verbose & batch  */
	          else
	           if (toupper(argv[argnr][j]) == 'L')
	              logging=TRUE;               /*  /L  :  logging  */
	           else
	            if (toupper(argv[argnr][j]) == 'P')
	               plot=TRUE;                 /*  /P  :  plot  */
	            else
	               return(UNKARG);
#else
	        if (argv[argnr][j] == 'l')
	           logging=TRUE;                  /*  -l  :  logging  */
	        else
	         if (argv[argnr][j] == 'v')
	            verbose=quiet=batch=TRUE;     /*  -v  :  verbose & batch  */
	         else
	          if (argv[argnr][j] == 'p')
	             plot=TRUE;                   /*  -p  :  plot  */
	          else
	             return(UNKARG);
#endif
	     }
      }
      else
      {
         if (strlen(input_name)==0)    /*  als er nog geen invoer naam is  */
         {
            if (strlen(argv[argnr])>MAXPATH)
               return(INTOOL);         /*  naam te lang  */

            strcpy(input_name, argv[argnr]);
            if ((rc=resolve_name(input_name, INPUTEXT))!=OK)
               return(rc);             /*  vind absolute pad  */
         }
         else
          if (strlen(output_name)==0)  /*  als er nog geen uitvoer naam is  */
          {
             if (strlen(argv[argnr])>MAXPATH)
                return(OUTOOL);        /*  naam te lang  */

             strcpy(output_name, argv[argnr]);
             if ((rc=resolve_name(output_name, OUTPUTEXT))!=OK)
                return(rc);            /*  vind absolute pad  */
          }
          else
           if (strlen(log_name)==0)    /*  als er nog geen log naam is  */
           {
              if (strlen(argv[argnr])>MAXPATH)
                 return(LGTOOL);       /*  naam te lang  */

              strcpy(log_name, argv[argnr]);
              if ((rc=resolve_name(log_name, LOGEXT))!=OK)
                 return(rc);           /*  vind absolute pad  */

              logging=TRUE;            /*  log naam, zet dan logging impliciet  */
           }
           else
              return(TOOMNY);          /*  te veel namen op commandoregel  */
      }

      argnr++;                         /*  volgende argument  */
   }


   if (strlen(input_name)==0)
      return(INPREQ);           /*  geen invoer naam, maar wel vereist  */

   if (strlen(output_name)==0)
   {                            /*  geen uitvoer naam, leid er een af van de invoer naam  */
#ifdef TURBOC
      fnsplit(input_name, NULL, NULL, output_name, NULL);
#else
      fnsplit(input_name, NULL, output_name, NULL);
#endif
      if ((rc=resolve_name(output_name, OUTPUTEXT))!=OK)
         return(rc);            /*  vind absolute pad  */
   }

   if (logging && strlen(log_name)==0)
   {
#ifdef TURBOC                   /*  geen log naam, leid er een af van de invoer naam  */
      fnsplit(input_name, NULL, NULL, log_name, NULL);
#else
      fnsplit(input_name, NULL, log_name, NULL);
#endif
      if ((rc=resolve_name(log_name, LOGEXT))!=OK)
         return(rc);            /* vind absolute pad  */
   }

   if (plot && strlen(learn_name)==0)
   {
#ifdef TURBOC                   /*  geen plot naam, leid er een af van de invoer naam  */
      fnsplit(input_name, NULL, NULL, learn_name, NULL);
#else
      fnsplit(input_name, NULL, learn_name, NULL);
#endif
      if ((rc=resolve_name(learn_name, LEARNEXT))!=OK)
         return(rc);            /* vind absolute pad  */
   }

   if (plot && strlen(test_name)==0)
   {
#ifdef TURBOC                   /*  geen plot naam, leid er een af van de invoer naam  */
      fnsplit(input_name, NULL, NULL, test_name, NULL);
#else
      fnsplit(input_name, NULL, test_name, NULL);
#endif
      if ((rc=resolve_name(test_name, TESTEXT))!=OK)
         return(rc);            /* vind absolute pad  */
   }

   if (plot && strlen(pll_name)==0)
   {
#ifdef TURBOC                   /*  geen plot naam, leid er een af van de invoer naam  */
      fnsplit(input_name, NULL, NULL, pll_name, NULL);
#else
      fnsplit(input_name, NULL, pll_name, NULL);
#endif
      if ((rc=resolve_name(pll_name, PLLEXT))!=OK)
         return(rc);            /* vind absolute pad  */
   }

   if (plot && strlen(plt_name)==0)
   {
#ifdef TURBOC                   /*  geen plot naam, leid er een af van de invoer naam  */
      fnsplit(input_name, NULL, NULL, plt_name, NULL);
#else
      fnsplit(input_name, NULL, plt_name, NULL);
#endif
      if ((rc=resolve_name(plt_name, PLTEXT))!=OK)
         return(rc);            /* vind absolute pad  */
   }


#ifdef DEBUG
   printf("%s\n%s\n%s\n%s\n%s\n", input_name, output_name, log_name,
                                  learn_name, test_name,
                                  pll_name, plt_name);
#endif


   if (strcmp(input_name, output_name)==0)
      return(FLSEQU);           /*  invoer en uitvoer naam gelijk  */

   if (logging && strcmp(input_name, log_name)==0)
      return(FLSEQU);           /*  log en invoer naam gelijk  */

   if (logging && strcmp(output_name, log_name)==0)
      return(FLSEQU);           /*  log en uitvoer naam gelijk  */

   if (plot && strcmp(input_name, learn_name)==0)
      return(FLSEQU);           /*  leer en invoer naam gelijk  */

   if (plot && strcmp(output_name, learn_name)==0)
      return(FLSEQU);           /*  leer en uitvoer naam gelijk  */

   if (plot && logging && strcmp(log_name, learn_name)==0)
      return(FLSEQU);           /*  log en leerresultaat naam gelijk  */

   if (plot && strcmp(input_name, test_name)==0)
      return(FLSEQU);           /*  test en invoer naam gelijk  */

   if (plot && strcmp(output_name, test_name)==0)
      return(FLSEQU);           /*  test en uitvoer naam gelijk  */

   if (plot && logging && strcmp(log_name, test_name)==0)
      return(FLSEQU);           /*  log en testresultaat naam gelijk  */

   if (plot && strcmp(input_name, pll_name)==0)
      return(FLSEQU);           /*  plot en invoer naam gelijk  */

   if (plot && strcmp(output_name, pll_name)==0)
      return(FLSEQU);           /*  plot en uitvoer naam gelijk  */

   if (plot && logging && strcmp(log_name, pll_name)==0)
      return(FLSEQU);           /*  log en plot naam gelijk  */

   if (plot && strcmp(input_name, plt_name)==0)
      return(FLSEQU);           /*  plot en invoer naam gelijk  */

   if (plot && strcmp(output_name, plt_name)==0)
      return(FLSEQU);           /*  plot en uitvoer naam gelijk  */

   if (plot && logging && strcmp(log_name, plt_name)==0)
      return(FLSEQU);           /*  log en plot naam gelijk  */

   if (access(input_name, R_OK)<0)
      return(NACCIN);           /*  invoerbestand niet toegankelijk  */

   if (access(output_name, F_OK)==0 && access(output_name, W_OK)<0)
      return(NACOUT);           /*  uitvoerbestand niet toegankelijk  */

   if (logging && access(log_name, F_OK)==0 && access(log_name, W_OK)<0)
      return(NACLOG);           /*  logbestand niet toegankelijk  */

   if (plot && access(learn_name, F_OK)==0 && access(learn_name, W_OK)<0)
      return(NACLRN);           /*  leerbestand niet toegankelijk  */

   if (plot && access(test_name, F_OK)==0 && access(test_name, W_OK)<0)
      return(NACTST);           /*  testbestand niet toegankelijk  */

   if (plot && access(pll_name, F_OK)==0 && access(pll_name, W_OK)<0)
      return(NACPLL);           /*  plotbestand niet toegankelijk  */

   if (plot && access(plt_name, F_OK)==0 && access(plt_name, W_OK)<0)
      return(NACPLT);           /*  plotbestand niet toegankelijk  */

   return(OK);
}


#ifdef USEPROTOS
int resolve_name(char *filename, char *extension)
#else
int resolve_name(filename, extension)
       char *filename;
       char *extension;
#endif
{
int flags;
char path[MAXPATH],
#ifdef TURBOC
     drive[MAXDRIVE],
#endif
     dir[MAXDIR],
     name[MAXFILE],
     ext[MAXEXT];
int fnlen;

   /*  splits de bestandsnaam op in [drive,] directory, naam en extensie  */
#ifdef TURBOC
   flags=fnsplit(strupr(filename), drive, dir, name, ext);
#else
   flags=fnsplit(filename, dir, name, ext);
#endif

   if (!(flags & FILENAME) || (flags & WILDCARDS))
      return(NONAME);           /*  eenduidige naam is verplicht  */

   if (!(flags & EXTENSION))    /*  als er geen extensie opgegeven is  */
      strcpy(ext, extension);   /*  copieer dan de default extensie    */

#ifdef TURBOC
   if (!(flags & DRIVE))        /*  als er geen drive opgegeven is  */
   {
      drive[0]=getdisk()+'A';   /*  haal de huidige drive op  */
      strcpy(drive+1, ":");     /*  copieer deze  */
   }
#endif

   if (!(flags & DIRECTORY))    /*  als er geen directory opgegeven is  */
   {
#ifdef TURBOC
      if (getcurdir(drive[0]-'A'+1, dir+1)<0)
         return(NOTDIR);        /*  fout bij bepalen huidige directory  */
      dir[0]=DIRSEPCHAR;
      if (strlen(dir)>1)        /*  copieer ook '/'  als niet root directory  */
         strcat(dir, DIRSEPSTR);
#else
      if (getcwd(dir, MAXDIR)==NULL)
         return(NOTDIR);        /*  fout bij bepalen huidige directory  */
      if (strlen(dir)>1)        /*  copieer ook '/' als niet root directory  */
         strcat(dir, DIRSEPSTR);
#endif
   }

#ifdef TURBOC
   strcpy(path, drive);         /*  zet drive in pad  */
   strcat(path, DIRSEPSTR);     /*  copieer '/' ook   */
   if (getcurdir(path[0]-'A'+1, path+strlen(path))<0)
      return(NOTDIR);           /*  bewaar huidige pad in 'path'  */

   strcpy(filename, drive);
   strcat(filename, dir);       /*  zet gespecificeerde pad in 'filename'  */
   fnlen=strlen(filename);
   if (fnlen>3 && filename[fnlen-1]==DIRSEPCHAR)
      filename[fnlen-1]='\0';   /*  verwijder overbodige '/' op het eind  */
#else
   if (getcwd(path, MAXDIR)==NULL)
      return(NOTDIR);           /*  bewaar huidige pad in 'path'  */

   strcpy(filename, dir);       /*  zet opgegeven pad in 'filename'  */
   fnlen=strlen(filename);
   if (fnlen>1 && filename[fnlen-1]==DIRSEPCHAR)
      filename[fnlen-1]='\0';   /*  verwijder overbodige '/' op het eind  */
#endif

#ifdef TURBOC
   if (chdir(filename)<0)       /*  verander naar dat pad  */
      return(NOTDIR);

   if (getcurdir(filename[0]-'A'+1, dir+1)<0)
      return(NOTDIR);           /*  lees directory van disk  */
   dir[0]='\\';
   if (strlen(dir)>1)
      strcat(dir, DIRSEPSTR);   /*  plak '/' eraan vast als niet root dir  */

   if (chdir(path)<0)
      return(NOTDIR);           /*  verander terug naar originele pad  */
#else
   if (chdir(filename)<0)       /*  verander naar dat pad  */
      return(NOTDIR);

   if (getcwd(dir, MAXPATH)==NULL)
      return(NOTDIR);           /*  lees directory van disk  */
   if (strlen(dir)>1)
      strcat(dir, DIRSEPSTR);   /*  plak '/' eraan vast als niet root dir  */

   if (chdir(path)<0)
      return(NOTDIR);           /*  verander terug naar originele pad  */
#endif

   /*  vorm een compleet pad uit verzamelde gegevens  */
#ifdef TURBOC
   fnmerge(filename, drive, dir, name, ext);
#else
   fnmerge(filename, dir, name, ext);
#endif

   return(OK);
}
