/*  $Id: rnscbrk.c,v 1.9 1991/10/10 16:44:28 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnscbrk.c,v $
 * Revision 1.9  1991/10/10  16:44:28  richard
 * Switched to UNIX RCS
 *
 * Revision 1.8  91/05/09  14:38:49  ROOT_DOS
 * Changed control-c handler
 * Added control-c error message
 * 
 * Revision 1.7  91/02/26  21:49:15  ROOT_DOS
 * Added comments
 *
 * Revision 1.6  91/02/17  14:30:54  ROOT_DOS
 * Minor changes
 *
 * Revision 1.5  91/01/30  21:43:50  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.4  91/01/28  22:21:26  ROOT_DOS
 * Changed handler in ANSI C mode
 *
 * Revision 1.3  91/01/27  21:01:36  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.2  90/12/08  03:50:41  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:14:14  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor de afhandeling van control-c of control-break  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#else
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#endif



#ifdef USEPROTOS
void ctrlbrk_handler(int sig)
#else
void ctrlbrk_handler(sig)
        int sig;
#endif
{
int rc = OK;

   signal(SIGINT, SIG_IGN);     /*  negeer control-c signaal    */
   signal(SIGTERM, SIG_IGN);    /*  negeer termination signaal  */

#if defined(FCLOSEALL) || defined(TURBOC)
   if (fcloseall()==EOF)        /*  sluit alle open bestanden  */
      rc=CLSALL;
#endif

   if (rc==OK)
      rc=log_end();             /*  sluit logbestand af  */

   update_time();               /*  doe tijdmeting       */

   if (rc==OK)
      rc=run_tests();           /*  test alle patronen   */

   close_graphics();            /*  sluit grafische scherm  */

   if (rc==OK)
      rc=write_output();        /*  schrijf de resultaten naar het uitvoerbestand  */

   clean_up();                  /*  ruim het geheugen op  */

   if (rc==OK)                  /*  alles goed gegaan ?     */
      rc=CTLBRK;                /*  geef dan control-c aan  */

   if (rc!=OK)
      process_error(rc);        /*  handel een eventuele fout af  */

   exit(rc);                    /*  stop programma  */
}
