/*  $Id: rnsdefs.h,v 1.21 1991/10/10 16:42:11 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsdefs.h,v $
 * Revision 1.21  1991/10/10  16:42:11  richard
 * Switched to UNIX RCS
 * New random bit pattern support
 *
 * Revision 1.20  91/05/09  14:34:55  ROOT_DOS
 * Added nested include file protection
 * Added USERERR learn property
 * Changed accuracy of neuron output values, EPS
 * Added output of generated seed value
 * Changed don't care and undefined values
 *
 * Revision 1.19  91/03/24  15:53:37  ROOT_DOS
 * Added DONTCARE command
 *
 * Revision 1.18  91/02/26  21:49:27  ROOT_DOS
 * Added comments
 * Added support for SEED command
 *
 * Revision 1.17  91/02/17  14:25:45  ROOT_DOS
 * Added NUMBER directive
 * Minor changes
 *
 * Revision 1.16  91/02/07  21:32:45  ROOT_DOS
 * Added initialization of globals
 *
 * Revision 1.15  91/02/05  21:50:37  ROOT_DOS
 * Added MAXSTEP command
 *
 * Revision 1.14  91/02/05  01:24:46  ROOT_DOS
 * Made version that can be compiled to single or double arithmetic simulator
 *
 * Revision 1.13  91/02/01  23:29:14  ROOT_DOS
 * Minor changes
 *
 * Revision 1.12  91/01/30  21:43:59  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.11  91/01/28  22:21:53  ROOT_DOS
 * Added definitions as result of dual mode (Turbo C / ANSI C) code
 *
 * Revision 1.10  91/01/27  21:01:51  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.9  91/01/22  16:53:55  ROOT_DOS
 * Made ITER command conditional compilable
 *
 * Revision 1.8  91/01/19  22:22:10  ROOT_DOS
 * Added support for real-valued patterns, relative learning rates
 *
 * Revision 1.6  91/01/03  14:43:25  ROOT_DOS
 * Added variables for simulated annealing
 *
 * Revision 1.5  90/12/18  22:23:03  ROOT_DOS
 * Added error code for ALPHA command
 *
 * Revision 1.4  90/12/12  20:49:50  ROOT_DOS
 * Added error code for missing learning mode
 *
 * Revision 1.3  90/12/12  20:43:51  ROOT_DOS
 * Added comment to MAXSTR for minimal size
 *
 * Revision 1.2  90/12/08  03:49:38  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:10:38  ROOT_DOS
 * Initial revision
 *   */



/*  alle #define's, enum's, typedefs en globale variabelen van RNS  */


#ifndef _RNSDEFS_H
#define _RNSDEFS_H


#include "rnsconf.h"


#ifdef DEBUG
#define SHOWERRS
#define VERBOSE
#endif


#ifdef EXTERN            /*  als EXTERN gedefinieerd is, moeten de   */
#define EXT   extern     /*  definities als extern worden beschouwd  */
#else                    /*  Dit moet in alle C files gedaan worden  */
#define EXT              /*  op 1 na; in ons geval is dat RNS.C      */
#endif


#ifdef DOUBLE            /*  als DOUBLE gedefinieerd is, moeten alle   */
#define FLOAT double     /*  FLOAT's double zijn, anders gewoon float  */
#else
#define FLOAT float
#endif


#ifdef TURBOC
#include "turboc.h"      /*  voor extra Turbo C  #def's  */
#include <dir.h>         /*  voor MAXPATH  */
#include <stddef.h>      /*  voor NULL     */
#include <stdio.h>       /*  voor BUFSIZ   */
#include <time.h>        /*  voor time_t   */
#else
#include "noturboc.h"    /*  voor Turbo C  #def's en functies niet in K&R C  */
#include <stdio.h>       /*  voor BUFSIZ   */
#include <time.h>        /*  voor time_t   */
#include <stddef.h>      /*  voor NULL (moet achteraan staan voor GCC include's)  */
#endif



#define RNSNAME   "RNS"
#ifdef TURBOC
#define PROGRAM   "RNS"
#else
#define PROGRAM   "rns"
#endif

#ifdef DOUBLE
#define VERSION   "RNS v1.6d  --  Recurrent Network Simulator (double precision)."
#else
#define VERSION   "RNS v1.6s  --  Recurrent Network Simulator (single precision)."
#endif


#define FALSE   0
#define TRUE    1



#ifdef TURBOC            /*  MS-DOS definities  */

#define SWITCHAR   '/'

#define F_OK   0
#define X_OK   1
#define W_OK   2
#define R_OK   4

#define DIRSEPCHAR   '\\'
#define DIRSEPSTR    "\\"

#else                    /*  UNIX definities  */

#define SWITCHAR   '-'

#define DIRSEPCHAR   '/'
#define DIRSEPSTR    "/"

#endif



#define FILEND   (-1)    /*  FILEND moet negatief zijn  */

enum                     /*  enumeratie van foutcodes  */
{
   OK,
   CTLBRK,
   CLOSIN,
   CLSOUT,
   CLSLOG,
   CLSLRN,
   CLSTST,
   CLSPLL,
   CLSPLT,
#ifdef TURBOC
   CLSALL,
#endif
   CNTPLT,
#ifdef UNIX
   GETTTY,
   CKDTTY,
   RAWTTY,
#endif
   FLSEQU,
   NONAME,
   NOINDF,
   NOUTDF,
   NORATE,
   NOPATD,
   NOLRNM,
   NOHTOV,
   NACCIN,
   NACOUT,
   NACLOG,
   NACLRN,
   NACTST,
   NACPLL,
   NACPLT,
   START_INPUT_ERROR,    /*  start van input fouten  */
   BADADA,
   BADADG,
   BADADR,
   BADCAR,
   BADCNS,
   BADDMM,
   BADEPS,
   BADERR,
   BADFGT,
#ifndef NOITER
   BADITR,
#endif
   BADLRN,
   BADMAX,
   BADMLR,
   BADMOM,
   BADPAT,
   BADPSE,
   BADPSS,
   BADREL,
   BADSTP,
   BADSED,
   BADBIN,
   BDBINF,
   BDBOUT,
   BDBRES,
   BADLIN,
   BDLINF,
   BDLOUT,
   BDLRES,
   BADRIN,
   BDRINF,
   BDROUT,
   BDRRES,
   BADTIN,
   BDTINF,
   BDTOUT,
   BDTRES,
   BADTOL,
   BADDCY,
   BITLNG,
   CMEXPD,
   CNEXPD,
   CNTADD,
   CNTCON,
   CNTPAT,
   DBLDEF,
   DSTLRG,
   EADINF,
   EARINF,
   EDINFO,
   EDMINF,
   EEINFO,
   EFGINF,
#ifndef NOITER
   EIINFO,
#endif
   ELINFO,
   EMINFO,
   EMRINF,
   EMWINF,
   ENINFO,
   EOINFO,
   EPINFO,
   EWINFO,
   ECINFO,
   EAINFO,
   ESINFO,
   ERINFO,
   ETINFO,
   ETLINF,
   FLTRNG,
   IALRDY,
   INVNUM,
   INVWDT,
   INVHGT,
   MIEXPD,
   NEQINP,
   NEQOUT,
   NOFUNC,
   NUMLNG,
   OALRDY,
   PATLNG,
   SCEXPD,
   SETSET,
   STRLNG,
   TESTST,
   TMBITS,
   UNFUNC,
   UNKNWN,
   VTHADD,
   VTHEXP,
   VTHINI,
   VTHMXR,
   END_INPUT_ERROR,      /*  einde van input fouten  */
#ifdef TURBOC
   CNTBGI,
   INFLTL,
   INFSML,
   INLTTL,
   INSMAL,
   OUTLTL,
   OUTSML,
   RESLTL,
   RESSML,
#endif
   MEMFUL,
   MEMPLT,
   MISEND,
   NOTDIR,
   INTOOL,
   OPENIN,
   OUTOOL,
   OPNOUT,
   LGTOOL,
   OPNLOG,
   OPNLRN,
   OPNTST,
   OPNPLL,
   OPNPLT,
   UNKARG,
   INPREQ,
   STMTCH,
   TOOMNY,
#ifdef TURBOC
   VINERR,
   VINFER,
   VOUTER,
   VRESER,
#endif
   UNTYPE,
   UNCONN,
   UNDEFN,
   MAXERR                /*  MAXERR altijd als laatste !  */
};


/*  leeralgoritme modi  */
enum { LEARN=0, HEBB=1, DHEBB=2, GROSSBERG=4, FBPR=8, ANNEAL=16,
       FORCED=32, SELF=64, CLIP424=128, CLIP262=256, RANDOM=512, USERERR=1024 };

/*  output functies  */
enum { FUNCTION, STEP, LOGISTIC, LOGC4, LOGC8, LINEAR };

/*  type neuronen  */
enum { TYPE, INPUT, HIDDEN, OUTPUT };

/*  berekeningsmodi  */
enum { OUT=1, DELTA=2, RESULT=4 };

/*  patroonmodi  */
enum { PATTERN, BIT, REAL };

enum { NONE, ALPHA, NUMBER, ATOH, BTOH, FTOH, NTOH };


/*  mogelijke inputcommando's  */
enum { READ_INPUT, READ_HIDDEN, READ_OUTPUT, READ_EPSILON, READ_MOMENTUM,
       READ_ERROR, READ_DISPLAY, READ_PATTERNS,
#ifndef NOITER
       READ_ITER,
#endif
       READ_LEARN, READ_DECAY, READ_STEP, READ_SEED, READ_DONTCARE,
       READ_PSELECT, READ_TOLERANCE, READ_MAXWEIGHT, READ_FORGET,
       READ_DMOMENTUM, READ_ADDRATE, READ_MULRATE, READ_ADJUST };


#ifdef TURBOC            /*  speciale toetsen onder MS-DOS  */
enum { ESC=27, HOME=71, UP, PGUP, LEFT=75, RIGHT=77, END=79, DOWN, PGDN };
#endif



/*  de minimale en maximale waarde moeten symmetrisch rond UNDEFINED liggen  */
#define MAXOUTPUT       1    /*  maximale waarde van LOGISTIC neuron output  */
#define MINOUTPUT     (-1)   /*  minimale waarde van LOGISTIC neuron output  */
#define UNDEFINED       0    /*  neutrale waarde van LOGISTIC neuron output  */
#define MAXMINOUT       2    /*  MAXOUTPUT - MINOUTPUT  */
#define DONTCARE        3    /*  "don't care" waarde    */


#define EPS       1E-4   /*  convergentie op EPS'ste decimaal nauwkeurig  */

#define EPSERROR  1E-5   /*  fout moet minimaal op EPSERROR'ste decimaal  */
                         /*  verschillen om foutdaling aan te geven       */

#define MAXWEIGHT   50   /*  maximale absolute waarde van gewichten  */


#define MINALLC      4   /*  alloceer minimaal MINALLC elementen per keer  */

#define REFRESH     10   /*  ververs scherm om de REFRESH stappen  */

/*  virtuele afmetingen van het scherm  */
#define VIRTUALX  1600   /*  virtuele breedte van het scherm  */
#define VIRTUALY  1200   /*  virtuele hoogte van het scherm   */

#ifdef TURBOC            /*  marges van verscheidene vensterranden  */
#define INMARGIN     2   /*  input venster      */
#define OUTMARGIN    2   /*  output venster     */
#define RESMARGIN    2   /*  resultaat venster  */
#define INFOMARGIN  12   /*  info venster       */

#define MSGMARGIN    4   /*  bericht venster  */
#endif

#define MAXSTR  40       /*  minimaal 16, zie patstr in display_error  */



typedef unsigned char  boolean;


typedef struct Neuron_struct  *Neuronptr;

typedef struct Weight_struct  *Weightptr;



typedef struct Neuron_struct
{
   int    number;        /*  nummer van neuron  */

   int    ionum;         /*  nummer van in- of output als in- of uitvoerneuron  */

   char   type;          /*  type van neuron    */

   FLOAT  epsilon;       /*  lokale parameter voor leersnelheid  */
   FLOAT  addrate;       /*  lokale parameter voor additieve leersnelheid  */
   FLOAT  mulrate;       /*  lokale parameter voor multiplicatieve leersnelheid  */

   FLOAT  activation;    /*  activatie waarde   */

   FLOAT  bias;          /*  bias waarde        */
   FLOAT  dbias;         /*  delta_bias         */
   FLOAT  prevdbias;     /*  vorige delta_bias  */
   FLOAT  orgbias;       /*  orginele/gespecificeerde bias  */

   char   *constraint;   /*  beperkingen op de bias  */

   char   function;      /*  output functie  */

   FLOAT  output;        /*  output waarde         */
   FLOAT  prevoutput;    /*  vorige output waarde  */
   FLOAT  derivation;    /*  eerste orde afgeleide van output  */

   FLOAT  deltasum;      /*  activatie waarde van delta  */

   FLOAT  delta;         /*  delta waarde  */
   FLOAT  prevdelta;     /*  vorige delta waarde  */

   struct
   {
      unsigned output : 1;      /*  output veranderd ?         */
      unsigned prev   : 1;      /*  vorige output veranderd ?  */
      unsigned delta  : 1;      /*  delta veranderd ?          */
      unsigned extra  : 1;      /*  extra boolean voor indicatie van  */
                                /*  in-function veranderingen         */
   } changed;

   int    nrweights;            /*  aantal gewichten  */

   Weightptr  weights;          /*  pointer naar gewichten  */

   Neuronptr  next;             /*  pointer naar volgende neuron  */

} Neuron;



typedef struct Weight_struct
{
   FLOAT  epsilon;              /*  lokale parameter voor leersnelheid  */
   FLOAT  addrate;              /*  lokale parameter voor additieve leersnelheid  */
   FLOAT  mulrate;              /*  lokale parameter voor multiplicatieve leersnelheid  */

   FLOAT  value;                /*  waarde van gewicht  */
   FLOAT  orgvalue;             /*  originele/gespecificeerde waarde  */

   FLOAT  partact;              /*  partiele activatie = w.i  */

   FLOAT  partdel, partdel2;    /*  partiele delta = w.d      */

   FLOAT  delta;                /*  delta_weight         */
   FLOAT  prevdelta;            /*  vorige delta_weight  */

   char   *constraint;          /*  beperkingen op het gewicht  */

   boolean delay;               /*  delayed link ?  */

   Neuronptr  from, from2;      /*  pointers naar neuronen waar signaal  */
                                /*  vandaan komt; tweede voor Sigma-Pi   */
} Weight;



typedef struct Pattern_struct  *Patternptr;


typedef struct Pattern_struct
{
   char type;            /*  type patroon  */

   FLOAT relative;       /*  relatieve factor  */

   long  count;          /*  patroon deselect teller  */

   int nrpairs;          /*  aantal paren in patroonset  */

   FLOAT *in;            /*  input patroon   */
   FLOAT *out;           /*  output patroon  */
   FLOAT *result;        /*  resultaat       */

   FLOAT error;          /*  fout voor patroon  */

} Pattern;



EXT char  *errstr[MAXERR];      /*  foutmeldingen; zie RNSINIT.C  */



EXT int  nrpatterns, nrtests;   /*  aantal patronen & aantal testpatronen  */

EXT Patternptr  *patternlistptr;       /*  pointer naar eerste patroon     */

/*  maximale patroonlengte en pointers naar patronen  */
#ifdef TURBOC
#define MAXPATLEN    4095
#else
#define MAXPATLEN   16380
#endif
EXT FLOAT  *input_pattern, *output_pattern;



EXT Neuronptr  neuronlist;      /*  pointer naar eerste neuron  */


EXT int  nrneurons;             /*  aantal neuronen  */

EXT int  nrinputs;              /*  aantal inputneuronen  */

EXT Neuronptr  *inputlistptr;   /*  pointers naar lijst met pointers naar inputneuronen  */

EXT int  nroutputs;             /*  aantal outputneuronen  */

EXT Neuronptr  *outputlistptr;  /*  pointers naar lijst met pointers naar outputneuronen  */



/*  zet een pointer in de patroonlijst of haal deze op   */
#define SETPATTERN(number)   (*(patternlistptr+number))

#define GETPATTERN(number)   (*(patternlistptr+number))
                                /*  inderdaad hetzelfde  */


/*  bepaal het aantal patroonparen in een set patronen  */
#define DESELECTED(number)   ((*(patternlistptr+number))->count>0)


/*  bepaal het aantal patroonparen in een set patronen  */
#define PAIRS(number)        ((*(patternlistptr+number))->nrpairs)



/*  haal een pointer naar een bepaalde inputneuron op   */
#define INPUTNEURON(number)    (*(inputlistptr+number))

/*  haal een pointer naar een bepaalde outputneuron op  */
#define OUTPUTNEURON(number)   (*(outputlistptr+number))




#ifdef TURBOC            /*  bepaal hoogte van punt in foutgrafiek  */
#define PLOTHEIGHT(error)   (infoview_height-INFOMARGIN- \
                             error/max_error*(infoview_height-2*INFOMARGIN))
#endif



/*  arrays voor de namen van het invoer-, uitvoer- en logbestand  */
EXT char  input_name[MAXPATH], output_name[MAXPATH], log_name[MAXPATH],
          learn_name[MAXPATH], test_name[MAXPATH],
          pll_name[MAXPATH], plt_name[MAXPATH];


#ifdef TURBOC            /*  MS-DOS extensies voor invoerbestand   */
#define INPUTEXT    ".NET"
#else                    /*  UNIX extensies voor invoerbestand     */
#define INPUTEXT    ".net"
#endif
#define INPUTMODE    "rt"       /*  modus voor openen invoerbestand   */
EXT FILE  *input_file;


#ifdef TURBOC            /*  MS-DOS extensies voor uitvoerbestand  */
#define OUTPUTEXT   ".OUT"
#else                    /*  UNIX extensies voor invoerbestand     */
#define OUTPUTEXT   ".out"
#endif
#define OUTPUTMODE   "wt"       /*  modus voor openen uitvoerbestand  */
EXT FILE  *output_file;

#ifdef TURBOC            /*  MS-DOS extensies voor logbestand      */
#define LOGEXT      ".LOG"
#else                    /*  UNIX extensies voor logbestand        */
#define LOGEXT      ".log"
#endif
#define LOGMODE      "at"       /*  modus voor openen logbestand      */
EXT FILE  *log_file;

#ifdef TURBOC            /*  MS-DOS extensies voor leerbestand      */
#define LEARNEXT    ".LRN"
#else                    /*  UNIX extensies voor leerbestand        */
#define LEARNEXT    ".lrn"
#endif
#define LEARNMODE    "wt"       /*  modus voor openen leerbestand     */
#define LEARNMODE2   "rt"       /*  modus voor openen leerbestand     */
EXT FILE  *learn_file;

#ifdef TURBOC            /*  MS-DOS extensies voor testbestand      */
#define TESTEXT     ".TST"
#else                    /*  UNIX extensies voor testbestand        */
#define TESTEXT     ".tst"
#endif
#define TESTMODE     "wt"       /*  modus voor openen testbestand     */
#define TESTMODE2    "rt"       /*  modus voor openen testbestand     */
EXT FILE  *test_file;

#ifdef TURBOC            /*  MS-DOS extensies voor plot-leerbestand      */
#define PLLEXT      ".PLL"
#else                    /*  UNIX extensies voor plot-leerbestand        */
#define PLLEXT      ".pll"
#endif
#define PLLMODE      "wt"       /*  modus voor openen plot-leerbestand     */
EXT FILE  *pll_file;

#ifdef TURBOC            /*  MS-DOS extensies voor plot-testbestand      */
#define PLTEXT      ".PLT"
#else                    /*  UNIX extensies voor plot-testbestand        */
#define PLTEXT      ".plt"
#endif
#define PLTMODE      "wt"       /*  modus voor openen plot-testbestand     */
EXT FILE  *plt_file;



#define LOGSTEP        5        /*  ververs logbestand om de LOGSTEP stappen  */


EXT char  file_buffer[BUFSIZ];  /*  buffer voor file I/O  */


/*  rij en kolom uit het invoerbestand  */
EXT int  input_row, input_colom;


#define MAXLINE  16380   /*  maximum lengte van een regel  */
#define MAXWORD  512     /*  maximum lengte van een woord  */
EXT char  input_line[MAXLINE+1];       /*  invoerregel     */
EXT char  input_word[MAXWORD+1];       /*  invoerwoord     */


/*  verscheidene leerparameters en fouten  */
EXT FLOAT  epsilon, addrate, mulrate, momentum, dmomentum, forget, tolerance,
           maxweight, error, total_error, min_error, max_error, dontcare,
           pselect_error;

EXT long  step, con_step, max_step, lim_step, iter, max_iter, complexity,
          decay, decay_val, pselect_steps;

EXT unsigned  seed, gseed;

EXT int  learn;


/*  variabelen voor 'simulated annealing'  */
EXT boolean  accept;     /*  accepteer huidige waardes van gewichten ?   */

EXT FLOAT  chance;       /*  kans op acceptatie van slechtere oplossing  */


/*  variabelen voor 'simulated annealing'  */
EXT boolean  pselect_adapt;     /*  accepteer huidige waardes van gewichten ?   */


/*  variabelen voor mode van aanpassen van lokale leerparameter  */
EXT enum { ADJUST_RECURRENT, ADJUST_ALL }  adjust_net;
EXT enum { ADJUST_RELATIVE, ADJUST_LOCAL, ADJUST_GLOBAL }  adjust_mode;


/*  breedtes en hoogtes van in- en uitvoerpatronen  */
EXT int  width_in, height_in, width_out, height_out;


/*  virtuele coordinaten van vensters  */
EXT int  left_in, top_in, right_in, bottom_in,
         left_out, top_out, right_out, bottom_out,
         left_res, top_res, right_res, bottom_res,
         left_info, top_info, right_info, bottom_info;


/*  strings die boven de vensters komen te staan  */
EXT char  inputstr[MAXSTR+1], outputstr[MAXSTR+1],
          resultstr[MAXSTR+1], infostr[MAXSTR+1];


#ifdef TURBOC            /*  variabelen voor afmetingen van vensters  */
EXT int  inview_left, inview_top, inview_right, inview_bottom,
         outview_left, outview_top, outview_right, outview_bottom,
         resview_left, resview_top, resview_right, resview_bottom,
         infoview_left, infoview_top, infoview_right, infoview_bottom;

EXT int  inview_width, inview_height,
         outview_width, outview_height,
         resview_width, resview_height,
         infoview_width, infoview_height;

EXT float  inblock_width, inblock_height,
           outblock_width, outblock_height,
           resblock_width, resblock_height;

EXT int  maxx, maxy, maxcolor;  /*  echte afmetingen scherm en maximale kleur  */

EXT int  errorpos;              /*  positie van punt in foutgrafiek  */

/*  variabelen voor graphische modus en driver  */
EXT int   graphdriver, graphmode;

EXT void  *bitmap;              /*  pointer naar bitmap  */
#endif


#define WAITMSG   "Please wait ..."    /*  bericht om even te wachten  */


/*  verschillende variabelen voor command-line instellingen  */
EXT boolean  batch, trace, quiet, verbose, logging, plot;


/*  variabelen voor tijdmetingen  */
EXT time_t  begin_time, end_time;
EXT char    begin_str[26], end_str[26];
                                /*  begin en eind tijd in ASCII  */


/*  patroon buffers voor het maken van plots  */
EXT char  *orig_input, *trans_input, *orig_output, *trans_output, *plot_line;


/*  pointers die in RNSPROC door de gebruiker te zetten zijn  */

EXT FLOAT  (*errorfp)__((FLOAT target, FLOAT output, void *erroropt));
EXT void  *erroropt;

EXT FLOAT  (*derrorfp)__((FLOAT target, FLOAT output, void *derroropt));
EXT void  *derroropt;


#endif  /*  _RNSDEFS_H  */

