/*  $Id: rnserror.c,v 1.9 1991/10/10 16:45:23 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnserror.c,v $
 * Revision 1.9  1991/10/10  16:45:23  richard
 * Switched to UNIX RCS
 *
 * Revision 1.8  91/02/26  21:49:40  ROOT_DOS
 * Added comments
 *
 * Revision 1.7  91/02/17  14:28:19  ROOT_DOS
 * Minor changes
 *
 * Revision 1.6  91/02/07  21:34:12  ROOT_DOS
 * Added quiet mode as default and a verbose mode in Sparc version
 *
 * Revision 1.5  91/02/01  23:29:27  ROOT_DOS
 * Minor changes in help information
 *
 * Revision 1.4  91/01/30  21:44:06  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.3  91/01/27  21:02:00  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.2  90/12/08  03:50:52  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:14:53  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het verwerken van een foutcode  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <graphics.h>
#include <stdio.h>
#else
#include <stdio.h>
#endif



#ifdef USEPROTOS
void process_error(int rc)
#else
void process_error(rc)
        int rc;
#endif
{
   /*  druk fouttekst af  */
#ifdef TURBOC
   fprintf(stderr, "\n"
                   "%s Error [%d]: %s",
                   RNSNAME, rc<0 ? -1 : rc, rc<0 ? grapherrormsg(rc) : errstr[rc]);
#else
   fprintf(stderr, "\n%s Error [%d]: %s",
                   RNSNAME, rc, errstr[rc]);
#endif

   /*  druk rij en kolom af indien het een invoer fout is  */
   if (START_INPUT_ERROR<rc && rc<END_INPUT_ERROR)
      fprintf(stderr, " (%d, %d)", input_row, input_colom+1);
   fprintf(stderr, ".\n\n");           /*  sluit af met een punt en 1 lege regel  */

   /*  druk een korte hulpboodschap af als het om een van de volgende fouten gaat:   */
   /*  gelijke namen voor invoer-, uitvoer- of logbestand; geen naam invoerbestand;  */
   /*  fout bij openen invoerbestand; niet bestaande directory; onbekende optie;     */
   /*  invoerbestand vereist; te veel bestandsnamen op de commandoregel              */
   switch (rc)
   {
      case FLSEQU:
      case NONAME:
      case OPENIN:
      case NOTDIR:
      case UNKARG:
      case INPREQ:
      case TOOMNY:
#ifdef TURBOC
         fprintf(stderr, "\n"
                         "%s\n"
                         "\n"
                         "Usage: %s input_file["INPUTEXT"] [output_file["OUTPUTEXT"]] "
                                    "[log_file["LOGEXT"]] [options]\n"
                         "\n"
                         "       options:\n"
                         "\n"
                         "       /B  - batch simulation\n"
                         "       /L  - log time and error data\n"
                         "       /P  - build plot files\n"
                         "       /Q  - quiet simulation\n"
                         "       /V  - display error data on text screen\n\n",
                         VERSION, PROGRAM);
#else
         fprintf(stderr, "\n\
%s\n\
\n\
Usage: %s input_file[%s] [output_file[%s]] \
[log_file[%s]] [options]\n\
\n\
       options:\n\
\n\
       -l  : log time and error data\n\
       -p  : build plot files\n\
       -v  : display error data on screen\n\n\n",
                         VERSION, PROGRAM, INPUTEXT, OUTPUTEXT, LOGEXT);
#endif
         break;
   }
}
