/*  $Id: rnsfuncs.h,v 1.17 1991/10/10 16:42:36 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsfuncs.h,v $
 * Revision 1.17  1991/10/10  16:42:36  richard
 * Switched to UNIX RCS
 * New random bit pattern support
 *
 * Revision 1.16  91/05/09  14:36:53  ROOT_DOS
 * Added nested include file protection
 * Added USERERR learn property
 *
 * Revision 1.15  91/03/24  15:54:49  ROOT_DOS
 * Fixed Differential Hebb learning algorithm
 * Added DONTCARE command
 *
 * Revision 1.14  91/02/26  21:49:47  ROOT_DOS
 * Added comments
 *
 * Revision 1.13  91/02/17  14:26:19  ROOT_DOS
 * Added NUMBER directive
 *
 * Revision 1.12  91/02/05  21:50:56  ROOT_DOS
 * Added MAXSTEP command
 *
 * Revision 1.11  91/02/05  01:26:35  ROOT_DOS
 * Made version that can be compiled to single or double arithmetic simulator
 *
 * Revision 1.10  91/01/30  21:44:10  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.9  91/01/27  21:02:09  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.8  91/01/22  16:53:14  ROOT_DOS
 * Made ITER command conditional compilable
 *
 * Revision 1.7  91/01/21  16:15:44  ROOT_DOS
 * Changed display of "don't care" values
 *
 * Revision 1.6  91/01/19  22:23:05  ROOT_DOS
 * Added support for real-valued patterns, relative learning rates
 *
 * Revision 1.4  90/12/18  22:24:04  ROOT_DOS
 * Added alnum_to_bitpat for conversion of alphanumeric strings to bit patterns
 * as support for ALPHA command
 *
 * Revision 1.3  90/12/12  20:44:18  ROOT_DOS
 * Changed prototype of display_error
 *
 * Revision 1.2  90/12/08  03:50:05  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:11:09  ROOT_DOS
 * Initial revision
 *   */



/*  alle functie definities van RNS  */


#ifndef _RNSFUNCS_H
#define _RNSFUNCS_H


int    init __((void));
int    process_args __((int argc, char *argv[]));
int    resolve_name __((char *filename, char *extension));
int    read_input __((void));
int    read_line __((FILE *fp));
char  *get_next_word __((void));
int    read_command __((void));
int    read_neurons __((char type));
int    read_epsilon __((void));
int    read_momentum __((void));
int    read_error __((void));
int    read_patterns __((void));
void   fprintf_pat __((FILE *output_file, char type, int length, FLOAT *pattern));
int    read_display __((void));
#ifndef NOITER
int    read_iter __((void));
#endif
int    read_learn __((void));
int    read_decay __((void));
int    read_step __((void));
int    read_seed __((void));
int    read_dontcare __((void));
int    read_pselect __((void));
int    read_tolerance __((void));
int    read_maxweight __((void));
int    read_forget __((void));
int    read_dmomentum __((void));
int    read_addrate __((void));
int    read_mulrate __((void));
int    read_adjust __((void));
Neuronptr   add_neuron __((int number));
Neuronptr   get_neuron __((int number));
int    connect_neuron __((Neuronptr neuronptr, Neuronptr fromptr, Neuronptr from2ptr,
                         FLOAT weight, char *constraint, boolean delay));
int    add_input __((Neuronptr neuronptr));
int    add_output __((Neuronptr neuronptr));
int    check_input __((void));
int    open_graphics __((void));
int    process_net __((void));
boolean   step_check __((void));
int    log_info __((boolean info));
int    log_start __((void));
int    log_end __((void));
void   init_time __((void));
void   update_time __((void));
void   init_net __((void));
void   init_weights __((void));
void   reset_activations __((int pattern, int pair, char mode));
boolean   calc_output __((int pattern, int pair));
void   calc_deriv __((int pattern, int pair));
void   calc_error __((void));
void   reset_pattern_error __((int pattern));
void   calc_pattern_error __((int pattern, int pair));
void   reset_deltasums __((int pattern, int pair, char mode));
void   adjust_lrates __((int pattern));
boolean   calc_delta __((void));
void   calc_delay __((void));
void   reset_dweights __((void));
void   calc_dweights __((int pattern));
void   update_weights __((void));
FLOAT  neuron_output __((Neuronptr neuronptr));
FLOAT  neuron_derivative __((Neuronptr neuronptr));
FLOAT  neuron_inverse __((Neuronptr neuronptr));
FLOAT  clip_value __((FLOAT value));
FLOAT  sqr __((FLOAT x));
FLOAT  default_errorf __((FLOAT target, FLOAT output, void *erroropt));
FLOAT  default_derrorf __((FLOAT target, FLOAT output, void *derroropt));
int    convert_to_bitpat __((char mode, char *source_pattern, int nrbits, int distance, char **dest_pattern));
int    add_pattern __((char type, int pair,
                      FLOAT *input_pattern, FLOAT *output_pattern,
                      FLOAT relative));
FLOAT  pattern_val __((int pattern, int pair, int number, char type));
int    run_tests __((void));
void   set_pattern_result __((int pattern, int pair));
int    show_results __((void));
int    init_screen __((void));
int    input_border __((void));
int    output_border __((void));
int    result_border __((void));
int    info_border __((void));
void   refresh_display __((int pattern, int pair, boolean info));
void   verbose_display __((int pattern, int pair, boolean info));
void   display_input __((int pattern, int pair));
void   display_output __((int pattern, int pair));
void   display_result __((int pattern, int pair));
void   draw_value __((float x, float y, float width, float height, FLOAT value, boolean undefined));
void   display_info __((void));
int    close_screen __((void));
void   display_error __((int pattern, int pair));
void   close_graphics __((void));
int    write_output __((void));
int    write_header __((void));
int    write_neurons __((void));
int    write_neuron __((Neuronptr neuronptr));
int    write_epsilon __((void));
int    write_momentum __((void));
int    write_error __((void));
int    write_display __((void));
int    write_patterns __((void));
#ifndef NOITER
int    write_iter __((void));
#endif
int    write_learn __((void));
int    write_decay __((void));
int    write_step __((void));
int    write_seed __((void));
int    write_dontcare __((void));
int    write_pselect __((void));
int    write_tolerance __((void));
int    write_maxweight __((void));
int    write_forget __((void));
int    write_dmomentum __((void));
int    write_addrate __((void));
int    write_mulrate __((void));
int    write_adjust __((void));
int    build_plot __((void));
int    convert_to_plot __((char *origpat, char *plotpat));
int    convert_to_results __((int pattern, int pair, char *origpat, char *plotpat));
int    value_to_h __((unsigned long value, int nrbits, int distance, char *bit_ptr));
int    h_to_value __((unsigned long value, int nrbits, int distance, unsigned long *value_ptr, int *dist_ptr));
int    countdbits __((int nrbits, unsigned long value1, unsigned long value2));
void   long_to_bitpat __((unsigned long value, int nrbits, char *bit_ptr));
void   vtohcleanup __((void));
void   clean_up __((void));
void   process_error __((int rc));
void   ctrlbrk_handler __((int sig));


#endif  /*  _RNSFUNCS_H  */

