/*  $Id: rnsgraph.c,v 1.17 1991/10/10 16:45:28 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsgraph.c,v $
 * Revision 1.17  1991/10/10  16:45:28  richard
 * Switched to UNIX RCS
 *
 * Revision 1.16  91/05/09  14:40:22  ROOT_DOS
 * Changed don't care and undefined values
 * Minor changes
 *
 * Revision 1.15  91/03/24  16:00:02  ROOT_DOS
 * Added RANDOM learning property
 * Cleaned up clipping
 * Moved 'display_error()' back in
 *
 * Revision 1.14  91/02/17  14:28:24  ROOT_DOS
 * Minor changes
 *
 * Revision 1.13  91/02/07  21:34:38  ROOT_DOS
 * Minor change in code for sake of consistency
 *
 * Revision 1.12  91/02/05  01:27:36  ROOT_DOS
 * Made version that can be compiled to single or double arithmetic simulator
 *
 * Revision 1.11  91/02/01  23:30:40  ROOT_DOS
 * Minor changes
 *
 * Revision 1.10  91/01/30  21:44:15  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.9  91/01/27  21:02:14  ROOT_DOS
 * Changed code to show the last error value reached
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.8  91/01/21  16:16:24  ROOT_DOS
 * Changed display of "don't care" values
 *
 * Revision 1.7  91/01/20  00:46:42  ROOT_DOS
 * Changed position of error display in windows somewhat
 * Moved display_error to RNSSHOW.C
 *
 * Revision 1.6  91/01/19  22:24:57  ROOT_DOS
 * Added error display in info window
 *
 * Revision 1.4  90/12/12  21:10:19  ROOT_DOS
 * Added stdio.h for sprintf
 *
 * Revision 1.3  90/12/12  20:44:49  ROOT_DOS
 * Changed display_error to display pattern and pair
 *
 * Revision 1.2  90/12/08  03:50:56  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:15:34  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het grafisch afbeelden van gegevens  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <alloc.h>
#include <conio.h>
#include <dos.h>
#include <graphics.h>
#include <stdio.h>
#include <string.h>
#else
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#endif



#ifdef USEPROTOS
int open_graphics(void)
#else
int open_graphics()
#endif
{
int rc = OK;

   if (quiet)
      return(OK);

#ifdef TURBOC
   if (registerbgidriver(ATT_driver)<0)
      return(CNTBGI);

   if (registerbgidriver(CGA_driver)<0)
      return(CNTBGI);

   if (registerbgidriver(Herc_driver)<0)
      return(CNTBGI);

   if (registerbgidriver(EGAVGA_driver)<0)
      return(CNTBGI);

   if (registerbgidriver(PC3270_driver)<0)
      return(CNTBGI);

   if (registerbgidriver(IBM8514_driver)<0)
      return(CNTBGI);

   graphdriver=DETECT;
   initgraph(&graphdriver, &graphmode, "");
   if ((rc=graphresult())!=grOk)
      return(rc);

   maxx=getmaxx();
   maxy=getmaxy();

   maxcolor=getmaxcolor();

   setwritemode(0);
#endif

   return(OK);
}



#ifdef USEPROTOS
int init_screen(void)
#else
int init_screen()
#endif
{
int rc = OK;

   if (verbose==TRUE)
   {
      printf("\n%s:  %s\n\n", RNSNAME, VERSION);
   }
   else
   {
      if (quiet==FALSE)
      {
#ifdef TURBOC
         /*  De TC compiler meldt het volgende over onderstaande opdrachten:  */
         /*  'warning: conversion may lose significant digits'                */
         /*  Dit komt door de 'cast (long)': de integer vermenigvuldiging     */
         /*  wordt hierdoor in long uitgevoerd waardoor het tussenresultaat   */
         /*  niet afgerond wordt, maar het eindresultaat wel. Deze past       */
         /*  echter altijd in een integer met de huidige instellingen.        */
         /*  Dus negeer deze waarschuwing, alles is OK.                       */

         /*  9 juni 1990:                                                     */
         /*  De waarschuwing wordt tijdelijk uitgeschakeld met '#pragma warn' */

#pragma warn -sig

         inview_left=(long)left_in*(maxx+1)/VIRTUALX;
         inview_top=(long)top_in*(maxy+1)/VIRTUALY;
         inview_right=(long)right_in*(maxx+1)/VIRTUALX;
         inview_bottom=(long)bottom_in*(maxy+1)/VIRTUALY;

         outview_left=(long)left_out*(maxx+1)/VIRTUALX;
         outview_top=(long)top_out*(maxy+1)/VIRTUALY;
         outview_right=(long)right_out*(maxx+1)/VIRTUALX;
         outview_bottom=(long)bottom_out*(maxy+1)/VIRTUALY;

         resview_left=(long)left_res*(maxx+1)/VIRTUALX;
         resview_top=(long)top_res*(maxy+1)/VIRTUALY;
         resview_right=(long)right_res*(maxx+1)/VIRTUALX;
         resview_bottom=(long)bottom_res*(maxy+1)/VIRTUALY;

         infoview_left=(long)left_info*(maxx+1)/VIRTUALX;
         infoview_top=(long)top_info*(maxy+1)/VIRTUALY;
         infoview_right=(long)right_info*(maxx+1)/VIRTUALX;
         infoview_bottom=(long)bottom_info*(maxy+1)/VIRTUALY;

         /* 9 juni 1990:                                               */
         /* Zet de waarschuwing-instelling terug op ingestelde waarde  */

#pragma warn .sig

         inview_width=inview_right-inview_left;
         inview_height=inview_bottom-inview_top;

         inblock_width=(float)(inview_width-INMARGIN)/width_in;
         inblock_height=(float)(inview_height-INMARGIN)/height_in;

         outview_width=outview_right-outview_left;
         outview_height=outview_bottom-outview_top;

         outblock_width=(float)(outview_width-OUTMARGIN)/width_out;
         outblock_height=(float)(outview_height-OUTMARGIN)/height_out;

         resview_width=resview_right-resview_left;
         resview_height=resview_bottom-resview_top;

         resblock_width=(float)(resview_width-OUTMARGIN)/width_out;
         resblock_height=(float)(resview_height-OUTMARGIN)/height_out;

         infoview_width=infoview_right-infoview_left;
         infoview_height=infoview_bottom-infoview_top;

         if (inview_left || inview_top || inview_right || inview_bottom)
         {
            if (inblock_width-INMARGIN<2)
               return(INSMAL);
            if (inblock_height-INMARGIN<2)
               return(INLTTL);

            if ((rc=input_border())!=OK)
               return(rc);
         }

         if (outview_left || outview_top || outview_right || outview_bottom)
         {
            if (outblock_width-OUTMARGIN<2)
               return(OUTSML);
            if (outblock_height-OUTMARGIN<2)
               return(OUTLTL);

            if ((rc=output_border())!=OK)
               return(rc);
         }

         if (resview_left || resview_top || resview_right || resview_bottom)
         {
            if (resblock_width-RESMARGIN<2)
               return(RESSML);
            if (resblock_height-RESMARGIN<2)
               return(RESLTL);

            if ((rc=result_border())!=OK)
               return(rc);
         }

         if (infoview_left || infoview_top || infoview_right || infoview_bottom)
         {
            if (infoview_width-22*textwidth("x")<0)
               return(INFSML);         /*  22 =  ruimte voor "train (%d,%d;%6.4f)"  */
            if (infoview_height<3*INFOMARGIN)
               return(INFLTL);

            if ((rc=info_border())!=OK)
               return(rc);

            setviewport(infoview_left, infoview_top,
                        infoview_right, infoview_bottom, TRUE);

            line(INFOMARGIN, INFOMARGIN, INFOMARGIN, infoview_height-INFOMARGIN);
            line(INFOMARGIN, infoview_height-INFOMARGIN,
                 infoview_width-INFOMARGIN, infoview_height-INFOMARGIN);

            outtextxy(4, 2, "error");
            outtextxy(infoview_width-textwidth("step")-2,
                      infoview_height-textheight("step")-2, "step");

            line(INFOMARGIN/2, INFOMARGIN+1, INFOMARGIN/2, INFOMARGIN+21);
            line(INFOMARGIN/2-1, INFOMARGIN+2, INFOMARGIN/2+1, INFOMARGIN+2);
            line(INFOMARGIN/2-2, INFOMARGIN+3, INFOMARGIN/2+2, INFOMARGIN+3);

            line(infoview_width-textwidth("step")-7,
                 infoview_height-INFOMARGIN/2,
                 infoview_width-textwidth("step")-32,
                 infoview_height-INFOMARGIN/2);
            line(infoview_width-textwidth("step")-8,
                 infoview_height-INFOMARGIN/2-1,
                 infoview_width-textwidth("step")-8,
                 infoview_height-INFOMARGIN/2+1);
            line(infoview_width-textwidth("step")-9,
                 infoview_height-INFOMARGIN/2-2,
                 infoview_width-textwidth("step")-9,
                 infoview_height-INFOMARGIN/2+2);

            if ((bitmap=(void *)malloc(imagesize(INFOMARGIN+2, INFOMARGIN+1,
                                                 infoview_width-INFOMARGIN-4,
                                                 infoview_height-INFOMARGIN-1)))==NULL)
               return(MEMFUL);

            errorpos=INFOMARGIN+1;
         }
#endif
      }
   }

   if ((rc=log_start())!=OK)
      return(rc);

   return(OK);
}



#ifdef USEPROTOS
int input_border(void)
#else
int input_border()
#endif
{
#ifdef TURBOC
   setviewport(inview_left, inview_top,
               inview_right, inview_bottom, TRUE);
   if (graphresult()!=grOk)
      return(VINERR);

   linerel(inview_width, 0);
   linerel(0, inview_height);
   linerel(-inview_width, 0);
   linerel(0, -inview_height);

   setviewport(0, 0, maxx, maxy, TRUE);
   outtextxy(inview_left, inview_top-textheight(inputstr)-1, inputstr);
#endif

   return(OK);
}



#ifdef USEPROTOS
int output_border(void)
#else
int output_border()
#endif
{
#ifdef TURBOC
   setviewport(outview_left, outview_top,
               outview_right, outview_bottom, TRUE);
   if (graphresult()!=grOk)
      return(VOUTER);

   linerel(outview_width, 0);
   linerel(0, outview_height);
   linerel(-outview_width, 0);
   linerel(0, -outview_height);

   setviewport(0, 0, maxx, maxy, TRUE);
   outtextxy(outview_left, outview_top-textheight(outputstr)-1, outputstr);
#endif

   return(OK);
}



#ifdef USEPROTOS
int result_border(void)
#else
int result_border()
#endif
{
#ifdef TURBOC
   setviewport(resview_left, resview_top,
               resview_right, resview_bottom, TRUE);
   if (graphresult()!=grOk)
      return(VRESER);

   linerel(resview_width, 0);
   linerel(0, resview_height);
   linerel(-resview_width, 0);
   linerel(0, -resview_height);

   setviewport(0, 0, maxx, maxy, TRUE);
   outtextxy(resview_left, resview_top-textheight(resultstr)-1, resultstr);
#endif

   return(OK);
}



#ifdef USEPROTOS
int info_border(void)
#else
int info_border()
#endif
{
#ifdef TURBOC
   setviewport(infoview_left, infoview_top,
               infoview_right, infoview_bottom, TRUE);
   if (graphresult()!=grOk)
      return(VINFER);
   clearviewport();

   linerel(infoview_width, 0);
   linerel(0, infoview_height);
   linerel(-infoview_width, 0);
   linerel(0, -infoview_height);

   setviewport(0, 0, maxx, maxy, TRUE);
   outtextxy(infoview_left, infoview_top-textheight(infostr)-1, infostr);
#endif

   return(OK);
}



#ifdef USEPROTOS
void refresh_display(int pattern, int pair, boolean info)
#else
void refresh_display(pattern, pair, info)
        int pattern;
        int pair;
        boolean info;
#endif
{
boolean refresh;

   refresh=(!(learn & RANDOM) && pattern==(float)(step % (REFRESH*(nrpatterns==0 ? 1 : nrpatterns)))/REFRESH) ||
            ((learn & RANDOM) && (step % REFRESH)==0) || info;

   if (verbose==TRUE)
   {
      if (((refresh && !trace) || (trace && (pattern==0 || (learn & RANDOM)))) && step>0 && pair==0)
         printf("%s:  step = %3ld,  error = %7.4f\n", RNSNAME, step, total_error);
   }
   else
   {
      if (quiet==FALSE && (trace || refresh))
      {
#ifdef TURBOC
         if (!info)
         {
            if (inview_left || inview_top || inview_right || inview_bottom)
               display_input(pattern, pair);

            if (outview_left || outview_top || outview_right || outview_bottom)
               display_output(pattern, pair);

            if (resview_left || resview_top || resview_right || resview_bottom)
               display_result(pattern, pair);
         }

         if (((refresh && !trace) || (trace && pattern==0)) && step>0 && pair==0 &&
             (infoview_left || infoview_top || infoview_right || infoview_bottom))
            display_info();
#endif
      }
   }
}



#ifdef USEPROTOS
void verbose_display(int pattern, int pair, boolean info)
#else
void verbose_display(pattern, pair, info)
        int pattern;
        int pair;
        boolean info;
#endif
{
   if (verbose==TRUE)    /*  als verbose roep dan refresh_display aan  */
      refresh_display(pattern, pair, info);
}



#ifdef USEPROTOS
void display_input(int pattern, int pair)
#else
void display_input(pattern, pair)
        int pattern;
        int pair;
#endif
{
#ifdef TURBOC
int row, colom;
#endif

#ifdef TURBOC
   setviewport(inview_left+1, inview_top+1,
               inview_right-1, inview_bottom-1, TRUE);

   clearviewport();

   setviewport(inview_left, inview_top,
               inview_right, inview_bottom, TRUE);

   for (row=0; row<height_in; row++)
      for(colom=0; colom<width_in; colom++)
         draw_value(colom*inblock_width+INMARGIN,
                    row*inblock_height+INMARGIN,
                    inblock_width-INMARGIN,
                    inblock_height-INMARGIN,
                    pattern_val(pattern, pair, row*width_in+colom, INPUT),
                    TRUE);
#endif
}



#ifdef USEPROTOS
void display_output(int pattern, int pair)
#else
void display_output(pattern, pair)
        int pattern;
        int pair;
#endif
{
#ifdef TURBOC
int row, colom;
#endif

#ifdef TURBOC
   setviewport(outview_left+1, outview_top+1,
               outview_right-1, outview_bottom-1, TRUE);

   clearviewport();

   setviewport(outview_left, outview_top,
               outview_right, outview_bottom, TRUE);

   for (row=0; row<height_out; row++)
      for(colom=0; colom<width_out; colom++)
         draw_value(colom*outblock_width+OUTMARGIN,
                    row*outblock_height+OUTMARGIN,
                    outblock_width-OUTMARGIN,
                    outblock_height-OUTMARGIN,
                    pattern_val(pattern, pair, row*width_out+colom, OUTPUT),
                    TRUE);
#endif
}



#ifdef USEPROTOS
void display_result(int pattern, int pair)
#else
void display_result(pattern, pair)
        int pattern;
        int pair;
#endif
{
#ifdef TURBOC
int row, colom;
FLOAT value;
#endif

#ifdef TURBOC
   setviewport(resview_left+1, resview_top+1,
               resview_right-1, resview_bottom-1, TRUE);

   clearviewport();

   setviewport(resview_left, resview_top,
               resview_right, resview_bottom, TRUE);

   for (row=0; row<height_out; row++)
      for(colom=0; colom<width_out; colom++)
      {
         if (GETPATTERN(pattern)->result==NULL)
            value=OUTPUTNEURON(row*width_out+colom)->output;
         else                          /*  result is niet gealloceerd  */
            value=pattern_val(pattern, pair, row*width_out+colom, RESULT);
                                       /*  wel beschikbaar: vraag result op  */

         if (learn & CLIP424)
            value=value>0.2*MAXOUTPUT ? MAXOUTPUT
                     : (value<0.2*MINOUTPUT ? MINOUTPUT : UNDEFINED);
         else
            if (learn & CLIP262)
               value=value>0.6*MAXOUTPUT ? MAXOUTPUT
                        : (value<0.6*MINOUTPUT ? MINOUTPUT : UNDEFINED);

         draw_value(colom*resblock_width+RESMARGIN,
                    row*resblock_height+RESMARGIN,
                    resblock_width-RESMARGIN,
                    resblock_height-RESMARGIN,
                    value, FALSE);
      }
#endif
}



#ifdef USEPROTOS
void draw_value(float x, float y, float width, float height, FLOAT value, boolean undefined)
#else
void draw_value(x, y, width, height, value, undefined)
        float x;
        float y;
        float width;
        float height;
        FLOAT value;
        boolean undefined;
#endif
{
#ifdef TURBOC
float factor1, factor2;
int points[8];
#endif

#ifdef TURBOC
   if (undefined && value==DONTCARE)
      setfillstyle(CLOSE_DOT_FILL, maxcolor);
   else
      setfillstyle(SOLID_FILL, maxcolor);

   factor1=(MAXOUTPUT-value)/(2*MAXMINOUT);
   factor2=(MAXOUTPUT-2*MINOUTPUT+value)/(2*MAXMINOUT);

   points[0]=x+factor1*width+0.5;
   points[1]=y+factor1*height+0.5;
   points[2]=x+factor2*width+0.5;
   points[3]=y+factor1*height+0.5;
   points[4]=x+factor2*width+0.5;
   points[5]=y+factor2*height+0.5;
   points[6]=x+factor1*width+0.5;
   points[7]=y+factor2*height+0.5;

   fillpoly(4, points);
#endif
}



#ifdef USEPROTOS
void display_info(void)
#else
void display_info()
#endif
{
#ifdef TURBOC
int plotheight;
char errorstr[MAXSTR];
#endif

#ifdef TURBOC
   setviewport(infoview_left+1, infoview_top+1,
               infoview_right-1, infoview_top+INFOMARGIN-1, TRUE);

   clearviewport();

   setviewport(infoview_left, infoview_top,
               infoview_right, infoview_bottom, TRUE);

   sprintf(errorstr, "error: %7.4f", total_error);
   outtextxy(4, 2, errorstr);

   plotheight=PLOTHEIGHT(total_error);
   if (plotheight<INFOMARGIN+1)
      plotheight=INFOMARGIN+1;
   line(errorpos, plotheight, errorpos, infoview_height-INFOMARGIN-1);

   if (errorpos<infoview_width-INFOMARGIN-5)
      errorpos++;
   else
   {
      getimage(INFOMARGIN+2, INFOMARGIN+1,
               infoview_width-INFOMARGIN-4,
               infoview_height-INFOMARGIN-1, bitmap);
      putimage(INFOMARGIN+1, INFOMARGIN+1, bitmap, COPY_PUT);
   }
#endif
}



#ifdef USEPROTOS
void display_error(int pattern, int pair)
#else
void display_error(pattern, pair)
        int pattern;
        int pair;
#endif
{
#ifdef TURBOC
int plotheight;
char patstr[MAXSTR], errorstr[MAXSTR];
#endif

#ifdef TURBOC
   setviewport(infoview_left+1, infoview_top+1,
               infoview_right-1, infoview_top+INFOMARGIN-1, TRUE);

   clearviewport();

   /*  gebruik de viewport van info  */
   setviewport(infoview_left+INFOMARGIN+1, infoview_top+INFOMARGIN,
               infoview_right-INFOMARGIN, infoview_bottom-INFOMARGIN-1,
               TRUE);

   clearviewport();

   /*  maak gebied voor tekst schoon  */
   setviewport(infoview_left+1, infoview_bottom-INFOMARGIN+1,
               infoview_right-1, infoview_bottom-1, TRUE);

   clearviewport();

   setviewport(infoview_left, infoview_top,
               infoview_right, infoview_bottom, TRUE);

   /*  druk fout waarde van patroon af  */
   sprintf(errorstr, "error: %7.4f", GETPATTERN(pattern)->error);
   outtextxy(4, 2, errorstr);

   /*  trek een horizontale lijn voor globale fout  */
   plotheight=PLOTHEIGHT(total_error);
   line(INFOMARGIN, plotheight, infoview_width-INFOMARGIN, plotheight);

   /*  zet gestippelde stijl en teken lijn voor fout voor patroon  */
   setlinestyle(DOTTED_LINE, 0, NORM_WIDTH);
   plotheight=PLOTHEIGHT(GETPATTERN(pattern)->error);
   if (plotheight>INFOMARGIN)
      line(INFOMARGIN, plotheight, infoview_width-INFOMARGIN, plotheight);
   setlinestyle(SOLID_LINE, 0, NORM_WIDTH);

   /*  geef aan of dit een leer- of testpatroon betreft  */
   if (pattern>=nrpatterns)
      sprintf(patstr, "test (%d", pattern);
   else
      sprintf(patstr, "train (%d", pattern);

   /*  laat aanduiding van patroonpaar achterwege indien er slechts 1 is  */
   if (PAIRS(pattern)==1)
      sprintf(patstr+strlen(patstr), ";%6.4f)", GETPATTERN(pattern)->relative);
   else
      sprintf(patstr+strlen(patstr), ",%d;%6.4f)", pair, GETPATTERN(pattern)->relative);

   outtextxy((infoview_width-textwidth(patstr))/2,
              infoview_height-textheight(patstr)-2, patstr);
#endif
}



#ifdef USEPROTOS
int close_screen(void)
#else
int close_screen()
#endif
{
int rc = OK;

#ifdef TURBOC
int loop;
#endif


   if (verbose==FALSE && quiet==FALSE)
   {
#ifdef TURBOC
      free(bitmap);

      nosound();
      sound(1000);
      delay(10);
      nosound();

      while (kbhit())                  /*  maak buffer voor toetsen leeg  */
         getch();

      if (batch==FALSE)
      {
         for (loop=0; loop<1000; loop++)
         {
            delay(10);          /*  wacht 10 seconden opdat scherm    */
            if (kbhit())        /*  niet direkt weer verstoord wordt  */
            {                   /*  1000 * 10 milliseconden           */
               getch();         /*  maar stop als toets ingedrukt is  */
               break;           /*  en lees toets in                  */
            }
         }

         if (kbhit())           /*  behandel laatste teken 'extended keys'  */
            getch();
      }
#endif
   }

   if ((rc=log_end())!=OK)
      return(rc);

   return(OK);
}



#ifdef USEPROTOS
void close_graphics(void)
#else
void close_graphics()
#endif
{
   if (quiet)
      return;

#ifdef TURBOC
   closegraph();

   restorecrtmode();
#endif
}
