/*  $Id: rnsinit.c,v 1.17 1991/10/10 16:45:32 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsinit.c,v $
 * Revision 1.17  1991/10/10  16:45:32  richard
 * Switched to UNIX RCS
 *
 * Revision 1.16  91/05/09  14:41:16  ROOT_DOS
 * Added control-c error message
 *
 * Revision 1.15  91/03/24  16:02:51  ROOT_DOS
 * Added messages for dead-end connections
 * Added messages for DONTCARE command
 *
 * Revision 1.14  91/02/26  21:49:59  ROOT_DOS
 * Added comments
 * Added support for SEED command
 *
 * Revision 1.13  91/02/17  14:28:35  ROOT_DOS
 * Minor changes
 *
 * Revision 1.12  91/02/07  21:37:43  ROOT_DOS
 * Added initialization of globals
 *
 * Revision 1.11  91/02/05  21:52:44  ROOT_DOS
 * Added MAXSTEP command and error codes
 *
 * Revision 1.10  91/02/05  01:28:25  ROOT_DOS
 * Added error message concerning bad constraints
 *
 * Revision 1.9  91/01/30  21:44:23  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.8  91/01/27  21:03:05  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.7  91/01/22  16:54:32  ROOT_DOS
 * Made ITER command conditional compilable
 *
 * Revision 1.6  91/01/19  22:25:40  ROOT_DOS
 * Added error codes and initialization commands
 *
 * Revision 1.5  91/01/03  14:44:54  ROOT_DOS
 * Added initialization of random seed
 * Added initialization for simulated annealing variables
 *
 * Revision 1.4  90/12/18  22:25:45  ROOT_DOS
 * Added error message for ALPHA command
 *
 * Revision 1.3  90/12/12  20:50:24  ROOT_DOS
 * Added error message for missing learning mode
 *
 * Revision 1.2  90/12/08  03:51:04  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:15:51  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het initialiseren van variabelen  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"

#include "rnstty.h"


#ifdef TURBOC
#include <signal.h>
#include <stdlib.h>
#else
#include <signal.h>
#include <stdlib.h>
#endif



#ifdef USEPROTOS
int init(void)
#else
int init()
#endif
{
#ifdef SHOWERRS
int index;
#endif

#ifdef UNIX
int rc;
#endif

   /*  vul alle foutboodschappen in  */
   errstr[OK] = "OK";
   errstr[CTLBRK] = "Control-C was hit";
   errstr[CLOSIN] = "Error closing input file";
   errstr[CLSOUT] = "Error closing output file";
   errstr[CLSLOG] = "Error closing log file";
   errstr[CLSLRN] = "Error closing learn pattern file";
   errstr[CLSTST] = "Error closing test pattern file";
   errstr[CLSPLL] = "Error closing learn plot file";
   errstr[CLSPLT] = "Error closing test plot file";
#ifdef TURBOC
   errstr[CLSALL] = "Error closing all files";
#endif
   errstr[CNTPLT] = "Can't make anything useful out of the plot info";
#ifdef UNIX
   errstr[GETTTY] = "Can't get terminal mode";
   errstr[CKDTTY] = "Can't set cooked terminal mode";
   errstr[RAWTTY] = "Can't set raw terminal mode";
#endif
   errstr[FLSEQU] = "Conflicting file names";
   errstr[NONAME] = "No filename specified";
   errstr[NOINDF] = "No input neurons specified";
   errstr[NOUTDF] = "No output neurons specified";
   errstr[NORATE] = "No learning rate specified";
   errstr[NOPATD] = "No patterns specified";
   errstr[NOLRNM] = "No learning mode specified";
   errstr[NOHTOV] = "Random bit pattern can't be found in internal tables";
   errstr[NACCIN] = "Can't read from input file";
   errstr[NACOUT] = "Can't write to output file";
   errstr[NACLOG] = "Can't write to log file";
   errstr[NACLRN] = "Can't write to learn pattern file";
   errstr[NACTST] = "Can't write to test pattern file";
   errstr[NACPLL] = "Can't write to learn plot file";
   errstr[NACPLT] = "Can't write to test plot file";
   errstr[START_INPUT_ERROR] = "Start of input error specifications";
   errstr[BADADA] = "Bad parameter value in ADJUST command; should be ALL or RECURRENT";
   errstr[BADADG] = "Bad parameter value in ADJUST command; should be LOCAL or GLOBAL";
   errstr[BADADR] = "Bad ADDRATE value";
   errstr[BADCAR] = "Bad DONTCARE value";
   errstr[BADCNS] = "Bad constraint(s)";
   errstr[BADDMM] = "Bad DMOMENTUM value";
   errstr[BADEPS] = "Bad RATE value specified";
   errstr[BADERR] = "Bad ERROR value specified";
   errstr[BADFGT] = "Bad FORGET value";
#ifndef NOITER
   errstr[BADITR] = "Bad ITER value specified";
#endif
   errstr[BADLRN] = "Bad LEARN mode specified";
   errstr[BADMAX] = "Bad MAXWEIGHT value specified";
   errstr[BADMLR] = "Bad MULRATE value specified";
   errstr[BADMOM] = "Bad MOMENTUM value specified";
   errstr[BADPAT] = "Bad pattern information";
   errstr[BADPSE] = "Bad pattern select error";
   errstr[BADPSS] = "Bad pattern select number of steps";
   errstr[BADREL] = "Bad RELATIVE value specified";
   errstr[BADSTP] = "Bad MAXSTEP value specified";
   errstr[BADSED] = "Bad SEED value specified";
   errstr[BADBIN] = "Bad bottom coordinate of input window";
   errstr[BDBINF] = "Bad bottom coordinate of information window";
   errstr[BDBOUT] = "Bad bottom coordinate of output window";
   errstr[BDBRES] = "Bad bottom coordinate of result window";
   errstr[BADLIN] = "Bad left coordinate of input window";
   errstr[BDLINF] = "Bad left coordinate of information window";
   errstr[BDLOUT] = "Bad left coordinate of output window";
   errstr[BDLRES] = "Bad left coordinate of result window";
   errstr[BADRIN] = "Bad right coordinate of input window";
   errstr[BDRINF] = "Bad right coordinate of information window";
   errstr[BDROUT] = "Bad right coordinate of output window";
   errstr[BDRRES] = "Bad right coordinate of result window";
   errstr[BADTIN] = "Bad top coordinate of input window";
   errstr[BDTINF] = "Bad top coordinate of information window";
   errstr[BDTOUT] = "Bad top coordinate of output window";
   errstr[BDTRES] = "Bad top coordinate of result window";
   errstr[BADTOL] = "Bad TOLERANCE value specified";
   errstr[BADDCY] = "Bad UPDATE value specified";
   errstr[BITLNG] = "Bit pattern is too long to fit in a random bit pattern";
   errstr[CMEXPD] = "Comma expected";
   errstr[CNEXPD] = "Colon expected";
   errstr[CNTADD] = "Can't add neuron: memory full";
   errstr[CNTCON] = "Can't connect the neurons: memory full";
   errstr[CNTPAT] = "Can't add pattern: memory full";
   errstr[DBLDEF] = "Neuron already defined as INPUT or OUTPUT";
   errstr[DSTLRG] = "Hamming distance too large";
   errstr[EADINF] = "Expected ADJUST information";
   errstr[EARINF] = "Expected ADDRATE information";
   errstr[EDINFO] = "Expected DISPLAY information";
   errstr[EDMINF] = "Expected DMOMENTUM information";
   errstr[EEINFO] = "Expected ERROR information";
   errstr[EFGINF] = "Expected FORGET information";
#ifndef NOITER
   errstr[EIINFO] = "Expected ITER information";
#endif
   errstr[ELINFO] = "Expected LEARN information";
   errstr[EMINFO] = "Expected MOMENTUM information";
   errstr[EMRINF] = "Expected MULRATE information";
   errstr[EMWINF] = "Expected MAXWEIGHT information";
   errstr[ENINFO] = "Expected neuron information";
   errstr[EOINFO] = "Expected DONTCARE information";
   errstr[EPINFO] = "Expected PATTERN information";
   errstr[EWINFO] = "Expected weight information";
   errstr[ECINFO] = "Expected UPDATE information";
   errstr[EAINFO] = "Expected RATE information";
   errstr[ESINFO] = "Expected MAXSTEP information";
   errstr[ERINFO] = "Expected SEED information";
   errstr[ETINFO] = "Expected PSELECT information";
   errstr[ETLINF] = "Expected TOLERANCE information";
   errstr[FLTRNG] = "Floating point value is out of range";
   errstr[IALRDY] = "Input neuron already defined";
   errstr[INVNUM] = "Invalid neuron number";
   errstr[INVWDT] = "Invalid width";
   errstr[INVHGT] = "Invalid height";
   errstr[MIEXPD] = "Expected minus sign";
   errstr[NEQINP] = "Number of inputs doesn't match input pattern size";
   errstr[NEQOUT] = "Number of outputs doesn't match output pattern size";
   errstr[NOFUNC] = "No function specified";
   errstr[NUMLNG] = "Number doesn't fit in specified number of bits";
   errstr[OALRDY] = "Output neuron already defined";
   errstr[PATLNG] = "Pattern is too long";
   errstr[SCEXPD] = "Semi-colon expected";
   errstr[SETSET] = "Already in SET definition";
   errstr[STRLNG] = "String too long";
   errstr[TESTST] = "Already in TEST definition";
   errstr[TMBITS] = "Too many bits per character";
   errstr[UNFUNC] = "Unknown function";
   errstr[UNKNWN] = "Unknown command";
   errstr[VTHADD] = "Can't add random bit pattern to internal tables";
   errstr[VTHEXP] = "Can't expand internal random bit pattern table";
   errstr[VTHINI] = "Can't initialize internal random bit pattern table";
   errstr[VTHMXR] = "Failed to generate a suitable random bit pattern";
   errstr[END_INPUT_ERROR] = "End of input error specifications";
#ifdef TURBOC
   errstr[CNTBGI] = "Can't register BGI driver";
   errstr[INFLTL] = "Information window is too little";
   errstr[INFSML] = "Information window is too narrow";
   errstr[INLTTL] = "Input window is too little";
   errstr[INSMAL] = "Input window is too narrow";
   errstr[OUTLTL] = "Output window is too little";
   errstr[OUTSML] = "Output window is too narrow";
   errstr[RESLTL] = "Result window is too little";
   errstr[RESSML] = "Result window is too narrow";
#endif
   errstr[MEMFUL] = "Memory full";
   errstr[MEMPLT] = "Memory full during plotting";
   errstr[MISEND] = "END missing in pattern file";
   errstr[NOTDIR] = "Error reading directory";
   errstr[INTOOL] = "Input filename is too long";
   errstr[OPENIN] = "Error opening input file";
   errstr[OUTOOL] = "Output filename is too long";
   errstr[OPNOUT] = "Error opening output file";
   errstr[LGTOOL] = "Log filename is too long";
   errstr[OPNLOG] = "Error opening log file";
   errstr[OPNLRN] = "Error opening learn pattern file";
   errstr[OPNTST] = "Error opening test pattern file";
   errstr[OPNPLL] = "Error opening learn plot file";
   errstr[OPNPLT] = "Error opening test plot file";
   errstr[UNKARG] = "Unknown argument on command-line";
   errstr[INPREQ] = "Input filename required";
   errstr[STMTCH] = "Set definition in pattern file doesn't match internal tables";
   errstr[TOOMNY] = "Too many filenames on command-line";
#ifdef TURBOC
   errstr[VINERR] = "Error displaying input window";
   errstr[VINFER] = "Error displaying information window";
   errstr[VOUTER] = "Error displaying output window";
   errstr[VRESER] = "Error displaying result window";
#endif
   errstr[UNTYPE] = "Neuron(s) without type definition detected";
   errstr[UNCONN] = "Unconnected neuron(s) detected";
   errstr[UNDEFN] = "Neuron(s) without function definition detected";

#ifdef SHOWERRS
   for (index=0; index<MAXERR; index++)
      printf("%s\n", errstr[index]);
#endif

   signal(SIGINT, ctrlbrk_handler);    /*  installeer cntrl-c handler      */
   signal(SIGTERM, ctrlbrk_handler);   /*  installeer termination handler  */


   /*  default start waarden voor verschillende variabelen  */

   input_name[0]='\0';
   output_name[0]='\0';
   log_name[0]='\0';
   learn_name[0]='\0';
   test_name[0]='\0';
   pll_name[0]='\0';
   plt_name[0]='\0';

   input_row=0;
   input_colom=0;
   input_line[0]='\0';
   input_word[0]='\0';

   nrneurons=0;
   neuronlist=NULL;

   nrinputs=0;
   inputlistptr=NULL;

   nroutputs=0;
   outputlistptr=0;

   epsilon=0;
   momentum=0;
   dmomentum=0;
   decay=0;
   addrate=0;
   mulrate=0;
   forget=0;

   lim_step=0;
   max_iter=0;

   seed=0;

   dontcare=0;

   pselect_adapt=FALSE;
   pselect_error=0;
   pselect_steps=0;

   learn=LEARN;

   error=0;

   tolerance=0;

   maxweight=MAXWEIGHT;

   adjust_net=ADJUST_RECURRENT;
   adjust_mode=ADJUST_LOCAL;

   left_in=top_in=right_in=bottom_in=0;
   left_out=top_out=right_out=bottom_out=0;
   left_res=top_res=right_res=bottom_res=0;
   left_info=top_info=right_info=bottom_info=0;

   inputstr[0]='\0';
   outputstr[0]='\0';
   resultstr[0]='\0';
   infostr[0]='\0';

#ifdef TURBOC
   errorpos=0;

   bitmap=NULL;
#endif

   nrpatterns=0;
   nrtests=0;

   patternlistptr=NULL;

   input_pattern=NULL;
   output_pattern=NULL;

   /*  default mode van RNS  */
#ifdef TURBOC
   batch=FALSE;
   trace=FALSE;
   quiet=FALSE;
   verbose=FALSE;
   logging=FALSE;
   plot=FALSE;
#else
   batch=TRUE;
   trace=FALSE;
   quiet=TRUE;
   verbose=FALSE;
   logging=FALSE;
   plot=FALSE;
#endif

   chance=1;                           /*  startwaarde voor acceptatie kans bij SA  */


   /*  hier zijn we er van afhankelijk dat de compiler globale variabelen  */
   /*  op 0 initialiseert, nl. omdat als de variabele foutfuncties nog     */
   /*  niet zijn ingevuld dan worden ze ingevuld met de default waarden    */
   if (errorfp==NULL)
   {
      errorfp=default_errorf;          /*  initialiseer fout functies met  */
      erroropt=NULL;                   /*  default functie definities      */
   }

   if (derrorfp==NULL)
   {
      derrorfp=default_derrorf;        /*  initialiseer fout functies met  */
      derroropt=NULL;                  /*  default functie definities      */
   }


   orig_input=NULL;
   trans_input=NULL;
   orig_output=NULL;
   trans_output=NULL;
   plot_line=NULL;


#ifdef UNIX
   if ((rc=tty_raw())!=OK)             /*  zet de terminal in raw mode  */
      return(rc);
#endif


   return(OK);
}
