/*  $Id$  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log$  */



/*  functies voor het opbouwen van plot files  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"

#include "rnsalloc.h"


#ifdef TURBOC
#include <alloc.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#else
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#endif



#ifdef USEPROTOS
int build_plot(void)
#else
int build_plot()
#endif
{
int rc;
char type;
int pattern, pair, nrpairs, output;
float relative;
boolean set;
FILE *pattern_file, *plot_file;

   if (plot)
   {
      if ((learn_file=fopen(learn_name, LEARNMODE2))==NULL)
         return(OPNLRN);

      if ((test_file=fopen(test_name, TESTMODE2))==NULL)
         return(OPNTST);

      if ((pll_file=fopen(pll_name, PLLMODE))==NULL)
         return(OPNPLL);

      if ((plt_file=fopen(plt_name, PLTMODE))==NULL)
         return(OPNPLT);

      if ((orig_input=(char *)malloc(MAXPATLEN+1))==NULL ||
          (trans_input=(char *)malloc(MAXPATLEN+1))==NULL ||
          (orig_output=(char *)malloc(MAXPATLEN+1))==NULL ||
          (trans_output=(char *)malloc(MAXPATLEN+1))==NULL ||
          (plot_line=(char *)malloc(4*MAXPATLEN+1))==NULL)
         return(MEMPLT);

      pattern_file=learn_file;
      plot_file=pll_file;

      for (pattern=0; pattern<nrpatterns+nrtests; pattern++)
      {
         if (pattern==nrpatterns)
         {
            pattern_file=test_file;
            plot_file=plt_file;
         }

         read_line(pattern_file);

         relative=1;
         sscanf(input_line, "RELATIVE: %f", &relative);

         read_line(pattern_file);

         type=BIT;
         if (strncmp(input_line, "BIT:", 4)==0)
            type=BIT;
         else
          if (strncmp(input_line, "REAL:", 5)==0)
             type=REAL;

         read_line(pattern_file);

         set=FALSE;
         if (strncmp(input_line, "SET:", 4)==0)
         {
            set=TRUE;
            read_line(pattern_file);
         }

         nrpairs=GETPATTERN(pattern)->nrpairs;
         if ((set==FALSE && nrpairs>1) ||
             (set==TRUE && nrpairs<2))
            return(STMTCH);

         if (set==TRUE)
            fprintf(plot_file, "# Pattern Set %d\n",
                       (pattern>=nrpatterns ? pattern-nrpatterns+1 : pattern+1));
         else
            fprintf(plot_file, "# Pattern %d\n",
                       (pattern>=nrpatterns ? pattern-nrpatterns+1 : pattern+1));

         for (pair=0; pair<nrpairs; pair++)
         {
            strcpy(orig_input, input_line);

#ifdef DEBUG
            printf("%s\n", orig_input);
#endif

            read_line(pattern_file);   /*  lees getransformeerde input  */
            strcpy(trans_input, input_line);

#ifdef DEBUG
            printf("%s\n", trans_input);
#endif

            read_line(pattern_file);   /*  lees originele output  */
            strcpy(orig_output, input_line);

#ifdef DEBUG
            printf("%s\n", orig_output);
#endif

            read_line(pattern_file);   /*  lees getransformeerde output  */
            strcpy(trans_output, input_line);

#ifdef DEBUG
            printf("%s\n", trans_output);
#endif

            switch (type)
            {
            case BIT:
               if ((rc=convert_to_plot(orig_input, plot_line))!=OK)
                  return(rc);
               fprintf(plot_file, "%s\n", plot_line);

#ifdef DEBUG
               printf("%s\n%s\n\n", orig_input, plot_line);
#endif

               if ((rc=convert_to_plot(orig_output, plot_line))!=OK)
                  return(rc);
               fprintf(plot_file, "%s\n", plot_line);

#ifdef DEBUG
               printf("%s\n%s\n\n", orig_output, plot_line);
#endif

               if ((rc=convert_to_results(pattern, pair,
                             orig_output, plot_line))!=OK)
                  return(rc);
               fprintf(plot_file, "%s\n", plot_line);

#ifdef DEBUG
               printf("%s\n%s\n%s\n\n", orig_output, trans_output, plot_line);
#endif

               break;
            case REAL:
               /*  kopieer patronen en resultaat gewoon naar plot file  */
               fprintf(plot_file, "%s\n", orig_input);
               fprintf(plot_file, "%s\n", orig_output);

               for (output=0; output<nroutputs; output++)
                  fprintf(plot_file, "%7.4f ",
                          (pattern_val(pattern, pair, output, RESULT)-MINOUTPUT)/MAXMINOUT);

               fprintf(plot_file, "\n");
               break;
            }

            if (set==TRUE)
               read_line(pattern_file);
         }

         if (set==TRUE && strncmp(input_line, "END;", 4)!=0)
               return(MISEND);

         fprintf(plot_file, "\n");
      }

      FREE(orig_input);
      FREE(trans_input);
      FREE(orig_output);
      FREE(trans_output);
      FREE(plot_line);

      if (fclose(pll_file)==EOF)
         return(CLSPLL);

      if (fclose(plt_file)==EOF)
         return(CLSPLT);

      if (fclose(learn_file)==EOF)
         return(CLSLRN);

      if (fclose(test_file)==EOF)
         return(CLSTST);
   }

   return(OK);
}



#ifdef USEPROTOS
int convert_to_plot(char *origpat, char *plotpat)
#else
int convert_to_plot(origpat, plotpat)
       char *origpat;
       char *plotpat;
#endif
{
char mode;
int nrbits, distance;

   while (*origpat!='\0')
   {
      distance=1;

      if (sscanf(origpat, "ALPHA: %d", &nrbits)==1)
         mode=ALPHA;
      else
       if (sscanf(origpat, "NUMBER: %d", &nrbits)==1)
          mode=NUMBER;
       else
        if (sscanf(origpat, "ATOH: %d %d", &nrbits, &distance)==2)
           mode=ATOH;
        else
         if (sscanf(origpat, "BTOH: %d %d", &nrbits, &distance)==2)
            mode=BTOH;
         else
          if (sscanf(origpat, "FTOH: %d %d", &nrbits, &distance)==2)
             mode=FTOH;
          else
           if (sscanf(origpat, "NTOH: %d %d", &nrbits, &distance)==2)
              mode=NTOH;
           else
              mode=NONE;

      if (mode!=NONE)    /*  sla mode directive en bit aantal over  */
      {
         while (!isspace(*origpat))
            origpat++;
         while (isspace(*origpat))
            origpat++;   /*  sla whitespace over  */

         while (!isspace(*origpat))
            origpat++;
         while (isspace(*origpat))
            origpat++;   /*  sla whitespace over  */
      }

      if (mode!=ALPHA && mode!=NUMBER && mode!=NONE)
      {                  /*  sla Hamming distance over  */
         while (!isspace(*origpat))
            origpat++;
         while (isspace(*origpat))
            origpat++;   /*  sla whitespace over  */
      }

      if (mode==NONE || mode==BTOH)
      {
         while (*origpat!='\0' && !isspace(*origpat))
         {
            sprintf(plotpat, "%7.4f ", (*origpat=='X' ? 1.0 : 0.0));
            plotpat+=strlen(plotpat);
            origpat++;
         }
      }
      else
      {
         if (mode==ALPHA || mode==ATOH)
            *plotpat++=*origpat++;     /*  kopieer aanhalingsteken  */

         while (*origpat!='\0' && (((mode!=ALPHA && mode!=ATOH) && !isspace(*origpat)) ||
                                   ((mode==ALPHA || mode==ATOH) && *origpat!='"')))
            *plotpat++=*origpat++;

         if (mode==ALPHA || mode==ATOH)
            *plotpat++=*origpat++;     /*  kopieer aanhalingsteken  */

         *plotpat++=' ';
      }

      while (*origpat!='\0' && isspace(*origpat))
         origpat++;      /*  sla whitespace over  */
   }

   *plotpat='\0';

   return(OK);
}



#ifdef USEPROTOS
int convert_to_results(int pattern, int pair,
                       char *origpat, char *plotpat)
#else
int convert_to_results(pattern, pair, origpat, plotpat)
       int pattern;
       int pair;
       char *origpat;
       char *plotpat;
#endif
{
char mode;
int bit, output, bitlen;
int nrbits, distance, hdist;
unsigned long mask;
unsigned long resval, hval;
boolean undefined;
FLOAT bitval;

   output=0;

   while (*origpat!='\0')
   {
      distance=1;

      if (sscanf(origpat, "ALPHA: %d", &nrbits)==1)
         mode=ALPHA;
      else
       if (sscanf(origpat, "NUMBER: %d", &nrbits)==1)
          mode=NUMBER;
       else
        if (sscanf(origpat, "ATOH: %d %d", &nrbits, &distance)==2)
           mode=ATOH;
        else
         if (sscanf(origpat, "BTOH: %d %d", &nrbits, &distance)==2)
            mode=BTOH;
         else
          if (sscanf(origpat, "FTOH: %d %d", &nrbits, &distance)==2)
             mode=FTOH;
          else
           if (sscanf(origpat, "NTOH: %d %d", &nrbits, &distance)==2)
              mode=NTOH;
           else
              mode=NONE;

      if (mode!=NONE)    /*  sla mode directive en bit aantal over  */
      {
         while (!isspace(*origpat))
            origpat++;
         while (isspace(*origpat))
            origpat++;   /*  sla whitespace over  */

         while (!isspace(*origpat))
            origpat++;
         while (isspace(*origpat))
            origpat++;   /*  sla whitespace over  */
      }

      if (mode!=ALPHA && mode!=NUMBER && mode!=NONE)
      {                  /*  sla Hamming distance over  */
         while (!isspace(*origpat))
            origpat++;
         while (isspace(*origpat))
            origpat++;   /*  sla whitespace over  */
      }

      if (mode==NONE)
      {
         while (*origpat!='\0' && !isspace(*origpat))
         {
            sprintf(plotpat, "%7.4f ", (pattern_val(pattern, pair, output++, RESULT)-MINOUTPUT)/MAXMINOUT);

            plotpat+=strlen(plotpat);

            origpat++;
         }
      }
      else
      {
         if (mode==ALPHA || mode==ATOH)
            origpat++;   /*  sla aanhalingsteken over  */

         do
         {
            resval=0;
            undefined=FALSE;

            for (bit=0; bit<nrbits && undefined==FALSE; bit++)
               if ((bitval=clip_value(pattern_val(pattern, pair,
                                            output+bit, RESULT)))==UNDEFINED)
                  undefined=TRUE;
               else
                  resval=(resval<<1)+(bitval==MAXOUTPUT ? 1 : 0);

            output+=nrbits;

            if (undefined==FALSE && (mode==ALPHA || mode==NUMBER || (h_to_value(resval, nrbits, distance, &hval, &hdist)==OK && hdist<(distance+1)/2)))
            {
               switch (mode)
               {
               case ALPHA:
                  hval=resval;
               case ATOH:
                  sprintf(plotpat, "%c", hval);
                  plotpat++;
                  break;
               case NUMBER:
                  hval=resval;
               case NTOH:
                  sprintf(plotpat, "%d ", hval);
                  plotpat+=strlen(plotpat);
                  break;
               case BTOH:
                  bitlen=strspn(origpat, "-X");
                  mask=pow(2.0, (double) bitlen-1);
                  for (bit=0; bit<bitlen; bit++)
                  {
                     if (hval & mask)
                        sprintf(plotpat, "%7.4f ", 1.0);
                     else
                        sprintf(plotpat, "%7.4f ", 0.0);
                     plotpat+=strlen(plotpat);
                     mask>>=1;
                  }
                  break;
               case FTOH:
                  sprintf(plotpat, "%7.4f ", (float) hval/(pow(2.0, (double) nrbits-distance+1)-1));
                  plotpat+=strlen(plotpat);
                  break;
               }
            }
            else
            {
               switch (mode)
               {
               case ALPHA:
               case ATOH:
                  sprintf(plotpat,"*");
                  plotpat++;
                  break;
               case NUMBER:
               case NTOH:
                  sprintf(plotpat, "%7.4f ", -1.0);
                  plotpat+=strlen(plotpat);
                  break;
               case BTOH:
                  bitlen=strspn(origpat, "-X");
                  for (bit=0; bit<bitlen; bit++)
                  {
                     sprintf(plotpat, "%7.4f ", -1.0);
                     plotpat+=strlen(plotpat);
                  }
                  break;
               case FTOH:
                  sprintf(plotpat, "%7.4f ", -1.0);
                  plotpat+=strlen(plotpat);
                  break;
               }
            }

            switch (mode)
            {
            case ALPHA:
            case ATOH:
               origpat++;
               break;
            case NUMBER:
            case BTOH:
            case FTOH:
            case NTOH:
               while (*origpat!='\0' && !isspace(*origpat))
                  origpat++;
               break;
            }

         } while ((mode==ALPHA || mode==ATOH) && *origpat!='"');

         if (mode==ALPHA || mode==ATOH)
         {
            origpat++;   /*  sla aanhalingstekens over  */
            *plotpat++=' ';
         }
      }

      while (*origpat!='\0' && isspace(*origpat))
         origpat++;      /*  sla whitespace over  */
   }

   *plotpat='\0';

   return(OK);
}
