/*  $Id: rnsshow.c,v 1.10 1991/10/10 16:46:29 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsshow.c,v $
 * Revision 1.10  1991/10/10  16:46:29  richard
 * Switched to UNIX RCS
 *
 * Revision 1.9  91/03/24  16:06:55  ROOT_DOS
 * Moved 'display_error()' out to RNSGRAPH.C
 * 
 * Revision 1.8  91/02/26  21:50:39  ROOT_DOS
 * Added comments
 *
 * Revision 1.7  91/02/17  14:29:19  ROOT_DOS
 * Minor changes
 *
 * Revision 1.6  91/01/30  21:44:48  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.5  91/01/27  21:04:12  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.4  91/01/20  00:47:48  ROOT_DOS
 * Moved display_error from RNSGRAPH.C into this source file
 * Added display of pattern error value during showing
 *
 * Revision 1.3  90/12/12  20:45:25  ROOT_DOS
 * Changed display_error call
 *
 * Revision 1.2  90/12/08  03:51:31  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:17:08  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het tonen van de resultaten op het scherm  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <conio.h>
#include <ctype.h>
#include <graphics.h>
#include <string.h>
#else
#include <ctype.h>
#include <string.h>
#endif



#ifdef USEPROTOS
int show_results(void)
#else
int show_results()
#endif
{
int rc = OK;

#ifdef TURBOC
int pattern, pair;
char key;
#endif


   if (batch)                   /*  sla dit over als batch mode  */
      return(OK);

#ifdef TURBOC
   max_error=total_error!=0 ? 1.2*total_error : 1.2*error;
                                /*  maximale fout wordt veranderd om   */
                                /*  de plots in info window anders te  */
                                /*  schalen voor weergave rel. fouten  */
                                /*  zie display_error & PLOTHEIGHT     */

   if (inview_left || inview_top || inview_right || inview_bottom)
      if ((rc=input_border())!=OK)     /*  teken input window border  */
         return(rc);

   if (outview_left || outview_top || outview_right || outview_bottom)
      if ((rc=output_border())!=OK)    /*  teken output window border  */
         return(rc);

   if (resview_left || resview_top || resview_right || resview_bottom)
      if ((rc=result_border())!=OK)    /*  teken result window border  */
         return(rc);

   /*  toon fout van patronen in zelfde viewport als info  */
   if (infoview_left || infoview_top || infoview_right || infoview_bottom)
   {
      if ((rc=info_border())!=OK)      /*  teken info window border  */
         return(rc);

      setviewport(infoview_left, infoview_top,
                  infoview_right, infoview_bottom, TRUE);

      /*  teken de assen  */
      line(INFOMARGIN, INFOMARGIN, INFOMARGIN, infoview_height-INFOMARGIN);
      line(INFOMARGIN/2, infoview_height-INFOMARGIN,
           infoview_width-INFOMARGIN/2, infoview_height-INFOMARGIN);

      outtextxy(4, 2, "error");

      /*  teken de pijl  */
      line(INFOMARGIN/2, INFOMARGIN+1, INFOMARGIN/2, INFOMARGIN+21);
      line(INFOMARGIN/2-1, INFOMARGIN+2, INFOMARGIN/2+1, INFOMARGIN+2);
      line(INFOMARGIN/2-2, INFOMARGIN+3, INFOMARGIN/2+2, INFOMARGIN+3);
   }


   pattern=0;
   pair=0;

   do
   {
      /*  reken het netwerk opnieuw door als result niet bewaard is  */
      if (GETPATTERN(pattern)->result==NULL)
      {                                /*  result is niet gealloceerd  */
         reset_activations(pattern, pair, OUT|RESULT);
         while (calc_output(pattern, pair)==FALSE)
            ;
      }

      calc_delay();             /*  update vorige outputs  */


      if (inview_left || inview_top || inview_right || inview_bottom)
         display_input(pattern, pair);

      if (outview_left || outview_top || outview_right || outview_bottom)
         display_output(pattern, pair);

      if (resview_left || resview_top || resview_right || resview_bottom)
         display_result(pattern, pair);

      /*  toon fout van patronen in zelfde viewport als info  */
      if (infoview_left || infoview_top || infoview_right || infoview_bottom)
         display_error(pattern, pair);        /*  zet er nu foutlijnen in  */


      do
      {
         key=getch();           /*  wacht op toets  */

         if (key==0)            /*  pijltjes, PgUp, PgDn etc.  */
         {
            key=getch();        /*  haal volgende code op  */

            switch (key)
            {
               case DOWN:
               case LEFT:
                  key='P';      /*  vorige patroon  */
                  break;
               case UP:
               case RIGHT:
                  key='N';      /*  volgende patroon  */
                  break;
               case HOME:
                  key='F';      /*  eerste patroon  */
                  break;
               case END:
                  key='L';      /*  laatste patroon  */
                  break;
               case PGUP:
                  key='U';      /*  10% van patronen verder  */
                  break;
               case PGDN:
                  key='D';      /*  10% van patronen terug  */
                  break;
               default:
                  key='K';      /*  onbekende toets  */
                  break;
            }
         }
         else
            if (key==ESC)
               key='S';         /*  ESC is hetzelfde als 'S', stoppen  */
            else
               key=isupper(key) ? key : toupper(key);
                                /*  maak hoofdletter van toets  */

         switch (key)
         {
            case 'N':
               pattern++;
               pair=0;
               break;
            case 'P':
               pattern--;
               pair=0;
               break;
            case 'F':
               pattern=0;
               pair=0;
               break;
            case 'L':
               pattern=nrpatterns+nrtests-1;
               pair=0;
               break;
            case 'U':
               pattern+=(nrpatterns+nrtests)/10;
               pair=0;
               break;
            case 'D':
               pattern-=(nrpatterns+nrtests)/10;
               pair=0;
               break;
            case '+':           /*  volgende patroonpaar  */
               pair++;
               break;
            case '-':           /*  vorige patroonpaar  */
               pair=0;
               break;
            case 'S':           /*  stoppen  */
               break;
            default:
               key='K';
               break;
         }

         /*  niet voorbij eerste of laatste patroon  */
         if (pattern<0)
            pattern=0;
         else
            if (pattern>=nrpatterns+nrtests)
               pattern=nrpatterns+nrtests-1;

         /*  niet voorbij laatste patroonpaar  */
         if (pair>=PAIRS(pattern))
         {
            pair=PAIRS(pattern)-1;
            key='K';
         }

      } while (key=='K');

   } while (key!='S');
#endif

   return(OK);
}
