/*  $Id: rnstests.c,v 1.9 1991/10/10 16:46:34 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnstests.c,v $
 * Revision 1.9  1991/10/10  16:46:34  richard
 * Switched to UNIX RCS
 *
 * Revision 1.8  91/02/26  21:50:47  ROOT_DOS
 * Added comments
 * 
 * Revision 1.7  91/02/17  14:29:24  ROOT_DOS
 * Minor changes
 *
 * Revision 1.6  91/01/30  21:44:54  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.5  91/01/27  21:04:24  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.4  91/01/19  22:26:52  ROOT_DOS
 * Took changes in other modules into account
 *
 * Revision 1.3  91/01/03  14:46:32  ROOT_DOS
 * Imported set_pattern_result from rnscalc.c
 *
 * Revision 1.2  90/12/08  03:51:38  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:18:29  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het doen van testen op alle patronen  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <alloc.h>
#include <graphics.h>
#else
#include <stdlib.h>
#endif



#ifdef USEPROTOS
int run_tests(void)
#else
int run_tests()
#endif
{
int rc = OK;

int pattern, pair;
#ifdef TURBOC
struct textsettingstype  textsettings;
int msg_left, msg_top, msg_right, msg_bottom;
#endif


   if (step==0)                        /*  sla tests over als step==0  */
      return(OK);

   if (verbose==TRUE)                  /*  als verbose dan tekst boodschap  */
   {
      printf("\n%s\n\n", WAITMSG);
   }
   else                                /*  anders grafische boodschap          */
      if (quiet==FALSE)                /*  maar alleen als quiet niet waar is  */
      {
#ifdef TURBOC
         gettextsettings(&textsettings);
                                       /*  bewaar huidige tekstinstellingen  */
         settextstyle(DEFAULT_FONT, HORIZ_DIR, 2);
                                       /*  zet default font, horizontaal  */

         /*  bepaal coordinaten van boodschapvenster  */
         msg_left=(maxx-textwidth(WAITMSG))/2-MSGMARGIN;
         msg_top=(maxy-textheight(WAITMSG))/2-MSGMARGIN;
         msg_right=(maxx+textwidth(WAITMSG))/2+MSGMARGIN;
         msg_bottom=(maxy+textheight(WAITMSG))/2+MSGMARGIN;

         /*  teken venster en druk wachtboodschap af  */
         setviewport(msg_left, msg_top, msg_right, msg_bottom, TRUE);
         clearviewport();
         linerel(msg_right-msg_left, 0);
         linerel(0, msg_bottom-msg_top);
         linerel(msg_left-msg_right, 0);
         linerel(0, msg_top-msg_bottom);
         outtextxy(MSGMARGIN, MSGMARGIN, WAITMSG);

         /*  zet oude tekstinstellingen terug  */
         settextstyle(textsettings.font, textsettings.direction,
                      textsettings.charsize);

         if ((rc=graphresult())!=grOk)
            return(rc);                /*  geef eventuele grafische fout terug  */
#endif
      }


   /*  alle patronen worden afgegaan omdat ->result voor elk nog berekend moet worden  */
   for (pattern=0; pattern<nrpatterns+nrtests; pattern++)
   {                                   /*  ga alle patroonnummers af    */
      reset_pattern_error(pattern);    /*  zet fout van patroon op nul  */

      for (pair=0; pair<PAIRS(pattern); pair++)
      {                                /*  ga alle patroonparen af   */
         reset_activations(pattern, pair, OUT|RESULT);
         while (calc_output(pattern, pair)==FALSE)
            ;                          /*  itereer tot convergentie  */

         set_pattern_result(pattern, pair);
                                       /*  zet patroon resultaat m.b.v. huidige uitvoer  */
         calc_pattern_error(pattern, pair);
                                       /*  bereken fout van patroon  */
         calc_delay();                 /*  bepaal delayed outputs    */
      }
   }

   calc_error();                       /*  bereken totale fout  */


   if (verbose==FALSE && quiet==FALSE) /*  als grafische uitvoer is toegestaan  */
   {
#ifdef TURBOC
      gettextsettings(&textsettings);  /*  bepaal huidige tekstinstellingen  */

      /*  zet tekststijl en maak venster leeg  */
      settextstyle(DEFAULT_FONT, HORIZ_DIR, 2);
      setviewport(msg_left, msg_top, msg_right, msg_bottom, TRUE);
      clearviewport();

      /*  zet oude tekstinstellingen terug  */
      settextstyle(textsettings.font, textsettings.direction,
                   textsettings.charsize);

      if ((rc=graphresult())!=grOk)
         return(rc);                   /*  geef eventuele grafische fout terug  */
#endif
   }

   return(OK);
}



#ifdef USEPROTOS
void set_pattern_result(int pattern, int pair)
#else
void set_pattern_result(pattern, pair)
        int pattern;
        int pair;
#endif
{
int output;

   /*  alloceer ->result alsnog als deze NULL is  */
   if (GETPATTERN(pattern)->result==NULL)
      GETPATTERN(pattern)->result=
         (FLOAT *)malloc(nroutputs*PAIRS(pattern)*sizeof(*GETPATTERN(pattern)->result));

   /*  als allocatie gelukt is, copieer dan uitvoerwaardes naar result  */
   if (GETPATTERN(pattern)->result!=NULL)
      for (output=0; output<nroutputs; output++)
         *(GETPATTERN(pattern)->result+pair*nroutputs+output)=
               OUTPUTNEURON(output)->output;
}
