/*  $Id$  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log$  */



/*  functies voor het instellen van terminals (enkel voor UNIX)  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"

#include "rnstty.h"


#include <termio.h>
#include <unistd.h>



static struct termio   tty_mode;



#ifdef USEPROTOS
int tty_raw(void)
#else
int tty_raw()
#endif
{
struct termio temp_mode;

   if (ioctl(STDIN_FILENO, TCGETA, (char *) &temp_mode)<0)
      return(GETTTY);

   tty_mode = temp_mode;

   temp_mode.c_iflag=0;
   temp_mode.c_lflag&=~(ICANON | ECHO | XCASE);
   temp_mode.c_cflag&=~(CSIZE | PARENB);
   temp_mode.c_cflag|=~CS8;

   temp_mode.c_cc[VMIN]=0;
   temp_mode.c_cc[VTIME]=0;

   if (ioctl(STDIN_FILENO, TCSETA, (char *) &temp_mode)<0)
      return(RAWTTY);

   return(OK);
}



#ifdef USEPROTOS
int tty_reset(void)
#else
int tty_reset()
#endif
{
   if (ioctl(STDIN_FILENO, TCSETA, (char *) &tty_mode)<0)
      return(CKDTTY);

   return(OK);
}
