/*  $Id: rnsuser.c,v 1.3 1991/10/10 16:46:40 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsuser.c,v $
 * Revision 1.3  1991/10/10  16:46:40  richard
 * Switched to UNIX RCS
 *
 * Revision 1.2  91/05/09  14:43:44  ROOT_DOS
 * Minor changes
 * 
 * Revision 1.1  91/04/25  21:01:39  ROOT_DOS
 * Initial revision
 *   */



/*  default functies voor herdefinieerbare gebruikers foutfuncties  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <math.h>
#else
#include <math.h>
#endif



#ifdef USEPROTOS
FLOAT default_errorf(FLOAT target, FLOAT output, void *erroropt)
#else
FLOAT default_errorf(target, output, erroropt)
         FLOAT target;
         FLOAT output;
         void *erroropt;
#endif
{
   return(0.5*sqr((target-output)/MAXMINOUT));
}



#ifdef USEPROTOS
FLOAT default_derrorf(FLOAT target, FLOAT output, void *derroropt)
#else
FLOAT default_derrorf(target, output, derroropt)
         FLOAT target;
         FLOAT output;
         void *derroropt;
#endif
{
   if (target!=DONTCARE)
      return(target-output);
   else
      return(0);
}
