/*  $Id: rnsvtoh.c,v 1.1 1991/10/10 16:46:42 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsvtoh.c,v $
 * Revision 1.1  1991/10/10  16:46:42  richard
 * Initial revision
 *  */



/*  functies voor het aanmaken en behandelen van random bitpatronen  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"

#include "rnsalloc.h"
#include "rnsvtoh.h"


#ifdef TURBOC
#include <math.h>               /*  voor pow()    */
#include <stdlib.h>             /*  voor random(), malloc()  */
#include <values.h>             /*  voor MAXLONG  */
#else
#include <math.h>               /*  voor pow()    */
#include <stdlib.h>             /*  voor random(), malloc()  */
#include <values.h>             /*  voor MAXLONG  */
#endif



int  nrvtoh = 0;

Vtohhdptr  *vtohlistptr = NULL;



#ifdef USEPROTOS
int value_to_h(unsigned long value, int nrbits, int distance, char *bit_ptr)
#else
int value_to_h(value, nrbits, distance, bit_ptr)
       unsigned long value;
       int nrbits;
       int distance;
       char *bit_ptr;
#endif
{
int vtohindex, retries;
unsigned long randomvalue;
boolean found;
Vtohhdptr vtohhdptr, newvtohhdptr;
Vtohptr vtohptr, topvtohptr, newvtohptr;

   vtohhdptr=NULL;       /*  initialiseer in ieder geval vtohhdptr, indien nrvtoh==0  */

   for (vtohindex=0; vtohindex<nrvtoh; vtohindex++)
   {
      vtohhdptr=*(vtohlistptr+vtohindex);
      if (vtohhdptr->nrbits==nrbits && vtohhdptr->distance==distance)
         break;
   }

   if (vtohhdptr!=NULL &&
       vtohhdptr->nrbits==nrbits && vtohhdptr->distance==distance)
   {
      topvtohptr=vtohptr=vtohhdptr->list;

      while (vtohptr!=NULL && vtohptr->value!=value)
         vtohptr=vtohptr->next;

      /*  maak, indien nodig, een nieuw random bitpatroon aan  */
      /*  met een Hamming afstand 'distance' tot de anderen    */
      if (vtohptr==NULL)
      {
         retries=0;

         do
         {
            found=TRUE;         /*  goede random waarde gevonden  */

            randomvalue=(unsigned long) Random(MAXLONG);

            for (vtohptr=topvtohptr; vtohptr!=NULL; vtohptr=vtohptr->next)
               if (countdbits(nrbits, vtohptr->randomvalue, randomvalue)<distance)
               {
                  found=FALSE;  /*  ligt binnen de afstand van andere  */
                  retries++;
                  break;
               }

         } while (found==FALSE && retries<MAXVTOHRETRIES);

         if (found==FALSE)
            return(VTHMXR);

         if ((newvtohptr=(Vtohptr)malloc(sizeof(Vtoh)))!=NULL)
         {
            newvtohptr->value=value;
            newvtohptr->randomvalue=randomvalue;

            newvtohptr->next=topvtohptr;
                         /*  voeg tussen als eerste element in de list  */

            (*(vtohlistptr+vtohindex))->list=newvtohptr;
                         /*  plaats nieuwe bit patroon in rij 'vtohindex'  */

            vtohptr=newvtohptr;
         }
         else
            return(VTHADD);
      }
   }
   else
   {
      if ((nrvtoh % MINALLC)==0)       /*  initialiseert vtohlistptr ook de eerste keer  */
         if ((vtohlistptr=
            (Vtohhdptr *)REALLOC(vtohlistptr,
                               (nrvtoh+MINALLC)*sizeof(Vtohhdptr)))==NULL)
         return(VTHEXP);

      if ((newvtohhdptr=(Vtohhdptr)malloc(sizeof(Vtohhd)))!=NULL)
      {
         newvtohhdptr->nrbits=nrbits;
         newvtohhdptr->distance=distance;
         newvtohhdptr->list=NULL;

         *(vtohlistptr+nrvtoh)=newvtohhdptr;
         nrvtoh++;
      }
      else
         return(VTHEXP);

      if ((newvtohptr=(Vtohptr)malloc(sizeof(Vtoh)))!=NULL)
      {
         newvtohptr->value=value;
         newvtohptr->randomvalue=(unsigned long) Random(MAXLONG);
                         /*  eerste bitpatroon dus waarde is willekeurig  */
         newvtohptr->next=NULL;

         (*(vtohlistptr+nrvtoh-1))->list=newvtohptr;

         vtohptr=newvtohptr;
      }
      else
         return(VTHADD);
   }

   long_to_bitpat(vtohptr->randomvalue, nrbits, bit_ptr);
                                /*  geef gevonden waarde terug in bit_ptr  */

   return(OK);
}



#ifdef USEPROTOS
int h_to_value(unsigned long value, int nrbits, int distance, unsigned long *value_ptr, int *dist_ptr)
#else
int h_to_value(value, nrbits, distance, value_ptr, dist_ptr)
       unsigned long value;
       int nrbits;
       int distance;
       unsigned long *value_ptr;
       int *dist_ptr;
#endif
{
int vtohindex;
int dist, smalldist;
Vtohhdptr vtohhdptr;
Vtohptr vtohptr, bestvtohptr;

   vtohhdptr=NULL;       /*  initialiseer in ieder geval vtohhdptr, indien nrvtoh==0  */

   for (vtohindex=0; vtohindex<nrvtoh; vtohindex++)
   {
      vtohhdptr=*(vtohlistptr+vtohindex);
      if (vtohhdptr->nrbits==nrbits && vtohhdptr->distance==distance)
         break;
   }

   if (vtohhdptr!=NULL &&
       vtohhdptr->nrbits==nrbits && vtohhdptr->distance==distance)
   {
      vtohptr=vtohhdptr->list;

      bestvtohptr=vtohptr;
      smalldist=nrbits;

      while (vtohptr!=NULL)
      {
         if ((dist=countdbits(nrbits, vtohptr->randomvalue, value))<smalldist)
         {
            bestvtohptr=vtohptr;
            smalldist=dist;
         }

         vtohptr=vtohptr->next;
      }

      if (bestvtohptr==NULL)
         return(NOHTOV);
   }
   else
      return(NOHTOV);

   *value_ptr=bestvtohptr->value;
   *dist_ptr=smalldist;

   return(OK);
}



#ifdef USEPROTOS
int countdbits(int nrbits, unsigned long value1, unsigned long value2)
#else
int countdbits(nrbits, value1, value2)
        int nrbits;
        unsigned long value1;
        unsigned long value2;
#endif
{
int count, bit;
unsigned long xorvalue, mask;

   xorvalue=value1 ^ value2;

   count=0;

   for (bit=0, mask=1; bit<nrbits; bit++, mask<<=1)
      if (xorvalue & mask)
         count++;

   return(count);
}



#ifdef USEPROTOS
void long_to_bitpat(unsigned long value, int nrbits, char *bit_ptr)
#else
void long_to_bitpat(value, nrbits, bit_ptr)
        unsigned long value;
        int nrbits;
        char *bit_ptr;
#endif
{
unsigned long mask;

   mask=(unsigned long) pow(2.0, (double) nrbits-1);

   while (mask!=0)
   {
      if (value & mask)
         *bit_ptr++='X';
      else
         *bit_ptr++='-';

      mask>>=1;
   }
}



#ifdef USEPROTOS
void vtohcleanup(void)
#else
void vtohcleanup()
#endif
{
int vtohindex;
Vtohhdptr vtohhdptr;
Vtohptr vtohptr, prvvtohptr;

   for (vtohindex=0; vtohindex<nrvtoh; vtohindex++)
   {
      vtohhdptr=*(vtohlistptr+vtohindex);

      vtohptr=vtohhdptr->list;

      while (vtohptr!=NULL)
      {
         prvvtohptr=vtohptr;
         vtohptr=vtohptr->next;

         FREE(prvvtohptr);
      }

      FREE(vtohhdptr);
   }

   nrvtoh=0;

   FREE(vtohlistptr);

   vtohlistptr=NULL;
}
