#|
:Auswahlelemente Auswahlelemente
:wert (wr=wert objekt)
:f-Text #'second
:Anordnung-Auswahlelemente :nebeneinander
:f-bei-Wertaenderung
:selektionstyp :multiple

|#


(defparameter *bal-einer-check-box-p* nil)

(defclass *b-auswahl-light-papa* (*b-dialog-item*)
  ())

(defclass *b-auswahl-light* (*b-auswahl-light-papa*)
  (
   (Auswahlelemente :initarg :Auswahlelemente
                    :initform nil
                    :accessor bal-Auswahlelemente)
   (Selektionstyp :initarg :Selektionstyp
                  :initform :single
                  :accessor bal-Selektionstyp)
   ;auch multiple
   (f-Text :initarg :f-Text
           :initform #'b=erzeuge-string
           :reader bal-f-Text)
   
   (unteritems :initform NIL
               :accessor bal-unteritems)

   (f-bei-Wertaenderung 
    :initform nil :initarg :f-bei-Wertaenderung
    :accessor bal-f-bei-Wertaenderung)
   (Anordnung-Auswahlelemente
    :initarg :Anordnung-Auswahlelemente
    :initform :untereinander ;oder :nebeneinander ;oder (:nebeneinander maximum)
    :accessor bal-Anordnung-Auswahlelemente)
   ;alter-wert
   (alter-wert :initform nil :accessor bal-alter-wert)
   (dummy-radio :initform nil :accessor bal-dummy-radio)
   )
  )

(defmethod initialize-instance ((ich *b-auswahl-light*) &rest init-list &key Wert)
  #-:aclpc (declare (ignore init-list))
  (call-next-method)
  (when (and *bal-einer-check-box-p*
             (b=einerliste-p (bal-Auswahlelemente ich))
             (eq (bal-Selektionstyp ich) :single))
    (setf (bal-Selektionstyp ich) :single-check))
  ;erzeuge-die unterobjekte
  (bal-erzeuge-objekte ich (bal-Selektionstyp ich))
  (when (eq :single (bal-Selektionstyp ich))
    (setf (bal-dummy-radio ich)
          (m->a=erzeuge-dialog-item '*b-auswahl-radio-button*
                                    :view-nick-name wert
                                    :radio-button-cluster ich
                                    :view-position (make-point -1000 -1000))))
  (bal-wert-setzen ich wert)
  )

(defclass *b-auswahl-radio-button* (*b-radio-button-dialog-item*)
  ()
  )

(defclass *b-auswahl-check-box* (*b-check-box-dialog-item*)
  ()
  )

(defmethod bal-erzeuge-objekte ((ich *b-auswahl-light*) typ)
  (let ((objekte nil))
    (dolist (wert (bal-Auswahlelemente ich))
      (let ((text (funcall (bal-f-Text ich) wert)))
        (push (ecase typ
                (:single (m->a=erzeuge-dialog-item '*b-auswahl-radio-button*
                           :view-font (view-font ich)
                           :view-nick-name wert
                           :dialog-item-text text
                           :dialog-item-action 
                           #'(lambda (objekt)
                               (declare (ignore objekt))
                               (bal-wertaenderung ich))
                           :radio-button-cluster ich))
                ((:multiple :single-check)
                 (m->a=erzeuge-dialog-item '*b-auswahl-check-box*
                   :view-nick-name wert
                   :view-font (view-font ich)
                   :dialog-item-text text
                   :dialog-item-action 
                   #'(lambda (objekt)
                       (declare (ignore objekt))
                       (bal-wertaenderung ich))
                   
                   )))
              objekte)))
    (setf (bal-unteritems ich)
          (reverse objekte))))

(defmethod set-view-container ((ich *b-auswahl-light*)(wohin (eql nil)))
  (call-next-method)
  (dolist (item (bal-unteritems ich))
    (set-view-container item nil)
    ))

(defmethod set-view-container :after  ((ich *b-auswahl-light*) wohin)
  (when (bal-dummy-radio ich)
    (set-view-container (bal-dummy-radio ich) wohin)))

;Die naechsten drei stimmen nur bei Anordnung der items untereinander

(defmethod bal-position-des-naechsten ((ich *b-auswahl-light*) position item)
  (if (listp (bal-Anordnung-Auswahlelemente ich))
    ;also nebeneinander mit maximum
    (let ((neu-horizontal (+ (point-h position) 5 (point-h (view-size item))))
          (maximum (second (bal-Anordnung-Auswahlelemente ich))))
      (if (> neu-horizontal (+ (point-h (view-position ich)) maximum))
        ;in die naechste zeile
        (make-point 
         ;anfang der zeile
         (point-h (view-position ich))
         (+ (point-v position) 2 (point-v (view-size item))))
        ;weitermachen
        (add-points position
                    (make-point (+ 5 (point-h (view-size item))) 0))))
    (ecase (bal-Anordnung-Auswahlelemente ich)
      (:untereinander
       (add-points position
                   (make-point 0 (+ 2 (point-v (view-size item))))))
      (:nebeneinander
       (add-points position
                   (make-point (+ 5 (point-h (view-size item))) 0)))
      )
    )
  )

(defmethod bal-position-testen ((ich *b-auswahl-light*) item position)
  ;es gibt ein maximum fuer die position, vielleicht bin ich ruebergerutscht
  (let* ((maximum (second (bal-Anordnung-Auswahlelemente ich)))
         (breite-des-item (point-h (view-size item)))
         (ende-horizontal (+ (point-h position) breite-des-item))
         (max-horizontal (+ (point-h (view-position ich)) maximum)))
    (if (< ende-horizontal max-horizontal)
      ;alles roger
      nil
      ;eigentlich zu weit
      ;testen ob es ueberhaupt geht
      (if (not (= (point-h (view-position ich))(point-h position)))
        ;es geht, aendern
        (progn
          (set-view-position item (make-point 
                                   ;anfang der zeile
                                   (point-h (view-position ich))
                                   (+ (point-v position) 2 (point-v (view-size item)))))
          t)
        nil))))

(defmethod set-view-container ((ich *b-auswahl-light*)(wohin view))
  (let ((wert-vorher (dialog-item-wert ich)))
    (call-next-method)
    (let ((position (view-position ich)))
      (dolist (item (bal-unteritems ich))
        (set-view-position item position)
        (set-view-container item wohin)
        ;vielleicht war das jetzt schon zu weit -> testen
        (when (listp (bal-Anordnung-Auswahlelemente ich))
          (let ((geaendert (bal-position-testen ich item position)))
            (when geaendert
              (setq position (view-position item)))))
        
        (setq position
              (bal-position-des-naechsten ich position item))
        ))
    (unless (equal wert-vorher (dialog-item-wert ich))
      (bal-wert-setzen ich wert-vorher))
    )
  )

(defmethod set-view-position ((ich *b-auswahl-light*) h &optional v)
  #-:aclpc (declare (ignore h v))
  (call-next-method)
  (when (view-container ich)
    ;die unterobjekt muessen mit verschoben werden !!!!
    (let ((position (view-position ich)))
      (dolist (item (bal-unteritems ich))
        (set-view-position item position)
        ;vielleicht war das jetzt schon zu weit -> testen
      (when (listp (bal-Anordnung-Auswahlelemente ich))
        (let ((geaendert (bal-position-testen ich item position)))
          (when geaendert
            (setq position (view-position item)))))
        (setq position
              (bal-position-des-naechsten  ich position item))))))

(defmethod view-size ((ich *b-auswahl-light*))
  (view-groesse-berechnen ich))

(defmethod view-groesse-berechnen ((ich *b-auswahl-light*))
  (if (and (view-container ich) (every #'view-container (bal-unteritems ich)))
    (let ((elemente (bal-unteritems ich)))
      (cond ((null elemente)
             0)
            ((null (cdr elemente))
             (view-size (first elemente)))
            (T
             ;mehr als ein Element
             (let ((was (bal-Anordnung-Auswahlelemente ich)))
               (if (listp was)
                 (let ((position_des_ersten (view-position (first elemente)))
                       (position_des_letzen (view-position (first (last elemente))))
                       (groesse_des_letzen (view-size (first (last elemente))))
                       (maximale-horizontale-position
                        (apply #'max (mapcar #'(lambda(item)
                                                 (+ (point-h (view-size item))
                                                    (point-h (view-position item))))
                                             elemente)))
                       )
                   (make-point (- maximale-horizontale-position (point-h position_des_ersten))
                               (- (+ (point-v position_des_letzen)(point-v groesse_des_letzen))
                                  (point-v position_des_ersten)))
                   )
                 (ecase was
                   (:untereinander
                    (let ((position_des_ersten (view-position (first elemente)))
                          (position_des_letzen (view-position (first (last elemente))))
                          (groesse_des_letzen (view-size (first (last elemente))))
                          (maxbreite 0))
                      (dolist (item (bal-unteritems ich))
                        (setq maxbreite (max maxbreite (point-h (view-size item)))))
                      (make-point maxbreite
                                  (- (+ (point-v groesse_des_letzen)(point-v position_des_letzen))
                                     (point-v position_des_ersten)))))
                   (:nebeneinander 
                    (let ((position_des_ersten (view-position (first elemente)))
                          (position_des_letzen (view-position (first (last elemente))))
                          (groesse_des_letzen (view-size (first (last elemente))))
                          )
                      (subtract-points (add-points position_des_letzen groesse_des_letzen)
                                       position_des_ersten)
                      )))))
             )))
    (make-point 0 0))
  )

(defmethod bal-wertaenderung ((ich *b-auswahl-light*))
  ;es hat sich potentiell ein wert geaendert
  (when (bal-f-bei-Wertaenderung ich)
    (let ((vorher (bal-alter-wert ich))
          (nachher (dialog-item-wert ich)))
      (funcall  (bal-f-bei-Wertaenderung ich) ich vorher nachher)
      (setf (bal-alter-wert ich) nachher)
      )
    )
  )
  
(defmethod bal-wert-setzen ((ich *b-auswahl-light*) wert)
  (ecase (bal-Selektionstyp ich)
    (:single (bal-radio-wert-setzen ich wert) )
    (:single-check (bal-einen-check-wert-setzen ich wert) )
    (:multiple (bal-check-wert-setzen ich wert))
    )
  (setf (bal-alter-wert ich) wert))
  
(defmethod bal-einen-check-wert-setzen ((ich *b-auswahl-light*) wert)
  (let ((item (first (bal-unteritems ich))))
    (if wert
      (check-box-check item)
      (check-box-uncheck item)
      )))

(defmethod bal-radio-wert-setzen ((ich *b-auswahl-light*) wert)
  ;abbildung wert -> item linear suchen ??
  (let ((item (bal-radio-objekt-zu-wert-finden ich wert)))
    (if item
      (radio-button-push item)
      (dolist (item (bal-unteritems ich))
        (bal-objekt-ruecksetzen item))
      )
    )
  (if (null wert)
    (radio-button-push (bal-dummy-radio ich)))
  )

(defmethod bal-check-wert-setzen ((ich *b-auswahl-light*) wert)
  ;abbildung wert -> item linear suchen ??
  (let ((items (bal-check-objekte-zu-wert-finden ich wert)))
    (dolist (item (bal-unteritems ich))
      (if (member item items)
        (check-box-check item)
        (check-box-uncheck item)))))

(defmethod bal-radio-objekt-zu-wert-finden ((ich *b-auswahl-light*) wert)
  (dolist (item (bal-unteritems ich))
    (when (equal (view-nick-name item) wert)
      (return item))))

(defmethod bal-check-objekte-zu-wert-finden ((ich *b-auswahl-light*) wert)
  (let ((objekte nil))
    (dolist (item (bal-unteritems ich))
      (when (member (view-nick-name item) wert :test #'equal)
        (push item objekte)))
    objekte))

(defmethod bal-ruecksetzen ((ich *b-auswahl-light*))
  (dolist (item (bal-unteritems ich))
    (bal-objekt-ruecksetzen item)))

(defmethod bal-objekt-ruecksetzen ((ich *b-auswahl-radio-button*))
  (when (radio-button-pushed-p ich)
    (radio-button-unpush ich)))

(defmethod bal-objekt-ruecksetzen ((ich *b-auswahl-check-box*))
  (when (check-box-checked-p ich)
    (check-box-checked-p ich)))

  
(defmethod dialog-item-wert ((ich *b-auswahl-light*))
  (ecase (bal-Selektionstyp ich)
    (:single (bal-radiowert ich))
    (:single-check (bal-einen-check-wert ich))
    (:multiple (bal-check-wert ich))))


(defmethod bal-radiowert ((ich *b-auswahl-light*))
  (dolist (item (bal-unteritems ich))
    (when (radio-button-pushed-p item)
      (return (view-nick-name item)))))

(defmethod bal-einen-check-wert ((ich *b-auswahl-light*))
  (let  ((item (first (bal-unteritems ich))))
    (if (check-box-checked-p item)
      (view-nick-name item)
      nil)))

(defmethod bal-check-wert ((ich *b-auswahl-light*))
  (let ((wert nil))
    (dolist (item (bal-unteritems ich))
      (when (check-box-checked-p item)
        (push (view-nick-name item) wert)))
    (reverse wert)))

(defmethod dialog-item-wert-setzen ((ich *b-auswahl-light*) wert)
  (bal-wert-setzen ich wert)
  (bal-wertaenderung ich))

#|
(setq der
      (m->a=erzeuge-dialog-item '*b-auswahl-light*
        :wert 'b
        :view-font #+:ccl-2 '("Monaco" 30) #+:aclpc #.(MAKE-FONT :MODERN :COURIER\ NEW 35 '(:BOLD :ITALIC))
        :auswahlelemente '(a b c d e)))

(setq der1
      (m->a=erzeuge-dialog-item '*b-auswahl-light*
        :view-position (make-point 100 20)
        :wert '(a e)
        :Anordnung-Auswahlelemente (list :nebeneinander 150)
        :selektionstyp :multiple
        :f-bei-Wertaenderung #'(lambda(objekt vorher nachher)
                                 (print `(objekt ,objekt vorher ,vorher nachher ,nachher)))
        :auswahlelemente '(a b c d e f g h i j k l m n o p q r s t)))

(setq der2
      (m->a=erzeuge-dialog-item '*b-auswahl-light*
        :view-position (make-point 100 120)
        :wert '(a)
        :selektionstyp :single
        :f-bei-Wertaenderung #'(lambda(objekt vorher nachher)
                                 (print `(objekt ,objekt vorher ,vorher nachher ,nachher)))
        :auswahlelemente '(a)))

(setq fenster (m->a=erzeuge-fenster '*b-window*))

(add-subviews fenster der der1 der2)

(dialog-item-wert der)
(dialog-item-wert-setzen der 'a)
(dialog-item-wert-setzen der 'nil)

(dialog-item-wert der1)
(dialog-item-wert-setzen der1 nil)
(dialog-item-wert-setzen der1 '(a))
(dialog-item-wert-setzen der1 '(b))
(dialog-item-wert-setzen der1 '(b c))


|#
