#+:aclpc
(defmacro b-mit-schrift (stream font &body body)
  (let ((temp (gensym)))
    `(if ,font
       (let ((,temp (font-handle ,stream)))
         (set-font ,stream ,font)
         ,@body
         (set-font ,stream ,temp))
       (progn
         ,@body))))

#+:ccl-2
(defmacro b-mit-font-code (a b &body body)
  `(multiple-value-bind
     (ff mm)
     (grafport-font-codes)
     (set-grafport-font-codes ,a ,b)
     ,@body
     (set-grafport-font-codes ff mm)))

(defun b-view-invalidieren (view &optional loeschen)
 (invalidate-view view loeschen)
   )

(defun b-rechteck-invertieren (view von bis)
  #+:ccl-2
  (invert-rect view von bis)
  #+:aclpc
  (highlight-contents-box view gray (make-box-from-corners von bis))
  )

(defun b-rechteck-intern-malen (view von bis)
  #+:ccl-2 (declare (ignore view))
  #+:ccl-2
  (b-with-rectangle-arg
    (rechteck 
     von
     bis)
    (#_FrameRect rechteck))
  #+:aclpc
  (draw-box view (make-box-from-corners von bis))
  )

(defclass *b-table-dialog-item-light* (#+:aclpc nachmal&click-mixin *b-dialog-item*)
  (
   (table-vscrollp :initarg :table-vscrollp 
                   :initform nil
                   :accessor table-vscrollp)
   (table-hscrollp :initarg :table-hscrollp
                   :initform nil
                   :accessor table-hscrollp)
   (cell-size :initarg :cell-size
              :accessor cell-size
              :initform nil)
   (selection-type :initarg :selection-type
                   :initform :single
                   :Accessor btl-selection-type
                   )
   (table-dimensions :initarg :table-dimensions :initform (make-point 3 3) :accessor table-dimensions)
   (visible-dimensions :initarg :visible-dimensions :initform nil :accessor visible-dimensions)
   ;
   (btl-selektierte-zellen :initform nil
                           :accessor btl-selektierte-zellen)
   (schriftinfo-pro-zelle :initform nil
                          :accessor btl-schriftinfo-pro-zelle)
   (meine-lieblings-scroller :initform nil :accessor btl-scroller)
   )
  )


(defclass *B-scroller-fuer-table-item*
        #+:aclpc (*b-view-mit-scroller*)
     #+:ccl-2 (*b-scroller-view*)
     ()
     )

#+:ccl-2
(defmethod setze-scroll-size ((self *B-scroller-fuer-table-item*) punkt)
  (when (ccl::h-scroller self) 
    (setf (ccl::scroll-bar-scroll-size (ccl::h-scroller self)) (point-h punkt)))
  (when (ccl::v-scroller self) 
    (setf (ccl::scroll-bar-scroll-size (ccl::v-scroller self)) (point-v punkt))))

#+:aclpc
(defmethod setze-scroll-size ((self *B-scroller-fuer-table-item*) punkt)
  )

#+:aclpc 
(defmethod user-scroll ((ich *B-scroller-fuer-table-item*)
                                      a b))

(defmethod  initialize-instance ((ich *b-table-dialog-item-light*)
                                &rest init-list)
  #-:aclpc (declare (ignore init-list))
  (call-next-method)
  (setf (btl-scroller  ich)
        (m->a=erzeuge-dialog-item '*B-scroller-fuer-table-item*
                                  :v-scrollp (table-vscrollp ich)
                                  :h-scrollp (table-hscrollp ich)
                                  )))

(defmethod initialize-instance :after  ((ich *b-table-dialog-item-light*)
                                                            &rest init-list)
     (when (null (cell-size ich))
          (set-cell-size ich (make-point 100 20)))
     (unless  (visible-dimensions ich)
          (setf (visible-dimensions ich)
                  (table-dimensions ich)))
     )

(defmethod B-SCROLLER-ADAPTIEREN ((ich *b-table-dialog-item-light*))
     (when (btl-scroller ich)
          (set-view-size (btl-scroller ich) (view-size-intern ich))
          (set-field-size (btl-scroller ich) (view-size-real ich))
          (setze-scroll-size (btl-scroller ich) (cell-size ich)))
     )

(defmethod set-view-container ((ich *b-table-dialog-item-light*) container)
     (cond (container
                   (let ((position-des-scrollers (or (view-position ich)
                                                                    (make-point 0 0))))
                       (set-view-position (btl-scroller ich) position-des-scrollers)
                       (set-view-position ich (make-point 0 0))
                       (set-view-size (btl-scroller ich) (view-size-intern ich))
                       (set-field-size (btl-scroller ich) (view-size-real ich))
                       (set-view-container (btl-scroller ich) container)
                       #+:ccl-2 (call-next-method ich (btl-scroller ich))
                       #+:aclpc (call-next-method ich (dialog-item-window (btl-scroller ich)))
                       )
                   (B-SCROLLER-ADAPTIEREN ich)
                   )
              (T (call-next-method ich nil)
                  (set-view-container (btl-scroller ich) nil))))

(defmethod view-contains-point-p ((ich *b-table-dialog-item-light*) wo)
  (let ((max (view-size-real ich)))
    (and (<= (point-h wo)(point-h max))
         (<= (point-v wo)(point-v max)))))

#|
Noch offen ab
|#

(defmethod scroll-position-1 ((ich *b-table-dialog-item-light*))
  (view-scroll-position (btl-scroller ich)))

#+:ccl-2
(defmethod scroll-position ((ich *b-table-dialog-item-light*))
  (scroll-position-1 ich))

(defmethod scroll-to-cell ((ich *b-table-dialog-item-light*) h &optional v)
  (declare (ignore h v))
  )

(defmethod set-cell-font ((ich *b-table-dialog-item-light*) zelle font)
  #+:aclpc
  (b=setze-Assoziativwert
   (btl-schriftinfo-pro-zelle ich)
   zelle
   font
   :test 'btl-point-equal)
  #+:ccl-2
  (if font
    (setf (getf (btl-schriftinfo-pro-zelle ich) zelle)
          (multiple-value-bind
            (a b)
            (font-codes font)
            (cons a b)))
    (remf (btl-schriftinfo-pro-zelle ich) zelle))
  )

#+:ccl-2
(defmethod cell-font-code ((ich *b-table-dialog-item-light*) zelle)
  (or (cell-font-intern ich zelle)
      (multiple-value-bind
        (a b)
        (font-codes (view-font ich))
        (cons a b))))

(defmethod cell-font-intern ((ich *b-table-dialog-item-light*) zelle)
  #+:aclpc
  (b=Assoziativwert zelle (btl-schriftinfo-pro-zelle ich) :test 'btl-point-equal)
  #+:ccl-2
  (getf (btl-schriftinfo-pro-zelle ich) zelle)
  )

(defmethod cell-font ((ich *b-table-dialog-item-light*) h &optional v)
  (let ((zelle (if v (make-point h v) h)))
    #+:aclpc
    (cell-font-intern ich zelle)
    #+:ccl-2
    (apply #'font-spec (cell-font-intern ich zelle))
    )
  )

(defmethod set-cell-size ((ich *b-table-dialog-item-light*) h &optional v)
  (b-view-invalidieren ich t)
  (setf (cell-size ich) (btl-care-point h v))
  (b-scroller-adaptieren ich)
  (b-view-invalidieren ich t)
  )

(defmethod view-click-event-handler ((ich *b-table-dialog-item-light*) wo)
  (call-next-method)
  (let ((zelle (point-to-cell ich wo)))
    (when zelle
      (btl-klick-auf-zelle ich zelle))))

(defun btl-point-equal (a b)
  (and (= (point-h a)
          (point-h b))
       (= (point-v a)
          (point-v b))))

(defmethod btl-sondertaste-p ((ich *b-table-dialog-item-light*))
  #+:ccl-2
  (command-key-p)
  #+:aclpc
  (view-shift-key-p (view-container ich))
  )

(defmethod btl-zelle-invertiert-p ((ich *b-table-dialog-item-light*) zelle)
  (member zelle (selected-cells ich) :test #'btl-point-equal)
  )

(defmethod btl-klick-auf-zelle ((ich *b-table-dialog-item-light*) zelle)
  (let ((vorher-selektiert-p (btl-zelle-invertiert-p ich zelle)))
    (case (btl-selection-type ich)
      (:single
       (if vorher-selektiert-p
         (btl-zelle-deselektieren ich zelle)
         (progn
           (btl-alle-zellen-deselektieren ich)
           (btl-zelle-selektieren ich zelle)
           )))
      (:disjoint
       (if vorher-selektiert-p
         (btl-zelle-deselektieren ich zelle)
         (if (btl-sondertaste-p ich)
           (btl-zelle-selektieren ich zelle)
           (progn
             (btl-alle-zellen-deselektieren ich)
             (btl-zelle-selektieren ich zelle))))
       )
      (t nil))
    )
  )

(defmethod selected-cells ((ich  *b-table-dialog-item-light*))
  (btl-selektierte-zellen ich))

(defun btl-care-point (h v)
  (if v
    (make-point h v)
    h)
  )

(defmethod cell-select ((ich *b-table-dialog-item-light*) h &optional v)
  (btl-zelle-selektieren ich (btl-care-point h v)))

(defmethod cell-deselect ((ich *b-table-dialog-item-light*) h &optional v)
  (btl-zelle-deselektieren ich (btl-care-point h v))
  )

(defmethod btl-alle-zellen-deselektieren ((ich *b-table-dialog-item-light*))
  (dolist (zelle (btl-selektierte-zellen ich))
    (btl-zelle-deselektieren ich zelle))
  )

(defmethod btl-zelle-deselektieren ((ich *b-table-dialog-item-light*) zelle)
  (setf (btl-selektierte-zellen ich)
        (delete zelle (btl-selektierte-zellen ich) :test #'btl-point-equal))
  (btl-zelle-demarkieren ich zelle)
  )

(defmethod btl-zelle-selektieren ((ich *b-table-dialog-item-light*) zelle)
  (setf (btl-selektierte-zellen ich)
        (cons zelle (btl-selektierte-zellen ich)))
  (btl-zelle-markieren ich zelle)
  )

(defmethod btl-zelle-demarkieren ((ich *b-table-dialog-item-light*) zelle)
  (btl-zelle-markieren ich zelle))

(defmethod btl-zelle-markieren ((ich *b-table-dialog-item-light*) zelle)
  (let ((wo (cell-position ich zelle)))
    (b-rechteck-invertieren (view-container ich)
                            (add-points #@(1 1) wo)
                            (subtract-points (add-points wo (cell-size ich)) #@(1 1))))
  )

(defmethod set-table-dimensions ((ich  *b-table-dialog-item-light*) h &optional v)
  (setf (table-dimensions ich)
        (btl-care-point h v))
  )

(defmethod set-visible-dimensions ((ich *b-table-dialog-item-light*) h &optional v)
  (b-view-invalidieren ich t)
  (setf (visible-dimensions ich)
        (btl-care-point h v))
  (b-view-invalidieren ich t)
  )

(defmethod cell-contents ((ich *b-table-dialog-item-light*) h &optional v)
  (declare (ignore h v))
  )

(defmethod cell-position ((ich *b-table-dialog-item-light*) h &optional v)
  (unless v
    (psetq h (point-h h)
           v (point-v h)))
  (let ((start-position (view-position ich)))
    (add-points
     start-position
     (make-point 
      (* h (point-h (cell-size ich)))
      (* v (point-v (cell-size ich))))))
  )

(defmethod point-to-cell ((ich *b-table-dialog-item-light*) h &optional v)
  (unless v
    (psetq h (point-h h)
           v (point-v h)))
  (let* ((relativ
          (subtract-points (make-point h v)(view-position ich)))
         (cell-size (cell-size ich))
         (h_div (1- (ceiling (point-h relativ)(point-h cell-size))))
         (v_div (1- (ceiling (point-v relativ)(point-v cell-size))))
         )
    (if (and (>= h_div 0)
             (>= v_div 0)
             (< h_div (point-h (table-dimensions ich)))
             (< v_div (point-v (table-dimensions ich)))
             )
      (make-point h_div v_div)
      nil
      )
    )
  )

(defmethod cell-contents-string ((ich *b-table-dialog-item-light*) cell)
  (let ((inhalt (cell-contents ich cell)))
    (if (stringp inhalt) inhalt
        (if (eq inhalt nil) "Nix du depp"
            (b=erzeuge-string inhalt))))
  )

(defmethod view-size ((ich *b-table-dialog-item-light*))
  (let ((zellen (cell-size ich))
        (dims (visible-dimensions ich)))
    (if (and zellen dims)
      (make-point 
       (+ (if (table-vscrollp ich) 15 0)(* (point-h zellen)(point-h dims)))
       (+ (if (table-hscrollp ich) 15 0) (* (point-v zellen)(point-v dims))))))
  )

(defmethod view-size-intern ((ich *b-table-dialog-item-light*))
  (let ((zellen (cell-size ich))
        (dims (visible-dimensions ich)))
    (if (and zellen dims)
      (make-point 
       (* (point-h zellen)(point-h dims))
       (* (point-v zellen)(point-v dims)))))
  )

(defmethod view-size-real ((ich *b-table-dialog-item-light*))
  (let ((zellen (cell-size ich))
        (dims (table-dimensions ich)))
    (if (and zellen dims)
      (make-point 
       (* (point-h zellen)(point-h dims))
       (* (point-v zellen)(point-v dims)))))
  )


(defmethod scrollable-view-size ((ich *b-table-dialog-item-light*))
  (let ((zellen (cell-size ich))
        (dims (table-dimensions ich)))
    (if (and zellen dims)
      (make-point 
       (* (point-h zellen)(point-h dims))
       (* (point-v zellen)(point-v dims)))
      (make-point 0 0)))
  )

(defmethod view-draw-contents ((ich *b-table-dialog-item-light*))
  (with-focused-view (view-container ich)
    (let* ((size (view-size-intern ich))
           (gescrollt (scroll-position-1 ich))
           (bis (add-points size gescrollt))
           (groesse (cell-size ich))
           (ab-x (floor (point-h gescrollt)(point-h groesse)))
           (ab-y (floor (point-v gescrollt)(point-v groesse)))
           (bis-x (ceiling (point-h bis)(point-h groesse)))
           (bis-y (ceiling (point-v bis)(point-v groesse)))
           (da (table-dimensions ich)))
      (dotimes (y (point-v  da))
        (dotimes (x (point-h  da))
          (when (bt-zelle-ist-sichtbar x y ab-x ab-y bis-x bis-y)
            (draw-table-cell ich x y))))))
  )

(defun bt-zelle-ist-sichtbar (zelle-x zelle-y ab-x ab-y bis-x bis-y)
  (and (>= zelle-x ab-x)
       (< zelle-x bis-x)
       (>= zelle-y ab-y)
       (< zelle-y bis-y))
  )
  
(defmethod redraw-cell ((ich *b-table-dialog-item-light*) horizontal
                        &optional vertical)
  (with-focused-view (view-container ich)
    (draw-table-cell ich horizontal vertical))
  )

(defmethod draw-table-cell ((ich *b-table-dialog-item-light*) horizontal
                               &optional vertical)
  (let* ((zelle (make-point horizontal vertical))
         (zellengroesse (cell-size ich))
         (zellenpos (cell-position ich horizontal vertical))
         (ausgabe-string (cell-contents-string ich zelle))                          
         )
    #+:ccl-2
    (let ((font-code (cell-font-code ich zelle)))
      (b-mit-font-code (first font-code)(rest font-code)
        (multiple-value-bind
          (ascent descent max-width leading)
          (font-codes-info (first font-code)(rest font-code))
          (declare (ignore descent max-width leading))
          (b-with-rectangle-arg 
            (rechteck (add-points #@(1 1) zellenpos)
                      (subtract-points (add-points zellenpos zellengroesse)
                                       #@(1 1)
                                       ))
            (ccl::with-clip-rect-intersect rechteck
              (#_eraserect rechteck)
              (draw-cell-contents ich horizontal vertical)
              (with-pstrs ((pascal-ptr ausgabe-string))
                (#_moveto (+ 3 (point-h zellenpos)) (+ 3 (+ ascent (point-v zellenpos))))
                (#_drawstring pascal-ptr))
              (when (btl-zelle-invertiert-p ich zelle)
                (#_InvertRect rechteck)))))
        )
      )
    #+:aclpc
    (let ((box (make-box-relative-from-corner
                (add-points (make-point 1 1) zellenpos)
                (- (point-h zellengroesse) 2)
                (- (point-v zellengroesse) 2)))
          )
      (erase-contents-box (view-container ich) box)
      (b-mit-schrift (view-container ich) (cell-font-intern ich zelle)
                     (draw-cell-contents ich horizontal vertical)
                     (draw-string-in-box (view-container ich) ausgabe-string 0 (length ausgabe-string) box
                                         :left :center nil)
                     (draw-cell-contents ich horizontal vertical))
      (when (btl-zelle-invertiert-p ich zelle)
        (HIGHLIGHT-CONTENTS-BOX  (view-container ich) gray
                                 box))
      )
    )
  )

(defmethod draw-cell-contents ((ich *b-table-dialog-item-light*) horizontal  &optional vertical)
  vertical
  horizontal
  #|
Hier kann der Benutzer jetzt irgendwelche Sachen machen
|#
  )

#|
Designentscheidung, es kann nur vertikale oder horizontale geben, keine Mehrspaltigen
|#

(defclass *b-sequence-dialog-item-lite* (*b-table-dialog-item-light*)
  (
   (default-table-sequence :allocation :class :initform '(0 1 2))
   (table-sequence :accessor bsd-table-sequence)
   (sequence-order :accessor bsd-sequence-order)
   )
  )

(defmethod initialize-instance ((ich *b-sequence-dialog-item-lite*)
                                &rest init-list
                                &key table-sequence sequence-order max-length)
  (when (null table-sequence)
    (setq table-sequence (list 0 1 2)))
  (when (null sequence-order)
    (setq sequence-order :vertical))
  (when (null max-length)
    (setq max-length (length table-sequence)))
  (multiple-value-bind
    (table-dimensions visible-dimensions)
    (ecase sequence-order
      (:vertical (values
                  (make-point 1 (length table-sequence))
                  (make-point 1 max-length)))
      (:horizontal (values
                    (make-point (length table-sequence) 1)
                    (make-point max-length 1))))
    (apply #'call-next-method ich 
           :table-dimensions table-dimensions
           :visible-dimensions visible-dimensions
           init-list
           )
    (setf (bsd-table-sequence ich) table-sequence)
    (setf (bsd-sequence-order ich) sequence-order)
    )
  )

(defmethod set-table-sequence ((ich *b-sequence-dialog-item-lite*) liste)
  (b-view-invalidieren ich t)
  (setf (bsd-table-sequence ich) liste)
  (set-table-dimensions ich
                        (ecase (bsd-sequence-order ich)
                          (:vertical (make-point 1 (length liste)))
                          (:horizontal (make-point (length liste) 1))))
  )


(defmethod table-sequence ((ich *b-sequence-dialog-item-lite*))
  (bsd-table-sequence ich))

(defmethod cell-to-index ((ich *b-sequence-dialog-item-lite*) h &optional v)
  (let ((index
         (case (bsd-sequence-order ich)
           (:vertical v)
           (t h))))
    (if (numberp index)
      (if (< index (length (bsd-table-sequence ich)))
        index
        nil)
      nil)
    )
  )

(defmethod cell-contents ((ich *b-sequence-dialog-item-lite*)
                          h &optional v)
  (unless v
    (psetq h (point-h h)
           v (point-v h)))
  (let ((index (cell-to-index ich h v)))
    (if index
      (elt (bsd-table-sequence ich) index)
      nil))
  )


#|
(defclass *test-table* (*b-table-dialog-item-light*)
  ())

(defmethod cell-contents ((ich *test-table*) h &optional v)
  (unless v
    (psetq h (point-h h)
          v (point-v h)))
  (format nil "~2D,~2d" h v))

(m->a=erzeuge-fenster '*b-window*
  :view-subviews
  (list
   (setq der (m->a=erzeuge-dialog-item '*test-table*
               :view-position (make-point 5 5)
               :visible-dimensions (make-point 5 5)
                :TABLE-vSCROLLP t :TABLE-hSCROLLP t
               :table-dimensions (make-point 10 10)
               ))))

(set-cell-font der (make-point 1 1)
               b_dickschrift
               )

(set-cell-font der (make-point 2 2)
               (b=schriftauswahl)
               )

(m->a=erzeuge-fenster
 '*b-window*
 :view-subviews
 (list
  (setq die (m->a=erzeuge-dialog-item 
             '*b-sequence-dialog-item-lite*
             :TABLE-vSCROLLP t :TABLE-hSCROLLP t
             :selection-type :disjoint
             :max-length 10
             :table-sequence (apropos-list 'b=)                         
             ))))


|#
