;******************************** Objekt: *nh-unter-b-Farb-sequence* *********************************************
;-----------------------------------------------------------------------------------------------------------
; Hilfskonstruktion, um aus der Parameter-Funktion "f-Hintergrundfarbe" auf aufrufendes Objekt zugreifen zu knnen
; (siehe Organisation-Ordner "Programmierprobleme Nr.4")
;-----------------------------------------------------------------------------------------------------------
(defclass *nh-unter-b-Farb-sequence* (#-:aclpc *nh-Farb-sequence*) 
  ((f-Objekt-Hintergrundfarbe :initarg :f-Objekt-Hintergrundfarbe)
   (f-Objekttyp-Hintergrundfarbe :initarg :f-Objekttyp-Hintergrundfarbe)
   (f-Objekttyp :initarg :f-Objekttyp)
   ))

(defmethod initialize-instance ((self *nh-unter-b-Farb-sequence*) &rest init-list)
     (apply #'call-next-method
          self
          (init-list-default init-list
                            :f-Hintergrundfarbe
                            #'(lambda (Feld Feldinhalt)
                                (nh-hilfs-f-Hintergrundfarbe self Feld Feldinhalt)))))

(defmethod nh-hilfs-f-Hintergrundfarbe ((self *nh-unter-b-Farb-sequence*) Feld Feldinhalt)
  ;Testausgaben
  ;(print `(slot f-Objekt-hintergrundfarbe ,(slot-value self 'f-Objekt-hintergrundfarbe)))
  ;(print `(feldinhalt ,feldinhalt))

   (if (slot-value self 'f-Objekt-hintergrundfarbe)
     (funcall (slot-value self 'f-Objekt-hintergrundfarbe) Feldinhalt)
     (when (and (slot-value self 'f-Objekttyp-Hintergrundfarbe)
                (slot-value self 'f-Objekttyp))
       (funcall (slot-value self 'f-Objekttyp-Hintergrundfarbe)
                (funcall (slot-value self 'f-Objekttyp) Feldinhalt)))))

;******************************************************************************************************************

;-------------------------------------------------------------------------------------------------------------------
(defmethod nh-erzeuge-fensterinhalt ((self *b-namen-suchen-window*) init-list)
     (let ((rand-re/li 15)
            )
     (add-subviews self 
          (m->a=erzeuge-dialog-item '*b-static-text-dialog-item*
           :view-position (make-point rand-re/li 10)
           :dialog-item-text (slot-value self 'anfangsbuchstaben-oder-teilwort-text)
           ;(getf init-list :anfangsbuchstaben-oder-teilwort-text
           ;    (b=s :Teilwort))
           :view-font b_chicagoschrift)
          (setf (slot-value self 'stringfeld)
                  (m->a=erzeuge-dialog-item '*b-text*
                   :view-position (make-point rand-re/li 30)
                   :view-size (make-point (- (point-h (view-size self)) (* 2 rand-re/li))
                                          #+ :ccl-2 16 #+ :aclpc 30)))
          (setf (slot-value self 'suchenbutton)
                  (m->a=erzeuge-dialog-item '*b-button*
                   :view-width 100
                   :view-position (make-point ;(slot-value self 'basis-suchen-button)
                                                (- (point-h (view-size self)) 115) #+ :ccl-2 60 #+ :aclpc 80)
                   :dialog-item-text (b=s :suchen)
                   :dialog-item-action 
                   #'(lambda (self)
                          (nh-suchen-button-action (view-container self)
                               #+ :ccl-2
                               (dialog-item-text
                                   (slot-value (view-container self) 'stringfeld))
                               #+ :aclpc
                               (dialog-item-value
                                   (slot-value (view-container self) 'stringfeld))))))
          (setf (slot-value self 'objektfeld)
                  (m->a=erzeuge-dialog-item 
                   #+ :ccl-2 '*b-sequence-dialog-item*
                   #+ :ccl-2 :selektionstyp  #+ :ccl-2 (getf init-list :selektionstyp)
                   #+ :aclpc
                   ;; da allegro zwischen single-item-list und /multi-item-list unterscheidet, muss hier 
                   ;; unterschieden werden
                   (if (eq (getf init-list :selektionstyp) :multiple)
                      'eg-multi
                      'eg-single) 
                   #+ :aclpc :key #+ :aclpc 'second
                   :view-position (make-point rand-re/li (slot-value self 'basis-objektfeld))
                   :view-size (make-point #+ :ccl-2 (point-h (view-size self))
                                          #+ :aclpc (-  (point-h (view-size self)) (* 2 rand-re/li))
                                          ;(+ (slot-value self 'breite-objektzeilen) 15)
                                          ;(+ 15 (* (slot-value self 'anzahl-sichtbarer-objektzeilen) 14)))
                                          (- (point-v (view-size self))
                                             (slot-value self 'basis-objektfeld)
                                             (if (buttons self)  ;falls buttons vorhanden
                                                #+ :ccl-2 40 #+ :aclpc 60      ;Platz fr Buttons lassen
                                                30)))
                   :view-font (slot-value self 'schrift) ;b_normalschrift
                   :cell-size (make-point (- (point-h (view-size self)) (* 2 rand-re/li) 15) 14)
                   ;15 horizontal weniger als das dialog-item wegen scrollbar
                   #+ :ccl-2 :table-sequence #+ :ccl-2 '("")
                   #+ :aclpc :range #+ :aclpc ()
                   #+ :aclpc :set-value-fn  #+ :aclpc 
                   (cond ((eq (getf init-list :selektionstyp) :single) 
                             #' (lambda (dial nachher vorher)
                                     (when nachher
                                          (when (slot-value self 'f-objekt-wurde-selektiert)
                                               (funcall (slot-value self 'f-objekt-wurde-selektiert) (first nachher))))
                                     (when vorher
                                          (when (slot-value self 'f-objekt-wurde-deselektiert)
                                               (funcall (slot-value self 'f-objekt-wurde-deselektiert) (first vorher))))
                                     (when (slot-value self 'f-objekt-wurde-selektiert-oder-deselektiert)
                                          (when (or nachher vorher)
                                               (funcall (slot-value self 'f-objekt-wurde-selektiert-oder-deselektiert) 
                                                   (list (first nachher)))))
                                     (values t nil)))
                            ((eq (getf init-list :selektionstyp) :multiple) 
                             #' (lambda (dial nachher vorher)
                                     (let ((weg-liste (set-difference vorher nachher :key 'first))
                                            (dazu-liste (set-difference nachher vorher :key 'first)))
                                         (when dazu-liste
                                              (when (slot-value self 'f-objekt-wurde-selektiert)
                                                   (mapc #'(lambda (obj)
                                                                    (funcall (slot-value self 'f-objekt-wurde-selektiert) (first obj)))
                                                         dazu-liste)))
                                         (when weg-liste
                                              (when (slot-value self 'f-objekt-wurde-deselektiert)
                                                   (mapc #'(lambda (obj)
                                                                    (funcall (slot-value self 'f-objekt-wurde-deselektiert) (first obj)))
                                                         weg-liste)))
                                         (when (or dazu-liste weg-liste)
                                              (when (slot-value self 'f-objekt-wurde-selektiert-oder-deselektiert)
                                                   (funcall (slot-value self 'f-objekt-wurde-selektiert-oder-deselektiert) 
                                                       (selektierte-objekte dial))))
                                         (values t nil))))
                            ((eq (getf init-list :selektionstyp) :pop-up) 
                             #'(lambda (dial nachher vorher)
                                    (when nachher 
                                         (when (slot-value self 'f-pop-up-menue)
                                              (let ((menu (funcall (slot-value self 'f-pop-up-menue) (first nachher))))
                                                  (when menu 
                                                       (b=pop-up-menue-aufklappen
                                                        (view-container self)
                                                        menu)))))
                                    (values nil nil)))
                            (T #'(lambda(s b c)
                                       (values nil nil)))
                            )
                   :indextyp :wert
                   :f-pop-up-menue (getf init-list :f-pop-up-menue)
                   :f-cursor (getf init-list :f-cursor)
                   :f-objekt-wurde-selektiert (getf init-list :f-objekt-wurde-selektiert)
                   :f-objekt-wurde-deselektiert (getf init-list :f-objekt-wurde-deselektiert)
                   :f-objekt-wurde-selektiert-oder-deselektiert 
                   (getf init-list :f-objekt-wurde-selektiert-oder-deselektiert)
                   :f-doppelklick-objekt (getf init-list :f-doppelklick-objekt)
                   :f-Hintergrundfarbe-Objekt (getf init-list :f-Objekt-Hintergrundfarbe)
                   )))
     ;damit sich nach Erzeugen einer Instanz nicht eine leere selektierbare Zelle im Objektfeld befindet
     (set-table-dimensions (slot-value self 'objektfeld) (make-point 0 0))))

;-------------------------------------------------------------------------------------------------------------------
(defmethod nh-suchen-button-action ((self *b-namen-suchen-window*) string)
     (alles-deselektieren self)
     #+ :aclpc (nh-klick-auf-typenauswahl self)
     ;     (print (slot-value self 'markierte-objekttypen))
     (when (slot-value self 'f-objekte-suchen)    ;suchfunktion vorhanden
           (with-cursor *watch-cursor*
               (let ((objekte (funcall (slot-value self 'f-objekte-suchen)
                                          string
                                          (slot-value self 'markierte-objekttypen))))
                   ;Testausgabe
                   ;(print `(objekte ,objekte))
                   #+ :ccl-2 (setf (werte (slot-value self 'objektfeld)) objekte)
                   (set-table-sequence (slot-value self 'objektfeld)
                        ())
                   (set-table-sequence (slot-value self 'objektfeld)
                        #+ :ccl-2 (do* ((objektids objekte (cdr objektids))
                                           (objektid (car objektids) (car objektids))
                                           (objektliste nil))
                                          ((null objektids) (reverse objektliste))
                                        (setq objektliste
                                             (cons (funcall (slot-value self 'f-objekttext)
                                                            objektid)
                                                  objektliste)))
                        #+ :aclpc (mapcar #'(lambda (obj) (list obj (funcall (slot-value self 'f-objekttext) obj))) objekte)
                        )
        (setf (slot-value self 'selektierte-objekte) nil)
        (setf (slot-value self 'angezeigte-objekte) objekte)))))


;******************************** berdefinierte Systemfunktionen ***************************************************
;--------------------------------------------------------------------------------------------------------------------
#+:ccl-2
(defmethod window-update-event-handler :after ((self *b-namen-suchen-window*))
     (nh-groesse-verandert self)
     )


#+:aclpc
(defmethod resize-window :after  ((ich *b-namen-suchen-window*) position)
     (nh-groesse-verandert ich))

(defmethod nh-groesse-verandert ((self *b-namen-suchen-window*))
     
     (let* ((v-pos-objektfeld (slot-value self 'basis-objektfeld))
             (window-size (view-size self))
             (size-changed (not (eq window-size (slot-value self 'old-size))))
             (rand-re/li-doppelt 30)
             )
         (when size-changed
               (when (slot-value self 'stringfeld)
                     (set-view-size (slot-value self 'stringfeld
                                                ) (make-point (- (point-h window-size) rand-re/li-doppelt) 
                                                        #+ :ccl-2 16 #+ :aclpc 30)))
               (when (slot-value self 'objektfeld)
                     (set-view-size (slot-value self 'objektfeld)
                          (make-point
                                #+ :ccl-2 (point-h window-size)
                                #+ :aclpc (-  (point-h window-size) rand-re/li-doppelt)
                                (- (point-v window-size) v-pos-objektfeld 
                                   (if (buttons self)  ;falls buttons vorhanden
                                      #+ :ccl-2 40 #+ :aclpc 60
                                     30))))    ;Objektfeld bis an unteren Rand des Fensters
                    #-:aclpc
                     (set-cell-size (slot-value self 'objektfeld)
                          (make-point (- (point-h window-size) 15) 14))
                     (farbe-neu-berechnen (slot-value self 'objektfeld))
                     )
               (when (slot-value self 'suchenbutton)
                     (set-view-position (slot-value self 'suchenbutton)
                           (make-point (- (point-h window-size) 115) #+ :ccl-2 60 #+ :aclpc 80)))
               (when (slot-value self 'alle-button)
                     (set-view-position (slot-value self 'alle-button)
                          (make-point (- (point-h window-size) 115) #+ :aclpc 110 #+ :ccl-2 90)))
               (setf (slot-value self 'old-size) window-size))
         ))


;-----------------------------------------------------------------------------------------------------------
(defmethod view-click-event-handler ((self *b-namen-suchen-window*) where)
  ;(print `(handler in window))
  (nh-klick-auf-typenauswahl self)
  (call-next-method self where))


;-----------------------------------------------------------------------------------------------------------
(defmethod view-activate-event-handler ((self *b-namen-suchen-window*))  ;vorher: window-select-event-handler, Ute
  (when (slot-value self 'f-Objekttypauswahl-editierbar-p)
    ;funktion vorhanden
    (setf (slot-value self 'Objekttypauswahl-editierbar-p)
          (funcall (slot-value self 'f-Objekttypauswahl-editierbar-p))))
  (do*
    ((typenauswahl (slot-value self 'Objekttypauswahl) (cdr typenauswahl)) ;kann :trennen enthalten
     (typ (car typenauswahl) (car typenauswahl))                      ;einzelner typ oder :trennen
     (typ-item-text
      (when (not (equal typ :trennen)) (funcall (slot-value self 'f-Objekttypauswahl-Text) typ))
      (when (not (equal typ :trennen)) (funcall (slot-value self 'f-Objekttypauswahl-Text) typ)))
     (editierbar (slot-value self 'Objekttypauswahl-editierbar-p)))
    ((null typenauswahl) nil)
    (when (not (equal typ :trennen))
      ;echter objekttyp
      (if editierbar
        ;then
        (dialog-item-enable (find-dialog-item self typ-item-text))
        ;else
        (dialog-item-disable (find-dialog-item self typ-item-text)))))
  (call-next-method self))

;**************************************************************************************************************


;----------------------------------------------------------------------------------------------------------
(defmethod nh-klick-auf-typenauswahl ((self *b-namen-suchen-window*))
     ;geht alle Typ-buttons durch und weist die markierten buttons dem slot "markierte-objekttypen" zu
     (do* ((typenauswahl (slot-value self 'Objekttypauswahl) (cdr typenauswahl))   ;kann :trennen enthalten
              (typ (car typenauswahl) (car typenauswahl))                        ;einzelner typ oder :trennen
              (typ-item-text (when (not (equal typ :trennen))
                         (funcall (slot-value self 'f-Objekttypauswahl-Text) typ))
                       (when (not (equal typ :trennen))
                         (funcall (slot-value self 'f-Objekttypauswahl-Text) typ)))
        (markierte))
       ((null typenauswahl) (setf (slot-value self 'markierte-objekttypen) markierte))
    (if (not (equal typ :trennen))   ;echter objekttyp
      ;then
      (cond ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :single)
             ; radio-buttons
             (if (radio-button-pushed-p (find-dialog-item self typ-item-text))
               (setq markierte (cons typ markierte))))
            ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :multiple)
             ; check-boxes
             (if (check-box-checked-p (find-dialog-item self typ-item-text))
               (setq markierte (cons typ markierte))))
            (T NIL)))))


;************************************ Schnittstellenfunktionen ********************************************

(defmethod fensterinhalt-loeschen ((self *b-namen-suchen-window*))
     (progn
         (alles-deselektieren self)
         (setf (slot-value self 'selektierte-objekte) nil)
         (setf (slot-value self 'angezeigte-objekte) nil)
         #+ :ccl-2 (set-dialog-item-text (slot-value self 'stringfeld) "")
         #+ :aclpc (set-dialog-item-text (slot-value self 'stringfeld) ())
         #+ :ccl-2 (set-table-sequence (slot-value self 'objektfeld) '(""))
         #+ :aclpc (set-table-sequence (slot-value self 'objektfeld) ())
         (when (slot-value self 'Objekttypauswahl)
               (cond ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :single)
                           ; radio-buttons
                           (progn
                               (setf (slot-value self 'markierte-objekttypen)
                                        (list (slot-value self 'Objekttypauswahl-Voreinstellung)))
                               (radio-button-push (find-dialog-item self 
                                                                    (funcall (slot-value self 'f-Objekttypauswahl-Text)
                                                                        (slot-value self 'Objekttypauswahl-Voreinstellung))))))
                          ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :multiple)
                           ; check-boxes
                           (progn
                               (setf (slot-value self 'markierte-objekttypen)
                                        (slot-value self 'Objekttypauswahl-Voreinstellung))
                               (do* ((typenauswahl (slot-value self 'Objekttypauswahl) (cdr typenauswahl))
                                        (typ (car typenauswahl) (car typenauswahl))
                                        (Objekttypauswahl-Voreinstellung (slot-value self 'Objekttypauswahl-Voreinstellung))
                                        )
                                       ((null typenauswahl) nil)
                                    (when (not (equal typ :trennen))
                                          (if (member typ Objekttypauswahl-Voreinstellung)
                                             ;then
                                             (check-box-check (find-dialog-item self 
                                                                                (funcall (slot-value self 'f-Objekttypauswahl-Text)
                                                                                    typ)))
                                             ;else
                                             (check-box-uncheck (find-dialog-item self 
                                                                                    (funcall (slot-value self 'f-Objekttypauswahl-Text)
                                                                                        typ))))))))
                          (T NIL)))))

;------------------------------------------------------------------------------------------------------  
(defmethod objekt-selektieren ((self *b-namen-suchen-window*) objektid)
     (unless (eq (slot-value self 'selektionstyp) :pop-up)
          (Objekt-selektieren (slot-value self 'objektfeld) objektid)))

;---------------------------------------------------------------------------------------------------------
(defmethod objekte-selektieren ((self *b-namen-suchen-window*) objektids)
     (unless (eq (slot-value self 'selektionstyp) :pop-up)
          (Objekte-selektieren (slot-value self 'objektfeld) objektids)))

;-------------------------------------------------------------------------------------------------------
(defmethod objekt-deselektieren ((self *b-namen-suchen-window*) objektid)
     (unless (eq (slot-value self 'selektionstyp) :pop-up)
          (Objekt-deselektieren (slot-value self 'objektfeld) objektid)))

;-------------------------------------------------------------------------------------------------------
(defmethod objekte-deselektieren ((self *b-namen-suchen-window*) objektids)
     (unless (eq (slot-value self 'selektionstyp) :pop-up)
          (Objekte-deselektieren (slot-value self 'objektfeld) objektids)))

;------------------------------------------------------------------------------------------------------
(defmethod alles-deselektieren ((self *b-namen-suchen-window*))
     (alles-deselektieren (slot-value self 'objektfeld)))


;----------------------------------------------------------------------------------------------------
(defmethod Objekttypauswahl-setzen ((self *b-namen-suchen-window*) objekttypid/s)
     ; Seiteneffekt: Aktualisert den Slot "markierte-objekttypen"
     
  (do* ((Objekttypauswahl (slot-value self 'Objekttypauswahl)
                     (cdr Objekttypauswahl))
        (objekttyp (car Objekttypauswahl) (car Objekttypauswahl))
        (objekttypen-zu-markieren
         (if (listp objekttypid/s)
           ;mehrere objekttypen
           objekttypid/s 
           ;nur ein objekttyp
           (list objekttypid/s)))
        (neu-markierte-objekttypen NIL))
       ((null Objekttypauswahl) (setf (slot-value self 'markierte-objekttypen) neu-markierte-objekttypen))
    (when (not (equal objekttyp :trennen))
      (cond ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :single)
             ; radio-buttons
             (when (member objekttyp objekttypen-zu-markieren)
               (progn
                 (setf neu-markierte-objekttypen (list objekttyp))
                 (radio-button-push (find-dialog-item self 
                                                      (funcall (slot-value self 'f-Objekttypauswahl-Text)
                                                               objekttyp))))))
            ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :multiple)
             ; check-boxes
             (if (member objekttyp objekttypen-zu-markieren)
               ;then markiere
               (progn
                 (setf neu-markierte-objekttypen (cons objekttyp neu-markierte-objekttypen))
                 (check-box-check (find-dialog-item self 
                                                    (funcall (slot-value self 'f-Objekttypauswahl-Text)
                                                             objekttyp))))
               ;else Markierung lschen
               (check-box-uncheck (find-dialog-item self 
                                                    (funcall (slot-value self 'f-Objekttypauswahl-Text)
                                                             objekttyp)))))
            (T NIL)))))



;----------------------------------------------------------------------------------------------------------------
(defmethod selektierte-objekte ((self *b-namen-suchen-window*))
  (selektierte-objekte (slot-value self 'objektfeld)))

;----------------------------------------------------------------------------------------------------------------
(defmethod objekt-position ((self *b-namen-suchen-window*) objektid)
  (objekt-position (slot-value self 'objektfeld) objektid))

