(defclass *b-button-window* (*b-window*)
       (
        (buttons :initform nil :initarg :buttons
              :accessor
              bbw-buttons)
        (buttonzeile-hoehe :initarg :buttonzeile-hoehe
         :initform 25
         :accessor bbw-buttonzeile-hoehe)
        (buttons-abstand :initarg buttons-abstand
         :initform 10 :accessor bbw-buttons-abstand)
        )
      )


(defmethod buttons ((ich *b-button-window*))
     (bbw-buttons ich))

(defmethod initialize-instance :after ((ich *b-button-window*)
                                                                        &rest init-list
                                                                        &key
                                                                         button-so-breit-wie-fenster-p
                                                                        )
      (declare (ignore button-so-breit-wie-fenster-p))
      (when (bbw-buttons ich)
             (bbw-buttons-positionieren ich)
             (apply #'add-subviews ich (bbw-buttons ich))))

(defmethod bbw-buttons-positionieren ((ich *b-button-window*))
     (let* ((y-start (- (window-interior-height ich) -3
                                (bbw-buttonzeile-hoehe ich)))
             (x-gesamt (window-interior-width ich))
               (buttons (bbw-buttons ich))
             (x-pro-button
             (floor
                (- x-gesamt (*  (1+ (length buttons))
                                          (bbw-buttons-abstand ich)))
                (length buttons)))
               (x-start  (bbw-buttons-abstand ich)))
         (dolist (button buttons)
               (set-dialog-item-box button
                     (make-box-relative-from-corner
                      (make-point x-start y-start)
                      x-pro-button 20))
               (incf x-start (+ (bbw-buttons-abstand ich) x-pro-button)))))

(defmethod buttonzeile-hoehe ((ich *b-button-window*))
      (if (bbw-buttons ich)
         (bbw-buttonzeile-hoehe ich) 0))

(defmethod fensterinhaltgroesse ((ich *b-button-window*))
     (make-point (point-h (view-size ich))
           (- (point-v (view-size ich)) (buttonzeile-hoehe ich)))
     )

(defmethod resize-window :after  ((ich *b-button-window*) position)
      (when (bbw-buttons ich)
             (bbw-buttons-positionieren ich))
      )  
#|

(m->a=erzeuge-fenster-local '*b-button-window*
 :user-resizable t
 :buttons (list (m->a=erzeuge-dialog-item '*b-button-dialog-item*
                           :dialog-item-text "Stefan")
                     (m->a=erzeuge-dialog-item '*b-button-dialog-item*
                      :dialog-item-text "Karsten")))
                     
|#