
(defun m->a=erzeuge-dialog-item (objekt &rest args
                                   &key
                                   (view-size (make-position 1 1)
                                      )
                                   (view-position (make-position 1 1))
                                   (dialog-item-text nil)
                                   &allow-other-keys
                                   )
   (if dialog-item-text
      (apply #'make-dialog-item
         :title dialog-item-text
         :Widget objekt
         :box (make-box-from-corners view-position
                 (add-points view-size  view-position))
         args)
      (apply #'make-dialog-item
         :Widget objekt
         :box (make-box-from-corners view-position
                 (add-points view-size  view-position))
         args))
   )

(defmethod m->a=erzeuge-fenster (ich  &rest args)
      (apply #'m->a=erzeuge-fenster-local ich args))


(defmethod m->a=erzeuge-modal-fenster (ich  &rest args)
      (apply #'m->a=erzeuge-fenster-local ich :modal t args))

(defmethod m->a=erzeuge-fenster-local  (klasse
                                                                     &rest args
                                                                     &key view-subviews
                                                                     (modal nil)
                                                                     (vaterfenster *unser-haupt-fenster*)
                                                                     &allow-other-keys)
     (let ((dialog
                (apply #'open-dialog nil  klasse vaterfenster
                     :pop-up-p modal
                     :window-state
                     (if (getf args :window-show t)
                        :normal :shrunk)
                     args)))
         (when view-subviews
              (apply #'add-subviews dialog  view-subviews))
         dialog))

(defun at-stelle-items-sicher (menus/items)
     (mapcar #'test-menu menus/items))

(defun m->a=erzeuge-menu (ich  &rest args)
    (apply #'open-menu 
         (at-stelle-items-sicher (getf args :menu-items))
         ich
         (getf args :location *screen*)
         :selection-function
          (getf args :menu-action
               #'(lambda (menu menu-item stream)
                      (when menu-item
                           (funcall-menu-item
                               menu menu-item stream))))
         :title (getf args :menu-title "Kein Text")
         args
         ))


;; erzeuger funktion fuer menu-item
(defun m->a=erzeuge-menu-item (ich  &rest args)
     (let* ((clos-objekt (apply #'make-instance ich args))
              (strukt
                (make-menu-item
                      :title (bmi-menu-item-title clos-objekt)
                      :value (bmi-menu-item-action clos-objekt)
                      :available-p (not (bmi-disabled clos-objekt))
                      :event-synonym (when (bmi-command-key clos-objekt)
                                                    (list control-key (bmi-command-key clos-objekt)))
                     :plist (list :clos-objekt clos-objekt)
                      ))
             )
         (setf (macemu-das-strukt clos-objekt) strukt)
         strukt
         )
     )