#+:aclnt
(defmethod initialize-instance :after
   ((widget dialog-item)
    &rest initargs)
   (setf (slot-value widget 'cg::plist)
         (cg::dialog-item-initial-plist initargs)
         (slot-value widget 'cg::initargs)
         (copy-list initargs)
         )
   )


(defun wptr (stream)
     (and (windowp stream)
          (not (closed-stream-p stream)))
     )

(defmethod VIEW-SCROLL-POSITION (egal)
     (declare (ignore egal))
     (make-point 0 0))


(defun mac-make-point-reader (stream sub arg)
     (declare (ignore sub arg))
     (cons
         'make-point
         (read stream t nil t)))

(defun mac-trap-reader (stream sub arg)
     (declare (ignore sub arg))
     'quote)

(set-dispatch-macro-character #\# #\@ #'mac-make-point-reader)

(set-dispatch-macro-character #\# #\_ #'mac-trap-reader)

(defvar *screen-width*)
(defvar *screen-height*)
(defvar *menubar-bottom* 0)

(defun b=menubar-bottom ( )
     *menubar-bottom*)

 (let ((groesse (page-box *screen*)))
     (setq *screen-width* (box-width groesse))
     (setq *screen-height* (box-height groesse)))

(defun target ()
      (second (windows *unser-haupt-fenster*)))

(defun find-window (string)
     (find-if #'(lambda(fenster)
                       (string-equal string
                           (window-title fenster)))
        (windows *unser-haupt-fenster*)))

(defun make-point ( a b)
      (make-position a b))

(defun point-h (a)
      (position-x a))

(defun point-v (a)
      (position-y a))

(defun add-points (a b)
      (position+ a b))

(defun subtract-points (a b)
      (position- a b))

(defmethod add-subviews (ich &rest was)
      (dolist (wer was)
            (set-view-container wer ich)))

(defmethod remove-subviews (ich &rest was)
      (dolist (wer was)
            (set-view-container wer nil)))

(defparameter b_normalschrift
    ; (MAKE-FONT :SWISS :SYSTEM 16 '(:BOLD))
     (MAKE-FONT :SWISS :ARIAL 16 nil)
     )

(defparameter b_dickschrift
     (MAKE-FONT :SWISS :ARIAL 16 '(:BOLD)))

(defparameter b_kleinschrift
     (MAKE-FONT :ROMAN :TIMES\ NEW\ ROMAN 16 NIL))

(defparameter b_chicagoschrift
     b_normalschrift)

(defun  b=view-font-info (view)
     (let ((font-metrics (fontmetrics view)))
     (values
          (font-ascent font-metrics)
          (font-descent font-metrics)
          nil
          (font-leading font-metrics))))

(defun b=mittlere-stream-buchstabenbreite (stream)
     (font-average-char-width (fontmetrics stream))
     )

(defun b=stream-ascent (stream)
     (font-ascent (fontmetrics stream))
     )

(defun b=stream-descent (stream)
     (font-descent (fontmetrics stream))
     )

(defun b=stream-schrifthoehe (view)
     (font-height (fontmetrics view))
     )

(defun b=stream-string-width (string stream)
     (stream-string-width stream string))


(defun init-list-default (liste &rest args)
      (do ((l args (cddr l)))
             ((endp l) liste)
            (unless (member (first l) liste)
                  (setq liste
                        (cons (first l)
                              (cons (second l)
                                    liste))))))

(defclass view ()
       ()
      )

(defclass mac-mixin ()
       (
        (view-size :initform nil :initarg :view-size :accessor mac-view-size)
        (view-position :initform nil :initarg :view-position :accessor mac-view-position)
        )
      )

(defmethod initialize-instance :after ((ich mac-mixin) &rest init-list)
   (declare (ignore init-list))
   (when (mac-view-size ich)
      (set-view-size ich (mac-view-size ich)))
   (when (mac-view-position ich)
      (set-view-position ich (mac-view-position ich))))

(defmethod initialize-instance  ((ich mac-mixin) &rest init-list &key view-container)
     (apply #'call-next-method ich
          (init-list-default init-list
              :font (getf init-list :view-font)
              :name (getf init-list :view-nick-name)
              ))
     (when view-container
          (add-subviews view-container ich)))

(defmethod view-font ((ich mac-mixin))
     (dialog-item-font ich))

(defclass mac-fenster-mixin ()
      (
       (key
           :initform nil
           :accessor view-key)
       (doppel-klick-p
           :initform nil
           :accessor view-doppel-klick-p)
       )
     )

(defclass mac-dialog-item-mixin (mac-mixin)
       (
        )
       )

(defmethod dialog-item-width-correction ((ich mac-dialog-item-mixin))
     0)

(defmethod initialize-instance  ((ich mac-dialog-item-mixin) &rest init-list
                                 &key view-container dialog-item-enabled-p)
     (apply #'call-next-method ich
          (init-list-default init-list
              :available-p (getf init-list :dialog-item-enabled-p t)
               )
          )
     )

(defmethod dialog-item-enable ((ich mac-dialog-item-mixin))
     (set-dialog-item-available-p ich t))

(defmethod dialog-item-enabled-p ((ich mac-dialog-item-mixin))
     (dialog-item-available-p ich))

(defmethod dialog-item-disable ((ich mac-dialog-item-mixin))
     (set-dialog-item-available-p ich nil))

(defmethod tatsaechliche-abmessungen ((ich mac-dialog-item-mixin))
     (view-size ich))

(defmethod view-nick-name ((ich mac-dialog-item-mixin))
      (object-name ich))

(defmethod view-container ((ich mac-dialog-item-mixin))
      (let ((f1 (dialog-item-window ich)))
          (if f1
             (window-parent f1) nil))
      )

(defmethod set-view-position ((ich  mac-dialog-item-mixin) h &optional v)
      (let ((vorher (dialog-item-box ich))
              (punkt (if v (make-point h v) h)))
          (set-dialog-item-box ich
          (if vorher
             (make-box-relative-from-corner punkt
              (box-width vorher)
              (box-height vorher))
             (make-box-relative-from-corner punkt 20 20)))))

(defmethod view-size ((ich mac-dialog-item-mixin))
      (let ((box  (dialog-item-box ich)))
      (make-position (box-width box)
             (box-height box)))
      )

(defmethod set-view-size ((ich  mac-dialog-item-mixin) h &optional v)
      (let ((vorher (dialog-item-box ich))
              (punkt (if v (make-point h v) h)))
          (set-dialog-item-box ich
          (if vorher
             (make-box-relative-from-corner (box-top-left vorher)
              (position-x  punkt)
              (position-y punkt)))
             (make-box-relative-from-corner
              (make-point 40 40)
                 (position-x  punkt)
              (position-y punkt)))
         )
      )

(defmethod view-position ((ich mac-dialog-item-mixin))
      (box-top-left (dialog-item-box ich)))

(defmethod set-dialog-item-text ((ich mac-dialog-item-mixin) text)
      (set-dialog-item-title ich text))

(defmethod dialog-item-text ((ich mac-dialog-item-mixin))
      (dialog-item-title ich))


(defmethod default-groesse-p ((ich mac-dialog-item-mixin))
      (position=
            (view-size ich)
            (make-point 1 1)))

(defmethod generic-add-widget ( view widget )
     (add-widget view widget))

(defmethod generic-remove-widget ( view widget )
     (remove-widget view widget))

(defun b-anzahl-returns (string)
     (if (stringp string)
        (count #\return string :test #'char-equal)
        0))

(defmethod set-view-container ((ich mac-dialog-item-mixin)
                                                               view)
      (if view
         (generic-add-widget ich view)
         (generic-remove-widget ich (view-container ich)))
      (when (and view 
                             (default-groesse-p ich)
                             (dialog-item-title ich) (not (string-equal "" (dialog-item-title ich))))
             (multiple-value-bind 
                      (oben-links unten-links
                            oben-rechts unten-rechts)
                     (stream-string-corners view  (dialog-item-title ich))
                    (declare (ignore oben-links unten-links
                                          oben-rechts))
                   (set-dialog-item-box ich
                          (make-box-relative-from-corner (box-top-left (dialog-item-box ich))
                           (+ (dialog-item-width-correction ich) 2
                               (if (view-font ich)
                                  (STRING-WIDTH (dialog-item-text ich)(view-font ich))
                                  (position-x unten-rechts)
                                  ))
                           (* (1+ (b-anzahl-returns (dialog-item-text ich)))
                                 (if (view-font ich)
                                    (+ 2 (b=schrifthoehe  (view-font ich)))
                                    (position-y unten-rechts)))
                           ))))
      
      )

(defmethod view-container ((ich pc::WINDOWS-WIDGET))
     (let ((f1 (dialog-item-window ich)))
         (if f1
            (window-parent f1) nil))
     )

(defmethod set-view-container ((ich pc::WINDOWS-WIDGET) view)
     (if view
        (generic-add-widget ich view)
        (generic-remove-widget ich (view-container ich)))
     )


(defclass *b-dialog-item* (mac-dialog-item-mixin static-text)
       ()
      )

(defclass *B-STATIC-TEXT-DIALOG-ITEM* (mac-dialog-item-mixin static-text)
       ()
      )

(defmethod initialize-instance ((ich *B-STATIC-TEXT-DIALOG-ITEM*)
                                                            &rest init-list
                                                            &key (dialog-item-text "kein text"))
      (apply #'call-next-method ich
            (init-list-default init-list
                :title dialog-item-text
                :value dialog-item-text)))

(defmethod set-dialog-item-text ((ich *b-static-text-dialog-item*) text)
      (set-dialog-item-value ich text))

(defmethod dialog-item-text ((ich *b-static-text-dialog-item*))
      (dialog-item-value ich))



(defclass *b-zahl* (mac-dialog-item-mixin lisp-text)
       ()
      (:default-initargs
       :view-size (make-point 200 25)
       )
      )
      
(defmethod initialize-instance ((ich *b-zahl*) &rest init-list
                                                 &key f-nach-taste
                                                 )
     (apply #'call-next-method ich
              (init-list-default init-list
                  :delayed nil
                  :set-value-fn #'(lambda(objekt  nachher vorher)
                                              (declare (ignore vorher))
                                              (cond ((or (numberp nachher)
                                                              (null nachher))
                                                        (when f-nach-taste
                                                             (funcall f-nach-taste objekt nil))
                                                        (values t nil))
                                                       (T
                                                           (values nil nil))))
                                              ))
     )

(defmethod dialog-item-wert ((ich *b-zahl*))
      (dialog-item-value ich))

(defmethod dialog-item-wert-setzen ((ich *b-zahl*) wert)
      (set-dialog-item-value ich (if (null wert) nil wert)))


(defclass *b-text-mixin* (mac-dialog-item-mixin)
         ()
     )

(defmethod dialog-item-wert ((ich *b-text-mixin*))
     (let ((wert 
                 (dialog-item-value ich)))
         (if (string= "" wert)
            nil wert
            )))

(defmethod dialog-item-wert-setzen ((ich *b-text-mixin*) wert)
     (if (null wert)
        (set-dialog-item-value ich "")
        (set-dialog-item-value ich wert)))

(defmethod set-dialog-item-text ((ich *b-text-mixin*) text)
      (set-dialog-item-value ich text))

(defmethod dialog-item-text ((ich *b-text-mixin*))
      (dialog-item-value ich))

     
(defclass *b-text* (*b-text-mixin* editable-text)
      ()
     ;(:default-initargs :view-size  (make-point 400 25))
     )
      
(defmethod initialize-instance ((ich *b-text*) &rest init-list
                                                 &key f-nach-taste
                                                 )
     (apply #'call-next-method ich
              (init-list-default init-list
                  :view-size (make-point 400 25)
                  :delayed nil
                  :set-value-fn #'(lambda(objekt  nachher vorher)
                                              (declare (ignore   vorher nachher))
                                              (when f-nach-taste
                                                   (funcall f-nach-taste objekt nil))
                                              (values t nil))))
     )

   
(defclass *b-multi-text* (*b-text-mixin* multi-line-editable-text)
      ())
      
(defmethod initialize-instance ((ich *b-multi-text*) &rest init-list
                                                 &key f-nach-taste zeilenzahl
                                                 )
     (let* ((font? (getf init-list :view-font))
            (zeilenhoehe
                 (if font?
                    (b=schrifthoehe font?)
                    20)))
                 
         (apply #'call-next-method ich
              (init-list-default init-list
                  :view-size (make-point 400 (+ 0 (* (or zeilenzahl 3) zeilenhoehe)))
                  :delayed nil
                  :set-value-fn #'(lambda(objekt  nachher vorher)
                                              (declare (ignore   vorher nachher))
                                              (when f-nach-taste
                                                   (funcall f-nach-taste objekt nil))
                                              (values t nil)))))
     )

(defclass *b-radio-button-dialog-item* (mac-dialog-item-mixin radio-button)
       ()
     ;(:default-initargs :3d-border t)
      )


(defmethod dialog-item-width-correction ((ich *b-radio-button-dialog-item*))
     20)

(defmethod radio-button-push ((ich *b-radio-button-dialog-item*))
      (set-dialog-item-value ich t))

(defmethod radio-button-unpush ((ich *b-radio-button-dialog-item*))
      (set-dialog-item-value ich nil))

(defmethod radio-button-pushed-p ((ich *b-radio-button-dialog-item*))
      (dialog-item-value ich))


(defmethod initialize-instance ((ich *b-radio-button-dialog-item*)
                                                 &rest args
                                                 &key
                                                 dialog-item-text
                                                 radio-button-cluster
                                                 dialog-item-action
                                                 radio-button-pushed-p                                                 
                                                 )
     (apply #'call-next-method ich
          :title dialog-item-text
          :value radio-button-pushed-p
          :cluster radio-button-cluster
           :set-value-fn #'(lambda(objekt vorher nachher)
                                      (declare (ignore vorher nachher))
                                      (when dialog-item-action
                                           (funcall dialog-item-action objekt))
                                      (values t nil))
          args)
      )

(defclass *b-check-box-dialog-item* (mac-dialog-item-mixin check-box)
    ()
   ;(:default-initargs :3d-border t)
   )


(defmethod dialog-item-width-correction ((ich *b-check-box-dialog-item*))
     20)

(defmethod initialize-instance ((ich *b-check-box-dialog-item*)
                                                 &rest args
                                                 &key
                                                 dialog-item-text
                                                 dialog-item-action
                                                 CHECK-BOX-CHECKED-P
                                                 )
      
      (apply #'call-next-method ich
         :title dialog-item-text
         :value CHECK-BOX-CHECKED-P
         :set-value-fn #'(lambda(objekt vorher nachher)
                            (declare (ignore vorher nachher))
                            (when dialog-item-action
                               (funcall dialog-item-action objekt))
                            (values t nil))
                     
         args)
   )

 (defmethod check-box-check ((ich  *b-check-box-dialog-item*))
       (set-dialog-item-value ich t))

 (defmethod check-box-uncheck ((ich  *b-check-box-dialog-item*))
       (set-dialog-item-value ich nil))

(defmethod check-box-checked-p ((ich  *b-check-box-dialog-item*))
       (dialog-item-value ich))


;buttons
(defclass *b-button-dialog-item-mixin* (mac-dialog-item-mixin
                                    button)
    ()
   )


(defmethod dialog-item-width-correction ((ich *b-button-dialog-item-mixin*))
   10)

(defmethod initialize-instance ((ich *b-button-dialog-item-mixin*)
                                &rest init-list
                                &key (dialog-item-text "Kein Text")
                                dialog-item-action
                                breite view-width
                                )
   (apply #'call-next-method ich
      (init-list-default init-list
         :view-size
         (if (or breite view-width)
            (make-point (or breite view-width) 20)
            (make-point 120 20))
         :set-value-fn
         #'(lambda(objekt vorher nachher)
              (when dialog-item-action
                 (funcall dialog-item-action ich))
              (values t nil))
         :title dialog-item-text)))

(defclass *b-button-dialog-item* (*b-button-dialog-item-mixin*
                                    button)
    ()
   )

(defmethod initialize-instance ((ich *b-button-dialog-item*)
                                &rest egal)
   (call-next-method))


(defclass *b-button* (*b-button-dialog-item*
                        )
    ()
   )


(defclass *b-ok-button* (*b-button-dialog-item-mixin* default-button
                           )
    ()
   )


(defmethod initialize-instance ((ich *b-ok-button*)
                                &rest init-list
                                )
   (apply #'call-next-method ich
      (init-list-default init-list
         :title "Ok"))
   )


(defclass *b-abbrechen-button* (*b-button-dialog-item-mixin* cancel-button
                                  )
    ()
   )

(defmethod initialize-instance ((ich *b-abbrechen-button*)
                                &rest init-list
                                )
   (apply #'call-next-method ich
      (init-list-default init-list
         :title "Abbrechen"))
   )



;;;;;Sequences



(defclass *bb-sequence-dialog-item*
        (mac-dialog-item-mixin single-item-list)
      ((give-string :initarg :text-des-tabellenelements
           :accessor sequence-give-string
           :initform #'b=erzeuge-string)
       (f-pop-up-menu :initarg :f-pop-up-menu
        :initform nil
        :accessor bb-f-pop-up-menu)
       )
      )
#-:aclnt
(defmethod initialize-instance ((ich *bb-sequence-dialog-item*)
                                                 &rest init-list 
                                                 &key table-sequence)
     (setf (getf (getf init-list 'cg::plist) :key)
             #'(lambda(was)
                    (text-des-tabellenelements ich was)))
     (apply #'call-next-method ich
          :range table-sequence
          :set-value-fn #'(lambda(item neu alt)
                                      (klick-auf-wert item neu alt))
          init-list))

#+:aclnt
(defmethod initialize-instance ((ich *bb-sequence-dialog-item*)
                                &rest init-list 
                                &key table-sequence)
   (apply #'call-next-method ich
      :key  #'(lambda(was)
                 (text-des-tabellenelements ich was))
      :range table-sequence
      :set-value-fn #'(lambda(item neu alt)
                         (klick-auf-wert item neu alt))
      init-list))

(defmethod set-table-sequence ((ich *bb-sequence-dialog-item*) range)
     (set-dialog-item-range ich range))


(defmethod table-sequence ((ich *bb-sequence-dialog-item*))
     (dialog-item-range ich))

(defmethod klick-auf-wert ((ich *bb-sequence-dialog-item*)
                                          neu alt)
     (declare (ignore alt))
     (cond ((and neu (bb-f-pop-up-menu ich))
               (let ((menu (funcall (bb-f-pop-up-menu ich) neu)))
                   (cond (menu
                                  (b=pop-up-menue-aufklappen
                                   (view-container ich)
                                   menu)
                                  (values nil t))
                            (t (values nil t)))))
              (t (values t nil)))
          )

(defmethod text-des-tabellenelements ((ich *bb-sequence-dialog-item*) was)
     (funcall (sequence-give-string ich) was))

#|
(defclass *kp-single-item-list-pane* (pc::SINGLE-ITEM-LIST-PANE)
      ()
     )

(defmethod widget-device ((ich *bb-sequence-dialog-item*) egal)
     '*kp-single-item-list-pane*)

(defmethod event :around ((ich *kp-single-item-list-pane*)
                                           event
                                           shift data time
                                           )
    ; (print `(,event ,shift ,data ,time))
   ;  (print "Hugo")
     )


(defmethod redisplay-window :around ((ich *kp-single-item-list-pane*) &optional was)
     (print "der"))

(defvar der)

(defun foo (number)
     (case number
         (1 "eins")
         (2 "zwei")
         (3 "drei")
         (t "Weiss nicht")))

(defclass *test-sequence* (*bb-sequence-dialog-item*)
      ()
     (:default-initargs
      :text-des-tabellenelements #'(lambda(was)
                    (foo was))
      :table-sequence (list 1 2 3 4 5)
    
      :view-size (make-point 100 100)
      
      )
     )

(setq der
     (m->a=erzeuge-dialog-item '*test-sequence*
     :view-position (make-point 50 50)
      :view-container  (m->a=erzeuge-fenster '*at-fenster*)
      :f-pop-up-menu #'(lambda(neu)
                                (m->a=erzeuge-menu
                                     '*b-menu*
                                     :menu-title "Test"
                                     :menu-items
                                     (list
                                        (M->A=ERZEUGE-MENU-ITEM
                                             '*test-menu-item
                                             :menu-item-title "Der"
                                             :menu-item-action #'(lambda()
                                                                                 (b=nachricht (format nil "~s" neu)))))))
        )
     )

(add-subviews
    
     )
     der)

|#


(defclass *b-icon-dialog-item*
      (mac-dialog-item-mixin static-picture)
    ())

(defmethod initialize-instance ((ich *b-icon-dialog-item*)
                                &rest init-list
                                &key (icon warning-icon)
                                )
   (apply #'call-next-method ich
      :value icon
      :view-size (make-point 32 32)
      init-list))
#|
(m->a=erzeuge-fenster
   '*b-window*
   :view-subviews (list (m->a=erzeuge-dialog-item '*b-icon-dialog-item*)))
|#

(defmethod invalidate-view ((view mac-dialog-item-mixin)
                            &optional loeschen)
  #+:ccl-2 (invalidate-view view loeschen)
  #+:aclpc
  (let ((window (dialog-item-window view)))
    (when window
      (invalidate-window
       window
         (visible-box window)
         loeschen))))
