;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: code-generator -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: the cover for the code-generation parts
-----------------------------------------------------------------------------------
File:    code-generator.em
Version: 2.0 (last modification on Mon Jul 11 11:15:48 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr
CONTACT: 
ingo.mohr@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/code-generator.em[2.0]:
  general part of a simple code generator for SPARC
[1.1] Thu May 27 14:43:41 1993 hfried@isst proposed
  [Thu May 27 12:57:29 1993] Intention for change:
  + code generation for functions oder so wat
  aaa
  done
[1.2] Thu Jun  3 09:10:08 1993 imohr@isst proposed
  [Thu Jun  3 08:18:38 1993] Intention for change:
  code output on screen when debugging
[1.3] Thu Jun  3 10:28:11 1993 imohr@isst proposed
  [Thu Jun  3 10:24:32 1993] Intention for change:
  close of .s-file only when not in debugging mode
[1.4] Thu Aug  5 09:36:58 1993 imohr@isst proposed
  [Mon Jul 19 08:26:31 1993] Intention for change:
  + c-code generation
  C-code generation
[1.5] Tue Aug 17 14:24:14 1993 imohr@isst proposed
  
[1.6] Fri Aug 20 07:57:40 1993 imohr@isst proposed
  [Tue Aug 17 14:30:02 1993] Intention for change:
  --- no intent expressed ---import of apply-configuration
[1.7] Thu Aug 26 09:51:30 1993 imohr@isst proposed
  [Tue Aug 24 11:40:26 1993] Intention for change:
  c-code for data
  ok
[1.8] Mon Aug 30 16:45:28 1993 imohr@isst published
  [Mon Aug 30 13:58:15 1993] Intention for change:
  - reset-c-data
  + configuration
  configuration not yet included
[1.9] Mon Sep 27 11:17:49 1993 imohr@isst published
  [Fri Sep 24 11:09:25 1993] Intention for change:
  deactivate asm-code generation
[1.10] Fri Nov 19 13:42:17 1993 ukriegel@isst proposed
  [Fri Nov 19 06:38:58 1993] Intention for change:
  reset *generate-code* by configuratiop
[1.11] Mon Dec 13 11:55:50 1993 imohr@isst proposed
  [Thu Dec  9 15:14:19 1993] Intention for change:
  + generation of h-file
  generation of h-file for modules with export interface
[1.12] Sat Dec 18 15:46:34 1993 imohr@isst published
  [Fri Dec 17 20:27:48 1993] Intention for change:
[1.13] Wed Feb  9 09:23:02 1994 imohr@isst saved
  
[1.14] Mon Feb 28 10:49:06 1994 imohr@isst saved
  basic system compilation: first step (not yet error free)
[1.15] Thu May  5 11:51:58 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.16] Mon Jun 20 11:54:50 1994 imohr@isst proposed
  [Wed May 11 16:49:22 1994] Intention for change:
  + collection of identifiers of imported program objects
  Beiratssitzung Abschluss
[1.17] Tue Jul 12 09:08:39 1994 imohr@isst proposed
  [Mon Jul 11 11:12:05 1994] Intention for change:
  changing info outputs
[2.0] Tue Jul 12 09:08:39 1994 imohr@isst proposed
  [Mon Jul 11 11:12:05 1994] Intention for change:
  changing info outputs

-----------------------------------------------------------------------------------
|#

#module code-generator
(import 
 (level-1-eulisp
  (only (?configuration configurationp) configuration)
  accessors lzs
  predicates
  c-code
  c-data
  code-identifier
  expand-literal
  (only (reset-code-identifier extend-identifier-table) code-identifier)
  generate-header-file
  generate-def-file
  debugging
  (only (*print-circle* *print-pretty*
         mapc reverse
         open make-pathname string-downcase string format)
    common-lisp))
 
 syntax (level-1-eulisp)

 export (generate-code))

(defvar code-output t)

(defun generate-c-file (main-module modules)
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type "c")
                         :direction :output :if-exists :new-version)))
                  )
       (unwind-protect 
         (generate-c-code main-module modules)
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output))))))

(defun generate-inst-file (main-module modules)
    (reset-c-data)
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type "inst")
                         :direction :output :if-exists :new-version)))
                  )
       (unwind-protect 
         (generate-c-data)
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output))))))

(defun generate-h-file (main-module modules)
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type "h")
                         :direction :output :if-exists :new-version)))
                  )
       (unwind-protect 
         (generate-header-file main-module modules)
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output))))))

(defun generate-def-file (main-module modules)
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type "def")
                         :direction :output :if-exists :new-version)))
                  )
       (unwind-protect 
         (generate-module-def main-module modules)
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output))))))

(defun generate-code (main-module modules)
  (let ((*print-circle* nil)
        (*print-pretty* nil)
        )
    ; to get the definition order of classes reverse the module list such that
    ; the top module is the last one and the most basic is the first one
    (setq modules (reverse modules))

    (reset-code-identifier)
    (reset-c-code)
    (mapc #'collect-c-identifiers modules)
    (map-modules #'expand-literal #'?class-def-list modules)
    (map-modules #'expand-literal #'?sym-list modules)
    ; all functions are needed as objects if they are exported for Lisp
    (map-modules (lambda (fun)
                   (when (exported-for-lisp-p fun)
                     (expand-literal fun))) 
                 #'?fun-list modules)
    (name-objects main-module modules)
    (when (?exports main-module)
      (format t "~%~(~A~).h..." (?identifier main-module))
      (generate-h-file main-module modules))
    (format t "~%~(~A~).c..." (?identifier main-module))
    (generate-c-file main-module modules)
    (format t "~%~(~A~).inst..." (?identifier main-module))
    (generate-inst-file main-module modules)
    (unless (eq *compilation-type* :application)
      (format t "~%~(~A~).def..." (?identifier main-module))
      (generate-def-file main-module modules))
    ))

(defun name-objects (main-module modules)
  (mapc #'name-global-object modules) ; naming the module objects 
  (name-global-object ())
  (mapc (if (eq *compilation-type* :application)
          #'name-exported-object ; do special naming for C-interface
          #'name-global-object) 
        (?exports main-module))
  (mapc #'name-global-objects modules)
  )

(defun name-global-objects (module)
  (when (?toplevel-forms module)
    (name-global-object (?toplevel-forms module)))
  (mapc #'name-global-object (?class-def-list module))
  (mapc (lambda (con)
          (when (or (null (fun-p (?value con)))
                    (function-needed-p (?value con))
                    (imported-p (?value con)))
            (name-global-object con))) 
        (?named-const-list module))
  (mapc (lambda (fun)
          (when (or (function-needed-p fun)
                    (imported-p fun))
            (name-global-object fun)))
        (?fun-list module))
  (mapc #'name-global-object (?var-list module))
  (mapc #'name-global-object (?sym-list module))
  )

(defun collect-c-identifiers (module)
  (labels ((add-c-identifier (object)
             (when (?code-identifier object)
               (extend-identifier-table (?code-identifier object)))))
    (mapc #'add-c-identifier (?fun-list module))
    (mapc #'add-c-identifier (?class-def-list module))
    (mapc #'add-c-identifier (?named-const-list module))
    (mapc #'add-c-identifier (?var-list module))
    (mapc #'add-c-identifier (?sym-list module))
    ))
#module-end ; code-generator
