;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: compiler-conditions -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: macros for compiler conditions
-----------------------------------------------------------------------------------
File:    compiler-conditions.em
Version: 2.0 (last modification on Fri Feb  4 16:53:38 1994)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/compiler-conditions.em[2.0]:
  compiler conditions
[1.1] Thu Apr 15 12:26:11 1993 ukriegel@isst saved
  [Thu Apr 15 12:19:51 1993] Intention for change:
  expose conditions
  done
[1.2] Fri Apr 16 08:57:24 1993 ukriegel@isst proposed
  [Fri Apr 16 06:36:33 1993] Intention for change:
  test.
  imports added, no-handler is called if signal returns nil
[1.3] Thu Sep  2 14:43:38 1993 ukriegel@isst proposed
  [Wed Sep  1 18:11:21 1993] Intention for change:
  imports
  done, onle level-0-eulisp imported
[1.4] Thu Sep  2 15:24:12 1993 ukriegel@isst proposed
  [Thu Sep  2 15:03:30 1993] Intention for change:
  expose of conditions deleted
[1.5] Fri Sep  3 10:53:31 1993 ukriegel@isst saved
  [Fri Sep  3 10:52:03 1993] Intention for change:
  #-cmu for print-object
  #+:cltl2
[1.6] Fri Sep  3 10:55:21 1993 ukriegel@isst published
  [Fri Sep  3 10:54:43 1993] Intention for change:
  #+:cltl2
[1.7] Fri Feb  4 07:29:31 1994 ukriegel@isst saved
  [Fri Feb  4 06:35:58 1994] Intention for change:
  eulisp0 instead of level-0-eulisp
[1.8] Fri Feb  4 09:46:47 1994 ukriegel@isst saved
  [Fri Feb  4 09:43:33 1994] Intention for change:
  [Fri Feb  4 08:48:43 1994] Intention for change:
  --- no intent expressed ---condition-message
[1.9] Fri Feb  4 16:54:50 1994 ukriegel@isst published
  
[2.0] Fri Feb  4 16:54:50 1994 ukriegel@isst proposed
  

-----------------------------------------------------------------------------------
|#

#module compiler-conditions
(import
(eulisp0 
 (only (get-option check-options) option-lists)
 (rename ((format cl:format)
          (defclass cl:defclass)
          (mapcar cl:mapcar)
          (make-instance cl:make-instance)
	  (error cl:error))
   (only (format defclass setf make-instance error) common-lisp)))
syntax (eulisp0)
export (compiler-error define-compiler-condition))



;; local macro definitions
(defmacro define-compiler-condition (name supers format . options)
  `(defcondition ,name ,supers
                           ((message-format :initform ,format :accessor message-format)
                            (message-format-options :initform ',options 
                                                    :accessor message-format-options))))


(defun compiler-error 
       (condition-class   continuation .  option-list) 
  (compiler-error-dispatch (cl:make-instance condition-class) 
                           continuation 
                           option-list))

(defgeneric compiler-error-dispatch 
  (condition  continuation  option-list))

(defmethod compiler-error-dispatch 
           ((condition-instance <condition>) continuation option-list)
  (let ((fmt (message-format condition-instance))
        (options (message-format-options condition-instance)))
    ;;check option list consistency
    (option-lists::check-options options nil nil option-list)
    (let ((fmt-args (cl:mapcar (lambda(x)
                                 (option-lists::get-option x option-list nil)) 
                               options)))
;      (setf (condition-message condition-instance)
;            (apply #'cl:format nil 
;                   (cons fmt fmt-args )))
;      (signal condition-instance continuation)
      (apply #'cl:format t (cons fmt fmt-args) );;only a hack
      (cl:error "~%compiler error signalled for condition ~s~%" condition-instance)
      )))




(defmethod compiler-error-dispatch 
           (condition-instance continuation  option-list)
  (signal condition-instance continuation)
  (cl:error "~%compiler error signalled for condition ~s~" condition-instance))




#module-end

