;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: configuration -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: interface to configuration of apply
-----------------------------------------------------------------------------------
File:    configuration.em
Version: 2.0 (last modification on Fri Feb 11 08:21:53 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/configuration.em[2.0]:
  aux. fcns and defs for configuration tool and #+
[1.1] Thu Nov 18 14:47:42 1993 ukriegel@isst saved
  [Thu Nov 18 13:53:42 1993] Intention for change:
  read configuration-file from dir ApplyModules
  new module syntax , read eu2c.config
[1.2] Fri Nov 19 13:42:24 1993 ukriegel@isst proposed
  [Thu Nov 18 15:04:31 1993] Intention for change:
  new syntax
[1.3] Fri Nov 26 10:56:00 1993 ukriegel@isst proposed
  [Fri Nov 26 10:53:20 1993] Intention for change:
  read configuration file at compilation time
  done
[1.4] Tue Dec  7 17:06:00 1993 imohr@isst proposed
  [Mon Dec  6 16:19:40 1993] Intention for change:
  add extraction of special configuration variables
  add :inline
[1.5] Tue Dec 21 15:32:40 1993 ukriegel@isst proposed
  [Tue Dec 21 15:10:56 1993] Intention for change:
  if key == value error
  done
[1.6] Thu Jan 13 11:18:33 1994 ukriegel@isst proposed
  [Thu Jan 13 07:51:42 1994] Intention for change:
  typing error
  set *static-mm-type* *static-mm-card*
[1.7] Tue Feb  8 16:48:53 1994 akind@isst proposed
  [Tue Feb  8 16:21:34 1994] Intention for change:
  global optimization flag
[1.8] Tue Feb  8 16:57:36 1994 akind@isst published
  [Tue Feb  8 16:57:04 1994] Intention for change:
  --- no intent expressed ---
[1.9] Wed Feb  9 15:07:53 1994 akind@isst proposed
  [Wed Feb  9 11:12:43 1994] Intention for change:
  insert *ti-break*
[1.10] Fri Feb 11 11:54:19 1994 wheick@isst proposed
  [Fri Feb 11 08:09:13 1994] Intention for change:
  export *ti-break*
  done
[2.0] Fri Feb 11 11:54:19 1994 wheick@isst proposed
  [Fri Feb 11 08:09:13 1994] Intention for change:
  export *ti-break*
  done

-----------------------------------------------------------------------------------
|#

#module configuration
(import ((except (member read) eulisp1) 
         (only (read-eulisp $eulisp-readtable) el-modules)
         (rename ((second cl:second)
                  (member cl:member)
                  (set-dispatch-macro-character cl::set-dispatch-macro-character)
                  (error cl:error)
                  (char= cl:char=)
                  (not cl:not)
                  (some cl:some)
                  (every cl:every)
                  (values cl:values)
                  (read cl:read)
                  (with-open-file cl:with-open-file)
                  (make-pathname cl:make-pathname))
           (only (values not some every make-pathname member second
                  read set-dispatch-macro-character error char= with-open-file) 
             common-lisp))
         )
 syntax (eulisp1)
 export (?configuration 
         ?configuration-value
         ?configuration-values
         configurationp
	 *global-optimization*
         init-configuration-table
         *ti-break*))

;;; -----------------------------------------------------------------------------------
;;; initialization of configuration
;;; -----------------------------------------------------------------------------------
(deflocal configuration-table  ())

(defun init-configuration-table ()
  (cl:with-open-file (s (cl:make-pathname 
                         :directory `(,@common-lisp-user::$applyroot "ApplyModules")
                         :name "eu2c.config") :direction :input)
    (setq configuration-table (read-eulisp s))
    (if (eq s configuration-table)
      (progn (cl:error "Error empty configuration file... Exit")
             (exit))
      (initialize-configuration-variables))))

;;; -----------------------------------------------------------------------------------
;;; interface functions
;;; -----------------------------------------------------------------------------------

(defun configurationp (key value)
  (if (cl:member value (cdr(car(cl:member key configuration-table :key #'car))))
    t
    ()))

(defun ?configuration (key)
  (let ((entry (cl:member key configuration-table :key #'car)))
    (and entry (car entry))))

(defun ?configuration-value (key)
  (cl:second (?configuration key)))

(defun ?configuration-values (key)
  (cdr (?configuration key)))

;;; -----------------------------------------------------------------------------------
;;; conditional reader macros for using configuration tests in applications
;;; -----------------------------------------------------------------------------------

(defun read-configuration-expression
       (s macro-char arg)
  (let ((conf (read-eulisp s))
        (expr (read-eulisp s)))
    (if (or (and (cl:char= macro-char #\+)
                 (check-configuration conf))
            (and (cl:char= macro-char #\-)
                 (cl:not (check-configuration conf))))
      expr
      (cl:values)
      )))

(defun check-configuration
       (conf)
  (if (consp conf)
      ()
      (error "~%Error wrong expression ~s for conditional read" conf))
  (let ((op (car conf)))
    (cond ((eq op 'eulisp-symbol::not)
           (cl:not (check-configuration (car (cdr conf)))))
          ((eq op 'eulisp-symbol::or)
           (cl:some #'check-configuration (cdr conf)))
          ((eq op 'eulisp-symbol::and)
           (cl:every #'check-configuration (cdr conf)))
          (t (configurationp (car conf) (car (cdr conf)))))))



(cl:set-dispatch-macro-character #\# #\+ #'read-configuration-expression
                              $eulisp-readtable)
(cl:set-dispatch-macro-character #\# #\- #'read-configuration-expression
                              $eulisp-readtable)
          
;;; -----------------------------------------------------------------------------------
;;; configuration variables
;;; -----------------------------------------------------------------------------------

(defvar *inline* nil) 
; used in function-call
; () - no inlining at all
; 0   - only inlining of slot-accessors and slot-initfunctions if they meet the
;       requirement of (dynamic *inline*) = 1
; n   - inlining takes place if the "complexity" of the function is less than n 
(defvar *info-level* 2)

(defvar *system-info-level* 2)
; 0 no infos, very short warnings and errors
; 1 very short infos
; 2 some infos
; 3 all infos

(defvar *static-mm-type* ^t)
; t  - sytem generates values during compile time
;      only applicable for total and rt-system compilation
; () - results in one additional indirection for each allocation of an instance

(defvar *static-mm-card* ^t)
; t  - sytem generates values during compile time
;      only applicable for total and rt-system compilation
; () - results in one additional indirection for each allocation of an instance

(deflocal *global-optimization* ^t)
; t  - global optimization on; function type schemes are reduced with type
;      schemes of applications (if known)
; () - global optimization off

(deflocal *ti-break* ())
; t  - compilation is suspended if a type clash occurs
; () - compilation is not suspended if a type clash occurs

(defun initialize-configuration-variables ()
  (dynamic-setq *inline* (?configuration-value ^inline))
  (dynamic-setq *info-level* (?configuration-value ^info-level))
  (dynamic-setq *system-info-level* (?configuration-value ^system-info-level))
  (dynamic-setq *static-mm-type* (?configuration-value ^static-mm-type))
  (dynamic-setq *static-mm-card* (?configuration-value ^static-mm-card))
  (setq *global-optimization* (?configuration-value ^global-optimization))
  (setq *ti-break* (?configuration-value ^ti-break))
  )

#module-end
