;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: debugging -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: Tools for Compiler Debugging
-----------------------------------------------------------------------------------
File:    debugging.em
Version: 2.0 (last modification on Thu Feb 10 15:54:29 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/debugging.em[2.0]:
  Some debugging tools for compiler debugging.
[1.1] Thu Apr  1 13:04:52 1993 akind@isst proposed
  [Thu Apr  1 13:01:39 1993] Intention for change:
  Toggle verbose for type inference.
  Toggle verbose for type inference.
[1.2] Fri May  7 15:19:53 1993 akind@isst proposed
  New flag for ti.
[1.3] Fri May  7 15:37:33 1993 akind@isst proposed
  
[1.4] Fri May  7 16:11:07 1993 akind@isst proposed
  
[1.5] Thu May 27 14:34:43 1993 hfried@isst proposed
  
[1.6] Thu Jun  3 08:30:36 1993 imohr@isst proposed
  [Thu Jun  3 08:28:13 1993] Intention for change:
  import interaction functions into package USER
  ok
[1.7] Tue Jul  6 16:09:32 1993 akind@isst published
  [Mon Jul  5 09:59:26 1993] Intention for change:
  Start/end analying a fun.
[1.8] Mon Jan 31 09:30:59 1994 akind@isst proposed
  [Mon Jan 17 13:20:06 1994] Intention for change:
  new compiler flag for global optimization
[1.9] Tue Feb  8 16:28:08 1994 akind@isst proposed
  
[1.10] Tue Feb  8 16:48:57 1994 akind@isst published
  [Tue Feb  8 16:27:32 1994] Intention for change:
  --- no intent expressed ---
[1.11] Wed Feb  9 15:08:51 1994 akind@isst proposed
  [Wed Feb  9 11:11:26 1994] Intention for change:
  insert function info-format
  ,`
[1.12] Fri Feb 11 11:57:54 1994 wheick@isst proposed
  [Thu Feb 10 14:52:24 1994] Intention for change:
  error with dynamic: *ti-break*
  done
[2.0] Fri Feb 11 11:57:54 1994 wheick@isst proposed
  [Thu Feb 10 14:52:24 1994] Intention for change:
  error with dynamic: *ti-break*
  done

-----------------------------------------------------------------------------------
|#

#module debugging
(import
 (eulisp0
  (only (format) common-lisp)
  (only (*ti-break*) configuration))

 syntax 
 (eulisp0
  dynamic
  )

 export ; export-syntax
 (development-mode
  ti-verbose
  ti-break)

 export 
 (*development-mode*		; until macro exp. is hygienic in EL
  *ti-verbose*			; printing on/off during ti
  toggle-ti-verbose
  *ti-break*			; stop/go ahead at type clash
  toggle-ti-break
  toggle-code-debug
  code-debug
  analysed-fun                    ; answer which function is analysed now
  start-analyse-fun
  end-analyse-fun
  info-format)

 expose 
 ((only (*global-optimization*) configuration))
 )

;(expose (only (*global-optimization* *ti-break*) configuration))

(cl:import '(toggle-ti-verbose toggle-ti-break toggle-code-debug analysed-fun) 
           (cl:find-package "USER"))

(deflocal *development-mode* t)

(defmacro development-mode ()
  '*development-mode*)

(deflocal *code-debug* nil)

(defun toggle-code-debug ()
  (if *code-debug*
    (setq *code-debug* ())
    (setq *code-debug* t)))

(defun code-debug () *code-debug*)

;;; Protocol and break flag for type inference
(deflocal *ti-verbose* nil)

(defmacro ti-verbose ()
  '*ti-verbose*)

(defun toggle-ti-verbose ()
  (if *ti-verbose*
      (setq *ti-verbose* nil)
    (setq *ti-verbose* t)))   

(defmacro ti-break ()
  '*ti-break*)

(defun toggle-ti-break ()
  (if *ti-break*
      (setq *ti-break* nil)
    (setq *ti-break* t)))

;;; What function is being analysed? Can be reimplemented with dynamic-let.
(deflocal *analysed-fun* '())

(defun start-analyse-fun (fun)
  (setq *analysed-fun* (cons fun *analysed-fun*)))

(defun end-analyse-fun (fun)
  (setq *analysed-fun* (cdr *analysed-fun*)))

(defun analysed-fun ()
  (if *analysed-fun*
      (car *analysed-fun*)
    nil))

(defun info-format (level string . args)
  (if (>= (dynamic *info-level*) level)
      (apply #'format t string args)))

#module-end
