;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-classes -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: Transformation of class definitions into LZS
-----------------------------------------------------------------------------------
File:    el2lzs-classes.em
Version: 2.0 (last modification on Tue Jul 12 15:42:21 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/el2lzs-classes.em[2.0]:
  transformation rules for class definitions to LZS
[1.1] Wed Mar 24 13:44:52 1993 imohr@isst proposed
  classes and generic functions ok
[1.2] Wed Mar 24 16:49:36 1993 imohr@isst proposed
  class options representation. ok
[1.3] Mon Mar 29 13:31:11 1993 imohr@isst proposed
  [Wed Mar 24 16:51:17 1993] Intention for change:
  --- no intent expressed ---
[1.4] Fri Apr  2 15:59:49 1993 imohr@isst proposed
  literal expansion for classes
[1.5] Tue Apr  6 16:10:30 1993 imohr@isst saved
  + stuff for lattice types
[1.6] Tue Apr  6 17:22:44 1993 imohr@isst saved
  
[1.7] Tue Apr  6 17:28:19 1993 imohr@isst proposed
  
[1.8] Thu Apr  8 15:20:28 1993 imohr@isst proposed
  code generation for classes ok
[1.9] Fri Apr 16 17:09:06 1993 imohr@isst proposed
  error in my english removed
[1.10] Mon Apr 19 15:43:13 1993 imohr@isst proposed
  without warning when searching for a class binding for lattice-types
[1.11] Thu May 27 08:55:35 1993 imohr@isst proposed
  abstract classes with predicate
[1.12] Fri Aug 27 17:12:07 1993 akind@isst proposed
  [Fri Aug 27 15:28:41 1993] Intention for change:
  change %define-lattice-type
[1.13] Tue Sep  7 17:15:42 1993 imohr@isst published
  [Tue Sep  7 16:17:02 1993] Intention for change:
  set setter in readers
[1.14] Thu Sep 23 13:10:58 1993 imohr@isst proposed
  [Tue Sep 21 15:59:22 1993] Intention for change:
  naming generated functions
  and install range-and-domain in slot init functions
[1.15] Thu Sep 30 15:06:27 1993 imohr@isst proposed
  [Thu Sep 30 12:53:22 1993] Intention for change:
  naming of accessors
[1.16] Fri Oct  1 18:48:05 1993 imohr@isst proposed
  [Fri Oct  1 15:46:34 1993] Intention for change:
  correcting naming of accessors
[1.17] Wed Oct 13 15:45:06 1993 imohr@isst proposed
  [Mon Oct 11 13:34:35 1993] Intention for change:
  + initarg-option for slots
[1.18] Fri Oct 15 17:34:31 1993 imohr@isst proposed
  [Fri Oct 15 08:27:45 1993] Intention for change:
  provide slot options reader, accessor and writer to initialize
[1.19] Wed Oct 20 18:44:28 1993 imohr@isst published
  [Wed Oct 20 17:12:18 1993] Intention for change:
  improve error handling
[1.20] Tue Nov  9 11:36:19 1993 imohr@isst proposed
  [Mon Nov  1 13:05:34 1993] Intention for change:
[1.21] Mon Jan 31 09:31:16 1994 akind@isst proposed
  [Mon Jan 10 15:20:24 1994] Intention for change:
  add get-lattice-type (gf)
[1.22] Mon Feb  7 08:26:04 1994 imohr@isst published
  [Wed Feb  2 10:48:13 1994] Intention for change:
  %declare-external-class
  new slot access and imported classes ok
[1.23] Mon Feb 28 10:46:51 1994 imohr@isst saved
  basic system compilation: first step (not yet error free)
[1.24] Thu May  5 11:52:02 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.25] Mon Jun 20 11:54:54 1994 imohr@isst proposed
  [Wed May 11 15:28:37 1994] Intention for change:
  option code-identifier for slots
  Beiratssitzung Abschluss
[1.26] Wed Jun 22 16:44:15 1994 imohr@isst proposed
  [Wed Jun 22 10:39:44 1994] Intention for change:
  removing mm-type
[1.27] Tue Jul 12 15:20:37 1994 imohr@isst saved
  [Tue Jul 12 13:56:41 1994] Intention for change:
  make symbols for initargs
[1.28] Tue Jul 12 15:42:45 1994 imohr@isst proposed
  [Tue Jul 12 15:41:56 1994] Intention for change:
  --- no intent expressed ---
[2.0] Tue Jul 12 15:42:45 1994 imohr@isst proposed
  [Tue Jul 12 15:41:56 1994] Intention for change:
  --- no intent expressed ---

-----------------------------------------------------------------------------------
|#

#module el2lzs-classes
(import (level-1-eulisp 
         el2lzs-rules
         el2lzs-error
         option-lists
         pair-ext 
         list-ext
         tail-module
         lzs-mop
         quasiquote
         (only (set-interpreter call) eval)
         (only (get-defined-lattice-type add-lattice-type
		trans-lattice-type-list) ti-lattice)
         (only (mapcar nconc mapc warn list* reverse vector append) 
           common-lisp))
 syntax (level-1-eulisp 
         el2lzs-main
         (only (prog1) common-lisp))
 export (get-class-or-lattice-type get-lattice-type)
 )

;;; -----------------------------------------------------------------------------------
;;; TS (transsyn)
;;; -----------------------------------------------------------------------------------

(deftranssyn (%define-standard-class class-spec superclass 
                                     slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs representation allocation
                             direct-super-lattice-types)
                           ^(constructor predicate)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(deftranssyn (%define-tail-class class-spec 
                                 slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs representation allocation
                             direct-super-lattice-types)
                           ^(constructor)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(deftranssyn (%define-abstract-class class-spec superclass
                                     slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs direct-super-lattice-types)
                           ^(predicate)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(deftranssyn (%define-metaclass class-spec superclass
                                slot-specs . class-options)
  (with-defining-form 
    (unless (check-options () 
                           ^(initargs representation allocation
                             direct-super-lattice-types)
                           ^(constructor predicate)
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-slot-specs slot-specs)
    (whole-form)))

(defun transsyn-slot-specs (slot-specs)
  (mapc (lambda (slot-spec)
          (check-options () ^(initform type initarg) ^(reader writer accessor)
                         (cdr slot-spec))
          (replace-option-value #'transsyn ^initform (cdr slot-spec)))
        slot-specs))

;;; -----------------------------------------------------------------------------------
;;; TM (transmod)
;;; -----------------------------------------------------------------------------------

(deftransmod (%define-standard-class class-spec superclass 
                                     slot-specs . class-options)
  (transmod-%define-class <standard-class-def> 
                          class-spec superclass 
                          slot-specs class-options))

(deftransmod (%define-tail-class class-spec 
                                 slot-specs . class-options)
  (transmod-%define-class <tail-class-def> 
                          class-spec () 
                          slot-specs class-options))

(deftransmod (%define-abstract-class class-spec superclass 
                                     slot-specs . class-options)
  (transmod-%define-class <abstract-class-def> 
                          class-spec superclass 
                          slot-specs class-options))

(deftransmod (%define-metaclass class-spec superclass 
                                slot-specs . class-options)
  (transmod-%define-class <metaclass-def> 
                          class-spec superclass 
                          slot-specs class-options))

(defun transmod-%define-class (compiler-class class-spec superclass
                               slot-specs class-options)
  (let* ((ID (first class-spec))
         (class (make-instance compiler-class :identifier ID)))
    (add-class class)
    (nconc (list class) 
           (transmod-slot-specs slot-specs)
           (transmod-class-options class-options))))

(defun transmod-slot-specs (slot-specs)
  (let ((accessor-bindings nil))
    (mapc (lambda (slot-spec)
            (map-option-list 
             (lambda (key value)
               (when (member key ^(reader writer accessor))
                 (push (add-const (make-instance <defined-named-const>
                                    :identifier value))
                       accessor-bindings))) 
             (cdr slot-spec)     ; the slot option list
             ))
          slot-specs)
    accessor-bindings))

(defun transmod-class-options (class-options)
  (let ((functions nil))
    (map-option-list 
     (lambda (key value)
       (cond ((eq key ^predicate)
              (push (add-const (make-instance <defined-named-const>
                                 :identifier value))
                    functions))
             ((eq key ^constructor)
              (push (add-const (make-instance <defined-named-const>
                                 :identifier (car value)))
                    functions))
             (t nil)))
     class-options)
    functions))

;;; -----------------------------------------------------------------------------------
;;; TD (transdef)
;;; -----------------------------------------------------------------------------------

(deftransdef (%define-standard-class class-spec superclass 
                                     slot-specs . class-options)
  (with-defining-form
    (transdef-%define-class class-spec superclass slot-specs class-options)))

(deftransdef (%define-tail-class class-spec
                                 slot-specs . class-options)
  (with-defining-form
    (transdef-%define-class class-spec () slot-specs class-options)))

(deftransdef (%define-abstract-class class-spec superclass 
                                     slot-specs . class-options)
  (with-defining-form 
    (transdef-%define-class class-spec superclass slot-specs class-options)))

(deftransdef (%define-metaclass class-spec superclass 
                                slot-specs . class-options)
  (with-defining-form
    (transdef-%define-class class-spec superclass slot-specs class-options)))

(defun transdef-%define-class (class-spec superclass slot-specs class-options)
  ; This function must fill the class definition and the function definitions
  ; for the predicate, the constructor and for all slot accessors
  (let* ((id (first class-spec))
         (metaclass (second class-spec))
         (class-def (find-in-lex-env id))
         (initargs (get-option ^initargs class-options nil))
         (supers (if superclass 
                   (list (find-in-lex-env superclass))
                   nil)))
    (setf (?class class-def) (find-in-lex-env metaclass))
    (mapc #'make-defined-sym initargs)
    (~initialize class-def
        (list ^name id
              ^direct-superclasses supers
              ^direct-slot-descriptions (mapcar (lambda (s)
                                                  (make-slot-spec class-def s))
                                                slot-specs)
              ^direct-initargs (append
                                (slot-initargs slot-specs)
                                initargs)
              ^representation (get-option ^representation class-options nil)
              ^allocation (get-option ^allocation class-options nil)
              ^direct-super-lattice-types 
              (trans-lattice-type-list 
               (get-option ^direct-super-lattice-types class-options nil))
              ))
    (bind-slot-accessors class-def slot-specs)
    (let ((init-forms 
           (reverse (~compute-runtime-initialization class-def))))
      ;; allocator and constructors can be created only 
      ;; after ~compute-runtime-initialization
      (compute&bind-class-functions class-def class-options)
      init-forms)))

(defun bind-slot-accessors (class-def slot-specs)
  (mapc (lambda (slot-spec)
          (let ((slot (~find-slot-description class-def (car slot-spec))))
            (map-option-list 
             (lambda (key value)
               (bind-slot-accessor key value slot))
             (cdr slot-spec))
            (name-slot-accessors slot)))
        slot-specs))

(defun bind-slot-accessor (accessor-type name slot)
  (let ((accessor nil))
    (cond ((eq accessor-type ^reader)
           (setq accessor (~slot-description-slot-reader slot)))
          ((eq accessor-type ^accessor)
           (setq accessor (~slot-description-slot-reader slot))
           (setf (?setter accessor)
                 (~slot-description-slot-writer slot))
           (unless (?identifier (?setter accessor))
             (setf (?identifier (?setter accessor)) (list ^setter name))))
          ((eq accessor-type ^writer)
           (setq accessor (~slot-description-slot-writer slot))))
    (when accessor
      (setf (?value (find-in-lex-env name)) accessor)
      ; the following installs a listed identifier to avoid that two objects 
      ; have the same name (a constant with accessor as value has already the
      ; same name)
      (unless (?identifier accessor)
        (setf (?identifier accessor) (list name)))
      )))

(defun name-slot-accessors (slot)
  ;installs default names for accessors not explicitely named
  (when (and (~slot-description-slot-reader slot)
             (null (?identifier (~slot-description-slot-reader slot))))
    (setf (?identifier (~slot-description-slot-reader slot))
          (list ^reader (~slot-description-name slot)
                ^of (?identifier (?slot-of slot))
                )))
  (when (and (~slot-description-slot-writer slot)
             (null (?identifier (~slot-description-slot-writer slot))))
    (setf (?identifier (~slot-description-slot-writer slot))
          (list ^setter
                (~slot-description-name slot)
                ^of
                (?identifier (?slot-of slot))
                )))
  )

(defun compute&bind-class-functions (class-def class-options)
  ;; ATTN: the allocator has to be created before any constructor 
  ;;       is computed 
  (setf (?allocator class-def) (~compute-allocator class-def))
  (map-option-list
   (lambda (key value)
     (bind-class-function key value class-def))
   class-options))

(defun bind-class-function (function-type spec class)
  (let (function name)
    (cond ((eq function-type ^predicate)
           (setq function (~compute-predicate class))
           (setq name spec))
          ((eq function-type ^constructor)
           (setq function (~compute-constructor class (cdr spec)))
           (setq name (car spec))))
    (when function
      (setf (?value (find-in-lex-env name))
            function)
      ; the following installs a listed identifier to avoid that two objects 
      ; have the same name 
      (unless (?identifier function)
        (setf (?identifier function) (list name)))
      )))

(defun make-slot-spec (class slot-spec)
  (let* ((name (car slot-spec))
        (type-option (find-option ^type (cdr slot-spec) nil))
        (type (and type-option (find-in-lex-env (car type-option))))
        (initform-option (find-option ^initform (cdr slot-spec) nil))
        (initarg-option (find-option ^initarg (cdr slot-spec) nil))
        (reader-option (or (find-option ^reader (cdr slot-spec) nil)
                           (find-option ^accessor (cdr slot-spec) nil)))
        (writer-option (or (find-option ^writer (cdr slot-spec) nil)
                           (find-option ^accessor (cdr slot-spec) nil)))
        )
    (nconc (list ^name name
                 ^reader reader-option  ; used as a flag only for tail classes
                 ^writer writer-option) ; used as a flag only for tail classes
           (when type-option 
             (list ^type type)) 
           (when initform-option 
             (list ^initfunction 
                   (create-slot-init-function class name type
                                              (car initform-option))))
           (when initarg-option
             (make-defined-sym (car initarg-option))
             (list ^initarg
                   (car initarg-option))))))

(defun create-slot-init-function (class slot-name slot-type initform)
  (let ((init-fun 
         (make-instance <slot-init-fun>
           :identifier (list ^init slot-name ^of (?identifier class)))))
    (when slot-type
      (setf (?range-and-domain init-fun) (vector slot-type)))
    (add-function                         ; install it as a global function  
     (complete-function init-fun
                        ()
                        initform
                        (dynamic lex-env)))))

(defun slot-initargs (slot-specs)
  (if (null slot-specs) nil
      (let ((initarg-option (find-option ^initarg (cdar slot-specs) nil)))
        (if initarg-option
          (cons (car initarg-option)
                (slot-initargs (cdr slot-specs)))
          (slot-initargs (cdr slot-specs))))))

;;; -----------------------------------------------------------------------------------
;;; %declare-external-class
;;; -----------------------------------------------------------------------------------

(deftranssyn (%declare-external-class class-spec superclasses 
                                     slot-specs . class-options)
  (with-defining-form 
    (unless (check-options ^(type-identifier 
                             representation) 
                           ^(converter 
                             object-identifier
                             direct-super-lattice-types
                             initargs 
                             language)
                           ()
                           class-options)
      (error-bad-class-options class-options))
    (transsyn-x-slot-specs slot-specs)
    (whole-form)))

(defun transsyn-x-slot-specs (slot-specs)
  (mapc (lambda (slot-spec)
          (check-options () 
                         ^(type initarg c-identifier) 
                         ()
                         (cdr slot-spec)))
        slot-specs))

(deftransmod (%declare-external-class class-spec superclasses 
                                      slot-specs . class-options)
  (let* ((ID (first class-spec))
         (class (make-instance <imported-class> :identifier ID)))
    (add-class class)
    (list class)))

(deftransdef (%declare-external-class class-spec superclasses 
                                      slot-specs . class-options)
  ; the class option 'language' isn't used yet
  (with-defining-form
    (let* ((id (first class-spec))
           (metaclass (second class-spec))
           (class-def (find-in-lex-env id))
           (supers (mapcar #'find-in-lex-env superclasses)))
      (setf (?class class-def) (find-in-lex-env metaclass))
      (setf (?code-identifier class-def) 
            (get-option ^object-identifier class-options nil))
      (setf (?type-identifier class-def) 
            (get-option ^type-identifier class-options nil))
      (~initialize class-def
                   (list ^name id
                         ^direct-superclasses supers
                         ^effective-slot-descriptions 
                         (mapcar (lambda (s)
                                   (make-x-slot-spec class-def s))
                                 slot-specs)
                         ^direct-initargs (append
                                           (slot-initargs slot-specs)
                                           (get-option ^initargs class-options nil))
                         ^direct-super-lattice-types 
                         (trans-lattice-type-list 
                          (get-option ^direct-super-lattice-types class-options
                                      nil))
                         ^converter (trans (get-option ^converter class-options nil))
                         ^representation (get-option ^representation class-options nil)
                         ))
      nil))) ; no initialization form is needed

(defun make-x-slot-spec (class slot-spec)
  (let* ((name (car slot-spec))
         (type-option (find-option ^type (cdr slot-spec) nil))
         (type (and type-option (find-in-lex-env (car type-option))))
         (initarg-option (find-option ^initarg (cdr slot-spec) nil))
         (c-identifier-option (find-option ^c-identifier (cdr slot-spec) nil))
         )
    (nconc (list ^name name)
           (when type-option 
             (list ^type type)) 
           (when initarg-option
             (list ^initarg
                   (car initarg-option)))
           (when c-identifier-option 
             (list ^c-identifier (car c-identifier-option))))))

#module-end
