;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-load -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: Loading of EuLisp sources
-----------------------------------------------------------------------------------
File:    el2lzs-load.em
Version: 2.0 (last modification on Mon Feb 14 16:38:45 1994)
State:   proposed

DESCRIPTION:
EL2LZS-LOAD contains all stuff for loading EuLisp sources, which depends on the
underlying file system and on the Lisp-system in which the compiler is running.

DOCUMENTATION:
The interface function load-apply-module accepts
- a string, which is used as the argument for load
- "", in which case a dialog is opened to ask for the file to be loaded
- a symbol - the name of a module - for which the path is determined using the
content of $apply-module-search-path. The constant $apply-module-search-path
must be set before loading this module. Their name is placed in the CL-package
USER. 

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/el2lzs-load.em[2.0]:
  Lisp-system dependent parts of the frontend for loading module files
[1.1] Fri Mar 19 13:36:44 1993 imohr@isst proposed
  Now the list of available files is calculated exactly once.
[1.2] Thu Apr 15 13:41:03 1993 imohr@isst published
  + warnings and comments for load of apply modules
[1.3] Tue Sep 28 08:14:52 1993 imohr@isst proposed
  [Fri Sep 24 09:12:21 1993] Intention for change:
  add explicitely the file extension .am when loading modules
[1.4] Fri Oct 15 17:34:47 1993 imohr@isst proposed
  [Thu Oct 14 09:29:34 1993] Intention for change:
  new style module headers
[1.5] Wed Oct 20 14:03:37 1993 imohr@isst published
  errors
[1.6] Wed Nov 24 08:47:52 1993 imohr@isst proposed
  
[1.7] Thu Jan 13 15:50:45 1994 imohr@isst saved
  [Thu Jan 13 14:27:48 1994] Intention for change:
  --- no intent expressed ---
[1.8] Thu Jan 13 16:18:43 1994 wheick@isst saved
  
[1.9] Mon Jan 31 09:04:24 1994 wheick@isst published
  [Thu Jan 13 16:15:58 1994] Intention for change:
  eulisp0
  done
[1.10] Mon Feb 28 10:47:01 1994 imohr@isst proposed
  basic system compilation: first step (not yet error free)
[2.0] Mon Feb 28 10:47:01 1994 imohr@isst proposed
  basic system compilation: first step (not yet error free)

-----------------------------------------------------------------------------------
|#


#module el2lzs-load
(import (eulisp1
         el2lzs-error
         (only (first second last directory 
                      merge-pathnames make-pathname
                      string pathname-name pathname string-equal find) 
           common-lisp)
         #+:MCL(only (choose-file-dialog) ccl)
         (only ($apply-module-search-path) user))
 syntax (eulisp1
         (only (with-open-file) 
           common-lisp))
 export (load-apply-module
         load-def-file)
 )

(defun check-module (path module-source)
  (cond ((null (and (consp module-source)
                    ;is it a true list?
                    (null (cdr (last module-source)))
                    ;is it at least (defmodule name directives) ?
                    (<= 3 (length module-source))
                    (eq (first module-source)
                        'ES::defmodule)
                    ;is the module-name a symbol?
                    (symbolp (second module-source))))
         (error-invalid-module-definition module-source path)
         nil)
        ((null (string-equal (string (second module-source))
                             (pathname-name (pathname path))))
         (warning-differing-names-for-module-and-file 
               (second module-source)
               path)
         module-source)
        (t 
           module-source)))

(defun load-module-file (path function)
  (dynamic-let ((*load-level* (+ 1 (dynamic *load-level*))))
     (info-loading-module path)
     (with-open-file (file path :direction :input :if-does-not-exist nil)
       (if file 
         (let ((module-source (check-module path (read file))))
           (if module-source
             (cl:prog1
               (funcall function module-source)
               (info-module-loaded (second module-source)))
             (progn (error-cannot-load-file path) nil)))
         (progn (error-cannot-open-file path) nil)))))

(defvar apply-module-directory nil)

(defconstant $apply-module-file-extension
  (make-pathname :name :wild :type "am"))

(defconstant $def-module-file-extension
  (make-pathname :name :wild :type "def"))

(defvar *apply-module-file-extension* $apply-module-file-extension)

(defun directory-of-apply-modules (pathes)
  (cl:mapcan (lambda (path)
            (directory 
             (merge-pathnames (dynamic *apply-module-file-extension*) 
                              path)))
          pathes))

(defgeneric load-apply-module (module-name-or-path function))

(defmethod load-apply-module ((path <string>) function)
  ; This method is activated only by top level loads and not by implicit ones
  ; (which means not for import handling). Therefore we must compute the list of
  ; available files in every case.
  #+:MCL
  (when (equal path "") 
    (setq path (choose-file-dialog
                :mac-file-type :text
                :button-string "Load")))
  (dynamic-let ((apply-module-directory 
                 (directory-of-apply-modules
                  (cons path $apply-module-search-path))))
    (load-module-file (merge-pathnames path 
                                       (dynamic *apply-module-file-extension*)) 
                      function)))

(defmethod load-apply-module ((name <symbol>) function)
  ; This method is activated by top level loads and by implicit loads for
  ; imports. Only in the first case we must compute the list of all available
  ; files. 
  (dynamic-let ((apply-module-directory 
                 (or (dynamic apply-module-directory) 
                     (directory-of-apply-modules $apply-module-search-path))))
    (let ((file (find (string name) (dynamic apply-module-directory)
                      :key #'pathname-name :test #'string-equal)))
      (if file 
        (load-module-file file function)
        (progn (error-cannot-find-file name) nil)))))

(defun load-def-file (module-name-or-path function)
  (dynamic-let ((*apply-module-file-extension* $def-module-file-extension))
     (load-apply-module module-name-or-path function)))

#module-end


                      