;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs-class-init -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: basic initialisation of the object system
-----------------------------------------------------------------------------------
File:    lzs-class-init.em
Version: 2.0 (last modification on Tue Jul 12 15:19:53 1994)
State:   proposed

DESCRIPTION:


DOCUMENTATION:

NOTES:
The initialization of predefined classes is divided into two steps to break the
circle 
initialization of <class> -> slot-accessors are needed to generate runtime
initialization -> <class> has to be initialized .

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/lzs-class-init.em[2.0]:
  initialization of lzs classes
[1.1] Wed Mar 31 10:39:42 1993 imohr@isst proposed
  + initialization for %object and %class
[1.2] Fri Apr  2 16:04:19 1993 imohr@isst proposed
  [Thu Apr  1 14:58:09 1993] Intention for change:
  initialization of predefined classes
[1.3] Wed Apr  7 09:38:46 1993 imohr@isst proposed
  [Wed Apr  7 09:16:02 1993] Intention for change:
  removing activation of initialize for predefined classes
[1.4] Thu Apr  8 15:20:55 1993 imohr@isst proposed
  code generation for classes ok
[1.5] Mon Apr 19 15:43:07 1993 imohr@isst proposed
  %function
[1.6] Tue Apr 20 16:09:24 1993 imohr@isst proposed
  [Mon Apr 19 15:44:49 1993] Intention for change:
  --- no intent expressed ---init for basic classes (%signed-word-integer.)
[1.7] Fri Apr 30 17:21:42 1993 imohr@isst saved
  + collection of static symbols and generic functions
[1.8] Fri Apr 30 17:23:22 1993 imohr@isst saved
  mapcar imported
[1.9] Mon May  3 13:30:47 1993 imohr@isst proposed
  + lists for statically allocated instances
[1.10] Thu May  6 08:44:49 1993 imohr@isst proposed
  %string
[1.11] Wed Jun  2 10:48:40 1993 imohr@isst proposed
  + initialization of *list-of-new-slot-descriptions*
[1.12] Thu Jun  3 14:37:10 1993 imohr@isst proposed
  slot accessors for %object. are now deleted during initialization
[1.13] Wed Jul 14 15:50:58 1993 imohr@isst proposed
  
[1.14] Thu Aug  5 09:35:11 1993 imohr@isst proposed
  [Thu Jul 22 08:34:10 1993] Intention for change:
  --- no intent expressed ---+ initialization for basic class %string
[1.15] Wed Sep  1 18:07:59 1993 imohr@isst published
  [Tue Aug 31 07:34:23 1993] Intention for change:
  static initialization of basic classes
[1.16] Fri Sep 17 16:00:52 1993 imohr@isst proposed
  [Fri Sep 17 14:00:03 1993] Intention for change:
  put list of collected symbols into module %tail
[1.17] Thu Sep 30 16:16:17 1993 imohr@isst proposed
  [Thu Sep 23 08:11:39 1993] Intention for change:
  + converter
  make slot accessors available in %tail
[1.18] Fri Oct  1 18:47:42 1993 imohr@isst proposed
  [Fri Oct  1 07:16:47 1993] Intention for change:
  provide slot-accessors for %string, %class.
[1.19] Fri Oct 15 17:34:53 1993 imohr@isst published
  [Fri Oct 15 09:09:18 1993] Intention for change:
  + option reader for %string in slot description list for initialize
[1.20] Fri Jan 14 15:20:01 1994 imohr@isst saved
  module-id -> module
[1.21] Wed Jan 19 16:05:24 1994 imohr@isst proposed
  module-id -> module
[1.22] Wed Feb  2 08:56:46 1994 imohr@isst proposed
  [Mon Jan 10 16:17:54 1994] Intention for change:
  removing *list-of-new-slot-descriptions*
[1.23] Mon Feb  7 08:26:38 1994 imohr@isst published
  [Thu Feb  3 08:47:12 1994] Intention for change:
  splitting initialization of predefined classes
  new slot access and imported classes ok
[1.24] Fri Feb 25 11:43:48 1994 wheick@isst proposed
  [Thu Feb 24 15:28:32 1994] Intention for change:
  insert eulisp0,1
  done
[1.25] Thu May  5 11:52:18 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.26] Tue Jul 12 15:20:45 1994 imohr@isst proposed
  [Tue Jul 12 14:09:02 1994] Intention for change:
  make symbols for initargs
[2.0] Tue Jul 12 15:20:45 1994 imohr@isst proposed
  [Tue Jul 12 14:09:02 1994] Intention for change:
  make symbols for initargs

-----------------------------------------------------------------------------------
|#
;;;begin module lzs-class-init

#module lzs-class-init

(import
 (accessors
  eulisp1
  lzs
  lzs-mop
  lzs-modules
  standard-init
  el2lzs
  expand-literal
  tail-module
  apply-funs
  (only (make-defined-sym) el2lzs-main)
  (only (*basic-system* *compilation-type*) predicates)
  (only (make-instance append mapc apply mapcar vector remove-if)
    common-lisp)
  machine-description)
 
 syntax
 (eulisp1 
  apply-standard 
  debugging
  (only (instance-of-p) el2lzs-main)
  (only (setf push)
    common-lisp)
  )
 
 export 
 (initialize-predefined-standard-classes
  initialize-predefined-standard-classes-part-2
  handle-symbols
  )
 )

(defconstant $class-type-descriptor 4)
(defconstant $abstract-class-type-descriptor 5)
(defconstant $tail-class-type-descriptor 6)
(defconstant $%string-type-descriptor 7)

(defgeneric generated-function-p (fun))
(defmethod generated-function-p (fun) nil)
(defmethod generated-function-p ((fun <slot-accessor-fun>)) t)
(defmethod generated-function-p ((fun <slot-init-fun>)) t)
(defmethod generated-function-p ((fun <constructor-fun>)) t)

(defun slot-description-option ()
  (if *basic-system* ^effective-slot-descriptions ^direct-slot-descriptions))

(defun accessor-bindings-needed-p ()
  (null *basic-system*))

(defun class-allocation (alloc-if-defined)
  (if *basic-system* nil alloc-if-defined))

(defun slot-specs-for-class ()
  (list (list ^name ^class-precedence-list 
              ^type %object)
        (list ^name ^slot-descriptions 
              ^type %object)
        (list ^name ^mm-type
              ^type %signed-word-integer)
        (list ^name ^mm-card
              ^type %signed-word-integer)
        (list ^name ^gc-tracer
              ^type %function)
        (list ^name ^converter
              ^type %object)
        (list ^name ^allocator
              ^type %function)
        ))

(defun initialize-predefined-standard-classes ()
(dynamic-let ((*current-module* $tail-module))

   ; remove all generated accessor-functions... created in a previous run for
   ; %object... in module %tail
   (setf (?fun-list $tail-module)
         (remove-if #'generated-function-p (?fun-list $tail-module)))

   (~initialize %object 
                (list ^name ^%object
                      ^direct-superclasses ()
                      (slot-description-option) ()
                      ^direct-initargs ()
                      ^representation ^pointer-to-void
                      ))
   (~initialize %class 
                (list ^name ^%class
                      ^direct-superclasses (list %object)
                      (slot-description-option) 
                      (slot-specs-for-class)
                      ^direct-initargs (let ((initargs ^(name 
                                                         direct-superclasses 
                                                         direct-slot-descriptions 
                                                         direct-initargs)))
                                         (mapc #'make-defined-sym initargs)
                                         initargs)
                      ^representation ^pointer-to-struct
                      ^allocation (class-allocation ^multiple-type-card)
                      ^mm-type $class-type-descriptor
                      ))

   (when (accessor-bindings-needed-p)
     (name-and-export-reader %class ^class-precedence-list 
                             ^%class-precedence-list)
     (name-and-export-reader %class ^slot-descriptions 
                             ^%class-slot-descriptions)
     (name-and-export-accessor %class ^mm-type 
                               ^%class-mm-type)
     (name-and-export-accessor %class ^mm-card 
                               ^%class-mm-card)
     (name-and-export-accessor %class ^gc-tracer 
                               ^%class-gc-tracer)
     (name-and-export-reader %class ^converter 
                             ^%class-converter)
     (name-and-export-reader %class ^allocator 
                             ^%class-allocator)
     )

   (~initialize %abstract-class 
                (list ^name ^%abstract-class
                      ^direct-superclasses (list %class)
                      (slot-description-option) 
                      (if (null *basic-system*)
                        ()
                        (slot-specs-for-class))
                      ^direct-initargs ()
                      ^representation ^pointer-to-struct
                      ^mm-type $abstract-class-type-descriptor
                      ^allocation (class-allocation ^multiple-type-card)
                      ))
   (~initialize %tail-class 
                (list ^name ^%tail-class
                      ^direct-superclasses (list %class)
                      (slot-description-option) 
                      (if (null *basic-system*)
                        ()
                        (slot-specs-for-class))
                      ^direct-initargs ()
                      ^representation ^pointer-to-struct
                      ^mm-type $tail-class-type-descriptor
                      ^allocation (class-allocation ^multiple-type-card)
                      ))
   (~initialize %string 
                ; ATTENTION: %string is an imported class in every case
                (list ^name ^%string
                      ^direct-superclasses ()
                      ^effective-slot-descriptions 
                      (list (list ^name ^length)
                            (list ^name ^element
                                  ^type %unsigned-byte-integer
                                  ^reader (accessor-bindings-needed-p)
                                  ^writer (accessor-bindings-needed-p))
                            )
                      ^direct-initargs (let ((initargs ^(length element)))
                                         (mapc #'make-defined-sym initargs)
                                         initargs)
                      ^representation ^pointer-to-vector
                      ^mm-type $%string-type-descriptor
                      ^allocation ^multiple-size-card
                      ))

   ()

   ; the accessor %string-ref is not yet needed in the implementation of eulisp0
   ; to provide this accessor a different mechanism is necessary because %string
   ; is an imported class
   ;(name-and-export-accessor %string ^element
   ;                            ^%string-ref)

   (mapc #'initialize-basic-class (?class-def-list $tail-module))
   
))

(defun initialize-predefined-standard-classes-part-2 ()
  (unless *basic-system*
(dynamic-let ((*current-module* $tail-module))
   (add-toplevel-forms-for-tail-module 
    (~compute-runtime-initialization %object))
   (add-toplevel-forms-for-tail-module 
    (~compute-runtime-initialization %class))
   (add-toplevel-forms-for-tail-module 
    (~compute-runtime-initialization %abstract-class))
   (add-toplevel-forms-for-tail-module 
    (~compute-runtime-initialization %tail-class))
   (add-toplevel-forms-for-tail-module 
    (~compute-runtime-initialization %string))
   
)))

(defgeneric initialize-basic-class (class))
(defmethod initialize-basic-class (class) nil)
(defmethod initialize-basic-class ((class <%string>)) 
  (setf (?class class) %tail-class)
  (setf (?expanded-literal class) nil)
  (setf (?class-precedence-list class) nil))
(defmethod initialize-basic-class ((class <basic-class-def>)) 
  (setf (?place class) nil)
  (setf (?expanded-literal class) nil)
  (setf (?class class) %tail-class)
  (setf (?class-precedence-list class) nil)
  ;lattice-type is set by the initialization of the type inference
  (~compute-runtime-initialization class) ;only for side effect
  )

(defun handle-symbols (main-module modules)
  (setf (?sym-list main-module) (dynamic symbol-env))
  (when (eq *compilation-type* :application)
    (let ((symtab-initfun
           (make-instance <global-fun>
             :identifier (list ^symbol-table-initializator)
             :params (make-instance <params>
                       :var-list nil
                       :rest nil)
             :body (make-instance <progn-form>
                     :form-list 
                     (mapcar (lambda (sym)
                               (make-instance <app>
                                 :function %add-symbol
                                 :arg-list (list sym)))
                             (dynamic symbol-env))))))
      (setf (?symtab-initfun main-module) symtab-initfun)
      (add-lexical symtab-initfun main-module nil))))

(defun name-and-export-reader (class slot-name reader-name)
  (let ((reader (~slot-description-slot-reader
                 (~find-slot-description class slot-name))))
    (setf (?identifier reader) reader-name)
    (push reader (?lex-env $tail-module))
    (push reader (?exports $tail-module))))

(defun name-and-export-accessor (class slot-name accessor-name)
  (let* ((slot (~find-slot-description class slot-name))
         (accessor (~slot-description-slot-reader slot))
         (writer (~slot-description-slot-writer slot)))
    (setf (?identifier accessor) accessor-name)
    (setf (?identifier writer) (list ^setter accessor-name))
    (setf (?setter accessor) writer)
    (push accessor (?lex-env $tail-module))
    (push accessor (?exports $tail-module))))

#module-end
;;;eof lzs-class-init