;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs-modules -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    lzs-modules.em
Version: 2.0 (last modification on Thu Feb 10 13:23:06 1994)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/lzs-modules.em[2.0]:
  Provides some stuff for working with LZS-modules.
[1.1] Thu Mar 18 13:14:28 1993 imohr@isst proposed
  + import of make-eulisp-class-id from apply-standard
[1.2] Wed Mar 31 10:40:15 1993 imohr@isst proposed
  literals for structures, literal expanders and expose ok
[1.3] Thu Apr 15 08:46:59 1993 imohr@isst proposed
  + tail-environment
[1.4] Thu Jun  3 17:39:54 1993 imohr@isst published
   symbols
[1.5] Wed Nov 24 08:47:11 1993 imohr@isst proposed
  
[1.6] Fri Jan 14 15:12:36 1994 wheick@isst published
  [Fri Jan 14 14:52:06 1994] Intention for change:
  in initialize: :module-id -> :module
[1.7] Fri Feb 11 12:59:52 1994 wheick@isst proposed
  [Thu Feb 10 11:22:16 1994] Intention for change:
  insert eulisp0, 1
  done
[2.0] Fri Feb 11 12:59:52 1994 wheick@isst proposed
  [Thu Feb 10 11:22:16 1994] Intention for change:
  insert eulisp0, 1
  done

-----------------------------------------------------------------------------------
|#

#module lzs-modules

(import 
 ((except (concatenate) eulisp1)
 lzs 
 accessors
 el2lzs-main
 (only (*PRINT-PRETTY* *PRINT-MISER-WIDTH* concatenate cerror intern
                       make-instance mapcar) 
   common-lisp)
 (only (make-eulisp-class-id) apply-standard)
 debugging)
 syntax 
 (eulisp1
  (only (generic-flet push) common-lisp)
  el2lzs-main
  class-ext
  debugging)

 export 
 ($tail-module ; from el2lzs-main
  pp-module
  find-lexical add-lexical
  export-lexical export-syntax-lexical
  tail-environment)
 )

; (export-syntax define-tail)

;;; -----------------------------------------------------------------------------------
;;; add-defined-object (obj module)
;;; -----------------------------------------------------------------------------------
;;; add-defined-object adds obj to one of the modules object-lists fun-list,
;;; class-def-list, named-const-list, var-list and sym-list. Which list must
;;; be modified is decided by the class of the object obj: <fun>, <class-def>,
;;; <named-const>, <var>, <sym> (in the order of object-lists above)
;;; This generic function is needed for get-lexical

(defgeneric add-defined-object (obj module))

(defmethod add-defined-object (obj (module <symbol>))
  (add-defined-object obj (find-module module)))

(defmethod add-defined-object ((obj <fun>) (module <module>))
  (push obj (?fun-list module))
  (push obj (?lex-env module))
  obj)

(defmethod add-defined-object ((obj <class-def>) (module <module>))
  (push obj (?class-def-list module))
  (push obj (?lex-env module))
  obj)

(defmethod add-defined-object ((obj <named-const>) (module <module>))
  (push obj (?named-const-list module))
  (push obj (?lex-env module))
  obj)

(defmethod add-defined-object ((obj <static>) (module <module>))
  (push obj (?named-const-list module))
  (push obj (?lex-env module))
  obj)

(defmethod add-defined-object ((obj <dynamic>) (module <module>))
  (push obj (?var-list module))
  obj)

(defmethod add-defined-object ((obj <sym>) (module <module>))
  (push obj (?sym-list module))
  obj)

;;; -----------------------------------------------------------------------------------
;;; add-lexical (obj module export)
;;; -----------------------------------------------------------------------------------
;;; add-lexical puts the given object in a module such that this object is
;;; acessible under its identifier in this module and appears in one of the
;;; lists of defined objects in the module. An error is signalled if a lexical
;;; binding already exists with the same name as in the identifier-slot of obj.
;;; The result of add-lexical is obj.

(defun add-lexical (obj module export)
  (when (and (development-mode) (find-lexical (?identifier obj) module))
    (cerror "bind ~A with ~A which then shadows the old binding ~A"
            "a lexical binding for ~A already exists"
            (?identifier obj) obj (find-lexical (?identifier obj) module)))
  (add-defined-object obj module)
  (cond ((eq export ^export) (export-lexical obj module))
        ((eq export ^syntax) (export-syntax-lexical obj module)))
  obj)

;;; -----------------------------------------------------------------------------------
;;; find-lexical (identifier module)
;;; -----------------------------------------------------------------------------------
;;; It returns the object which is bound lexically to identifier at module
;;; top-level. As the argument module a symbol (the name of the module) or the
;;; module object itself may be given.

(defgeneric find-lexical (identifier module))

(defmethod find-lexical (identifier (module <symbol>))
  (let ((module (find-module module)))
    (if module 
      (find-lexical identifier module)
      nil)))

(defmethod find-lexical (identifier (module <module>))
  (find-in-env (?lex-env module) identifier))

#| do we need the following stuff ???

;;; -----------------------------------------------------------------------------------
;;; get-lexical identifier module class
;;; -----------------------------------------------------------------------------------
;;;It returns the object which is bound lexically to identifier at module
;;;top-level. If no such object exists, an instance of the given class is created
;;;where the annotations identifier and module are set. All other slots are left
;;;unbound (or initialized as specified in the class-def). The given class must be
;;;<fun>, <class-def>, <named-const>, <var> or <sym> or a subclass of one of
;;;them. 
;;;As the module argument a symbol (the name of the module) or the
;;;module object itself may be given.

(defgeneric get-lexical (identifier module class))

(defmethod get-lexical (identifier (module <symbol>) class)
  (get-lexical identifier (find-module module) class))

(defmethod get-lexical (identifier (module <module>) class)
  (or (find-in-env (?lex-env module) identifier)
      (add-defined-object (make-instance class 
                                   :identifier identifier
                                   :module module))))

|#
;;; -----------------------------------------------------------------------------------
;;; export-lexical lzs-object
;;; export-syntax-lexical lzs-object
;;; -----------------------------------------------------------------------------------

(defun export-lexical (obj module-object)
  (setf (?exports module-object) (cons obj (?exports module-object))))

(defun export-syntax-lexical (obj module-object)
  (setf (?syntax-exports module-object) (cons obj (?syntax-exports module-object))))

;;; -----------------------------------------------------------------------------------
;;; define-tail
;;; -----------------------------------------------------------------------------------
;;;(define-tail identifier export supers . initial-values) installs a basic tail
;;;object and initializes it with the given initial-values. The following things
;;;are done:
;;;* Definition of a class <identifier> as a direct subclass of classes in supers
;;;* Definition of a constant named identifier holding the only instance of
;;;<identifier>, which is initialized according to initial-values
;;;* If export is not NIL the instance is installed in the basic module TAIL, such
;;;that it is lexically available under the name identifier, and it is installed
;;;in the appropriate list of defined objects
;;;* export=EXPORT - the instance is exported from module TAIL
;;;        =SYNTAX - the instance is syntax-exported from module TAIL
;;;        = NIL   - the instance isn't exported and is not included in the
;;;                  module TAIL
;;;* <identifier> and identifier are exported from the current module.
 
(defmacro define-tail (identifier export supers . initial-values)
  (let ((class-id (make-eulisp-class-id identifier)))
    `(progn
       (defstandardclass ,class-id ,(mapcar #'make-eulisp-class-id supers))
       (defconstant ,identifier (make-instance ,class-id 
                                      :identifier ',(make-eulisp-symbol identifier)
                                      :module  $tail-module
                                      ,@initial-values))
       (add-lexical ,identifier $tail-module ',(make-eulisp-symbol export))
       (export ,identifier ,class-id))))

;;; -----------------------------------------------------------------------------------
;;; pretty-printing modules
;;; -----------------------------------------------------------------------------------

(defun pp-module (mod)
(let ((*print-pretty* t)
      (*print-miser-width* nil))
  (print (if (symbolp mod) (find-module mod) mod))))

;;; -----------------------------------------------------------------------------------
;;; retrieving the environment of the module TAIL
;;; -----------------------------------------------------------------------------------

(defun tail-environment ()
  (?exports $tail-module))



#module-end
