;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: mm-initialize-syntax -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    mm-initialize-syntax.em
Version: 2.0 (last modification on Tue Jun 21 11:37:48 1994)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/mm-initialize-syntax.em[2.0]:
  syntax-module for mm-initialize
[1.1] Mon Nov 22 15:24:57 1993 ukriegel@isst saved
  [Mon Nov 22 11:50:37 1993] Intention for change:
[1.2] Tue Nov 23 12:52:55 1993 ukriegel@isst saved
  [Tue Nov 23 07:10:11 1993] Intention for change:
  unbound value
  macros
[1.3] Wed Nov 24 11:07:28 1993 ukriegel@isst published
  [Wed Nov 24 10:44:42 1993] Intention for change:
[1.4] Fri Feb 18 10:18:29 1994 ukriegel@isst saved
  [Fri Feb 18 09:30:39 1994] Intention for change:
  add set-card-descriptor for multiple type cards
  done
[1.5] Fri Feb 18 15:41:54 1994 ukriegel@isst proposed
  [Fri Feb 18 13:03:06 1994] Intention for change:
  --- no intent expressed ---done
[1.6] Fri Feb 25 11:49:03 1994 wheick@isst proposed
  [Thu Feb 24 15:37:03 1994] Intention for change:
  insert eulisp0,1
  done
[1.7] Tue Jun 21 11:39:26 1994 ukriegel@isst proposed
  
[2.0] Tue Jun 21 11:39:26 1994 ukriegel@isst proposed
  

-----------------------------------------------------------------------------------
|#

#module mm-initialize-syntax
(import
 (representation
  tail-module
  (only (?var) accessors)
  (only (get-option check-options) option-lists)
  eulisp0
  expand-literal
  (only ($mtss $stss $stms max-used-card-descriptor max-used-type-descriptor) apply-funs)
  )
 syntax 
(eulisp0
 (rename ((incf cl:incf)
          (push cl:push))
  (only (incf push ) common-lisp)))
 export ( create-runtime-cdscr-initform)
)




;;; -----------------------------------------------------------------------------------
;;; define a dummy generic function to solve package problems 
;;; -----------------------------------------------------------------------------------

(defgeneric create-runtime-cdscr-initform (class cdscr cardtype size tdscr))

(defmacro canonize-multiple-card-descriptors
          (class representation-object size mm-type card-type key descriptor-list )
  `(let ((cds (get-option ,key ,descriptor-list ())))
     (if cds 
        
       (progn
         
         (if (eq (?var ,card-type) $mtss)
          
           ;;set card descriptor again to be independent of module load
           ;;hierarchy
           (create-runtime-cdscr-initform ,class cds
                                          ,card-type ,size ,mm-type)
           ())
         ;;use existing card descriptor
         (setf(?mm-card ,representation-object) 
            (literal-instance %signed-word-integer cds))
         )
       ;;add new cds to list of descriptors and create run-time
       ;;initialization form
       (progn
         (cl:incf max-used-card-descriptor)
         (cl:push max-used-card-descriptor
                  ,descriptor-list)
         (cl:push ,key ,descriptor-list)
         (setf (?mm-card ,representation-object) 
               (literal-instance
                %signed-word-integer max-used-card-descriptor))
         (create-runtime-cdscr-initform ,class max-used-card-descriptor ,card-type ,size ,mm-type)))))

(defmacro literal-instance
          (type . values )
  `(make-literal-instance ,type
                          (list ,@values)))



#module-end
