;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: quasiquote -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: backquote from feel for apply
-----------------------------------------------------------------------------------
File:    quasiquote.em
Version: 2.0 (last modification on Thu Feb 10 13:22:03 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:

CONTACT: 


HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/quasiquote.em[2.0]:
  
[1.1] Fri Feb 11 15:42:42 1994 wheick@isst proposed
  [Thu Feb 10 12:01:46 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Fri Feb 11 15:42:42 1994 wheick@isst proposed
  [Thu Feb 10 12:01:46 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#



#module quasiquote

(import
 ((except (STRINGP append) eulisp1)
  (only (CADAR
         CADR
         ERROR
         STRINGP
         append)
    common-lisp)
  )

 syntax
 (eulisp1)

 export
 (unquote-constructor)
 )

;; Quasi-quoting

(defun unquote-constructor (x)
  (cond ((atom x) 
	 (cond ((or (null x) (numberp x) (stringp x) (eq x t)) x)
	       (t (mkquote x))))
	
	((eq (car x) ^unquote) (cadr x))
	((eq (car x) ^unquote-splicing) 
	 (error "Illegal use of ,@ marker"))
	((eqcar (car x) ^unquote-splicing)
	 (list ^append (cadar x) (unquote-constructor (cdr x))))
;;	((contains-no-unquote x) (mkquote x))
	(t (list ^cons 
		 (unquote-constructor (car x))
		 (unquote-constructor (cdr x))))))

(defun contains-no-unquote (x)
  (cond ((atom x) t)
	((or (eq (car x) ^unquote) (eq (car x) ^unquote-splicing))
	 nil)
	(t (and (contains-no-unquote (car x))
		(contains-no-unquote (cdr x))))))

(defun mkquote (x) (list ^quote x))

(defun eqcar (a b) (cond ((atom a) nil) ((eq (car a) b) t) (t nil)))

;; (defmacro quasiquote (dummy form) (unquote-constructor form))


;(defmacro quasiquote (skel) (unquote-constructor skel))
