;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: type-inference -*-
#|
$__copyright
-------------------------------------------------------------------------------
TITLE: Main Type Inference File
-------------------------------------------------------------------------------
File:    type-inference.em
Version: 2.0 (last modification on Fri Jul  1 15:47:57 1994)
State:   proposed

DESCRIPTION:
Provides type inference functions, that are used in other
parts of the APPLY compiler.

DOCUMENTATION:

NOTES:

REQUIRES:
Other modules that are used for type inference directly or
indirectly by this module are:

ti-signature  Handling Type Schemes (Signatures)
ti-descr      Default Type Descriptors
ti-special    Special Inference with some System (TAIL) Functions
ti-comp       Inference with Compound Lattice Types
ti-const      Type Inference of Constants
ti-init       Initialization of the Typ Inference System
ti-meet-join  Operations on Type Expressions for Type Inference
ti-unify      A Modified Unification Algorithm for Type Inference
ti-eqs        Type Equations for Type Inference
ti-exprs      Type Expressions for Type Inference
ti-copy       Copying Type Inference Objects
ti-write      Formatting Type Inference Objects
ti-lattice    Lattice and Lattice Types Used for Type Inference
ti-codes      Encoding Lattice Types
ti            Auxiliary Functions and Parameters for Type Inference

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/type-inference.em[2.0]:
  
[1.1] Tue Apr  6 14:03:02 1993 akind@isst saved
  [Tue Apr  6 14:02:28 1993] Intention for change:
[1.2] Tue Apr  6 15:38:48 1993 akind@isst saved
  [Tue Apr  6 15:38:27 1993] Intention for change:
  log removed from the file header.
[1.3] Tue Apr  6 15:56:25 1993 akind@isst saved
  [Tue Apr  6 15:55:48 1993] Intention for change:
[1.4] Wed Apr  7 11:47:32 1993 akind@isst proposed
  
[1.5] Wed Apr  7 14:53:34 1993 akind@isst proposed
  
[1.6] Wed Apr  7 15:12:46 1993 akind@isst proposed
  
[1.7] Wed Apr  7 18:02:37 1993 akind@isst proposed
  
[1.8] Tue Apr 13 14:37:22 1993 akind@isst proposed
  
[1.9] Tue Apr 13 14:52:37 1993 akind@isst proposed
  
[1.10] Wed Apr 14 13:30:41 1993 akind@isst proposed
  
[1.11] Fri Apr 16 18:12:27 1993 akind@isst proposed
  
[1.12] Mon Apr 19 18:03:39 1993 akind@isst proposed
  
[1.13] Tue Apr 20 17:37:53 1993 akind@isst proposed
  
[1.14] Wed Apr 21 16:43:32 1993 akind@isst saved
  
[1.15] Fri May  7 10:59:56 1993 akind@isst proposed
  
[1.16] Mon May 10 13:36:52 1993 ukriegel@isst proposed
  [Mon May 10 09:40:47 1993] Intention for change:
  unify-descrs called without fun
  done
[1.17] Tue May 18 17:30:17 1993 akind@isst proposed
  
[1.18] Mon May 24 12:10:35 1993 akind@isst proposed
  
[1.19] Tue May 25 11:08:56 1993 akind@isst proposed
  
[1.20] Tue May 25 11:44:58 1993 akind@isst proposed
  
[1.21] Tue May 25 17:28:19 1993 akind@isst proposed
  
[1.22] Wed May 26 12:12:36 1993 akind@isst proposed
  
[1.23] Thu May 27 10:12:22 1993 akind@isst proposed
  
[1.24] Mon Aug  9 14:30:22 1993 akind@isst proposed
  
[1.25] Mon Aug  9 16:11:38 1993 akind@isst proposed
  
[1.26] Fri Aug 20 17:23:02 1993 akind@isst proposed
  
[1.27] Tue Aug 24 09:32:33 1993 akind@isst proposed
  
[1.28] Tue Aug 24 16:24:51 1993 akind@isst proposed
  
[1.29] Wed Aug 25 17:38:42 1993 akind@isst proposed
  
[1.30] Fri Aug 27 17:29:19 1993 akind@isst published
  
[1.31] Mon Sep 13 13:48:13 1993 akind@isst saved
  New header.
[1.32] Tue Sep 14 12:41:23 1993 akind@isst saved
  [Mon Sep 13 14:11:34 1993] Intention for change:
[1.33] Tue Sep 21 09:13:25 1993 akind@isst saved
  [Tue Sep 21 09:07:08 1993] Intention for change:
[1.34] Tue Sep 21 14:46:02 1993 akind@isst proposed
  [Tue Sep 21 14:43:24 1993] Intention for change:
[1.35] Wed Sep 22 09:01:17 1993 akind@isst proposed
  [Wed Sep 22 09:00:18 1993] Intention for change:
[1.36] Wed Sep 22 17:28:09 1993 akind@isst proposed
  [Wed Sep 22 17:27:29 1993] Intention for change:
[1.37] Thu Sep 23 14:34:37 1993 akind@isst proposed
  
[1.38] Fri Sep 24 10:04:54 1993 akind@isst saved
  
[1.39] Fri Oct  1 14:40:05 1993 akind@isst saved
  [Mon Sep 27 10:14:38 1993] Intention for change:
[1.40] Mon Oct 11 10:29:00 1993 akind@isst proposed
  
[1.41] Tue Oct 12 17:12:13 1993 akind@isst published
  
[1.42] Thu Oct 21 15:03:00 1993 akind@isst saved
  
[1.43] Tue Nov  2 16:21:09 1993 akind@isst saved
  
[1.44] Tue Nov  9 17:28:20 1993 akind@isst saved
  
[1.45] Tue Nov 16 13:11:43 1993 akind@isst proposed
  
[1.46] Thu Nov 18 09:55:46 1993 akind@isst proposed
  
[1.47] Thu Nov 18 17:12:23 1993 akind@isst proposed
  
[1.48] Thu Dec  9 16:58:27 1993 akind@isst proposed
  
[1.49] Tue Jan  4 11:46:39 1994 akind@isst saved
  [Fri Dec 10 09:31:11 1993] Intention for change:
[1.50] Wed Jan 19 13:20:25 1994 akind@isst saved
  
[1.51] Mon Jan 31 09:35:33 1994 akind@isst proposed
  [Tue Jan 11 09:54:21 1994] Intention for change:
  --- no intent expressed ---
[1.52] Mon Feb  7 09:30:17 1994 akind@isst published
  [Tue Feb  1 10:53:43 1994] Intention for change:
  --- no intent expressed ---
[1.53] Wed Feb  9 15:08:12 1994 akind@isst proposed
  [Wed Feb  9 14:18:07 1994] Intention for change:
  --- no intent expressed ---
[1.54] Tue Jul  5 09:06:10 1994 jbimberg@isst proposed
  [Tue Jul  5 09:05:15 1994] Intention for change:
  setq *...-subset* ()
[2.0] Tue Jul  5 09:06:10 1994 jbimberg@isst proposed
  [Tue Jul  5 09:05:15 1994] Intention for change:
  setq *...-subset* ()

-------------------------------------------------------------------------------
|#

#module type-inference
(import (ti lzs lzs-mop mzs lzs-modules tail-module apply-funs analyse-h
	    name-of-fun
	    ti ti-lattice  ti-exprs ti-eqs ti-write ti-copy ti-comp
	    ti-meet-join ti-signature ti-const ti-descrs ti-special
	    (only (mapc mapcar dotimes format terpri delete-if-not)
		  common-lisp))
 syntax (ti)
 export (inference inference-get-slot-value inference-set-slot-value
	 balance balance-applications constant-type
	 filled-formal-descr filled-recursive-descr filled-actual-descr
	 general-var-formal-descr general-var-recursive-descr
	 general-var-actual-descr
	 empty-formal-descr empty-recursive-descr empty-actual-descr
	 get-descr-type set-descr-type get-previous-subs
	 set-signature set-signature-from-classes set-predicate-signature
	 reduce-descr set-joined-result-types
	 convert-to-sys-type-vec class-as-type-expr
	 check-result-subtypes check-subtype-exprs
	 initialize-lattice general-type %object-type
	 copy-descr-up-to ti-copy-subs
	 ti-format ti-short-write ti-def-write))

;;; ---------------------------------------------------------------------------
;;; SPECIALIZING ACTUAL TYPE DESCRIPTORS
;;; ---------------------------------------------------------------------------

;; Inference step, i.e. a function is called with an actual type scheme.
(defun inference (fun incomming-descrs)
  (ti-statistics *fun-call-key*)
  (ti-format t "~%Notice: check-compound-types ~A" (name-of fun))
  (let (new-incomming-descrs
	result-descrs)	; treat compound type?
    (setq new-incomming-descrs
      (if *use-compound-types*	
	  (delete-if-not #'check-compound-types-before incomming-descrs)
	incomming-descrs))
    (setq *actual-method-subset* ())
    (setq result-descrs (compute-inference fun new-incomming-descrs))
    (if *use-compound-types*
	(setq result-descrs
	  (delete-if-not #'check-compound-types-after result-descrs)))
;;    (if cl::*p*
;;	(format t "~%== NEW DESCRS:~A" (ti-print-string result-descrs)))
    result-descrs))

(defgeneric compute-inference (fun descrs))

(defmethod compute-inference ((fun <fun>) descrs)
  (let ((formal-descrs ())
	(standard-inference nil))
    (cond ((eq fun %extract)
	   (setq formal-descrs (convert-to-formal-descrs-%extract descrs))
	   (setf (?signature fun) formal-descrs))
	  ((eq fun %setf-extract)
	   (setq formal-descrs (convert-to-formal-descrs-%setf-extract descrs))
	   (setf (?signature fun) formal-descrs))
	  ((eq fun %funcall)
	   (setq formal-descrs (convert-to-formal-descrs-%funcall descrs))
	   (setf (?signature fun) formal-descrs))
	  (t
	   (setq formal-descrs (?signature fun))
	   (setq standard-inference t)))
;;    (if cl::*p*
;;	(progn
;;	  (format t "~%== FUNCTION DESCRS:~A" (ti-print-string fun))
;;	  (format t "~%== ACTUAL DESCRS:~A"
;;		  (ti-print-string
;;		   (mapcar (lambda (descr)
;;			     (get-previous-subs (ti-copy-descr descr)))
;;			   descrs)))))
    (if formal-descrs			; uncomplete signature?
	(if standard-inference
	    (unify-descrs fun descrs formal-descrs)
	  (unify-descrs fun descrs formal-descrs t))
      (let ((range-and-domain-descr (?type-descr fun)))
	(if range-and-domain-descr
	    (unify-descrs fun descrs (list range-and-domain-descr))
	  (mapcar #'get-previous-subs descrs))))))

(defmethod compute-inference ((fun <defined-generic-fun>) descrs)
  (ti-format2 t "~%== GENERIC FUNCTION DESCRS:~A" (ti-print-string fun))
  (if (null (?signature fun))
      (ti-format2 t "~%~A" (?identifier fun)))
  (ti-format2 t "~%== ACTUAL DESCRS:~A"
	      (ti-print-string
	       (mapcar (lambda (descr)
			 (get-previous-subs (ti-copy-descr descr)))
		       descrs)))
  (let* ((formal-descrs (?signature fun))
	 (result-descrs
	  (if formal-descrs
	      (unify-descrs fun descrs formal-descrs)
	    (let ((range-and-domain-descr (?type-descr fun)))
	      (if range-and-domain-descr
		  (unify-descrs fun descrs (list range-and-domain-descr))
		(mapcar #'get-previous-subs descrs))))))
    (setq *actual-method-subset*
      (select-methods fun result-descrs))
;;    (cond (*ti-verbose*
;;	   (terpri) (terpri)
;;	   (ti-short-write t (mapcar #'ti-copy-descr result-descrs))
;;	   (terpri)
;;	   (ti-short-write-methods t (?method-list fun))
;;	   (format t "~%Notice: reduced possible methods ~A -> ~A"
;;		      (length (?method-list fun))
;;		      (length *actual-method-subset*))
;;	   (ti-short-write-methods t *actual-method-subset*)
;;	   (terpri) (terpri)))
    (ti-format2 t "~%== NEW DESCRS:~A" (ti-print-string result-descrs))
    (if (null *actual-method-subset*)
	(ti-error))			; no applicable method!
    result-descrs))

(defun inference-get-slot-value (descrs slot-description)
  (let ((formal-descrs (formal-descrs-get-slot-value descrs slot-description))
	(fun %select))
    (setf (?signature fun) formal-descrs)
    (unify-descrs fun descrs formal-descrs t)))

(defun inference-set-slot-value (descrs slot-description)
  (ti-statistics *%setf-select-key*)
  (let ((formal-descrs (formal-descrs-set-slot-value descrs slot-description))
	(fun %setf-select))
    (setf (?signature fun) formal-descrs)
    (unify-descrs fun descrs formal-descrs t)))

;;; Condense descriptor list to a single descriptor.
(defun balance (descrs)
  (join-descrs-min (ti-copy-descr (car descrs)) (cdr descrs)))

;;; Condense application descriptor list to a single descriptor.
(defun balance-applications (fun applications)
  (let* ((new-descr (balance (mapcar #'?type-descr applications)))
	 (old-descr (balance (?type-descr-s fun)))
	 (new-result-type (get-result-type new-descr))
	 (old-result-type (get-result-type old-descr))
	 (optimized ()))
;    (format t "g")			; mark global optimization
    (cond ((%void-type-p new-result-type)
	   (set-result-type-min new-descr old-result-type))
	  ((true-subtype-expr-p old-result-type new-result-type)
	   (set-result-type-min new-descr old-result-type)))
    ;;      (cond (*ti-verbose*
    ;;	     (dotimes (i (length (?type-vec new-descr)))
    ;;	       (setq optimized
    ;;		 (or (null (and (subtype-expr-p
    ;;				 (get-arg-type old-descr i)
    ;;				 (get-arg-type new-descr i))
    ;;				(subtype-expr-p
    ;;				 (get-arg-type new-descr i)
    ;;				 (get-arg-type old-descr i))))
    ;;		     optimized)))
    ;;	     (if optimized
    ;;		 (progn
    ;;		   (format t "~2%Global optimization of ~A function ~A::~A~%"
    ;;			   (funtype-of fun)
    ;;			   (?module-id fun)
    ;;			   (name-of fun))
    ;;		   (ti-short-write t new-descr)
    ;;		   (format t "~%    instead of~%")
    ;;		   (ti-short-write t old-descr)))))
    new-descr))

#module-end