;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: collection -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: standard module collection
-----------------------------------------------------------------------------------
File:    collection.em
Version: 2.0 (last modification on Thu Jan 13 09:02:23 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/collection.em[2.0]:
  
[1.1] Wed Mar 10 13:11:19 1993 imohr@isst proposed
  [Mon Mar  8 14:34:04 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Thu Apr 15 09:40:05 1993 imohr@isst saved
  ok
[1.3] Thu Apr 15 11:27:42 1993 imohr@isst published
  map for NULL as result class
[1.4] Tue Jan  4 11:21:27 1994 wheick@isst saved
  [Tue Nov  9 13:56:59 1993] Intention for change:
  complete like 0.99
[1.5] Thu Jan 13 09:11:07 1994 wheick@isst published
  insert <collection>
[2.0] Thu Jan 13 09:11:07 1994 wheick@isst proposed
  insert <collection>

-----------------------------------------------------------------------------------
|#

#module collection

(import 
 (eulisp-kernel
  list
  (only (<vector>) vector)
  (only (<string>) string)
  (only (<table>) table)
  (only (<character>) character)
  function
  (only (<cons> <null> <list> nil) list)
  (only (type-of
         coerce
         get
         ;funcall
         ;apply
         car
         cdr 
         length 
         elt + = cons eq list print < string vector error
         ) common-lisp)
  (rename ((map cl:map)
           (find cl:find)
           (concatenate cl:concatenate)
           (fill cl:fill))
            common-lisp))

 syntax
 (eulisp-kernel
  (only (defsetf setf case) common-lisp)
  )

 export 
 (
  accumulate 
  accumulate1 
  anyp 
  collectionp 
  concatenate 
  do 
  element 
  setter-element 
  emptyp 
  fill
  map
  member
  sequencep
  size)

 expose
 ((only (reverse) common-lisp))
 )


(make-eulisp-class collection sequence)


;(defun member (element collection)
;(find element collection))

#+(and :ALLEGRO :FRANZ-INC)
(defun franz-type-of (object)
  (let ((type (type-of object)))
    (case type
      ((cl:cons cl:null) 'cl:list)
      (t type))))

;(defun map (function collection)
;(cl:map (#-(and :ALLEGRO :FRANZ-INC) type-of 
;         #+(and :ALLEGRO :FRANZ-INC) franz-type-of
;         collection) 
;        function collection))


(deflocal $end-string "end of collection")


;;;---------------------------------------------------------------
;;; converter
;;;---------------------------------------------------------------
;;; e.g.: (convert '(a b c) <list>)



;(defmacro convert (collection dest-class)
;  `(let ((coll ,collection) (class ',dest-class))
;     (coerce coll 
;          (case class
;            (<list> 'cl:list)
;            (<null> 'cl:list)
;            (<vector> 'cl:vector)
;            (<string> 'cl:string)
;            (<character> 'cl:character)
;            (t nil)))))


;;;       #######
(defmacro convert (collection dest-class)
;;;       #######
  `(let ((coll ,collection) (class ,dest-class))
     (coerce coll 
          (cond 
            ((eq class <list>) 'cl:list)
            ((eq class <null>) 'cl:list)
            ((eq class <vector>) 'cl:vector)
            ((eq class <string>) 'cl:string)
            ((eq class <character>) 'cl:character)
            (t nil)))))

;;;------------------------------------------------------------
;;; accumulate
;;;------------------------------------------------------------------

;;;          ##########
  (defmethod accumulate ((function <function>)
;;;          ##########
                         (object <object>)
                         (lst <cons>))
    (map-accumulate-list function lst object))

;;;          ########## 
  (defmethod accumulate ((function <function>)
;;;          ##########
                         (object <object>)
                         (lst <null>))
    object)


  (defun map-accumulate-list (function lst res)
    (if (consp lst)
      (map-accumulate-list function 
                      (cdr lst)
                      (funcall function res (car lst)) 
                      )
      res))
;;;          ##########  
  (defmethod accumulate ((function <function>)
;;;          ########## 
                         (object <object>) 
                         (vec <vector>))
    (map-accumulate-vector function vec object (length vec) 0))
  
  
  (defun map-accumulate-vector (function vec res max-len index) 
    (if (< index max-len)
      (map-accumulate-vector function 
                             vec
                             (funcall function res (elt vec index)) 
                             max-len
                             (+ index 1))
      res))
  
;;;          ##########
  (defmethod accumulate ((function <function>) 
;;;          ##########
                         (object <object>) 
                         (str <string>))
    (map-accumulate-vector function str object 
                    (length str) 0))



;;;------------------------------------------------------------      
;;; accumulate1
;;;------------------------------------------------------------


;;;          ###########  
  (defmethod accumulate1 ((function <function>)
;;;          ###########
                          (lst <cons>))
    (map-accumulate-list function (cdr lst) (car lst)))

;;;          ###########  
  (defmethod accumulate1 ((function <function>)
;;;          ###########
                          (lst <null>))
    lst)
  

;;;          ###########  
  (defmethod accumulate1 ((function <function>)
;;;          ###########
                          (vec <vector>))
    (if (= (length vec) 0)
      ()
      (map-accumulate-vector function vec 
                      (elt vec 0) ;initial element
                      (length vec)
                      1))) ;start is second element
  
 
;;;          ###########
  (defmethod accumulate1 ((function <function>)
;;;          ########### 
                          (str <string>))
    (if (emptyp-string str)
      nil
      (map-accumulate-vector function str 
                      (elt str 0)
                      (length str)
                      1)))
  (defun emptyp-string (str)
    (if (= (length str) 0)
      t 
      ()))

;;;------------------------------------------------------------      
;;; anyp
;;;------------------------------------------------------------


;;;          ####
  (defmethod anyp ((function <function>)
;;;          ####
                    (lst <cons>) . more-collections)
   (anyp-collection function lst more-collections))

  
;;;          ####
  (defmethod anyp ((function <function>)
;;;          ####
                    (lst <null>) . more-collections)
  nil)


;;;          ####
  (defmethod anyp ((function <function>)
;;;          ####
                   (str <vector>) . more-collections)
    (anyp-collection function str more-collections))


;;;          ####
  (defmethod anyp ((function <function>)
;;;          ####
                   (str <string>) . more-collections)
    (anyp-collection function str more-collections))

;;;      ###############
  (defun anyp-collection (function lst  more-collections)
;;;      ###############
    (anyp-with-apply 
     function 
     (mapc-more-collections 
      (cons 
       lst 
       more-collections))
     ))

  (defun mapc-more-collections (li)
    (cons (construct-collection-info (car li)) 
            (mapc-more-collections1 (cdr li) nil))
    )

(defun mapc-more-collections1 (li res)
  (if li 
    (mapc-more-collections1 
     (cdr li)
     (cons (construct-collection-info (car li)) res))
    
    res))

  (defun anyp-with-apply (function collection-list)
    (let ((first-apply-arg 
           (take-next-elt (car (car collection-list)) 
                          collection-list)) 
          (rest-elts 
           (apply-rest-list 
              (cdr collection-list) nil)))
      ;(print first-apply-arg)
      ;(print rest-elts)
      (if 
        (if (eq first-apply-arg $end-string)
            t
            (if (eq rest-elts $end-string)
                t
                nil))
          nil
          (if (apply function               
                 first-apply-arg 
                 rest-elts)
                t
               (anyp-with-apply function collection-list)))))
  

  (defmethod construct-collection-info  ((collection <list>))
    (cons collection nil))
  

  (defmethod construct-collection-info  ((collection <vector>))
    (list collection 0))

  (defmethod construct-collection-info  ((collection <string>))
    (list collection 0))

  (defmethod construct-collection-info (collection)
    (print "unknown type for collection"))
  
  (defun apply-rest-list (collection-list result-list)
    (if collection-list
      (let ((next-elt 
             (take-next-elt (car (car collection-list))
                            collection-list)))
        (if (eq next-elt $end-string)
          $end-string
          (apply-rest-list (cdr collection-list) 
                           (cons next-elt result-list))
          ))
      result-list))

  
  (defmethod take-next-elt ((element <list>) (collection <object>))
    (next-list-elt collection))

  (defmethod take-next-elt ((element <vector>) (collection <object>))
    (next-vector-elt collection))

  (defmethod take-next-elt ((element <string>) (collection <object>))
    (next-vector-elt collection))

  
  (defun next-list-elt (liste)
    (let ((one-arg-list (car liste))
          (lst (car (car liste))))
      (if lst
        (progn (setf (car one-arg-list)   ;set cdr of list
                     (cdr lst))
               (car lst))
        $end-string)))
  
  
  ;;;list of table-infos:: ((vector index) ...)
  ;;;for vectors too!

  (defun next-vector-elt (collection-info)
    (let ((index (car (cdr (car collection-info))))
          (vector (car (car collection-info))) 
          res)
      (if (< index (length vector)) ;=lenght of vector
        (progn
          (setq res 
                (elt vector index)) ;give element
          (setf (car (cdr (car collection-info)))        ;set index
                (+ index 1))
          res)
        $end-string)))
  
   
;;;        ###########
(defmethod collectionp ((object <list>)) t)
;;;        ###########

(defmethod collectionp ((object <vector>)) t)

(defmethod collectionp ((object <string>)) t)

(defmethod collectionp ((object <table>)) t)

(defmethod collectionp (object) nil)


;;;         ##########
(defun concatenate (collection . more-collections)
;;;        ###########
  (apply #'cl:concatenate
         (#-(and :ALLEGRO :FRANZ-INC) type-of 
         #+(and :ALLEGRO :FRANZ-INC) franz-type-of
         collection)
         ;'list 
         collection more-collections))

;(defmethod concatenate ((collection <vector>) . more-collections)
;  (apply #'cl:concatenate 'vector collection more-collections))
;
;(defmethod concatenate ((collection <string>) . more-collections)
;  (apply #'cl:concatenate 'string collection more-collections))


;;;;        ###
;(defmethod do ((function <function>)
;;;;        ### 
;               (collection <null>) . more-collections)
;  ())

(defun do (function collection . more-collections) 
               ;(collection <cons>) . more-collections)
  (apply #'cl:map 
         (#-(and :ALLEGRO :FRANZ-INC) type-of 
          #+(and :ALLEGRO :FRANZ-INC) franz-type-of
         collection) 
         function collection more-collections)
  nil)

;(defmethod do ((function <function>) 
;               (collection <vector>) . more-collections)
;  (apply #'cl:map 'vector function collection more-collections)
;  ())
;
;(defmethod do ((function <function>) 
;               (collection <string>) . more-collections)
;  (apply #'cl:map 'vector function collection more-collections)
;  ())

;;;    #######
(defun element (collection key)
;;;    #######
  (elt collection key))

(defsetf element (collection key) (value)
  `(setter-element ,collection ,key ,value))

;;;    ##############
(defun setter-element (collection key value)
;;;    ##############
  (setf (elt collection key) value))


;;;        ######
(defmethod emptyp ((collection <cons>))
;;;        ######
  nil)

(defmethod emptyp ((collection <null>))
  t)

(defmethod emptyp ((collection <vector>))
  (if (= (length collection) 0)
    t
    nil))

(defmethod emptyp ((collection <string>))
  (if (= (length collection) 0)
    t
    nil))


;;;        ####
(defun fill (collection object . keys)
;;;        ####
  (let ((rest-list-length (length keys)))
    (if (= rest-list-length 0)
      (cl:fill collection object)
      (if (= rest-list-length 1)
        (error  "collection with list of indizes")
        (let ((start (car keys))
              (end (cadr keys)))
          (cl:fill collection object :start start :end end))))
    )
  nil)


;;;;        ###
;(defmethod map ((function <function>)
;;;;        ### 
;               (collection <null>) . more-collections)
;  ())

(defun map (function collection . more-collections) 
              ; (collection <cons>) . more-collections)
  (apply #'cl:map 
         (#-(and :ALLEGRO :FRANZ-INC) type-of 
         #+(and :ALLEGRO :FRANZ-INC) franz-type-of
         collection) 
         function collection more-collections))


;(defmethod map ((function <function>) 
;               (collection <vector>) . more-collections)
;  (apply #'cl:map 'vector function collection more-collections))
;
;
;(defmethod map ((function <function>) 
;               (collection <string>) . more-collections)
;  (apply #'cl:map 'vector function collection more-collections))


;;;        ######
(defmethod member (object (collection <list>) . rest)
;;;        ######
  (if rest
      (cl:member object collection :test (car rest))
      (cl:member object collection)))

(defmethod member (object collection . rest)
  (error  "collection not a list"))
        

;;; reverse like in CL

;;;        #########
(defmethod sequencep ((collection <list>))
;;;        #########
  t)

(defmethod sequencep ((collection <vector>))
  t)

(defmethod sequencep ((collection <string>))
  t)

(defmethod sequencep (collection)
  ())


;;;    #####
(defun size (collection) (length collection))
;;;    #####




#module-end
