;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: string -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: module string
-----------------------------------------------------------------------------------
File:    string.em
Version: 2.0 (last modification on Mon Mar 14 09:18:38 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/string.em[2.0]:
  
[1.1] Wed Mar 10 13:13:11 1993 imohr@isst published
  [Mon Mar  8 14:36:33 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Tue Jan  4 11:31:36 1994 wheick@isst published
  [Mon Nov  8 13:12:36 1993] Intention for change:
  complete like 0.99: stringp converter equal copy binary<
  as-lower-case as-upper-case
[1.3] Mon Mar 21 09:19:15 1994 wheick@isst proposed
  [Mon Mar 14 09:08:19 1994] Intention for change:
  as-upper-case => as-uppercase, as-lower-case => as-lowercase
  done
[2.0] Mon Mar 21 09:19:15 1994 wheick@isst proposed
  [Mon Mar 14 09:08:19 1994] Intention for change:
  as-upper-case => as-uppercase, as-lower-case => as-lowercase
  done

-----------------------------------------------------------------------------------
|#

#module string

(import 
 (eulisp-kernel
  (only (code-char char string< string> subseq concatenate
                   stringp
                   copy-seq
                   string<
                   numberp
                   string-downcase 
                   string-upcase
                   )
    common-lisp)
  (rename ((make-string cl:make-string))
    common-lisp)
  (only (binary<) compare-generic)
  character-generic ; as-lowercase as-uppercase
  copy-generic ; deep-copy shallow-copy
  )

 export 
 (make-string 
  string-ref        ; not in el 
  string-lt         ; not in el
  string-gt         ; not in el
  string-slice      ; not in el
  string-append     ; not in el
  )

 export
 (
  ;converter
  deep-copy
  shallow-copy
  binary<
  as-lowercase
  as-uppercase)

 expose 
 ((only (stringp equal) common-lisp))

 syntax
 (eulisp-kernel
  (rename ((defun cl:defun))
    common-lisp)
  (only (&optional) 
    common-lisp)))


(make-eulisp-class string)

(defconstant $null-char (code-char 0))

(cl:defun make-string (n &optional (character $null-char))
(cl:make-string n :initial-element  character))

(defun string-ref (string n)
(char string n))

(defun string-lt (string1 string2)
(string< string1 string2))

(defun string-gt (string1 string2)
(string> string1 string2))

(defun string-slice (string start end)
(subseq string start end))

(defun string-append (string1 string2)
(concatenate 'cl:string string1 string2))


(defmethod deep-copy ((strng <string>))
  (copy-seq strng))

(defmethod shallow-copy ((strng <string>))
  (copy-seq strng))

(defmethod binary< ((strng1 <string>)(strng2 <string>))
  (if (numberp (string< strng1 strng2))
    t
    ()))

(defmethod as-lowercase ((strng <string>))
  (string-downcase strng))

(defmethod as-uppercase ((strng <string>))
  (string-upcase strng))


#module-end


