/*  HEAD.PL  */


/*
This is the full canting dictionary for use in the exercise. It defines
predicate
    head( English, Cant )
where English is a list of English words, and Cant is a list of the
corresponding canting words. English is entirely in lower-case, for ease
of matching.

I typed in the dictionary from the English-to-Cant one in the "Canting
Academy" (see the bibliography in the "Logic Programming Tutor"), and
added a few extra equivalences from the Cant-to-English one. The two
were by no means exact inverses.

Spelling and punctuation of the Cant is exactly as written: of the
English, I have modernised the spelling to give the user a higher chance
of hitting words. Spelling in the original book, incidentally, is not
consistent (there seem also to be a fair number of misprints); also, I
may have misread some long s's for f's or vice versa.

In the rest of this comment, there follows an exact transcription of the
English-to-Cant dictionary, starting at page 47:


Villanies Discovered: Or, The Devil's Cabinet opened

AN
ALPHABETICAL
Canting Dictionary.

English before the Canting

AAA.

a curious wench / Rum Mort
an apron / Belly cheat
An instrument to break a door / Betty
A part or share / Earnest
An hole / Ferm
A Groat / Flag
A Receiver of stolen goods / Fencing Cully
A fine Gentlewoman / Gentry-Mort
A door / Gigger
Any writing or Pass / Gybe
A Guiny, or Job / Huskie lour
A Little child / Kinchin
A Little man / Kinchin Cove
All manner of cloaths / Lurries
All sorts of Thieves / Priggs
Any sort of meat / Peck or Peckidge
Any Lace / Peak
A notorious Rogue / Ruffler
An Arm / Smiter
An Arse / Cracker
Andirons / Glimfenders
Agree with a man / Famgrasp the Cove
Angry / Glim flashy

BBB.

Bar-boy / Squeeker
Beadle of Bridewell / Flogging Cove
Better / Benar
Bridewell / Naskin
Beggar born / Clapperdogeon
Boghouse or Privy / Croppinken
Bed / Libbedge
Bottle / Bounsing cheat
Beg / Maund
Beggars / Maunders
Bread / Pannam
Be careful of what you say / Stow your whids and plant 'em
Bridle / Nabgirder
Belts or Shackles / Cramprings
Body / Quarron
Base or Roguish / Queer
Bacon / Ruff peck
Bastard / Stall-whimper
Broker / Fencing Cully
Belated / Hoodwinkt
Blind men / Gropers
Barn / Skippers
Bar of an Alehouse or Tavern / Touting Ken
Be wary / Stow your whids
Brokers shop / Stallen-ken
Beaten / Chaft
Breast / Heaver

CCC.

Cart / Tumbler
Coach-beggars / Ratling Mumpers
Cloak-bag / Roges or Peeter
Cheat / Napper
Coach / Ratler
Chamber pot / Jockum-gage
Coachman / Smacking-cove
Constable / Harmanbeck
Candle stick / Glym-stick
Cut the Cloak-bag / Flick the Peeter
Corn / Grannam
Clusters of Grapes / Rum-boozing Welts
Carriers / Deuseavile Stampers
Choak'd / Frummagem'd
Crutch / Lifter or Plyer
Copulate / Wap or Jockum cloy
Country / Deuseavile
Counterfeit / Confeck
Crafty fellow / Clincher
Crust / Crakler
Cheese / Cash or Cassan
Chicken / Cackling-cheat
Cloak / Calle or Togeman
Cheat or cuzen / Bite
Church / Autem
Coat / Mish-topper
Cow / Mower

DDD.

Drawers of Wine / Rum hoppers
Dog / Bughar
Drink / Booze
Drousie / Peeping
Dumb / Cank
Ditch / Jague
Day, or Day-break / Lightmans
Drunken / Nazy
Dry or thirsty / Chaps
Drunkard / Nazy-Cove
Duck / Quacking-cheat
Devil / Ruffin
Dish / Skew
Drover / Mow-heater

EEE.

Enter or go into an house / Dup
Eyes / Ogles or Glaziers
Ends of Gold and Silver / Spangles
Eggs / Cackling-farts

FFF.

Fellows that pick up people for transportation commonly called Spirits / Kidnappers
Face / Muns
Fool or Coxcomb / Nizie
Fearful / Peely
Fly or run / Brush
Fop, or one that may easily be wrought upon / Cully
Fire / Glymmer
Feet / Stampers

GGG.

Gold / Mynt
Gentile Beggars / Mumpers
Goal / Naskin
Gallows / Trim
Gallant / Rum
Goldsmith / Ridgcully
Garden or Nosegay / Smelling cheat
Goes up the Stairs / Track up the Dancers
Give / Tip
Glass / Flicker
Gallows / Topping cheat
Glass broken / Flicker snaps

HHH.

High-way / Topping Cove
High-way-men / Rum pad
Horse / Rum padders
Horse-stealer / Prancer
Head / Nab
Hat / Nab cheat
Half-penny / Make
House / Ken
Hands / Fambles
Hose / Drawers
Hostess / Su pouch
Heart / Panter
Host / Bluffer

III.

Ingage / Blot the Skrip

KKK.

King of the Link-boys / Rum glimmer
Knavery / Queer topping

LLL.                     

Link-boy / Moon-curser, or Glym-Jack
Looking-glass / Peeper
London / Rumvile
Legs / Stampers
Licence / Jukrum
Look through the Casement / Tout through the Wicker
Lips / Gans
Lye / Coker

MMM.

Mass / Salomon
Mallard / Red shank
Milk-pottage / Papplar
Money / Lour
Married Woman / Autem-Mart                     
Mad-men / Dommerars
Man / Cove

NNN.

Nose / Gigg
Neck / Nub
Newgate / Whit
Night or Evening / Darkman
Naked / Abram

OOO.

One that slips into an house in the dark and steals what he can lay hands on / Budge
One that creeps in at Casements and lets in others to rob the house / Glazier
One that filcheth commodities out of a shop under the pretence of Cheapning or Buying / Shoplift
One that lieth underneath a bed, or in some other covert place to watch an opportunity to rob the house / Snudge
One whose father is born a Beggar / Palliard
OQP on the stairs / Blow off on the Groundsill

PPP.

Pottage / Lap
Pork / Grunting peck
Pease / Trundlers
Partners to Files / Shoulder-shams
Piece of old Gold / Old Mr. Gory
Portmantue / Peeter
Prison / Queer Ken
Penny / Win
Picklock / Gilt
Pot or Pipe / Gage
Pretty / Dimber
Plague / Cannakin
Pox / Bube
Purse / Bung
Poor Fellow / Abram Cove

QQQ.

Question / Starter                     

RRR.

Rascal / Damber
Rings or Gloves / Famble cheats
Rich Coxcomb / Rum Cully
Ride / Prig
Riding / Prigging
Riders / Priggers
Rogue / Queer Cove

SSS.

Shilling / Bord or Hog
Sheep / Bleating cheats
Steal the Portmantue / Bite the Roger
Shirt / Mish
Speak / Cut
Stockings / Drawers
Sucking Pig / Grunting cheat
Stocks / Harmans
Sixpence / Half a Hog
Silver / Witcher
Silver bowl / Witcher bubber
Silver-smith / Witcher-cully
Straw / Strummel
Sheets / Slates
Stockings / Stock drawers
Shoes / Stamps
Shop / Swag
Sought after with a warrant / Romboyld
Sheep-stealer / Napper or Naps
Steal / Mill or Cloy
Seal / Jark

TTT.                     

Teeth / Cushing cheats
To lye / Couch
To go to sleep / Couch a Hogshead
To speak well / Cut been whids                    
To speak ill / Cut queer whids
To be whipt / Cly the Jerk
Two pence / Deuswins
Three pence / Treswins
Tobacco / Fogus
To take Tobacco / Raise a cloud
To beat / Fib
To spend or lay out / Fence
Teeth / Grinders
To rob an house / Heave a booth
To tumble together / Lib
Transported / Marinate
To lay place or hide / Plant
Tongue / Prating cheat
To rune away / Pikes
To wear / Scour
To look out / Tour
To hang / Trine
The Sessions-house / Nubbing Ken
Turky / Cobble-colter


Our Canting Alphabet will not extend a Letter farther than T, as far as
I can find out; not knowing any Canting word beginning with V, X, Y, Z,
although I have made a strict inquiry from some of the most notorious
Professors hereof: I have consulted likewise what is printed on this
subject, and have slighted no help I could gather from thence, which
indeed is very little; the greatest assistance I had in this discovery,
was from Newgate; which with much difficulty I screw'd out of the sullen
Rogues, who would not speak a word till I had suppled their tongues with
the oil of Barley, or rather thaw'd their obstinate silence with the
heat of strong Liquors.

From there I understood, that the Mode of Canting alter'd very often,
and that they were forced to change frequently those material words
which chiefly discovered their mysterious practices and Villanies, least
growing too common their own words should betray them.

Here in this Vocabulary or little Canting Dictionary, You have all or
most of the old words which are still in use, and a many new never
published in print, and but very lately minted, such too which have
passed the approbation of the Critical Canter. If I seem deficient in
the quantity of words, let some else supply my defects, having collected
words sufficiently enough for one, if you will have more, take the pains
which I have done to be supplyed, and in the mean time be content with
what is gathered to your hands.
*/


head( [a, curious, wench], ['Rum', 'Mort']).
head( [an, apron], ['Belly', cheat]).
head( [an, instrument, to, break, a, door], ['Betty']).
head( [a, part, or, share], ['Earnest']).
head( [an, hole], ['Ferm']).
head( [a, groat], ['Flag']).
head( [a, receiver, of, stolen, goods], ['Fencing', 'Cully']).
head( [a, fine, gentlewoman], ['Gentry', -, 'Mort']).
head( [a, door], ['Gigger']).
head( [any, writing, or, pass], ['Gybe']).
head( [a, guinea], ['Huskie', lour]).
head( [a, little, child], ['Kinchin']).
head( [a, little, man], ['Kinchin', 'Cove']).
head( [all, manner, of, clothes], ['Lurries']).
head( [a, 'man\'s', neck], ['Colquarron']).
head( [a, private, dwelling, house], ['Libben']).
head( [a, tippling, -, house], ['Boozing', -, ken]).
head( [all, sorts, of, thieves], ['Priggs']).
head( [any, sort, of, meat], ['Peck', or, 'Peckidge']).
head( [any, lace], ['Peak']).
head( [a, notorious, rogue], ['Ruffler']).
head( [an, arm], ['Smiter']).
head( [an, arse], ['Cracker']).
head( [andirons], ['Glimfenders']).
head( [agree, with, a, man], ['Famgrasp', the, 'Cove']).
head( [angry], ['Glim', flashy]).
head( [bar, -, boy], ['Squeeker']).
head( [beadle, of, bridewell], ['Flogging', 'Cove']).
head( [better], ['Benar']).
head( [bridewell], ['Naskin']).
head( [beggar, born], ['Clapperdogeon']).
head( [boghouse, or, privy], ['Croppinken']).
head( [bed], ['Libbedge']).
head( [bottle], ['Bounsing', cheat]).
head( [beg], ['Maund']).
head( [beggars], ['Maunders']).
head( [bread], ['Pannam']).
head( [be, careful, of, what, you, say], ['Stow', your, whids, and, plant, '\'em']).
head( [bridle], ['Nabgirder']).
head( [belts, or, shackles], ['Cramprings']).
head( [body], ['Quarron']).
head( [base, or, roguish], ['Queer']).
head( [bacon], ['Ruff', peck]).
head( [bastard], ['Stall', -, whimper]).
head( [broker], ['Fencing', 'Cully']).
head( [belated], ['Hoodwinkt']).
head( [blind, men], ['Gropers']).
head( [barn], ['Skippers']).
head( [bar, of, an, alehouse, or, tavern], ['Touting', 'Ken']).
head( [be, wary], ['Stow', your, whids]).
head( ['broker\'s', shop], ['Stallen', -, ken]).
head( [beaten, or, banged], ['Chaft']).
head( [breast], ['Heaver']).
head( [cart], ['Tumbler']).
head( [canary, wine], ['Rum', gutlers]).
head( [casement], ['Wicket']).
head( [cant], ['Stam', flesh]).
head( [coach, -, beggars], ['Ratling', 'Mumpers']).
head( [cloak], ['Calle']).
head( [cloak, -, bag], ['Roges', or, 'Peeter']).
head( [cheat], ['Napper']).
head( [coach], ['Ratler']).
head( [chamber, pot], ['Jockum', -, gage]).
head( [coachman], ['Smacking', -, cove, or, rarling, cove]).
head( [constable], ['Harmanbeck']).
head( [candle, stick], ['Glym', -, stick]).
head( [cut, the, cloak, -, bag], ['Flick', the, 'Peeter']).
head( [corn], ['Grannam']).
head( [clusters, of, grapes], ['Rum', -, boozing, 'Welts']).
head( [carriers], ['Deuseavile', 'Stampers']).
head( [choked], ['Frummagem\'d']).
head( [crutch], ['Lifter', or, 'Plyer']).
head( [copulate], ['Wap', or, 'Jockum', cloy]).
head( [country], ['Deuseavile']).
head( [country, carriers], ['Deuseavile', -, 'Stampers']).
head( [counterfeit], ['Confeck']).
head( [crafty, fellow], ['Clincher']).
head( [crust], ['Crakler']).
head( [cheese], ['Cash', or, 'Cassan']).
head( [chicken], ['Cackling', -, cheat]).
head( [cloak], ['Calle', or, 'Togeman']).
head( [cheat, or, cuzen], ['Bite']).
head( [church], ['Autem']).
head( [coat], ['Mish', -, topper]).
head( [cow], ['Mower']).
head( [drawers, of, wine], ['Rum', hoppers]).
head( [dog], ['Bughar']).
head( [drink], ['Booze']).
head( [drowsy, or, sleepy], ['Peeping']).
head( [dumb], ['Cank', or, chats]).
head( [ditch], ['Jague']).
head( [day, ',', or, day, -, break], ['Lightmans']).
head( [drunken], ['Nazy']).
head( [dry, or, thirsty], ['Chaps']).
head( [drunkard], ['Nazy', -, 'Cove']).
head( [duck], ['Quacking', -, cheat]).
head( [devil], ['Ruffin']).
head( [dish], ['Skew']).
head( [drover], ['Mow', -, heater]).
head( [enter, or, go, into, an, house], ['Dup']).
head( [eyes], ['Ogles', or, 'Glaziers']).
head( [ends, of, gold, and, silver], ['Spangles']).
head( [eggs], ['Cackling', -, farts]).
head( [fellows, that, pick, up, people, for, transportation, commonly, called, spirits], ['Kidnappers']).
head( [face], ['Muns']).
head( [fool, or, coxcomb], ['Nizie']).
head( [fearful], ['Peery']).
head( [fly, or, run], ['Brush']).
head( [fop, ',', or, one, that, may, easily, be, wrought, upon], ['Cully']).
head( [fire], ['Glymmer']).
head( [feet], ['Stampers']).
head( [gold], ['Mynt']).
head( [gentile, beggars], ['Mumpers']).
head( [goal], ['Naskin']).
head( [gallows], ['Trim', or, 'The', 'Chats']).
head( [gallant], ['Rum']).
head( [goldsmith], ['Ridgcully']).
head( [garden, or, nosegay], ['Smelling', cheat]).
head( [goes, up, the, stairs], ['Track', up, the, 'Dancers']).
head( [give], ['Tip']).
head( [glass], ['Flicker']).
head( [gallows], ['Topping', cheat, or, 'Nubbing', cheat]).
head( [glass, broken], ['Flicker', snaps]).
head( [goods], ['Duds']).
head( [good, night], ['Been', darkmans]).
head( [goose], ['Tib', of, the, buttery]).
head( [hanging], ['Nubbing']).
head( [hangman], ['Nubbing', 'Cove']).
head( [high, -, way], ['Topping', 'Cove', or, pad]).
head( [high, -, way, -, men], ['Rum', pad]).
head( [horse], ['Rum', padders]).
head( [horse, -, stealer], ['Prancer', or, prig, -, napper, or, prigger]).
head( [head], ['Nab']).
head( [hedges], ['Crackmans']).
head( [hat], ['Nab', cheat]).
head( [half, -, penny], ['Make']).
head( [hen], ['Margry', 'Prater']).
head( [house], ['Ken']).
head( [housebreaker], ['Milken']).
head( [hands], ['Fambles']).
head( [hose], ['Drawers']).
head( [hostess], ['Su', pouch]).
head( [heart], ['Panter']).
head( [host], ['Bluffer']).
head( [engage], ['Blot', the, 'Skrip']).
head( [king, of, the, link, -, boys], ['Rum', glimmer]).
head( [knavery], ['Queer', topping]).
head( [link, -, boy], ['Moon', -, curser, ',', or, 'Glym', -, 'Jack']).
head( [looking, -, glass], ['Peeper']).
head( [london], ['Rumvile']).
head( [legs], ['Stampers', or, stamps]).
head( [licence], ['Jukrum', or, tick, -, rum]).
head( [look, through, the, casement], ['Tout', through, the, 'Wicker']).
head( [lips], ['Gans']).
head( [lye], ['Coker']).
head( [mass], ['Salomon']).
head( [mallard], ['Red', shank]).
head( [milk, -, pottage], ['Papplar']).
head( [money], ['Lour']).
head( [married, woman], ['Autem', -, 'Mart']).
head( [mad, -, men], ['Dommerars']).
head( [man], ['Cove', ',', or, 'Cuffin']).
head( [nose], ['Gigg']).
head( [neck], ['Nub']).
head( [newgate], ['Whit']).
head( [night, or, evening], ['Darkman']).
head( [naked], ['Abram']).
head( [napkin], ['Muffling', cheat]).
head( [one, 'man\'s', particular, wench], ['Blower']).
head( [one, that, slips, into, an, house, in, the, dark, and, steals, what, he, can, lay, hands, on], ['Budge']).
head( [one, that, creeps, in, at, casements, and, lets, in, others, to, rob, the, house], ['Glazier']).
head( [one, that, filcheth, commodities, out, of, a, shop, under, the, pretence, of, cheapning, or, buying], ['Shoplift']).
head( [one, that, lieth, underneath, a, bed, ',', or, in, some, other, covert, place, to, watch, an, opportunity, to, rob, the, house], ['Snudge']).
head( [one, whose, father, is, born, a, beggar], ['Palliard']).
head( [oqp, on, the, stairs], ['Blow', off, on, the, 'Groundsill']).
head( [ox], ['Batner']).
head( [paper], ['Skrip']).
head( [pottage], ['Lap']).
head( [pork], ['Grunting', peck]).
head( [pease], ['Trundlers']).
head( [partners, to, files], ['Shoulder', -, shams]).
head( [piece, of, old, gold], ['Old', 'Mr', ., 'Gory']).
head( [portmantle], ['Peeter']).
head( [prison], ['Queer', 'Ken']).
head( [penny], ['Win']).
head( [picklock], ['Gilt']).
head( [pork], ['Grunting', peck]).
head( [pot, or, pipe], ['Gage']).
head( [pot, -, boy], ['Neck', stamper]).
head( [pretty], ['Dimber']).
head( [plague], ['Cannakin']).
head( [pox], ['Bube']).
head( [purse], ['Bung']).
head( [poor, fellow], ['Abram', 'Cove']).
head( [question], ['Starter']).
head( [rascal], ['Damber']).
head( [rings, or, gloves], ['Famble', cheats]).
head( [rich, coxcomb], ['Rum', 'Cully']).
head( [ride], ['Prig']).
head( [riding], ['Prigging']).
head( [riders], ['Priggers']).
head( [rival, in, love], ['Prig', -, star]).
head( [rogue], ['Queer', 'Cove']).
head( [run], ['Pike']).
head( [shilling], ['Bord', or, 'Hog']).
head( [sheep], ['Bleating', cheats]).
head( [steal, the, portmantle], ['Bite', the, 'Roger']).
head( [shirt], ['Mish', or, 'Commission']).
head( [speak], ['Cut']).
head( [stairs], ['Dancers']).
head( [stockings], ['Drawers', or, stock, -, drawers]).
head( [sucking, pig], ['Grunting', cheat]).
head( [stocks], ['Harmans']).
head( [sixpence], ['Half', a, 'Hog', or, 'Half', a, bord]).
head( [silver], ['Witcher']).
head( [silver, bowl], ['Witcher', bubber]).
head( [silver, -, hilted, sword], ['Witcher', -, tilter]).
head( [silver, -, smith], ['Witcher', -, cully]).
head( [straw], ['Strummel']).
head( [sheets], ['Slates']).
head( [stockings], ['Stock', drawers]).
head( [shoes], ['Stamps', or, stampers]).
head( [shop], ['Swag']).
head( [sought, after, with, a, warrant], ['Romboyld']).
head( [sheep, -, stealer], ['Napper', or, 'Naps']).
head( [steal], ['Mill', or, 'Cloy']).
head( [seal], ['Jark']).
head( [teeth], ['Crashing', cheats]).
head( [thighs], ['Prats']).
head( [to, lie], ['Couch']).
head( [to, go, to, sleep], ['Couch', a, 'Hogshead']).
head( [to, speak, well], ['Cut', been, whids]).
head( [to, speak, ill], ['Cut', queer, whids]).
head( [to, be, whipt], ['Cly', the, 'Jerk']).
head( [two, pence], ['Deuswins']).
head( [three, pence], ['Treswins']).
head( [tobacco], ['Fogus']).
head( [to, take, tobacco], ['Raise', a, cloud]).
head( [to, beat], ['Fib']).
head( [to, cut], ['Flick']).
head( [to, spend, or, lay, out], ['Fence']).
head( [teeth], ['Grinders']).
head( [to, rob, an, house], ['Heave', a, booth]).
head( [to, tumble, together], ['Lib']).
head( [transported], ['Marinate']).
head( [to, lay, place, or, hide], ['Plant']).
head( [tongue], ['Prating', cheat]).
head( [to, run, away], ['Pikes']).
head( [to, go, away], ['Bing', away]).
head( [to, go], ['Bing']).
head( [to, wear], ['Scour']).
head( [to, look, out], ['Tour']).
head( [to, hang], ['Trine']).
head( [to, whip, as, in, bridewell], ['Flog']).
head( [the, sessions, -, house], ['Nubbing', 'Ken']).
head( [turkey], ['Cobble', -, colter]).
head( [the, one, jostles, you, up, whilst, the, other, picks, your, pocket], ['Bulk', and, 'File']).
head( [the, wench, hath, clapt, the, fellow], ['The', 'Mort', hath, tipt, the, 'Bube', to, the, 'Cully']).
