/*  MOW.PL  */


/*
The predicate mow(N) generates verses of "One man went to mow", starting
at N and working down. The idea came from "A comparative study of
Programming Languages" by Brian Higman, which contains definitions in
Strachey's GPM for several such songs.
*/


mow( N ) :-
    N > 10,
    !,
    output('Too many men.'), nl.

mow( N ) :-
    N < 1,
    !,
    output('Too few men.'), nl.

mow( N ) :-
    mow_2( N ).


mow_2( 0 ) :- !.

mow_2( N ) :-
    number_name( N, Name ),
    man_or_men( N, Men ),
    capitalise( Name, UName ),
    output( UName...Men...'went to mow,'~ ),
    output( 'Went to mow a meadow.'~ ),
    mow_3( N, cap ), nl,
    output( 'Went to mow a meadow.'~~ ),
    Nd is N-1,
    mow_2( Nd ).


mow_3( 1, cap ) :-
    !,
    output( 'One man and his dog,' ).

mow_3( 1, small ) :-
    !,
    output( 'one man and his dog,' ).

mow_3( N, UL ) :-
    number_name( N, Name ), man_or_men( N, Men ),
    (
        UL = cap
    ->
        capitalise( Name, NName )
    ;
        NName = Name
    ),
    output( NName...Men...', ' ),
    mow_3_nl( N, C ),
    Nd is N-1,
    mow_3( Nd, C ).


mow_3_nl( 5, cap ) :-
    !,
    nl.

mow_3_nl( _, small ).


man_or_men( N, men ) :-
    N > 1, !.
man_or_men( N, man ).


number_name( 10, ten ).
number_name( 9, nine ).
number_name( 8, eight ).
number_name( 7, seven ).
number_name( 6, six ).
number_name( 5, five ).
number_name( 4, four ).
number_name( 3, three ).
number_name( 2, two ).
number_name( 1, one ).


capitalise( A, UA ) :-
    name( A, [C1|Cn] ),
    !,
    char_to_uppercase( C1, UC1 ),
    name( UA, [UC1|Cn] ).                    

capitalise( A, A ).



/*
one man went to mow
went to mow a meadow
one man and his dog
went to mow a meadow.


two men went to mow
went to mow a meadow
two men, one man and his dog
went to mow a meadow.
*/
