/*  TOKENISE.P  */


/*  This file defines routines for converting between numbers and
    their character code represntation. See TOKENISE.PL for an
    explanation.
*/


;;;  n is an integer or real. Return the corresponding text representation
;;;  as a character-code list in digits.
;;;
define number_to_chars(n) -> digits;
    lvars n, digits;
    vars cucharout;

    ;;;  Works by defining a character consumer that's called by 'pr', and
    ;;;  that dumps the characters printed into a list.

    procedure(c);
        c
    endprocedure -> cucharout;
    [% pr(n) %] -> digits;
enddefine;


;;;  digits is a list of character codes representing an integer or
;;;  real. Return the corresponding numeric value in n.
;;;
define chars_to_number(digits) -> n;
    lvars digits, n, index=1, repeater;

    ;;; Works by defining a repeater that reads successive characters
    ;;; from digits.

    procedure ();
        if index > length(digits) then
            termin
        else
            digits(index);
            1 + index -> index;
        endif
    endprocedure -> repeater;
    incharitem(repeater)() -> n;
enddefine;
