;;; At least for debugging, let me try some simple definitions:

(define (make-rectangle origin horiz vert)
  (list 'rectangle origin horiz vert))

(define origin cadr)
(define horiz caddr)
(define vert cadddr)


(define (make-vect xcor ycor)
  (list 'vect xcor ycor))

(define xcor cadr)
(define ycor caddr)

;;; Operations on vectors:

(define (+vect v1 v2)
  (make-vect (+ (xcor v1) (xcor v2))
             (+ (ycor v1) (ycor v2))))

(define (-vect v1 v2)
  (make-vect (- (xcor v1) (xcor v2))
             (- (ycor v1) (ycor v2))))

(define (scale-vect v factor)
  (make-vect (* factor (xcor v))
             (* factor (ycor v))))


;;; Rotation by a positive angle is (accidentally) clockwise.

(define (rotate-vect v angle)
  (define (square x) (* x x))
  (let ((r (sqrt (+ (square (xcor v)) (square (ycor v)))))
	(theta (+ angle (atan (ycor v) (xcor v)))))
    (make-vect (* r (cos theta)) (* r (sin theta)))))
